#include <sys/stat.h>
#include <unistd.h>
#include <stdio.h>
#include <string.h>
#include "scv-file.h"

#define FREAD_SUCCESSFULLY(pfile,dst,x) \
	(fread((dst), 1, sizeof((x)), pfile) < sizeof((x)))

#if (0)
static void
scv_file_dump(ScvFile *scv_file)
{
	int Nix;

	if (scv_file) {

		g_print("%02X %02X # magic\n", scv_file->magic[0], scv_file->magic[1]);

		g_print("%02X # description1_length = %d\n", scv_file->description1_length, scv_file->description1_length);
		for (Nix = 0 ; Nix < scv_file->description1_length ; Nix++)
			g_print("%02X ", scv_file->description1[Nix]);
		g_print("# description1 = \"%*s\"\n", scv_file->description1_length, scv_file->description1);

		g_print("%02X # description2_length = %d\n", scv_file->description2_length, scv_file->description2_length);
		for (Nix = 0 ; Nix < scv_file->description2_length ; Nix++)
			g_print("%02X ", scv_file->description2[Nix]);
		g_print("# description1 = \"%*s\"\n", scv_file->description2_length, scv_file->description2);

		for (Nix = 0 ; Nix < sizeof(scv_file->magic1) ; Nix++)
			g_print("%02X ", scv_file->magic1[Nix]);
		g_print("# magic1\n");

		for (Nix = 0 ; Nix < sizeof(scv_file->magic2) ; Nix++)
			g_print("%02X ", scv_file->magic2[Nix]);
		g_print("# magic2\n");

		for (Nix = 0 ; Nix < G_N_ELEMENTS(scv_file->kb1) ; Nix++) {
			g_print("kb1[%3d]: %02X %02X # magic\n", Nix, scv_file->kb1[Nix].magic[0], scv_file->kb1[Nix].magic[1]);
			g_print("kb1[%3d]: %02X # key_length = %d\n", Nix, scv_file->kb1[Nix].key_length, scv_file->kb1[Nix].key_length);
			g_print("kb1[%3d]: %s # key\n", Nix, scv_file->kb1[Nix].key);
			g_print("kb1[%3d]: %02X # zero\n", Nix, scv_file->kb1[Nix].zero);
		}

		g_print("%02X %02X # separator\n", scv_file->separator[0], scv_file->separator[1]);

		for (Nix = 0 ; Nix < sizeof(scv_file->magic3) ; Nix++)
			g_print("%02X ", scv_file->magic3[Nix]);
		g_print("# magic3\n");

		for (Nix = 0 ; Nix < G_N_ELEMENTS(scv_file->kb2) ; Nix++) {
			g_print("kb2[%3d]: %02X %02X # magic\n", Nix, scv_file->kb2[Nix].magic[0], scv_file->kb2[Nix].magic[1]);
			g_print("kb2[%3d]: %02X # key_length = %d\n", Nix, scv_file->kb2[Nix].key_length, scv_file->kb2[Nix].key_length);
			g_print("kb1[%3d]: %s # key\n", Nix, scv_file->kb1[Nix].key);
			g_print("kb2[%3d]: %02X # zero\n", Nix, scv_file->kb2[Nix].zero);
		}
	}
}
#endif /* (0) */

static gboolean
scv_file_read_kb_buttons(FILE *pfile, KBButton *kbb, int n_buttons)
{
	int Nix;
	for (Nix = 0 ; Nix < n_buttons ; Nix++) {
		if (FREAD_SUCCESSFULLY(pfile, kbb[Nix].magic,         kbb[Nix].magic))
			return FALSE;
		else
		if (FREAD_SUCCESSFULLY(pfile, &(kbb[Nix].key_length), kbb[Nix].key_length))
			return FALSE;
		else {
			kbb[Nix].key = g_new0(char, kbb[Nix].key_length + 1);
			/* For some reason, for tabs, this value is 4 */
			if (fread(kbb[Nix].key, 1, (4 == kbb[Nix].key_length ? 1 : kbb[Nix].key_length), pfile) < (4 == kbb[Nix].key_length ? 1 : kbb[Nix].key_length))
				return FALSE;
			else
			if (FREAD_SUCCESSFULLY(pfile, &(kbb[Nix].zero), kbb[Nix].zero))
				return FALSE;
			if (4 == kbb[Nix].key_length)
				g_snprintf(kbb[Nix].key, sizeof(kbb[Nix].key), "↹");
		}
	}

	return TRUE;
}

static gboolean
scv_file_validate_kb(KBButton *kbb, int n_buttons) {
	gboolean ret = TRUE;
	int Nix;

	for (Nix = 0 ; Nix < n_buttons ; Nix++) {
		if (kbb[Nix].key_length > sizeof(gunichar) || kbb[Nix].key_length == 0) {
			g_warning("scv_file_validate_kb: kbb[%d].key_length = %d\n", Nix, kbb[Nix].key_length);
			ret = FALSE;
		}
		else
		if (kbb[Nix].zero != 0) {
			g_warning("scv_file_validate_kb: kbb[%d].zero != 0\n", Nix);
			ret = FALSE;
		}
	}

	return ret;
}

static
ScvFile *scv_file_validate(ScvFile *scv_file)
{
	if (scv_file) {
		if (scv_file->magic[0] != 0x01 || scv_file->magic[1] != 0x01)
			g_warning("scv_file_validate: Invalid magic: %02X %02X\n", scv_file->magic[0], scv_file->magic[1]);
		else
		if (!scv_file_validate_kb(scv_file->kb1, G_N_ELEMENTS(scv_file->kb1)))
			g_warning("scv_file_validate: kb1 invalid\n");
		else
		if (memcmp(scv_file->magic2, scv_file->magic3, MIN(sizeof(scv_file->magic2), sizeof(scv_file->magic3))))
			g_warning("scv_file_validate: magic2 != magic3");
		else
		if (!scv_file_validate_kb(scv_file->kb2, G_N_ELEMENTS(scv_file->kb2)))
			g_warning("scv_file_validate: kb2 invalid\n");
	}

	return scv_file;
}

ScvFile *
scv_file_new_from_file(char *fname)
{
	ScvFile *scv_file = NULL;
	FILE *pfile = NULL;

	g_return_val_if_fail(NULL != fname, NULL);

	pfile = fopen(fname, "r");
	if (pfile) {
		scv_file = g_new0(ScvFile, 1);
		scv_file->fname = g_strdup(fname);

		if (FREAD_SUCCESSFULLY(pfile, scv_file->magic,                  scv_file->magic))
			scv_file = scv_file_free(scv_file);
		else
		if (FREAD_SUCCESSFULLY(pfile, &(scv_file->description1_length), scv_file->description1_length))
			scv_file = scv_file_free(scv_file);
		else
		if (fread(scv_file->description1, 1, scv_file->description1_length, pfile) < scv_file->description1_length)
			scv_file = scv_file_free(scv_file);
		else
		if (FREAD_SUCCESSFULLY(pfile, &(scv_file->description2_length), scv_file->description2_length))
			scv_file = scv_file_free(scv_file);
		else
		if (fread(scv_file->description2, 1, scv_file->description2_length, pfile) < scv_file->description2_length)
			scv_file = scv_file_free(scv_file);
		else
		if (FREAD_SUCCESSFULLY(pfile, &(scv_file->description3_length), scv_file->description3_length))
			scv_file = scv_file_free(scv_file);
		else
		if (fread(scv_file->description3, 1, scv_file->description3_length, pfile) < scv_file->description3_length)
			scv_file = scv_file_free(scv_file);
		else
		if (FREAD_SUCCESSFULLY(pfile, scv_file->magic1,                 scv_file->magic1))
			scv_file = scv_file_free(scv_file);
		else
		if (FREAD_SUCCESSFULLY(pfile, scv_file->magic2,                 scv_file->magic2))
			scv_file = scv_file_free(scv_file);
		else
		if (!scv_file_read_kb_buttons(pfile, scv_file->kb1, G_N_ELEMENTS(scv_file->kb1)))
			scv_file = scv_file_free(scv_file);
		else
		if (FREAD_SUCCESSFULLY(pfile, scv_file->separator,              scv_file->separator))
			scv_file = scv_file_free(scv_file);
		else
		if (FREAD_SUCCESSFULLY(pfile, scv_file->magic3,                 scv_file->magic3))
			scv_file = scv_file_free(scv_file);
		else
		if (!scv_file_read_kb_buttons(pfile, scv_file->kb2, G_N_ELEMENTS(scv_file->kb2)))
			scv_file = scv_file_free(scv_file);

		fclose(pfile);
	}
	else
		g_warning("scv_file_new_from_file: Failed to open \"%s\"\n", fname);

	scv_file = scv_file_validate(scv_file);
#if (0)
	scv_file_dump(scv_file);
#endif /* (0) */
	return scv_file;
}

gboolean
scv_file_save(ScvFile *scv_file)
{
	gboolean ret = FALSE;
	char *actual_name = NULL;
	int fd;

	fd = g_file_open_tmp("scv-reader.XXXXXX.scv", &actual_name, NULL);

	if (fd != -1) {
		if (write(fd, scv_file->magic,                  sizeof(scv_file->magic))                  == sizeof(scv_file->magic))
		if (write(fd, &(scv_file->description1_length), sizeof(scv_file->description1_length))    == sizeof(scv_file->description1_length))
		if (write(fd, scv_file->description1,           strlen((char *)(scv_file->description1))) == strlen((char *)(scv_file->description1)))
		if (write(fd, &(scv_file->description2_length), sizeof(scv_file->description2_length))    == sizeof(scv_file->description2_length))
		if (write(fd, scv_file->description2,           strlen((char *)(scv_file->description2))) == strlen((char *)(scv_file->description2)))
		if (write(fd, &(scv_file->description3_length), sizeof(scv_file->description3_length))    == sizeof(scv_file->description3_length))
		if (write(fd, scv_file->description3,           strlen((char *)(scv_file->description3))) == strlen((char *)(scv_file->description3)))
		if (write(fd, scv_file->magic1,                 sizeof(scv_file->magic1))                 == sizeof(scv_file->magic1))
		if (write(fd, scv_file->magic2,                 sizeof(scv_file->magic2))                 == sizeof(scv_file->magic2)) {
			int Nix;

			for (Nix = 0 ; Nix < G_N_ELEMENTS(scv_file->kb1) ; Nix++)
				if (write(fd, scv_file->kb1[Nix].magic,         sizeof(scv_file->kb1[Nix].magic))         != sizeof(scv_file->kb1[Nix].magic))
					break;
				else
				if (write(fd, &(scv_file->kb1[Nix].key_length), sizeof(scv_file->kb1[Nix].key_length))    != sizeof(scv_file->kb1[Nix].key_length))
					break;
				else
				if ((4 != scv_file->kb1[Nix].key_length) &&
					(write(fd, scv_file->kb1[Nix].key,            strlen((char *)(scv_file->kb1[Nix].key))) != strlen((char *)(scv_file->kb1[Nix].key))))
					break;
				else
				if (4 == scv_file->kb1[Nix].key_length) {
					if (write(fd, &(scv_file->kb1[Nix].zero),     1)                                        != 1)
						break;
					if (write(fd, &(scv_file->kb1[Nix].zero),     1)                                        != 1)
						break;
				}
				else
				if (write(fd, &(scv_file->kb1[Nix].zero),       sizeof(scv_file->kb1[Nix].zero))          != sizeof(scv_file->kb1[Nix].zero))
					break;

			if (Nix == G_N_ELEMENTS(scv_file->kb1))
				if (write(fd, scv_file->separator, sizeof(scv_file->separator)) == sizeof(scv_file->separator))
				if (write(fd, scv_file->magic3,    sizeof(scv_file->magic3))    == sizeof(scv_file->magic3)) {
					for (Nix = 0 ; Nix < G_N_ELEMENTS(scv_file->kb2) ; Nix++)
						if (write(fd, scv_file->kb2[Nix].magic,         sizeof(scv_file->kb2[Nix].magic))         != sizeof(scv_file->kb2[Nix].magic))
							break;
						else
						if (write(fd, &(scv_file->kb2[Nix].key_length), sizeof(scv_file->kb2[Nix].key_length))    != sizeof(scv_file->kb2[Nix].key_length))
							break;
						else
						if ((4 != scv_file->kb2[Nix].key_length) &&
							(write(fd, scv_file->kb2[Nix].key,            strlen((char *)(scv_file->kb2[Nix].key))) != strlen((char *)(scv_file->kb2[Nix].key))))
							break;
						else
						if (4 == scv_file->kb2[Nix].key_length) {
							if (write(fd, &(scv_file->kb2[Nix].zero),     1)                                        != 1)
								break;
							if (write(fd, &(scv_file->kb2[Nix].zero),     1)                                        != 1)
								break;
						}
						else
						if (write(fd, &(scv_file->kb2[Nix].zero),       sizeof(scv_file->kb2[Nix].zero))          != sizeof(scv_file->kb2[Nix].zero))
							break;
					ret = (Nix == G_N_ELEMENTS(scv_file->kb2));
				}
		}
		fchmod(fd, S_IRUSR | S_IWUSR | S_IRGRP | S_IROTH);
		close(fd);
	}

	if (ret) {
		if (actual_name)
			ret = (rename(actual_name, scv_file->fname) != -1);
	}

	return ret;
}

char *
scv_file_read_description(char *fname)
{
	char *description1 = NULL;
	ScvFile *scv_file = NULL;
	FILE *pfile = NULL;

	g_return_val_if_fail(NULL != fname, NULL);

	pfile = fopen(fname, "r");
	if (pfile) {
		scv_file = g_new0(ScvFile, 1);
		if (FREAD_SUCCESSFULLY(pfile, scv_file->magic,                  scv_file->magic))
			scv_file = scv_file_free(scv_file);
		else
		if (FREAD_SUCCESSFULLY(pfile, &(scv_file->description1_length), scv_file->description1_length))
			scv_file = scv_file_free(scv_file);
		else
		if (fread(scv_file->description1, 1, scv_file->description1_length, pfile) < scv_file->description1_length)
			scv_file = scv_file_free(scv_file);

		fclose(pfile);
	}
	else
		g_warning("scv_file_read_description: Failed to open \"%s\"\n", fname);

	if (scv_file) {
		description1 = g_strdup((char *)(scv_file->description1));

		scv_file_free(scv_file);
	}

	return description1;
}

ScvFile *
scv_file_free(ScvFile *scv_file)
{
	int Nix;

	if (scv_file)
		g_free(scv_file->fname);

	for (Nix = 0 ; Nix < G_N_ELEMENTS(scv_file->kb1) ; Nix++)
		g_free(scv_file->kb1[Nix].key);

	for (Nix = 0 ; Nix < G_N_ELEMENTS(scv_file->kb2) ; Nix++)
		g_free(scv_file->kb2[Nix].key);

	g_free(scv_file);
	return NULL;
}
