/* ScummVM - Graphic Adventure Engine
 *
 * ScummVM is the legal property of its developers, whose names
 * are too numerous to list here. Please refer to the COPYRIGHT
 * file distributed with this source distribution.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.

 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 * $URL: https://scummvm.svn.sourceforge.net/svnroot/scummvm/scummvm/tags/release-1-1-0/engines/sky/skydefs.h $
 * $Id: skydefs.h 34425 2008-09-07 21:38:53Z fingolfin $
 *
 */

#ifndef SKY_DEFS_H
#define SKY_DEFS_H



namespace Sky {

//This file is incomplete, several flags still missing.

// grafixProg pointer types:
#define OG_PTR_NULL		0
#define OG_AUTOROUTE	1
#define OG_COMPACT		2
#define OG_COMPACTELEM	3 // needed by fnSetToStand
#define OG_TALKTABLE	4

// language codes:
#define SKY_ENGLISH		0
#define SKY_GERMAN		1
#define SKY_FRENCH		2
#define SKY_USA			3
#define SKY_SWEDISH		4
#define SKY_ITALIAN		5
#define SKY_PORTUGUESE	6
#define SKY_SPANISH		7

#define ST_COLLISION_BIT	5

#define S_COUNT	0
#define S_FRAME	2
#define S_AR_X	4
#define S_AR_Y	6
#define S_LENGTH	8

#define KEY_BUFFER_SIZE	80
#define SEQUENCE_COUNT	3

#define	FIRST_TEXT_COMPACT	23
#define LAST_TEXT_COMPACT	33
#define FIXED_TEXT_WIDTH	128

//screen/grid defines
#define GAME_SCREEN_WIDTH	320
#define GAME_SCREEN_HEIGHT	192
#define FULL_SCREEN_WIDTH	320
#define FULL_SCREEN_HEIGHT	200

#define TOT_NO_GRIDS	70	//total no. of grids supported
#define GRID_SIZE	120	//grid size in bytes

#define GRID_X	20
#define GRID_Y	24
#define GRID_W	16
#define GRID_H	8

#define GRID_W_SHIFT	4
#define GRID_H_SHIFT	3

#define TOP_LEFT_X	128
#define TOP_LEFT_Y	136

//item list defines
#define section_0_item	119

#define MAIN_CHAR_HEIGHT	12

#define C_BASE_MODE	0
#define C_BASE_MODE56	56
#define C_ACTION_MODE	4
#define C_SP_COLOUR	90
#define C_MEGA_SET	112
#define C_GRID_WIDTH	114
#define C_ANIM_UP	122
#define C_STAND_UP	138
#define C_TURN_TABLE	158

#define SECTION_0_ITEM 119 //item number of first item section
#define NEXT_MEGA_SET (258 - C_GRID_WIDTH)

#define SEND_SYNC	0xFFFF
#define LF_START_FX	0xFFFE
#define SAFE_START_SCREEN	0

//autoroute defines
#define UPY	0
#define DOWNY	1
#define LEFTY	2
#define RIGHTY	3

#define ROUTE_SPACE	64

#define PCONLY_F_R3_1 0
#define PCONLY_F_R3_2 0

#define RESTART_BUTT_X 147
#define RESTART_BUTT_Y 309
#define RESTORE_BUTT_X 246
#define RESTORE_BUTT_Y 309
#define EXIT_BUTT_X 345
#define EXIT_BUTT_Y 309

#define L_SCRIPT	1
#define L_AR	2
#define L_AR_ANIM	3
#define L_AR_TURNING	4
#define L_ALT	5
#define L_MOD_ANIMATE	6
#define L_TURNING	7
#define L_CURSOR	8
#define L_TALK	9
#define L_LISTEN	10
#define L_STOPPED	11
#define L_CHOOSE	12
#define L_FRAMES	13
#define L_PAUSE	14
#define L_WAIT_SYNC	15
#define L_SIMPLE_MOD	16

// characters with own colour set
#define SP_COL_FOSTER 194
#define SP_COL_JOEY 216
#define SP_COL_JOBS 209
#define SP_COL_SO 218
#define SP_COL_HOLO 234
#define SP_COL_LAMB 203
#define SP_COL_FOREMAN 205
#define SP_COL_SHADES 217
#define SP_COL_MONITOR 224
#define SP_COL_WRECK 219     //wreck guard
#define SP_COL_ANITA 73
#define SP_COL_DAD 224
#define SP_COL_SON 223
#define SP_COL_GALAG 194
#define SP_COL_ANCHOR 85      //194
#define SP_COL_BURKE 192
#define SP_COL_BODY 234
#define SP_COL_MEDI 235
#define SP_COL_SKORL 241     //skorl guard    will probably go
#define SP_COL_ANDROID2 222
#define SP_COL_ANDROID3 222
#define SP_COL_KEN 222
#define SP_COL_HENRI30 128     //207
#define SP_COL_GUARD31 216
#define SP_DAN_COL 228
#define SP_COL_BUZZER32 228     //124
#define SP_COL_VINCENT32 193
#define SP_COL_GARDENER32 145
#define SP_COL_WITNESS 195
#define SP_COL_JOBS82 209
#define SP_COL_KEN81 224
#define SP_COL_FATHER81 177
#define SP_COL_TREVOR 216
#define SP_COL_RADMAN 193
#define SP_COL_BARMAN36 144
#define SP_COL_BABS36 202
#define SP_COL_GALLAGHER36 145
#define SP_COL_COLSTON36 146
#define SP_COL_JUKEBOX36 176
#define SP_COL_JUDGE42 193
#define SP_COL_CLERK42 195
#define SP_COL_PROS42 217
#define SP_COL_JOBS42 209

#define SP_COL_HOLOGRAM_B 255
#define SP_COL_BLUE 255
#define SP_COL_LOADER 255

#define SP_COL_UCHAR 255

#define ST_NO_VMASK 0x200

// Files.asm
#define DISK_1	(2048)
#define DISK_2	(2048*2)
#define DISK_3	(2048*3)
#define DISK_4	(2048*4)
#define DISK_5	(2048*5)
#define DISK_6	(2048*6)
#define DISK_7	(2048*7)
#define DISK_8	(2048*8)
#define DISK_9	(2048*9)
#define DISK_10	(2048*10)
#define DISK_12	(2048*12)
#define DISK_13	(2048*13)
#define DISK_14	(2048*14)
#define DISK_15	(2048*15)
#define F_MODULE_0	60400
#define F_MODULE_1	60401
#define CHAR_SET_FILE	60150

// Script.equ
#define STD_BASE	(0x0000+0x1)
#define ADVISOR_188	(0x0000+0x2)
#define JUST_INTERACT	(0x0000+0x3)
#define MEGA_CLICK	(0x0000+0x4)
#define STD_EXIT_RIGHT_ON	(0x0000+0x5)
#define STD_EXIT_LEFT_ON	(0x0000+0x6)
#define STD_EXIT_DOWN_ON	(0x0000+0x7)
#define STD_EXIT_UP_ON	(0x0000+0x8)
#define STD_ON	(0x0000+0x9)
#define STD_OFF	(0x0000+0xa)
#define TEXT_ON	(0x0000+0xb)
#define TEXT_OFF	(0x0000+0xc)
#define START_MENU	(0x0000+0xd)
#define MENU_SELECT	(0x0000+0xe)
#define CLICK_LEFT_ARROW	(0x0000+0xf)
#define CLICK_RIGHT_ARROW	(0x0000+0x10)
#define TOUCH_MENU	(0x0000+0x11)
#define UNTOUCH_MENU	(0x0000+0x12)
#define TOUCH_ARROW	(0x0000+0x13)
#define UNTOUCH_ARROW	(0x0000+0x14)
#define MENU_SCRIPT	(0x0000+0x15)
#define TEXT_CLICK	(0x0000+0x16)
#define RESET_MOUSE	(0x0000+0x17)
#define CLICK_DEBUG	(0x0000+0x18)
#define STD_MEGA_STOP	(0x0000+0x19)
#define STD_PLAYER_STOP	(0x0000+0x1a)
#define STD_MINI_BUMP	(0x0000+0x1b)
#define RET_OK	(0x0000+0x1c)
#define RET_FAIL	(0x0000+0x1d)
#define STD_ADJOIN_FLOOR	(0x0000+0x1e)
#define FLOOR_ACTION	(0x0000+0x1f)
#define ANIMATE_LOGIC	(0x0000+0x20)
#define STORE_188	(0x0000+0x21)
#define TEXT_EDIT	(0x0000+0x22)
#define SHOUT_SSS	(0x0000+0x23)
#define SHOUT_ACTION	(0x0000+0x24)
#define MEGA_SSS	(0x0000+0x25)
#define MEGA_ACTION	(0x0000+0x26)
#define BASE_INTRO	(0x0000+0x27)
#define FURNACE_D_ACTION	(0x0000+0x28)
#define STAIR6_ACTION	(0x0000+0x29)
#define GET_TO_JP2	(0x0000+0x2a)
#define JOEY_EXTRA	(0x0000+0x2b)
#define JOEY_LOGIC	(0x0000+0x2c)
#define SECURITY_EXIT_ACTION	(0x0000+0x2d)
#define SMALL_DOOR_ACTION	(0x0000+0x2e)
#define LINK_7_29	(0x0000+0x2f)
#define LINK_29_7	(0x0000+0x30)
#define LAMB_TO_3	(0x0000+0x31)
#define LAMB_TO_2	(0x0000+0x32)
#define SS_SIGN_ACTION	(0x0000+0x33)
#define SCANNER_10_LOGIC	(0x0000+0x34)
#define SLOT_10_ACTION	(0x0000+0x35)
#define DAD_SCAN_SSS	(0x0000+0x36)
#define LOBBY_SLOT_ACTION	(0x0000+0x37)
#define LINK_28_31	(0x0000+0x38)
#define LINK_31_28	(0x0000+0x39)
#define LINK_65_66	(0x0000+0x3a)
#define DEATH_SCRIPT	(0x0000+0x3b)
#define RESTART_BUTTON_LOGIC	(0x0000+0x3c)
#define RESTORE_BUTTON_LOGIC	(0x0000+0x3d)
#define EXIT_BUTTON_LOGIC	(0x0000+0x3e)
#define DEATH_CLICK	(0x0000+0x3f)
#define STD_GIVE_UP	(0x1000+0x1)
#define GET_TO_TALK1	(0x1000+0x2)
#define GET_TO_TALK2	(0x1000+0x3)
#define STAIRS_FROM_LOW	(0x1000+0x4)
#define STAIRS_FROM_HIGH	(0x1000+0x5)
#define STAIR_ACTION	(0x1000+0x6)
#define CLIMB_STAIRS	(0x1000+0x7)
#define SS_SHOOTS	(0x1000+0x8)
#define UPSTAIR_ACTION	(0x1000+0x9)
#define DECEND	(0x1000+0xa)
#define START_MINI_SS	(0x1000+0xb)
#define ALERT_SS	(0x1000+0xc)
#define MORE_SS	(0x1000+0xd)
#define BAR_ACTION	(0x1000+0xe)
#define GET_TO_BAR	(0x1000+0xf)
#define FULL_SS_CUT	(0x1000+0x10)
#define CUT_SEQ	(0x1000+0x11)
#define FIRE_EXIT_ACTION	(0x1000+0x12)
#define GET_TO_FEXIT	(0x1000+0x13)
#define FEXIT_DOOR	(0x1000+0x14)
#define FEXIT_ON	(0x1000+0x15)
#define SMALL_DOOR_LOGIC	(0x1000+0x16)
#define GET_TO_SMALL_DOOR	(0x1000+0x17)
#define ER0_ACTION	(0x1000+0x18)
#define ER0_ALT	(0x1000+0x19)
#define GET_TO_ER0	(0x1000+0x1a)
#define FAN1_LOGIC	(0x1000+0x1b)
#define FAN2_LOGIC	(0x1000+0x1c)
#define FAN3_LOGIC	(0x1000+0x1d)
#define FAN4_LOGIC	(0x1000+0x1e)
#define FAN5_LOGIC	(0x1000+0x1f)
#define FAN6_LOGIC	(0x1000+0x20)
#define FAN7_LOGIC	(0x1000+0x21)
#define UPLOAD_WAIT	(0x1000+0x22)
#define GET_TO_UPLOAD	(0x1000+0x23)
#define LAZER_GUN_LOGIC	(0x1000+0x24)
#define LOAD_POINT_LOGIC	(0x1000+0x25)
#define NOTICE_LOGIC	(0x1000+0x26)
#define NOTICE_ACTION	(0x1000+0x27)
#define GET_TO_NOTICE	(0x1000+0x28)
#define PRESS_LOGIC	(0x1000+0x29)
#define PRESS_ACTION	(0x1000+0x2a)
#define GET_TO_PRESS	(0x1000+0x2b)
#define LOAD_POINT_ACTION	(0x1000+0x2c)
#define SMALL_DOOR_ON	(0x1000+0x2d)
#define OUT_EXIT_ON	(0x1000+0x2e)
#define R1EXIT_DOOR	(0x1000+0x2f)
#define GET_TO_R1_DOOR	(0x1000+0x30)
#define S1_DOOR_ACTION	(0x1000+0x31)
#define GET_TO_NOTICE2	(0x1000+0x32)
#define NOTICE2_ACTION	(0x1000+0x33)
#define GET_TO_SS_SIGN	(0x1000+0x34)
#define LFAN1_LOGIC	(0x1000+0x35)
#define LFAN2_LOGIC	(0x1000+0x36)
#define SMOKE1_LOGIC	(0x1000+0x37)
#define SMOKE2_LOGIC	(0x1000+0x38)
#define FIRE1_LOGIC	(0x1000+0x39)
#define FIRE2_LOGIC	(0x1000+0x3a)
#define CAR_LOGIC	(0x1000+0x3b)
#define ER0_WALK_ON	(0x1000+0x3c)
#define S2_WALK_ON	(0x1000+0x3d)
#define EL2_ACTION	(0x1000+0x3e)
#define GET_TO_EL2	(0x1000+0x3f)
#define GET_TO_TALK21	(0x1000+0x40)
#define MEGA_FAILED_S2	(0x1000+0x41)
#define GET_TO_TALK22	(0x1000+0x42)
#define GET_TO_ER2	(0x1000+0x43)
#define FIRST_INTERACT	(0x1000+0x44)
#define ER2_ACTION	(0x1000+0x45)
#define TOP_LIFT_ACTION	(0x1000+0x46)
#define LIFT_WAIT	(0x1000+0x47)
#define GET_TO_LIFTER	(0x1000+0x48)
#define LIFT_TO_FLOOR	(0x1000+0x49)
#define TOP_BARREL_LOGIC	(0x1000+0x4a)
#define LIGHT_LOGIC	(0x1000+0x4b)
#define GET_TO_LIGHT1	(0x1000+0x4c)
#define PANEL_LOGIC	(0x1000+0x4d)
#define ALARM_LOGIC	(0x1000+0x4e)
#define GET_TO_HOLE	(0x1000+0x4f)
#define HOLE_ACTION	(0x1000+0x50)
#define DEAD_LOSS	(0x1000+0x51)
#define GET_TO_TRANSPORTER	(0x1000+0x52)
#define TRANSPORTER_ACTION	(0x1000+0x53)
#define TRANS_ALIVE_ACTION	(0x1000+0x54)
#define JOEY_START	(0x1000+0x55)
#define JOEY_MISSION	(0x1000+0x56)
#define TRANS_MISSION	(0x1000+0x57)
#define SHELL_ACTION	(0x1000+0x58)
#define GET_TO_SHELL	(0x1000+0x59)
#define LIGHT1_ACTION	(0x1000+0x5a)
#define GET_TO_LEDS	(0x1000+0x5b)
#define GT_PANEL2	(0x1000+0x5c)
#define PANEL2_ACTION	(0x1000+0x5d)
#define GT_JUNK1	(0x1000+0x5e)
#define JUNK1_ACTION	(0x1000+0x5f)
#define GT_JUNK2	(0x1000+0x60)
#define JUNK2_ACTION	(0x1000+0x61)
#define TOP_LIFT_LOGIC	(0x1000+0x62)
#define TOP_LIFT_2_LOGIC	(0x1000+0x63)
#define LOW_LIFT_LOGIC	(0x1000+0x64)
#define LOW_LIFT2_LOGIC	(0x1000+0x65)
#define LOW_LIFT3_LOGIC	(0x1000+0x66)
#define STEVE_SPY_LOGIC	(0x1000+0x67)
#define LOW_BARREL_LOGIC	(0x1000+0x68)
#define CONVEY_LOGIC	(0x1000+0x69)
#define FLY_LOGIC	(0x1000+0x6a)
#define FURNACE_LOGIC	(0x1000+0x6b)
#define LIGHTS1_LOGIC	(0x1000+0x6c)
#define EYE_BALL_LOGIC	(0x1000+0x6d)
#define NEW_EYE_BALL	(0x1000+0x6e)
#define FURNACE_DOOR_LOGIC	(0x1000+0x6f)
#define GET_TO_FURNACE_DOOR	(0x1000+0x70)
#define GET_TO_SLOT	(0x1000+0x71)
#define SLOT_ACTION	(0x1000+0x72)
#define SLOT_MISSION	(0x1000+0x73)
#define SHADES_LOGIC	(0x1000+0x74)
#define CORNER_MISSION	(0x1000+0x75)
#define EYE_BOLT_LOGIC	(0x1000+0x76)
#define SMOULDER_LOGIC	(0x1000+0x77)
#define GET_TO_BODY	(0x1000+0x78)
#define SMOULDER_ACTION	(0x1000+0x79)
#define GET_TO_EYE	(0x1000+0x7a)
#define EYE_ACTION	(0x1000+0x7b)
#define GET_TO_FURNACE	(0x1000+0x7c)
#define FURNACE_ACTION	(0x1000+0x7d)
#define FURNACE_EXIT_ON	(0x1000+0x7e)
#define GET_TO_EL4	(0x1000+0x7f)
#define S4_WALK_ON	(0x1000+0x80)
#define EL4_ACTION	(0x1000+0x81)
#define PLAYER_FAIL_S4	(0x1000+0x82)
#define GET_TO_TALK41	(0x1000+0x83)
#define MEGA_FAILED_S4	(0x1000+0x84)
#define GET_TO_TALK42	(0x1000+0x85)
#define TV_LOGIC	(0x1000+0x86)
#define KNOB_ACTION	(0x1000+0x87)
#define KNOB_LOGIC	(0x1000+0x88)
#define CHUCK_LOGIC	(0x1000+0x89)
#define LAZER_LOGIC	(0x1000+0x8a)
#define GT_LAZER	(0x1000+0x8b)
#define LAZER_ACTION	(0x1000+0x8c)
#define CUPBOARD_LOGIC	(0x1000+0x8d)
#define CUPBOARD_ALERT	(0x1000+0x8e)
#define CUPBOARD_ACTION	(0x1000+0x8f)
#define GET_TO_CUPBOARD	(0x1000+0x90)
#define GET_TO_SHELVES	(0x1000+0x91)
#define GET_TO_KNOB	(0x1000+0x92)
#define GET_TO_CHUCK	(0x1000+0x93)
#define GET_TO_SCREENS	(0x1000+0x94)
#define SPANNER_ACTION	(0x1000+0x95)
#define SARNIE_ACTION	(0x1000+0x96)
#define GET_TO_BUTTONS	(0x1000+0x97)
#define MONITOR_LOGIC	(0x1000+0x98)
#define BUTTON_ACTION	(0x1000+0x99)
#define POSTCARD_ACTION	(0x1000+0x9a)
#define GET_TO_POSTCARD	(0x1000+0x9b)
#define NOTICE4_ACTION	(0x1000+0x9c)
#define CHUCK_ACTION	(0x1000+0x9d)
#define TV_1_ACTION	(0x1000+0x9e)
#define TV_2_ACTION	(0x1000+0x9f)
#define GET_TO_MONITOR	(0x1000+0xa0)
#define JOBS_ALARMED	(0x1000+0xa1)
#define JOBS_S4	(0x1000+0xa2)
#define MORE_JOBS	(0x1000+0xa3)
#define BASIC_JOBS	(0x1000+0xa4)
#define START_JOBS	(0x1000+0xa5)
#define DEAD_LOGIC	(0x1000+0xa6)
#define LOADER_LOGIC	(0x1000+0xa7)
#define LOADER_START	(0x1000+0xa8)
#define JOBS_SPEECH	(0x1000+0xa9)
#define UNUSED	(0x1000+0xaa)
#define GET_TO_STAIRS6	(0x2000+0x1)
#define GET_SECURITY_S6	(0x2000+0x2)
#define JOEY_FLY_TO_6	(0x2000+0x3)
#define GET_TO_L_EXIT_S6	(0x2000+0x4)
#define EL6_ACTION	(0x2000+0x5)
#define S5_WALK_ON	(0x2000+0x6)
#define S5_STROLL_ON	(0x2000+0x7)
#define GET_TO_R_EXIT_S5	(0x2000+0x8)
#define ER5_ACTION	(0x2000+0x9)
#define S6_WALK_ON	(0x2000+0xa)
#define GET_TO_R_EXIT_S6	(0x2000+0xb)
#define S6_RWALK_ON	(0x2000+0xc)
#define INTO_18_FAIL	(0x2000+0xd)
#define GET_TO_L_EXIT_S5	(0x2000+0xe)
#define LDOOR_5_ACTION	(0x2000+0xf)
#define S6_DOOR_ACTION	(0x2000+0x10)
#define S6_SEC_WALK_ON	(0x2000+0x11)
#define SKORL_LOGIC	(0x2000+0x12)
#define SKORL_SSS	(0x2000+0x13)
#define SKORL_ACTION	(0x2000+0x14)
#define GET_TO_SKORL	(0x2000+0x15)
#define GET_TO_SECURITY_EXIT	(0x2000+0x16)
#define ER6_ACTION	(0x2000+0x17)
#define EL7_ACTION	(0x2000+0x18)
#define GET_TO_L_EXIT_S7	(0x2000+0x19)
#define S7_WALK_ON	(0x2000+0x1a)
#define GET_TO_R_EXIT_S7	(0x2000+0x1b)
#define ER7_ACTION	(0x2000+0x1c)
#define S8_WALK_ON	(0x2000+0x1d)
#define ED8_ACTION	(0x2000+0x1e)
#define GET_TO_EXIT_S8	(0x2000+0x1f)
#define S7_RIGHT_ON	(0x2000+0x20)
#define GET_TO_WRECK	(0x2000+0x21)
#define WRECK_ACTION	(0x2000+0x22)
#define WRECK_LOGIC	(0x2000+0x23)
#define FACT_FAIL	(0x2000+0x24)
#define GET_TO_FACTORY	(0x2000+0x25)
#define FACTORY_ENTRY_ACTION	(0x2000+0x26)
#define S12_WALK_ON	(0x2000+0x27)
#define GT_S7_LINC	(0x2000+0x28)
#define GT_S7_SLOT	(0x2000+0x29)
#define GT_LIFT_NOTICE	(0x2000+0x2a)
#define LIFT_NOTICE_ACTION	(0x2000+0x2b)
#define S7_SLOT_ACTION	(0x2000+0x2c)
#define LINC_S7_ACTION	(0x2000+0x2d)
#define LEFT_FAIL_7	(0x2000+0x2e)
#define GT_L_TALK_7	(0x2000+0x2f)
#define RIGHT_FAIL_7	(0x2000+0x30)
#define GT_R_TALK_7	(0x2000+0x31)
#define JOEY_OUT_OF_LIFT7	(0x2000+0x32)
#define CABLE_7_LOGIC	(0x2000+0x33)
#define GT_CABLE_7	(0x2000+0x34)
#define CABLE_7_ACTION	(0x2000+0x35)
#define CABLE_MISSION	(0x2000+0x36)
#define GT_S7_LIFT	(0x2000+0x37)
#define S7_LIFT_LOGIC	(0x2000+0x38)
#define JOEY_TO_LIFT	(0x2000+0x39)
#define LIFT_S7_ACTION	(0x2000+0x3a)
#define COPTER_ACTION	(0x2000+0x3b)
#define S9_WALK_ON	(0x2000+0x3c)
#define FANS_LOGIC	(0x2000+0x3d)
#define GET_TO_L_EXIT_S9	(0x2000+0x3e)
#define EL9_ACTION	(0x2000+0x3f)
#define LOBBY_DOOR_LOGIC	(0x2000+0x40)
#define LOBBY_DOOR_ON	(0x2000+0x41)
#define GET_TO_LOBBY_DOOR	(0x2000+0x42)
#define LOBBY_DOOR_ACTION	(0x2000+0x43)
#define SCANNER_LOGIC	(0x2000+0x44)
#define GET_TO_SCANNER	(0x2000+0x45)
#define SCANNER_ACTION	(0x2000+0x46)
#define DAD_LOGIC	(0x2000+0x47)
#define DAD_SSS	(0x2000+0x48)
#define DAD_ACTION	(0x2000+0x49)
#define GET_TO_DAD	(0x2000+0x4a)
#define GET_TO_SON	(0x2000+0x4b)
#define SON_LOGIC	(0x2000+0x4c)
#define SON_ACTION	(0x2000+0x4d)
#define GT_LINC_S9	(0x2000+0x4e)
#define LINC_S9_ACTION	(0x2000+0x4f)
#define GET_TO_R_EXIT_S18	(0x2000+0x50)
#define S18_WALK_ON	(0x2000+0x51)
#define ER18_ACTION	(0x2000+0x52)
#define MONITOR_SLEEP	(0x2000+0x53)
#define SON_SSS	(0x2000+0x54)
#define STEAM_FRIGHT	(0x2000+0x55)
#define MONITOR_ALERT	(0x2000+0x56)
#define STEAM_LOGIC	(0x2000+0x57)
#define POWER_DOOR_LOGIC	(0x2000+0x58)
#define POWER_MOTOR_LOGIC	(0x2000+0x59)
#define POWER_PANEL_LOGIC	(0x2000+0x5a)
#define GET_TO_POWER_PANEL	(0x2000+0x5b)
#define SOCKET_ACTION	(0x2000+0x5c)
#define POWER_SWITCH_LOGIC	(0x2000+0x5d)
#define GET_TO_POWER_SWITCH	(0x2000+0x5e)
#define SWITCH_ACTION	(0x2000+0x5f)
#define CHAIR_FAIL	(0x2000+0x60)
#define GET_TO_POWER_CHAIR	(0x2000+0x61)
#define GET_TO_LEFT_SKULL	(0x2000+0x62)
#define GET_TO_RIGHT_SKULL	(0x2000+0x63)
#define LEFT_SKULL_ACTION	(0x2000+0x64)
#define POWER_BANG_LOGIC	(0x2000+0x65)
#define RIGHT_SKULL_ACTION	(0x2000+0x66)
#define GET_TO_TALK	(0x2000+0x67)
#define GORDON_SSS	(0x2000+0x68)
#define SAT_GORDON_ACTION	(0x2000+0x69)
#define GET_TO_POWER_DOOR	(0x2000+0x6a)
#define POWER_DOOR_ACTION	(0x2000+0x6b)
#define JOEY_BUTTON_MISSION	(0x2000+0x6c)
#define LEFT_LEVER_LOGIC	(0x2000+0x6d)
#define RIGHT_LEVER_LOGIC	(0x2000+0x6e)
#define LEFT_LEVER_ACTION	(0x2000+0x6f)
#define RIGHT_LEVER_ACTION	(0x2000+0x70)
#define GET_TO_RIGHT_LEVER	(0x2000+0x71)
#define GET_TO_LEFT_LEVER	(0x2000+0x72)
#define CHAIR_ACTION	(0x2000+0x73)
#define S12_LEFT_ON	(0x2000+0x74)
#define GET_TO_FACTORY_EXIT	(0x2000+0x75)
#define FACTORY_EXIT_ACTION	(0x2000+0x76)
#define LAMB_LEAVE_FACTORY	(0x2000+0x77)
#define LAMB_FACT_2	(0x2000+0x78)
#define LAMB_FACT_RETURN	(0x2000+0x79)
#define LAMB_FACTORY_START	(0x2000+0x7a)
#define LAMB_FORCE_START	(0x2000+0x7b)
#define GT_FACT1_EXIT	(0x2000+0x7c)
#define FACT1_EXIT_ACTION	(0x2000+0x7d)
#define S12_RIGHT_ON	(0x2000+0x7e)
#define ANITA_WORK	(0x2000+0x7f)
#define ANITA_SSS	(0x2000+0x80)
#define ANITA_ACTION	(0x2000+0x81)
#define GT_ANITA	(0x2000+0x82)
#define BOTBELT_LOGIC	(0x2000+0x83)
#define STD_FACT_LOGIC	(0x2000+0x84)
#define ANITA_ALERT	(0x2000+0x85)
#define ANITA_SPY_ACTION	(0x2000+0x86)
#define ANITA_SPY_LOGIC	(0x2000+0x87)
#define TICK_OFF_II	(0x2000+0x88)
#define GT_TICK_OFF	(0x2000+0x89)
#define WELDER_LOGIC	(0x2000+0x8a)
#define GT_WELDER	(0x2000+0x8b)
#define WELDER_ACTION	(0x2000+0x8c)
#define LEFT_FAIL_12	(0x2000+0x8d)
#define GT_L_TALK_12	(0x2000+0x8e)
#define RIGHT_FAIL_12	(0x2000+0x8f)
#define GT_R_TALK_12	(0x2000+0x90)
#define WELDER_MISSION	(0x2000+0x91)
#define JOEY_WELD_MISSION	(0x2000+0x92)
#define GT_STUMP	(0x2000+0x93)
#define STUMP_ACTION	(0x2000+0x94)
#define GT_CONSOLE_12	(0x2000+0x95)
#define CONSOLE_12_ACTION	(0x2000+0x96)
#define GT_TOUR_1	(0x2000+0x97)
#define GT_TOUR_2	(0x2000+0x98)
#define FOREMAN_LAMB	(0x2000+0x99)
#define FOSTER_TOUR	(0x2000+0x9a)
#define LAMB_TOUR	(0x2000+0x9b)
#define ON_FROM_S15	(0x2000+0x9c)
#define S13_LEFT_ON	(0x2000+0x9d)
#define GT_FACT2_L_EXIT	(0x2000+0x9e)
#define FACT2_ACTION	(0x2000+0x9f)
#define FACT2_RIGHT_ACTION	(0x2000+0xa0)
#define GT_FACT2_R_EXIT	(0x2000+0xa1)
#define S13_RIGHT_ON	(0x2000+0xa2)
#define GT_FACT2_STORE_EXIT	(0x2000+0xa3)
#define FACT2_STORE_ACTION	(0x2000+0xa4)
#define GT_COGS	(0x2000+0xa5)
#define FOREMAN_LOGIC	(0x2000+0xa6)
#define FOREMAN_ALERT	(0x2000+0xa7)
#define COGS_ACTION	(0x2000+0xa8)
#define GT_LITE1	(0x2000+0xa9)
#define STORE_ROOM_STOP	(0x2000+0xaa)
#define SENSOR_LOGIC	(0x2000+0xab)
#define RIGHT_FAIL_13	(0x2000+0xac)
#define GT_R_TALK_13	(0x2000+0xad)
#define LEFT_FAIL_13	(0x2000+0xae)
#define GT_L_TALK_13	(0x2000+0xaf)
#define GT_STORE_STOP	(0x2000+0xb0)
#define FACT2_FOREMAN_ALERT	(0x2000+0xb1)
#define FACT2_STOP	(0x2000+0xb2)
#define FACT2_SPY_LOGIC	(0x2000+0xb3)
#define GT_WINDOW	(0x2000+0xb4)
#define WINDOW_ACTION	(0x2000+0xb5)
#define FACT_CONSOLE_LOGIC	(0x2000+0xb6)
#define FOREMAN_STORE_CHECK	(0x2000+0xb7)
#define GT_SENSORS	(0x2000+0xb8)
#define SENSORS_ACTION	(0x2000+0xb9)
#define GT_FACT_CONSOLE	(0x2000+0xba)
#define CONSOLE_13_ACTION	(0x2000+0xbb)
#define RAD_BACK	(0x2000+0xbc)
#define FACT3_ACTION	(0x2000+0xbd)
#define S14_LEFT_ON	(0x2000+0xbe)
#define GT_FACT3_L_EXIT	(0x2000+0xbf)
#define ALT_NU_ANITA	(0x2000+0xc0)
#define GT_NU_ANITA	(0x2000+0xc1)
#define GT_FACT3_R_EXIT	(0x2000+0xc2)
#define LOCKER3_LOGIC	(0x2000+0xc3)
#define LOCKER2_LOGIC	(0x2000+0xc4)
#define LOCKER1_LOGIC	(0x2000+0xc5)
#define LOCKER3_ACTION	(0x2000+0xc6)
#define GT_LOCKER3	(0x2000+0xc7)
#define LOCKER2_ACTION	(0x2000+0xc8)
#define GT_LOCKER2	(0x2000+0xc9)
#define GT_LOCKER1	(0x2000+0xca)
#define LOCKER1_ACTION	(0x2000+0xcb)
#define GT_MACHINE	(0x2000+0xcc)
#define MACHINE_ACTION	(0x2000+0xcd)
#define FACT3_R_ACTION	(0x2000+0xce)
#define S14_RIGHT_ON	(0x2000+0xcf)
#define NU_ANITA_SSS	(0x2000+0xd0)
#define RADMAN_LOGIC	(0x2000+0xd1)
#define LEFT_FAIL_14	(0x2000+0xd2)
#define GT_L_TALK_14	(0x2000+0xd3)
#define RIGHT_FAIL_14	(0x2000+0xd4)
#define GT_R_TALK_14	(0x2000+0xd5)
#define RAD_SCREEN_ACTION	(0x2000+0xd6)
#define GT_RAD_SCREEN	(0x2000+0xd7)
#define GT_14_CONSOLE	(0x2000+0xd8)
#define CONSOLE_14_ACTION	(0x2000+0xd9)
#define COAT_LOGIC	(0x2000+0xda)
#define GT_COAT	(0x2000+0xdb)
#define COAT_ACTION	(0x2000+0xdc)
#define S15_WALK_ON	(0x2000+0xdd)
#define GT_STORE_EXIT	(0x2000+0xde)
#define STORE_EXIT_ACTION	(0x2000+0xdf)
#define JOEY_42_MISS	(0x2000+0xe0)
#define JOEY_JUNCTION_MISS	(0x2000+0xe1)
#define GT_JUNCTION_BOX	(0x2000+0xe2)
#define JUNCTION_ACTION	(0x2000+0xe3)
#define FLAP_LOGIC	(0x2000+0xe4)
#define GT_FLAP	(0x2000+0xe5)
#define FLAP_ACTION	(0x2000+0xe6)
#define GT_SKEY	(0x2000+0xe7)
#define GT_WD40	(0x2000+0xe8)
#define SKEY_ACTION	(0x2000+0xe9)
#define WD40_ACTION	(0x2000+0xea)
#define SHELF_OBJECT_LOGIC	(0x2000+0xeb)
#define FLOOR_PUTTY_ACTION	(0x2000+0xec)
#define GT_PUTTY	(0x2000+0xed)
#define FORKLIFT_LOGIC	(0x2000+0xee)
#define S16_LEFT_ON	(0x2000+0xef)
#define ENTRANCE_EXIT_ACTION	(0x2000+0xf0)
#define GT_ENTRANCE_EXIT	(0x2000+0xf1)
#define GT_ALT_CONSOLE	(0x2000+0xf2)
#define GT_REACTOR_CONSOLE	(0x2000+0xf3)
#define REACTOR_PC_ACTION	(0x2000+0xf4)
#define REACTOR_DOOR_ACTION	(0x2000+0xf5)
#define GT_REACTOR_DOOR	(0x2000+0xf6)
#define LEFT_FAIL_16	(0x2000+0xf7)
#define GT_L_TALK_16	(0x2000+0xf8)
#define RIGHT_FAIL_16	(0x2000+0xf9)
#define GT_R_TALK_16	(0x2000+0xfa)
#define REACTOR_ON	(0x2000+0xfb)
#define S17_LEFT_ON	(0x2000+0xfc)
#define GT_CORE_EXIT	(0x2000+0xfd)
#define CORE_EXIT_ACTION	(0x2000+0xfe)
#define S16_CORE_ON	(0x2000+0xff)
#define GT_ANITA_CARD	(0x2000+0x100)
#define ANITA_CARD_ACTION	(0x2000+0x101)
#define GT_RODS	(0x2000+0x102)
#define RODS_ACTION	(0x2000+0x103)
#define CONSOLE_16_LOGIC	(0x2000+0x104)
#define S10_RIGHT_ON	(0x3000+0x1)
#define GT_LEFT_EXIT_10	(0x3000+0x2)
#define EL10_ACTION	(0x3000+0x3)
#define LIFT_10_LOGIC	(0x3000+0x4)
#define GT_SLOT_10	(0x3000+0x5)
#define POD_LOGIC	(0x3000+0x6)
#define POD_LIGHT_LOGIC	(0x3000+0x7)
#define POD_LIGHT_ACTION	(0x3000+0x8)
#define GT_POD_LIGHT	(0x3000+0x9)
#define GT_LINC_10	(0x3000+0xa)
#define LINC_10_ACTION	(0x3000+0xb)
#define GT_FLOOR_FROM_CHAIR10	(0x3000+0xc)
#define GT_TERMINAL_10	(0x3000+0xd)
#define TERMINAL_10_ACTION	(0x3000+0xe)
#define GT_SCANNER_10	(0x3000+0xf)
#define SCANNER_10_ACTION	(0x3000+0x10)
#define GT_DOOR_10	(0x3000+0x11)
#define DOOR_10_ACTION	(0x3000+0x12)
#define GT_SLOT_11	(0x3000+0x13)
#define SLOT_11_ACTION	(0x3000+0x14)
#define GT_SOCCER_1	(0x3000+0x15)
#define SOCCER_1_ACTION	(0x3000+0x16)
#define GT_SOCCER_2	(0x3000+0x17)
#define GT_SOCCER_3	(0x3000+0x18)
#define GT_SOCCER_4	(0x3000+0x19)
#define GT_SOCCER_5	(0x3000+0x1a)
#define SLAT_ACTION	(0x3000+0x1b)
#define GT_RIGHT_EXIT_11	(0x3000+0x1c)
#define ER11_ACTION	(0x3000+0x1d)
#define S11_LEFT_ON	(0x3000+0x1e)
#define GT_LEFT_EXIT_19	(0x3000+0x1f)
#define EL19_ACTION	(0x3000+0x20)
#define GT_TOP_RIGHT_19	(0x3000+0x21)
#define TOP_R19_ACTION	(0x3000+0x22)
#define UCHAR_SSS	(0x3000+0x23)
#define UCHAR_ACTION	(0x3000+0x24)
#define GET_TO_UCHAR	(0x3000+0x25)
#define UCHAR_LOGIC	(0x3000+0x26)
#define S20_START_ON	(0x3000+0x27)
#define DOWN_20_FAIL	(0x3000+0x28)
#define GT_DOWN_EXIT_20	(0x3000+0x29)
#define ED20_ACTION	(0x3000+0x2a)
#define REICH_20_ON	(0x3000+0x2b)
#define REICH_DOOR_FAIL	(0x3000+0x2c)
#define GT_REICH_DOOR_20	(0x3000+0x2d)
#define REICH_DOOR_20_ACTION	(0x3000+0x2e)
#define GT_REICH_SLOT	(0x3000+0x2f)
#define REICH_SLOT_ACTION	(0x3000+0x30)
#define S20_REICH_ON	(0x3000+0x31)
#define REICH_DOOR_20_LOGIC	(0x3000+0x32)
#define LAMB_DOOR_20_LOGIC	(0x3000+0x33)
#define LAMB_SLOT_FAIL	(0x3000+0x34)
#define GT_LAMB_SLOT	(0x3000+0x35)
#define LAMB_SLOT_ACTION	(0x3000+0x36)
#define LAMB_20_ON	(0x3000+0x37)
#define LAMB_DOOR_FAIL	(0x3000+0x38)
#define GT_LAMB_DOOR_20	(0x3000+0x39)
#define LAMB_DOOR_20_ACTION	(0x3000+0x3a)
#define S20_LAMB_ON	(0x3000+0x3b)
#define GT_SHRUB_1	(0x3000+0x3c)
#define SHRUB_1_ACTION	(0x3000+0x3d)
#define GT_SHRUB_2	(0x3000+0x3e)
#define SHRUB_2_ACTION	(0x3000+0x3f)
#define GT_SHRUB_3	(0x3000+0x40)
#define SHRUB_3_ACTION	(0x3000+0x41)
#define START_20	(0x3000+0x42)
#define GAL_LOGIC	(0x3000+0x43)
#define GT_GALLAGER_BEL	(0x3000+0x44)
#define GAL_BEL_ACTION	(0x3000+0x45)
#define GT_REICH_WINDOW	(0x3000+0x46)
#define REICH_WINDOW_ACTION	(0x3000+0x47)
#define GT_LAMB_WINDOW	(0x3000+0x48)
#define LAMB_WINDOW_ACTION	(0x3000+0x49)
#define LEFT_FAIL_20	(0x3000+0x4a)
#define GT_L_TALK_20	(0x3000+0x4b)
#define RIGHT_FAIL_20	(0x3000+0x4c)
#define GT_R_TALK_20	(0x3000+0x4d)
#define S21_START_ON	(0x3000+0x4e)
#define GT_LEFT_EXIT_21	(0x3000+0x4f)
#define EL21_ACTION	(0x3000+0x50)
#define GT_LAMBS_BOOKS	(0x3000+0x51)
#define LAMBS_BOOKS_ACTION	(0x3000+0x52)
#define GT_LAMBS_CHAIR	(0x3000+0x53)
#define LAMBS_CHAIR_ACTION	(0x3000+0x54)
#define GT_DISPENSOR	(0x3000+0x55)
#define DISPENSOR_ACTION	(0x3000+0x56)
#define CAT_FOOD_LOGIC	(0x3000+0x57)
#define GT_CAT_FOOD	(0x3000+0x58)
#define CAT_FOOD_ACTION	(0x3000+0x59)
#define VIDEO_LOGIC	(0x3000+0x5a)
#define GT_VIDEO	(0x3000+0x5b)
#define VIDEO_ACTION	(0x3000+0x5c)
#define GT_CASSETTE	(0x3000+0x5d)
#define CASSETTE_ACTION	(0x3000+0x5e)
#define GT_BIG_PICT1	(0x3000+0x5f)
#define BIG_PICT1_ACTION	(0x3000+0x60)
#define GT_VIDEO_SCREEN	(0x3000+0x61)
#define VIDEO_SCREEN_ACTION	(0x3000+0x62)
#define VIDEO_SCREEN_LOGIC	(0x3000+0x63)
#define GT_BIG_PICT2	(0x3000+0x64)
#define BIG_PICT2_ACTION	(0x3000+0x65)
#define GT_BIG_PICT3	(0x3000+0x66)
#define BIG_PICT3_ACTION	(0x3000+0x67)
#define CAT_LOGIC	(0x3000+0x68)
#define GT_CAT	(0x3000+0x69)
#define CAT_ACTION	(0x3000+0x6a)
#define INNER_LAMB_DOOR_LOGIC	(0x3000+0x6b)
#define S22_START_ON	(0x3000+0x6c)
#define GT_RIGHT_EXIT_22	(0x3000+0x6d)
#define ER22_ACTION	(0x3000+0x6e)
#define GT_LAMB_BED	(0x3000+0x6f)
#define BED_ACTION	(0x3000+0x70)
#define GT_LAMB_TV	(0x3000+0x71)
#define LAMB_TV_ACTION	(0x3000+0x72)
#define GT_FISH_TANK	(0x3000+0x73)
#define FISH_TANK_ACTION	(0x3000+0x74)
#define FISH_POSTER_ACTION	(0x3000+0x75)
#define PILLOW_LOGIC	(0x3000+0x76)
#define GT_PILLOW	(0x3000+0x77)
#define PILLOW_ACTION	(0x3000+0x78)
#define GT_MAGAZINE	(0x3000+0x79)
#define MAGAZINE_ACTION	(0x3000+0x7a)
#define FISH_LOGIC	(0x3000+0x7b)
#define GT_REICH_CHAIR	(0x3000+0x7c)
#define REICH_CHAIR_ACTION	(0x3000+0x7d)
#define GT_CABINET	(0x3000+0x7e)
#define CABINET_ACTION	(0x3000+0x7f)
#define GT_CERT	(0x3000+0x80)
#define CERT_ACTION	(0x3000+0x81)
#define GT_REICH_PICTURE	(0x3000+0x82)
#define REICH_PICTURE_ACTION	(0x3000+0x83)
#define GT_FISH_FOOD	(0x3000+0x84)
#define FISH_FOOD_ACTION	(0x3000+0x85)
#define INNER_R_DOOR_LOGIC	(0x3000+0x86)
#define S23_LEFT_ON	(0x3000+0x87)
#define S23_ANCHOR_ON	(0x3000+0x88)
#define S23_TRAVEL_ON	(0x3000+0x89)
#define GT_LEFT_EXIT_23	(0x3000+0x8a)
#define EL23_ACTION	(0x3000+0x8b)
#define GT_ANCHOR_EXIT_23	(0x3000+0x8c)
#define ANCHOR23_ACTION	(0x3000+0x8d)
#define GT_TRAVEL_FAIL	(0x3000+0x8e)
#define GT_TRAVEL_EXIT_23	(0x3000+0x8f)
#define TRAVEL_23_ACTION	(0x3000+0x90)
#define GT_BIN_23	(0x3000+0x91)
#define BIN_23_ACTION	(0x3000+0x92)
#define GT_SCULPTURE	(0x3000+0x93)
#define SCULPTURE_ACTION	(0x3000+0x94)
#define GT_LINK_23	(0x3000+0x95)
#define LINK_23_ACTION	(0x3000+0x96)
#define GT_WRECK_23	(0x3000+0x97)
#define WRECK_23_ACTION	(0x3000+0x98)
#define GT_SMALL_23	(0x3000+0x99)
#define SML_EXIT_S23_ACTION	(0x3000+0x9a)
#define S24_LEFT_ON	(0x3000+0x9b)
#define GT_LEFT_EXIT_24	(0x3000+0x9c)
#define EL24_ACTION	(0x3000+0x9d)
#define GT_LONDON_POSTER	(0x3000+0x9e)
#define LONDON_ACTION	(0x3000+0x9f)
#define GT_NEW_YORK	(0x3000+0xa0)
#define NEW_YORK_ACTION	(0x3000+0xa1)
#define GT_MURAL	(0x3000+0xa2)
#define MURAL_ACTION	(0x3000+0xa3)
#define GT_PIDGEONS	(0x3000+0xa4)
#define PIDGEONS_ACTION	(0x3000+0xa5)
#define TREVOR_LOGIC	(0x3000+0xa6)
#define TREVOR_SSS	(0x3000+0xa7)
#define TREVOR_ACTION	(0x3000+0xa8)
#define GT_TREVOR	(0x3000+0xa9)
#define TICKET_LOGIC	(0x3000+0xaa)
#define TICKET_ACTION	(0x3000+0xab)
#define GT_TICKET	(0x3000+0xac)
#define GT_GLOBE	(0x3000+0xad)
#define GLOBE_ACTION	(0x3000+0xae)
#define GLOBE_LOGIC	(0x3000+0xaf)
#define S25_LEFT_ON	(0x3000+0xb0)
#define GT_ANCHOR_EXIT_25	(0x3000+0xb1)
#define ANCHOR25_ACTION	(0x3000+0xb2)
#define ANCHOR_LOGIC	(0x3000+0xb3)
#define ANCHOR_SSS	(0x3000+0xb4)
#define ANCHOR_ACTION	(0x3000+0xb5)
#define GT_ANCHOR	(0x3000+0xb6)
#define ANCHOR_MISSION	(0x3000+0xb7)
#define JOEY_PC_MISSION	(0x3000+0xb8)
#define GT_ANCHOR_PC	(0x3000+0xb9)
#define HOOK_LOGIC	(0x3000+0xba)
#define GT_STATUE_25	(0x3000+0xbb)
#define STATUE_25_ACTION	(0x3000+0xbc)
#define HOOK_MISSION	(0x3000+0xbd)
#define LAZER_25_LOGIC	(0x3000+0xbe)
#define SPARK_25_LOGIC	(0x3000+0xbf)
#define GT_HOOK	(0x3000+0xc0)
#define HOOK_ACTION	(0x3000+0xc1)
#define GT_SALES_CHART	(0x3000+0xc2)
#define SALES_CHART_ACTION	(0x3000+0xc3)
#define S26_LEFT_ON	(0x3000+0xc4)
#define S26_RIGHT_ON	(0x3000+0xc5)
#define GT_RIGHT_EXIT_26	(0x3000+0xc6)
#define ER26_ACTION	(0x3000+0xc7)
#define START_26	(0x3000+0xc8)
#define GT_POSTER	(0x3000+0xc9)
#define POSTER1_ACTION	(0x3000+0xca)
#define POSTER2_ACTION	(0x3000+0xcb)
#define POSTER3_ACTION	(0x3000+0xcc)
#define POSTER4_ACTION	(0x3000+0xcd)
#define GT_PLANT	(0x3000+0xce)
#define PLANT_26_ACTION	(0x3000+0xcf)
#define NU_GT_HOLO	(0x3000+0xd0)
#define GT_HOLO	(0x3000+0xd1)
#define HOLO_ACTION	(0x3000+0xd2)
#define HELGA_LOGIC	(0x3000+0xd3)
#define JOEY_HELGA_MISSION	(0x3000+0xd4)
#define GT_LEFT_EXIT_26	(0x3000+0xd5)
#define EL26_ACTION	(0x3000+0xd6)
#define HELGA_ACTION	(0x3000+0xd7)
#define BIO_DOOR_LOGIC	(0x3000+0xd8)
#define GT_BIO_DOOR	(0x3000+0xd9)
#define BIO_DOOR_ACTION	(0x3000+0xda)
#define GT_LEAFLET	(0x3000+0xdb)
#define LEAFLET_LOGIC	(0x3000+0xdc)
#define LEAFLET_ACTION	(0x3000+0xdd)
#define S27_RIGHT_ON	(0x3000+0xde)
#define GT_RIGHT_EXIT_27	(0x3000+0xdf)
#define ER27_ACTION	(0x3000+0xe0)
#define GT_CHART1	(0x3000+0xe1)
#define CHART1_ACTION	(0x3000+0xe2)
#define GT_CHART2	(0x3000+0xe3)
#define CHART2_ACTION	(0x3000+0xe4)
#define GT_GAS	(0x3000+0xe5)
#define GAS_ACTION	(0x3000+0xe6)
#define GT_CHAIR_27	(0x3000+0xe7)
#define CHAIR_27_ACTION	(0x3000+0xe8)
#define GT_FLOOR_FROM_CHAIR	(0x3000+0xe9)
#define GT_SCANNER_27	(0x3000+0xea)
#define SCANNER_27_ACTION	(0x3000+0xeb)
#define GT_L_TALK_27	(0x3000+0xec)
#define RIGHT_FAIL_27	(0x3000+0xed)
#define GT_R_TALK_27	(0x3000+0xee)
#define BURKE_LOGIC	(0x3000+0xef)
#define GT_MEDI_COMP	(0x3000+0xf0)
#define MEDI_COMP_ACTION	(0x3000+0xf1)
#define BURKE_1	(0x3000+0xf2)
#define BURKE_2	(0x3000+0xf3)
#define DR_BURKE_1	(0x3000+0xf4)
#define SCANNER_27_LOGIC	(0x3000+0xf5)
#define HELMET_LOGIC	(0x3000+0xf6)
#define BODY_SSS	(0x3000+0xf7)
#define BODY_ACTION	(0x3000+0xf8)
#define BUSY_BODY	(0x3000+0xf9)
#define GT_BODY	(0x3000+0xfa)
#define GT_HELMET	(0x3000+0xfb)
#define HELMET_ACTION	(0x3000+0xfc)
#define GLASS_SLOT_LOGIC	(0x3000+0xfd)
#define GLASS_MISSION	(0x3000+0xfe)
#define MEDIC_LOGIC	(0x3000+0xff)
#define S28_RIGHT_ON	(0x3000+0x100)
#define GT_RIGHT_EXIT_28	(0x3000+0x101)
#define ER28_ACTION	(0x3000+0x102)
#define GT_LEFT_EXIT_28	(0x3000+0x103)
#define EL28_ACTION	(0x3000+0x104)
#define S28_LEFT_ON	(0x3000+0x105)
#define GT_DUSTBIN_28	(0x3000+0x106)
#define DUSTBIN_ACTION	(0x3000+0x107)
#define UP_28_FAIL	(0x3000+0x108)
#define GT_UP_EXIT_28	(0x3000+0x109)
#define EU28_ACTION	(0x3000+0x10a)
#define S28_UP_ON	(0x3000+0x10b)
#define LEFT_FAIL_28	(0x3000+0x10c)
#define GT_L_TALK_28	(0x3000+0x10d)
#define RIGHT_FAIL_28	(0x3000+0x10e)
#define GT_R_TALK_28	(0x3000+0x10f)
#define GT_SML_R_28	(0x3000+0x110)
#define R_28_SML_ACTION	(0x3000+0x111)
#define GT_SML_L_28	(0x3000+0x112)
#define L_28_SML_ACTION	(0x3000+0x113)
#define SML_RIGHT_28	(0x3000+0x114)
#define SML_LEFT_28	(0x3000+0x115)
#define LIFT_28_LOGIC	(0x3000+0x116)
#define GT_LIFT_28	(0x3000+0x117)
#define LIFT_28_ACTION	(0x3000+0x118)
#define S28_SLOT_ACTION	(0x3000+0x119)
#define GT_SLOT_28	(0x3000+0x11a)
#define S29_LIFT_LOGIC	(0x3000+0x11b)
#define JOEY_TO_LIFT29	(0x3000+0x11c)
#define LIFT_29_ACTION	(0x3000+0x11d)
#define GT_29_LIFT	(0x3000+0x11e)
#define S29_SLOT_ACTION	(0x3000+0x11f)
#define GT_29_CARD_SLOT	(0x3000+0x120)
#define JOEY_OUT_OF_LIFT	(0x3000+0x121)
#define GT_RIGHT_EXIT_29	(0x3000+0x122)
#define ER29_ACTION	(0x3000+0x123)
#define S29_RIGHT_ON	(0x3000+0x124)
#define GT_LEFT_EXIT_29	(0x3000+0x125)
#define EL29_ACTION	(0x3000+0x126)
#define S29_LEFT_ON	(0x3000+0x127)
#define OTHER_LIFT_WAIT	(0x3000+0x128)
#define GT_LIFT_WAIT	(0x3000+0x129)
#define LAMB_BELL_LOGIC	(0x3000+0x12a)
#define LAMB_LEAVE_GARDEN	(0x3000+0x12b)
#define LAMB_START_29	(0x3000+0x12c)
#define LEFT_FAIL_29	(0x3000+0x12d)
#define GT_L_TALK_29	(0x3000+0x12e)
#define RIGHT_FAIL_29	(0x3000+0x12f)
#define GT_R_TALK_29	(0x3000+0x130)
#define GT_CABLE_29	(0x3000+0x131)
#define CABLE_29_ACTION	(0x3000+0x132)
#define GT_SML_R_29	(0x3000+0x133)
#define R_29_SML_ACTION	(0x3000+0x134)
#define GT_SML_L_29	(0x3000+0x135)
#define L_29_SML_ACTION	(0x3000+0x136)
#define SML_RIGHT_29	(0x3000+0x137)
#define SML_LEFT_29	(0x3000+0x138)
#define DANI_SPEECH	(0x4000+0x1)
#define HENRI_SPEECH	(0x4000+0x2)
#define BUZZER_SPEECH	(0x4000+0x3)
#define JUKEBOX_SPEECH	(0x4000+0x4)
#define VINCENT_SPEECH	(0x0000+0x40)
#define EDDIE_SPEECH	(0x0000+0x41)
#define BLUNT_SPEECH	(0x0000+0x42)
#define BARRY_SPEECH	(0x4000+0x5)
#define COLSTON_SPEECH	(0x0000+0x43)
#define GALL_SPEECH	(0x0000+0x44)
#define BABS_SPEECH	(0x4000+0x6)
#define CHUTNEY_SPEECH	(0x0000+0x45)
#define DOG_BARK_LOGIC	(0x4000+0x7)
#define SPUNKY_SMELLS_FOOD	(0x4000+0x8)
#define SPUNKY_EXTRA	(0x4000+0x9)
#define SPUNKY_LOGIC	(0x4000+0xa)
#define SPUNKY_EAT_FOOD	(0x4000+0xb)
#define SPUNKY_BARK_AT_FOSTER	(0x4000+0xc)
#define SPUNKY_GO_HOME	(0x4000+0xd)
#define SPUNKY_SEE_VIDEO	(0x4000+0xe)
#define DANIELLE_SSS	(0x4000+0xf)
#define GT_SC31_DANIELLE	(0x4000+0x10)
#define SC31_DANI_ACTION	(0x4000+0x11)
#define DANI_CHAT_TO_GUARD	(0x4000+0x12)
#define GT_DANI_WAIT	(0x4000+0x13)
#define DANIELLE_EXTRA	(0x4000+0x14)
#define DANIELLE_LOGIC	(0x4000+0x15)
#define GT_SC32_DANIELLE_AT_LIFT	(0x4000+0x16)
#define SC32_DANIELLE_AT_LIFT_ACTION	(0x4000+0x17)
#define DANIELLE_GO_HOME	(0x4000+0x18)
#define GT_SC38_DANIELLE	(0x4000+0x19)
#define SC38_DANIELLE_ACTION	(0x4000+0x1a)
#define GT_SC38_HAND_SET	(0x4000+0x1b)
#define DANI_ANSWER_PHONE	(0x4000+0x1c)
#define FOSTER_VISIT_DANI	(0x4000+0x1d)
#define GN_SC30_LEFT_TALK	(0x4000+0x1e)
#define GT_SC30_LEFT_TALK	(0x4000+0x1f)
#define GN_SC30_RIGHT_TALK	(0x4000+0x20)
#define GT_SC30_RIGHT_TALK	(0x4000+0x21)
#define SC30_EXIT_31_WALK_ON	(0x4000+0x22)
#define GT_SC30_EXIT_31	(0x4000+0x23)
#define SC30_EXIT_31_ACTION	(0x4000+0x24)
#define SC30_EXIT_33_WALK_ON	(0x4000+0x25)
#define GT_SC30_EXIT_33	(0x4000+0x26)
#define SC30_EXIT_33_ACTION	(0x4000+0x27)
#define SC30_COURT_DOOR_MOUSE_ON	(0x4000+0x28)
#define SC30_COURT_DOOR_WALK_ON	(0x4000+0x29)
#define GT_SC30_COURT_DOOR	(0x4000+0x2a)
#define SC30_COURT_DOOR_ACTION	(0x4000+0x2b)
#define SC30_COURT_DOOR_LOGIC	(0x4000+0x2c)
#define GT_SC30_NOTICE	(0x4000+0x2d)
#define SC30_NOTICE_ACTION	(0x4000+0x2e)
#define GT_SC30_STATUE_1	(0x4000+0x2f)
#define SC30_STATUE_1_ACTION	(0x4000+0x30)
#define GT_SC30_STATUE_2	(0x4000+0x31)
#define SC30_STATUE_2_ACTION	(0x4000+0x32)
#define SC30_HENRI_LOGIC	(0x4000+0x33)
#define SC30_HENRI_SSS	(0x4000+0x34)
#define GT_SC30_HENRI	(0x4000+0x35)
#define SC30_HENRI_ACTION	(0x4000+0x36)
#define SC30_EXIT_36_WALK_ON	(0x4000+0x37)
#define GT_SC30_EXIT_36	(0x4000+0x38)
#define SC30_EXIT_36_ACTION	(0x4000+0x39)
#define GN_SC31_LEFT_TALK	(0x4000+0x3a)
#define GT_SC31_LEFT_TALK	(0x4000+0x3b)
#define GN_SC31_RIGHT_TALK	(0x4000+0x3c)
#define GT_SC31_RIGHT_TALK	(0x4000+0x3d)
#define SC31_EXIT_30_WALK_ON	(0x4000+0x3e)
#define GT_SC31_EXIT_30	(0x4000+0x3f)
#define SC31_EXIT_30_ACTION	(0x4000+0x40)
#define SC31_EXIT_32_WALK_ON	(0x4000+0x41)
#define GT_SC31_EXIT_32	(0x4000+0x42)
#define SC31_EXIT_32_ACTION	(0x4000+0x43)
#define GT_SC31_LIFT_SLOT	(0x4000+0x44)
#define SC31_LIFT_SLOT_ACTION	(0x4000+0x45)
#define GT_SC31_LIFT	(0x4000+0x46)
#define SC31_LIFT_ACTION	(0x4000+0x47)
#define SC31_LIFT_LOGIC	(0x4000+0x48)
#define SC31_GUARD_RESCUE_DOG	(0x4000+0x49)
#define GT_SC31_END_OF_ROPE	(0x4000+0x4a)
#define SC31_END_OF_ROPE_ACTION	(0x4000+0x4b)
#define SC31_ROPE_LOGIC	(0x4000+0x4c)
#define SC31_BRICKS_LOGIC	(0x4000+0x4d)
#define SC31_PLANK_LOGIC	(0x4000+0x4e)
#define SC31_BISCUITS_LOGIC	(0x4000+0x4f)
#define GT_SC31_BRICKS	(0x4000+0x50)
#define SC31_BRICKS_ACTION	(0x4000+0x51)
#define GN_SC31_PLANK	(0x4000+0x52)
#define GT_SC31_PLANK	(0x4000+0x53)
#define SC31_PLANK_ACTION	(0x4000+0x54)
#define SC31_GUARD_LOGIC	(0x4000+0x55)
#define SC31_GUARD_CHATTING_LOGIC	(0x4000+0x56)
#define SC31_GUARD_SSS	(0x4000+0x57)
#define GN_SC31_GUARD	(0x4000+0x58)
#define GT_SC31_GUARD	(0x4000+0x59)
#define SC31_GUARD_ACTION	(0x4000+0x5a)
#define SC31_GUARD_CHATTING_ACTION	(0x4000+0x5b)
#define SC31_EXIT_39_WALK_ON	(0x4000+0x5c)
#define GT_SC31_EXIT_39	(0x4000+0x5d)
#define SC31_EXIT_39_ACTION	(0x4000+0x5e)
#define SC31_JOEY_LOGIC	(0x4000+0x5f)
#define GT_SC31_JOEY	(0x4000+0x60)
#define SC31_JOEY_ACTION	(0x4000+0x61)
#define SC31_AT_WATCHER_LOGIC	(0x4000+0x62)
#define GN_SC32_LEFT_TALK	(0x4000+0x63)
#define GT_SC32_LEFT_TALK	(0x4000+0x64)
#define GN_SC32_RIGHT_TALK	(0x4000+0x65)
#define GT_SC32_RIGHT_TALK	(0x4000+0x66)
#define SC32_EXIT_31_WALK_ON	(0x4000+0x67)
#define GT_SC32_EXIT_31	(0x4000+0x68)
#define SC32_EXIT_31_ACTION	(0x4000+0x69)
#define SC32_EXIT_33_WALK_ON	(0x4000+0x6a)
#define GT_SC32_EXIT_33	(0x4000+0x6b)
#define SC32_EXIT_33_ACTION	(0x4000+0x6c)
#define GT_SC32_TERMINAL	(0x4000+0x6d)
#define SC32_TERMINAL_ACTION	(0x4000+0x6e)
#define GT_SC32_PLANT_1	(0x4000+0x6f)
#define SC32_PLANT_1_ACTION	(0x4000+0x70)
#define GT_SC32_PLANT_2	(0x4000+0x71)
#define SC32_PLANT_2_ACTION	(0x4000+0x72)
#define GT_SC32_PLANT_3	(0x4000+0x73)
#define SC32_PLANT_3_ACTION	(0x4000+0x74)
#define SC32_BUZZER_LOGIC	(0x4000+0x75)
#define GT_SC32_BUZZER	(0x4000+0x76)
#define SC32_BUZZER_ACTION	(0x4000+0x77)
#define GT_SC32_LIFT	(0x4000+0x78)
#define SC32_LIFT_ACTION	(0x4000+0x79)
#define SC32_LIFT_LOGIC	(0x4000+0x7a)
#define SC32_VINCENT_LOGIC	(0x4000+0x7b)
#define SC32_VINCENT_SSS	(0x4000+0x7c)
#define GT_SC32_VINCENT	(0x4000+0x7d)
#define SC32_VINCENT_ACTION	(0x4000+0x7e)
#define SC32_GARDENER_LOGIC	(0x4000+0x7f)
#define SC32_GARDENER_SSS	(0x4000+0x80)
#define GT_SC32_GARDENER	(0x4000+0x81)
#define SC32_GARDENER_ACTION	(0x4000+0x82)
#define GN_SC33_LEFT_TALK	(0x4000+0x83)
#define GT_SC33_LEFT_TALK	(0x4000+0x84)
#define GN_SC33_RIGHT_TALK	(0x4000+0x85)
#define GT_SC33_RIGHT_TALK	(0x4000+0x86)
#define SC33_EXIT_30_WALK_ON	(0x4000+0x87)
#define GT_SC33_EXIT_30	(0x4000+0x88)
#define SC33_EXIT_30_ACTION	(0x4000+0x89)
#define SC33_EXIT_32_WALK_ON	(0x4000+0x8a)
#define GT_SC33_EXIT_32	(0x4000+0x8b)
#define SC33_EXIT_32_ACTION	(0x4000+0x8c)
#define SC33_SHED_DOOR_LOGIC	(0x4000+0x8d)
#define SC33_SHED_DOOR_MOUSE_ON	(0x4000+0x8e)
#define SC33_SHED_DOOR_WALK_ON	(0x4000+0x8f)
#define GT_SC33_SHED_DOOR	(0x4000+0x90)
#define SC33_SHED_DOOR_ACTION	(0x4000+0x91)
#define GT_SC33_LOCK	(0x4000+0x92)
#define SC33_LOCK_ACTION	(0x4000+0x93)
#define SC34_DOOR_WALK_ON	(0x4000+0x94)
#define GT_SC34_DOOR	(0x4000+0x95)
#define SC34_DOOR_ACTION	(0x4000+0x96)
#define GT_SC34_SECATEURS	(0x4000+0x97)
#define SC34_SECATEURS_ACTION	(0x4000+0x98)
#define SC34_SECATEURS_LOGIC	(0x4000+0x99)
#define GT_SC34_TKT_MACHINE	(0x4000+0x9a)
#define SC34_TKT_MACHINE_ACTION	(0x4000+0x9b)
#define GT_SC34_MAP	(0x4000+0x9c)
#define SC34_MAP_ACTION	(0x4000+0x9d)
#define GT_SC34_BRICKS	(0x4000+0x9e)
#define SC34_BRICKS_ACTION	(0x4000+0x9f)
#define GN_SC36_LEFT_TALK	(0x4000+0xa0)
#define GT_SC36_LEFT_TALK	(0x4000+0xa1)
#define GN_SC36_RIGHT_TALK	(0x4000+0xa2)
#define GT_SC36_RIGHT_TALK	(0x4000+0xa3)
#define GT_SC36_LOW_FLOOR	(0x4000+0xa4)
#define GT_SC36_FLOOR	(0x4000+0xa5)
#define SC36_EXIT_30_WALK_ON	(0x4000+0xa6)
#define GT_SC36_EXIT_30	(0x4000+0xa7)
#define SC36_EXIT_30_ACTION	(0x4000+0xa8)
#define GT_SC36_SENSOR	(0x4000+0xa9)
#define SC36_SENSOR_ACTION	(0x4000+0xaa)
#define SC36_DOOR_WALK_ON	(0x4000+0xab)
#define GT_SC36_DOOR	(0x4000+0xac)
#define SC36_DOOR_ACTION	(0x4000+0xad)
#define SC36_DOOR_LOGIC	(0x4000+0xae)
#define SC36_BAND_LOGIC	(0x4000+0xaf)
#define GT_SC36_BAND	(0x4000+0xb0)
#define SC36_BAND_ACTION	(0x4000+0xb1)
#define SC36_JUKE_LIGHT_LOGIC	(0x4000+0xb2)
#define SC36_COLSTON_FIX_JUKEBOX	(0x4000+0xb3)
#define PLAY_TUNE_1	(0x4000+0xb4)
#define PLAY_TUNE_2	(0x4000+0xb5)
#define PLAY_TUNE_3	(0x4000+0xb6)
#define SC36_JUKEBOX_SSS	(0x4000+0xb7)
#define SC36_JUKEBOX_LOGIC	(0x4000+0xb8)
#define GT_SC36_JUKEBOX	(0x4000+0xb9)
#define SC36_JUKEBOX_ACTION	(0x4000+0xba)
#define SC36_BARMAN_LOGIC	(0x4000+0xbb)
#define SC36_BARMAN_SSS	(0x4000+0xbc)
#define GT_SC36_BARMAN	(0x4000+0xbd)
#define SC36_BARMAN_ACTION	(0x4000+0xbe)
#define SC36_COLSTON_LOGIC	(0x4000+0xbf)
#define SC36_COLSTON_SSS	(0x4000+0xc0)
#define GT_SC36_COLSTON	(0x4000+0xc1)
#define SC36_COLSTON_ACTION	(0x4000+0xc2)
#define SC36_GALLAGHER_LOGIC	(0x4000+0xc3)
#define SC36_GALLAGHER_SSS	(0x4000+0xc4)
#define GT_SC36_GALLAGHER	(0x4000+0xc5)
#define SC36_GALLAGHER_ACTION	(0x4000+0xc6)
#define SC36_CARDS_LOGIC	(0x4000+0xc7)
#define GT_SC36_GLASS	(0x4000+0xc8)
#define SC36_COLSTON_PROTEST	(0x4000+0xc9)
#define SC36_GLASS_ACTION	(0x4000+0xca)
#define MOVE_BABS	(0x4000+0xcb)
#define SC36_BABS_LOGIC	(0x4000+0xcc)
#define BABS_LOGIC_AMIGA	(0x4000+0xcd)
#define GT_BABS_AMIGA	(0x4000+0xce)
#define BABS_SSS_AMIGA	(0x4000+0xcf)
#define BABS_ACTION_AMIGA	(0x4000+0xd0)
#define GT_SC37_SENSOR	(0x4000+0xd1)
#define SC37_SENSOR_ACTION	(0x4000+0xd2)
#define SC37_DOOR_WALK_ON	(0x4000+0xd3)
#define GT_SC37_DOOR	(0x4000+0xd4)
#define SC37_DOOR_ACTION	(0x4000+0xd5)
#define SC37_DOOR_LOGIC	(0x4000+0xd6)
#define GT_SC37_GRILL	(0x4000+0xd7)
#define SC37_GRILL_ACTION	(0x4000+0xd8)
#define SC37_GRILL_LOGIC	(0x4000+0xd9)
#define GT_SC37_FLIMSY_BOX	(0x4000+0xda)
#define SC37_FLIMSY_BOX_ACTION	(0x4000+0xdb)
#define STEP_OFF_BOX	(0x4000+0xdc)
#define GT_SC37_BIG_BOX	(0x4000+0xdd)
#define SC37_BIG_BOX_ACTION	(0x4000+0xde)
#define GT_SC37_LID	(0x4000+0xdf)
#define SC37_LID_ACTION	(0x4000+0xe0)
#define PUT_LID_BACK	(0x4000+0xe1)
#define USE_LID_ON_FLIMSY_BOX	(0x4000+0xe2)
#define SC37_LID_LOGIC	(0x4000+0xe3)
#define GT_SC37_WINE_RACK	(0x4000+0xe4)
#define SC37_WINE_RACK_ACTION	(0x4000+0xe5)
#define GN_SC38_LEFT_TALK	(0x4000+0xe6)
#define GT_SC38_LEFT_TALK	(0x4000+0xe7)
#define GN_SC38_RIGHT_TALK	(0x4000+0xe8)
#define GT_SC38_RIGHT_TALK	(0x4000+0xe9)
#define GT_SC38_LIFT	(0x4000+0xea)
#define SC38_LIFT_ACTION	(0x4000+0xeb)
#define SC38_LIFT_LOGIC	(0x4000+0xec)
#define GT_SC38_STATUE	(0x4000+0xed)
#define SC38_STATUE_ACTION	(0x4000+0xee)
#define GT_SC38_VIDEO	(0x4000+0xef)
#define SC38_VIDEO_ACTION	(0x4000+0xf0)
#define SC38_VIDEO_LOGIC	(0x4000+0xf1)
#define GT_SC38_MONITOR	(0x4000+0xf2)
#define SC38_MONITOR_ACTION	(0x4000+0xf3)
#define SC38_MONITOR_LOGIC	(0x4000+0xf4)
#define GT_SC38_SOFA	(0x4000+0xf5)
#define SC38_SOFA_ACTION	(0x4000+0xf6)
#define GT_SC38_DOG_TRAY	(0x4000+0xf7)
#define SC38_DOG_TRAY_ACTION	(0x4000+0xf8)
#define GT_SC38_BISCUITS	(0x4000+0xf9)
#define SC38_BISCUITS_ACTION	(0x4000+0xfa)
#define SC38_RINGER_LOGIC	(0x4000+0xfb)
#define SC39_EXIT_31_WALK_ON	(0x4000+0xfc)
#define GT_SC39_EXIT_31	(0x4000+0xfd)
#define SC39_EXIT_31_ACTION	(0x4000+0xfe)
#define GT_SC39_EXIT_40	(0x4000+0xff)
#define SC39_EXIT_40_ACTION	(0x4000+0x100)
#define SC39_EXIT_41_WALK_ON	(0x4000+0x101)
#define GT_SC39_EXIT_41	(0x4000+0x102)
#define SC39_EXIT_41_ACTION	(0x4000+0x103)
#define GT_SC39_WALTERS	(0x4000+0x104)
#define SC39_WALTERS_ACTION	(0x4000+0x105)
#define GT_SC40_EXIT_39	(0x4000+0x106)
#define SC40_EXIT_39_ACTION	(0x4000+0x107)
#define GT_SC40_CABINET	(0x4000+0x108)
#define SC40_CABINET_ACTION	(0x4000+0x109)
#define GT_SC40_TROLLEY	(0x4000+0x10a)
#define SC40_TROLLEY_ACTION	(0x4000+0x10b)
#define GT_SC40_LOCKER_1	(0x4000+0x10c)
#define SC40_LOCKER_1_ACTION	(0x4000+0x10d)
#define GT_SC40_LOCKER_2	(0x4000+0x10e)
#define SC40_LOCKER_2_ACTION	(0x4000+0x10f)
#define GT_SC40_LOCKER_3	(0x4000+0x110)
#define SC40_LOCKER_3_ACTION	(0x4000+0x111)
#define GT_SC40_LOCKER_4	(0x4000+0x112)
#define SC40_LOCKER_4_ACTION	(0x4000+0x113)
#define GT_SC40_LOCKER_5	(0x4000+0x114)
#define SC40_LOCKER_5_ACTION	(0x4000+0x115)
#define GT_SC40_BODY_1	(0x4000+0x116)
#define SC40_BODY_1_ACTION	(0x4000+0x117)
#define GT_SC40_BODY_2	(0x4000+0x118)
#define SC40_BODY_2_ACTION	(0x4000+0x119)
#define GT_SC40_BODY_3	(0x4000+0x11a)
#define SC40_BODY_3_ACTION	(0x4000+0x11b)
#define GT_SC40_BODY_4	(0x4000+0x11c)
#define SC40_BODY_4_ACTION	(0x4000+0x11d)
#define GT_SC40_BODY_5	(0x4000+0x11e)
#define SC40_BODY_5_ACTION	(0x4000+0x11f)
#define SC40_LOCKER_1_LOGIC	(0x4000+0x120)
#define SC40_LOCKER_2_LOGIC	(0x4000+0x121)
#define SC40_LOCKER_3_LOGIC	(0x4000+0x122)
#define SC40_LOCKER_4_LOGIC	(0x4000+0x123)
#define SC40_LOCKER_5_LOGIC	(0x4000+0x124)
#define SC41_EXIT_39_WALK_ON	(0x4000+0x125)
#define GT_SC41_EXIT_39	(0x4000+0x126)
#define SC41_EXIT_39_ACTION	(0x4000+0x127)
#define SC41_HEAT_1_LOGIC	(0x4000+0x128)
#define SC41_HEAT_2_LOGIC	(0x4000+0x129)
#define SC41_HEAT_3_LOGIC	(0x4000+0x12a)
#define FOSTER_ENTER_COURT	(0x4000+0x12b)
#define SC42_JUDGE_LOGIC	(0x4000+0x12c)
#define SC42_CLERK_LOGIC	(0x4000+0x12d)
#define SC42_PROSECUTION_LOGIC	(0x4000+0x12e)
#define SC42_JOBSWORTH_LOGIC	(0x4000+0x12f)
#define SC42_BLUNT_LOGIC	(0x4000+0x130)
#define SC42_DANI_LOGIC	(0x4000+0x131)
#define SC42_SIGN_LOGIC	(0x4000+0x132)
#define SC44_EXIT_45_WALK_ON	(0x4000+0x133)
#define GT_SC44_EXIT_45	(0x4000+0x134)
#define SC44_EXIT_45_ACTION	(0x4000+0x135)
#define GT_SC44_GRILL	(0x4000+0x136)
#define SC44_GRILL_ACTION	(0x4000+0x137)
#define GT_SC44_RUBBLE	(0x4000+0x138)
#define SC44_RUBBLE_ACTION	(0x4000+0x139)
#define SC45_EXIT_44_WALK_ON	(0x4000+0x13a)
#define GT_SC45_EXIT_44	(0x4000+0x13b)
#define SC45_EXIT_44_ACTION	(0x4000+0x13c)
#define SC45_EXIT_46_WALK_ON	(0x4000+0x13d)
#define GT_SC45_EXIT_46	(0x4000+0x13e)
#define SC45_EXIT_46_ACTION	(0x4000+0x13f)
#define SC45_EXIT_47_WALK_ON	(0x4000+0x140)
#define GT_SC45_EXIT_47	(0x4000+0x141)
#define SC45_EXIT_47_ACTION	(0x4000+0x142)
#define SC46_EXIT_45_WALK_ON	(0x4000+0x143)
#define GT_SC46_EXIT_45	(0x4000+0x144)
#define SC46_EXIT_45_ACTION	(0x4000+0x145)
#define GT_SC46_RUBBLE	(0x4000+0x146)
#define SC46_RUBBLE_ACTION	(0x4000+0x147)
#define SC47_EXIT_45_WALK_ON	(0x4000+0x148)
#define GT_SC47_EXIT_45	(0x4000+0x149)
#define SC47_EXIT_45_ACTION	(0x4000+0x14a)
#define SC47_EXIT_48_WALK_ON	(0x4000+0x14b)
#define GT_SC47_EXIT_48	(0x4000+0x14c)
#define SC47_EXIT_48_ACTION	(0x4000+0x14d)
#define SC48_EXIT_47_WALK_ON	(0x4000+0x14e)
#define GT_SC48_EXIT_47	(0x4000+0x14f)
#define SC48_EXIT_47_ACTION	(0x4000+0x150)
#define SC48_EXIT_65_WALK_ON	(0x4000+0x151)
#define GT_SC48_EXIT_65	(0x4000+0x152)
#define SC48_EXIT_65_ACTION	(0x4000+0x153)
#define GT_SC48_SOCKET	(0x4000+0x154)
#define SC48_SOCKET_ACTION	(0x4000+0x155)
#define SC48_SOCKET_LOGIC	(0x4000+0x156)
#define GT_SC48_HOLE	(0x4000+0x157)
#define SC48_HOLE_ACTION	(0x4000+0x158)
#define FOSTER_SEES_EYES	(0x4000+0x159)
#define SC48_HOLE_LOGIC	(0x4000+0x15a)
#define SC48_EYES_LOGIC	(0x4000+0x15b)
#define SC65_EXIT_48_WALK_ON	(0x4000+0x15c)
#define GT_SC65_EXIT_48	(0x4000+0x15d)
#define SC65_EXIT_48_ACTION	(0x4000+0x15e)
#define GT_SC65_EXIT_66	(0x4000+0x15f)
#define GT_SC65_POSTER1	(0x4000+0x160)
#define SC65_POSTER1_ACTION	(0x4000+0x161)
#define GT_SC65_POSTER2	(0x4000+0x162)
#define SC65_POSTER2_ACTION	(0x4000+0x163)
#define GT_SC65_SIGN	(0x4000+0x164)
#define SC65_SIGN_ACTION	(0x4000+0x165)
#define WALTER_SPEECH	(0x5000+0x1)
#define JOEY_MEDIC	(0x5000+0x2)
#define KEN_SPEECH	(0x5000+0x3)
#define BORED_ROOM	(0x5000+0x4)
#define HOBS_END	(0x0000+0x46)
#define GT_JOEY_PARK	(0x5000+0x5)
#define JOEY_MED_EXTRA	(0x5000+0x6)
#define JOEY_MED_LOGIC	(0x5000+0x7)
#define JOEY_MISSION72_EXTRA	(0x5000+0x8)
#define JOEY_MED_MISSION72	(0x5000+0x9)
#define GT_RECHARGING_MEDI	(0x5000+0xa)
#define RECHARGING_MEDI_ACTION	(0x5000+0xb)
#define MEDI_LOGIC	(0x5000+0xc)
#define SC67_MEND_LOGIC	(0x5000+0xd)
#define MEDI_ACTION	(0x5000+0xe)
#define GT_SC71_MEDI_SLOT	(0x5000+0xf)
#define SC71_MEDI_SLOT_ACTION	(0x5000+0x10)
#define SC66_FOSTER_GETS_CRUSHED	(0x5000+0x11)
#define SC66_TIMER_LOGIC	(0x5000+0x12)
#define SC66_DOOR_LOGIC	(0x5000+0x13)
#define SC66_STONES_LOGIC	(0x5000+0x14)
#define SC66_LO_BEAM_LOGIC	(0x5000+0x15)
#define SC66_HI_BEAM_LOGIC	(0x5000+0x16)
#define SC66_ROCK1_LOGIC	(0x5000+0x17)
#define SC66_ROCK2_LOGIC	(0x5000+0x18)
#define SC66_ROCK3_LOGIC	(0x5000+0x19)
#define SC66_HOLE_ACTION	(0x5000+0x1a)
#define SC67_PULSE1_LOGIC	(0x5000+0x1b)
#define SC67_PULSE2_LOGIC	(0x5000+0x1c)
#define SC67_PULSE3_LOGIC	(0x5000+0x1d)
#define SC67_PULSE4_LOGIC	(0x5000+0x1e)
#define SC67_ROCK_LOGIC	(0x5000+0x1f)
#define GT_SC67_BRICKWORK	(0x5000+0x20)
#define SC67_BRICKWORK_ACTION	(0x5000+0x21)
#define SC67_CLOT_LOGIC	(0x5000+0x22)
#define GN_SC67_CLOT	(0x5000+0x23)
#define GT_SC67_CLOT	(0x5000+0x24)
#define SC67_CLOT_ACTION	(0x5000+0x25)
#define GT_SC67_VEIN	(0x5000+0x26)
#define SC67_VEIN_ACTION	(0x5000+0x27)
#define SC67_DOOR_MOUSE_ON	(0x5000+0x28)
#define SC67_DOOR_LOGIC	(0x5000+0x29)
#define SC67_DOOR_WALK_ON	(0x5000+0x2a)
#define GN_SC67_DOOR	(0x5000+0x2b)
#define GT_SC67_DOOR	(0x5000+0x2c)
#define SC67_DOOR_ACTION	(0x5000+0x2d)
#define SC67_PLASTER_LOGIC	(0x5000+0x2e)
#define GT_SC67_PLASTER	(0x5000+0x2f)
#define SC67_PLASTER_ACTION	(0x5000+0x30)
#define SC67_BRICK_LOGIC	(0x5000+0x31)
#define GT_SC67_BRICK	(0x5000+0x32)
#define SC67_BRICK_ACTION	(0x5000+0x33)
#define SC67_CROWBAR_LOGIC	(0x5000+0x34)
#define GT_SC67_CROWBAR	(0x5000+0x35)
#define SC67_CROWBAR_ACTION	(0x5000+0x36)
#define GT_SC68_JOEY_WAIT	(0x5000+0x37)
#define SC68_PULSE1_LOGIC	(0x5000+0x38)
#define SC68_PULSE2_LOGIC	(0x5000+0x39)
#define SC68_PULSE3_LOGIC	(0x5000+0x3a)
#define SC68_PULSE4_LOGIC	(0x5000+0x3b)
#define SC68_PULSE5_LOGIC	(0x5000+0x3c)
#define SC68_PULSE6_LOGIC	(0x5000+0x3d)
#define SC68_SENSOR_LOGIC	(0x5000+0x3e)
#define SC68_DOOR_WALK_ON	(0x5000+0x3f)
#define GN_SC68_DOOR	(0x5000+0x40)
#define GT_SC68_DOOR	(0x5000+0x41)
#define SC68_DOOR_ACTION	(0x5000+0x42)
#define SC68_DOOR_MOUSE_ON	(0x5000+0x43)
#define SC68_DOOR_LOGIC	(0x5000+0x44)
#define GT_SC68_SENSOR	(0x5000+0x45)
#define SC68_SENSOR_ACTION	(0x5000+0x46)
#define GT_SC68_STAIRS	(0x5000+0x47)
#define SC68_STAIRS_ACTION	(0x5000+0x48)
#define SC68_EXIT_WALK_ON	(0x5000+0x49)
#define GT2_SC68_EXIT	(0x5000+0x4a)
#define GT_SC68_EXIT	(0x5000+0x4b)
#define SC68_EXIT_ACTION	(0x5000+0x4c)
#define GT_SC68_GRILL	(0x5000+0x4d)
#define SC68_GRILL_ACTION	(0x5000+0x4e)
#define SC69_PULSE1_LOGIC	(0x5000+0x4f)
#define SC69_PULSE2_LOGIC	(0x5000+0x50)
#define SC69_PULSE3_LOGIC	(0x5000+0x51)
#define SC69_PULSE4_LOGIC	(0x5000+0x52)
#define SC69_PULSE5_LOGIC	(0x5000+0x53)
#define SC69_PULSE6_LOGIC	(0x5000+0x54)
#define SC69_EXIT_WALK_ON	(0x5000+0x55)
#define GT2_SC69_EXIT	(0x5000+0x56)
#define GT_SC69_EXIT	(0x5000+0x57)
#define SC69_EXIT_ACTION	(0x5000+0x58)
#define SC69_DOOR_WALK_ON	(0x5000+0x59)
#define GN_SC69_DOOR	(0x5000+0x5a)
#define GT_SC69_DOOR	(0x5000+0x5b)
#define SC69_DOOR_ACTION	(0x5000+0x5c)
#define GT_SC69_GRILL	(0x5000+0x5d)
#define SC69_GRILL_ACTION	(0x5000+0x5e)
#define GT_SC70_DOOR	(0x5000+0x5f)
#define SC70_DOOR_ACTION	(0x5000+0x60)
#define SC70_IRIS_LOGIC	(0x5000+0x61)
#define SC70_IRIS_OPENED	(0x5000+0x62)
#define SC70_IRIS_CLOSED	(0x5000+0x63)
#define GT_SC70_IRIS	(0x5000+0x64)
#define SC70_IRIS_ACTION	(0x5000+0x65)
#define SC70_BAR_LOGIC	(0x5000+0x66)
#define GT_SC70_BAR	(0x5000+0x67)
#define SC70_BAR_ACTION	(0x5000+0x68)
#define GT_SC70_GRILL	(0x5000+0x69)
#define SC70_GRILL_ACTION	(0x5000+0x6a)
#define SC70_CONTROL_LOGIC	(0x5000+0x6b)
#define GT_SC70_CONTROL	(0x5000+0x6c)
#define SC70_CONTROL_ACTION	(0x5000+0x6d)
#define SC70_PIT_LOGIC	(0x5000+0x6e)
#define GT_SC70_PIT	(0x5000+0x6f)
#define SC70_PIT_ACTION	(0x5000+0x70)
#define GT_SC70_FLOOR	(0x5000+0x71)
#define SC71_DOOR69_WALK_ON	(0x5000+0x72)
#define GN_SC71_DOOR69	(0x5000+0x73)
#define GT_SC71_DOOR69	(0x5000+0x74)
#define SC71_DOOR69_ACTION	(0x5000+0x75)
#define SC71_DOOR72_WALK_ON	(0x5000+0x76)
#define GN_SC71_DOOR72	(0x5000+0x77)
#define GT_SC71_DOOR72	(0x5000+0x78)
#define SC71_DOOR72_ACTION	(0x5000+0x79)
#define GN_INTO_RECHARGING_UNIT	(0x5000+0x7a)
#define GET_INTO_RECHARGING_UNIT	(0x5000+0x7b)
#define GT_SC71_RECHARGER	(0x5000+0x7c)
#define SC71_RECHARGER_ACTION	(0x5000+0x7d)
#define GT_SC71_MONITOR	(0x5000+0x7e)
#define SC71_MONITOR_ACTION	(0x5000+0x7f)
#define GT_SC71_CONTROLS	(0x5000+0x80)
#define SC71_CONTROLS_ACTION	(0x5000+0x81)
#define GT_SC71_LOCKED_DOOR	(0x5000+0x82)
#define SC71_LOCKED_DOOR_ACTION	(0x5000+0x83)
#define SC71_RECHARGER_LOGIC	(0x5000+0x84)
#define SC71_PANEL2_LOGIC	(0x5000+0x85)
#define SC71_LIGHT1_LOGIC	(0x5000+0x86)
#define SC71_CHLITE_LOGIC	(0x5000+0x87)
#define SC71_MONITOR_LOGIC	(0x5000+0x88)
#define SC71_CONTROLS_LOGIC	(0x5000+0x89)
#define WITNESS_LOGIC	(0x5000+0x8a)
#define SC72_FOSTER_DEATH	(0x5000+0x8b)
#define WITNESS_CATCHES_FOSTER	(0x5000+0x8c)
#define SC72_DOOR_WALK_ON	(0x5000+0x8d)
#define GN_SC72_DOOR	(0x5000+0x8e)
#define GT_SC72_DOOR	(0x5000+0x8f)
#define SC72_DOOR_ACTION	(0x5000+0x90)
#define SC72_EXIT_WALK_ON	(0x5000+0x91)
#define GN_SC72_EXIT	(0x5000+0x92)
#define GT_SC72_EXIT	(0x5000+0x93)
#define SC72_EXIT_ACTION	(0x5000+0x94)
#define SC72_TANK_LOGIC	(0x5000+0x95)
#define GT_SC72_TANK	(0x5000+0x96)
#define SC72_TANK_ACTION	(0x5000+0x97)
#define GT_SC72_TAP	(0x5000+0x98)
#define SC72_TAP_ACTION	(0x5000+0x99)
#define SC72_SPILL_LOGIC	(0x5000+0x9a)
#define GT_SC72_SPILL	(0x5000+0x9b)
#define SC72_SPILL_ACTION	(0x5000+0x9c)
#define SC72_GRILL_LOGIC	(0x5000+0x9d)
#define GT_SC72_GRILL	(0x5000+0x9e)
#define SC72_GRILL_ACTION	(0x5000+0x9f)
#define SC72_CHAMBER1_LOGIC	(0x5000+0xa0)
#define SC72_CHAM1_LIGHT_LOGIC	(0x5000+0xa1)
#define SC72_CHAMBER2_LOGIC	(0x5000+0xa2)
#define SC72_CHAM2_LIGHT_LOGIC	(0x5000+0xa3)
#define SC72_CHAMBER3_LOGIC	(0x5000+0xa4)
#define GT_SC72_CHAMBER1	(0x5000+0xa5)
#define GT_SC72_CHAMBER2	(0x5000+0xa6)
#define GT_SC72_CHAMBER3	(0x5000+0xa7)
#define SC72_CHAMBERS_ACTION	(0x5000+0xa8)
#define GT_SC72_LIGHT1	(0x5000+0xa9)
#define GT_SC72_LIGHT2	(0x5000+0xaa)
#define GT_SC72_LIGHT3	(0x5000+0xab)
#define SC72_ROT_LIGHT_LOGIC	(0x5000+0xac)
#define SC72_COMPUTER_LOGIC	(0x5000+0xad)
#define SC72_COMPUTER2_LOGIC	(0x5000+0xae)
#define GT_SC72_COMPUTER	(0x5000+0xaf)
#define SC72_COMPUTER_ACTION	(0x5000+0xb0)
#define GN_SC72_WITNESS_TALK	(0x5000+0xb1)
#define GT_SC72_WITNESS_TALK	(0x5000+0xb2)
#define GN_SC72_FOSTER_TALK	(0x5000+0xb3)
#define GT_SC72_FOSTER_TALK	(0x5000+0xb4)
#define GT_SC72_WITNESS_KILL	(0x5000+0xb5)
#define GT_SC73_CORPSE	(0x5000+0xb6)
#define SC73_CORPSE_ACTION	(0x5000+0xb7)
#define GALLAGHER_LOGIC73	(0x5000+0xb8)
#define GT_SC73_GALL_1	(0x5000+0xb9)
#define GT_SC73_GALL_2	(0x5000+0xba)
#define GT_SC73_JOEY_WAIT	(0x5000+0xbb)
#define SC73_SENSOR_LOGIC	(0x5000+0xbc)
#define SC73_EXIT_WALK_ON	(0x5000+0xbd)
#define GT2_SC73_EXIT	(0x5000+0xbe)
#define GT_SC73_EXIT	(0x5000+0xbf)
#define SC73_EXIT_ACTION	(0x5000+0xc0)
#define SC73_DOOR_WALK_ON	(0x5000+0xc1)
#define GT_SC73_DOOR	(0x5000+0xc2)
#define SC73_DOOR_ACTION	(0x5000+0xc3)
#define SC73_CHAMBER3_LOGIC	(0x5000+0xc4)
#define SC73_CHAMBER4_LOGIC	(0x5000+0xc5)
#define SC73_CHAM4_LIGHT_LOGIC	(0x5000+0xc6)
#define GT_SC73_CHAMBER4	(0x5000+0xc7)
#define SC73_CHAMBER4_ACTION	(0x5000+0xc8)
#define SC73_CHAMBER5_LOGIC	(0x5000+0xc9)
#define SC73_CHAM5_LIGHT_LOGIC	(0x5000+0xca)
#define GT_SC73_CHAMBER5	(0x5000+0xcb)
#define SC73_CHAMBER5_ACTION	(0x5000+0xcc)
#define SC73_BIG_DOOR_MOUSE_ON	(0x5000+0xcd)
#define SC73_BIG_DOOR_WALK_ON	(0x5000+0xce)
#define GT_SC73_BIG_DOOR	(0x5000+0xcf)
#define SC73_BIG_DOOR_ACTION	(0x5000+0xd0)
#define GT_SC73_SENSOR	(0x5000+0xd1)
#define SC73_SENSOR_ACTION	(0x5000+0xd2)
#define GT_SC73_LOCKED_DOOR	(0x5000+0xd3)
#define SC73_LOCKED_DOOR_ACTION	(0x5000+0xd4)
#define SC73_BITS_LOGIC	(0x5000+0xd5)
#define SC73_BITS2_LOGIC	(0x5000+0xd6)
#define SC73_SPRAY_LOGIC	(0x5000+0xd7)
#define GT_SC73_WRECKED_DROID	(0x5000+0xd8)
#define SC73_WRECKED_DROID_ACTION	(0x5000+0xd9)
#define JOEY_MED_LOGIC73	(0x5000+0xda)
#define SC74_DOOR_WALK_ON	(0x5000+0xdb)
#define GT_SC74_DOOR	(0x5000+0xdc)
#define SC74_DOOR_ACTION	(0x5000+0xdd)
#define SC74_MONITOR1_LOGIC	(0x5000+0xde)
#define SC74_MONITOR2_LOGIC	(0x5000+0xdf)
#define SC74_MONITOR3_LOGIC	(0x5000+0xe0)
#define SC74_MONITOR4_LOGIC	(0x5000+0xe1)
#define SC74_LEFT_TV_LOGIC	(0x5000+0xe2)
#define SC74_RIGHT_TV_LOGIC	(0x5000+0xe3)
#define SC74_LIGHTS_LOGIC	(0x5000+0xe4)
#define GT_SC74_MONITOR1	(0x5000+0xe5)
#define GT_SC74_LEFT_TV	(0x5000+0xe6)
#define GT_SC74_RIGHT_TV	(0x5000+0xe7)
#define SC74_MONITORS_ACTION	(0x5000+0xe8)
#define GT_SC74_INTERFACE	(0x5000+0xe9)
#define SC74_INTERFACE_ACTION	(0x5000+0xea)
#define GT_SC74_FLOOR	(0x5000+0xeb)
#define GT_SC74_INT_SLOT	(0x5000+0xec)
#define SC74_INT_SLOT_ACTION	(0x5000+0xed)
#define SC74_INT_SLOT_LOGIC	(0x5000+0xee)
#define GT_SC74_TERMINAL	(0x5000+0xef)
#define SC74_TERMINAL_ACTION	(0x5000+0xf0)
#define SC74_POD_LOGIC	(0x5000+0xf1)
#define SC75_BIG_DOOR_WALK_ON	(0x5000+0xf2)
#define GT_SC75_BIG_DOOR	(0x5000+0xf3)
#define SC75_BIG_DOOR_ACTION	(0x5000+0xf4)
#define SC75_DOOR_WALK_ON	(0x5000+0xf5)
#define GT_SC75_DOOR	(0x5000+0xf6)
#define SC75_DOOR_ACTION	(0x5000+0xf7)
#define SC75_NITRO_TANK_LOGIC	(0x5000+0xf8)
#define GT_SC75_NITRO_TANK	(0x5000+0xf9)
#define SC75_NITRO_TANK_ACTION	(0x5000+0xfa)
#define SC75_LIVE_TANK_LOGIC	(0x5000+0xfb)
#define GT_SC75_LIVE_TANK	(0x5000+0xfc)
#define SC75_TISSUE_LOGIC	(0x5000+0xfd)
#define SC75_LIVE_TANK_ACTION	(0x5000+0xfe)
#define SC75_CONSOLE_LOGIC	(0x5000+0xff)
#define SC75_CRASH_LOGIC	(0x5000+0x100)
#define GT_SC75_CONSOLE	(0x5000+0x101)
#define SC75_CONSOLE_ACTION	(0x5000+0x102)
#define SC75_TONGS_LOGIC	(0x5000+0x103)
#define GT_SC75_TONGS	(0x5000+0x104)
#define SC75_TONGS_ACTION	(0x5000+0x105)
#define SC75_LIGHT1_LOGIC	(0x5000+0x106)
#define SC75_LIGHT2_LOGIC	(0x5000+0x107)
#define SC76_DOOR75_WALK_ON	(0x5000+0x108)
#define GT_SC76_DOOR75	(0x5000+0x109)
#define SC76_DOOR75_ACTION	(0x5000+0x10a)
#define SC76_DOOR77_WALK_ON	(0x5000+0x10b)
#define GT_SC76_DOOR77	(0x5000+0x10c)
#define SC76_DOOR77_ACTION	(0x5000+0x10d)
#define GT_SC76_ANYTHING	(0x5000+0x10e)
#define SC76_ANDROID_ACTION	(0x5000+0x10f)
#define SC76_CONSOLE_1_ACTION	(0x5000+0x110)
#define SC76_CONSOLE_2_ACTION	(0x5000+0x111)
#define SC76_CONSOLE_3_ACTION	(0x5000+0x112)
#define SC76_BOARD_1_ACTION	(0x5000+0x113)
#define SC76_BOARD_2_ACTION	(0x5000+0x114)
#define SC76_BOARD_3_ACTION	(0x5000+0x115)
#define SC76_BOARD_1_LOGIC	(0x5000+0x116)
#define SC76_BOARD_2_LOGIC	(0x5000+0x117)
#define SC76_BOARD_3_LOGIC	(0x5000+0x118)
#define SC76_CABINET_1_ACTION	(0x5000+0x119)
#define SC76_CABINET_2_ACTION	(0x5000+0x11a)
#define SC76_CABINET_3_ACTION	(0x5000+0x11b)
#define SC76_CABINET_1_LOGIC	(0x5000+0x11c)
#define SC76_CABINET_2_LOGIC	(0x5000+0x11d)
#define SC76_CABINET_3_LOGIC	(0x5000+0x11e)
#define SC76_LIGHT1_LOGIC	(0x5000+0x11f)
#define SC76_LIGHT2_LOGIC	(0x5000+0x120)
#define SC76_LIGHT3_LOGIC	(0x5000+0x121)
#define SC76_LIGHT4_LOGIC	(0x5000+0x122)
#define SC76_LIGHT5_LOGIC	(0x5000+0x123)
#define SC76_LIGHT6_LOGIC	(0x5000+0x124)
#define SC76_LIGHT7_LOGIC	(0x5000+0x125)
#define SC76_LIGHT8_LOGIC	(0x5000+0x126)
#define SC76_LIGHT9_LOGIC	(0x5000+0x127)
#define SC76_ANDROID_1_LOGIC	(0x5000+0x128)
#define SC76_ANDROID_2_LOGIC	(0x5000+0x129)
#define KEN_START_LOGIC	(0x5000+0x12a)
#define SC76_ANDROID_3_LOGIC	(0x5000+0x12b)
#define KEN_EXTRA	(0x5000+0x12c)
#define KEN_LOGIC	(0x5000+0x12d)
#define KEN_STUCK_LOGIC	(0x5000+0x12e)
#define STUCK_SSS	(0x5000+0x12f)
#define GT_SC77_STUCK_KEN	(0x5000+0x130)
#define STUCK_KEN_ACTION	(0x5000+0x131)
#define KEN_MISSION_HAND_EXTRA	(0x5000+0x132)
#define KEN_MISSION_HAND	(0x5000+0x133)
#define SC77_DOOR76_WALK_ON	(0x5000+0x134)
#define GT_SC77_DOOR76	(0x5000+0x135)
#define SC77_DOOR76_ACTION	(0x5000+0x136)
#define SC77_BIG_DOOR_MOUSE_ON	(0x5000+0x137)
#define SC77_BIG_DOOR_LOGIC	(0x5000+0x138)
#define SC77_BIG_DOOR_WALK_ON	(0x5000+0x139)
#define GT_SC77_BIG_DOOR	(0x5000+0x13a)
#define SC77_BIG_DOOR_ACTION	(0x5000+0x13b)
#define GT_SC77_TANKS	(0x5000+0x13c)
#define SC77_TANKS_ACTION	(0x5000+0x13d)
#define GT_SC77_HAND_1	(0x5000+0x13e)
#define SC77_HAND_1_ACTION	(0x5000+0x13f)
#define GN_SC77_HAND_2	(0x5000+0x140)
#define GT_SC77_HAND_2	(0x5000+0x141)
#define SC77_HAND_2_ACTION	(0x5000+0x142)
#define GT_SC78_LEDGE	(0x5000+0x143)
#define GT_SC78_PIPE	(0x5000+0x144)
#define SC78_BIG_DOOR_WALK_ON	(0x5000+0x145)
#define GT_SC78_BIG_DOOR	(0x5000+0x146)
#define SC78_BIG_DOOR_ACTION	(0x5000+0x147)
#define SC78_EXIT_WALK_ON	(0x5000+0x148)
#define GT_SC78_EXIT	(0x5000+0x149)
#define SC78_EXIT_ACTION	(0x5000+0x14a)
#define GT_SC78_SUPPORT	(0x5000+0x14b)
#define SC78_SUPPORT_ACTION	(0x5000+0x14c)
#define SC79_EXIT_WALK_ON	(0x5000+0x14d)
#define GT_SC79_EXIT	(0x5000+0x14e)
#define SC79_EXIT_ACTION	(0x5000+0x14f)
#define GT_SC79_SUPPORT	(0x5000+0x150)
#define SC79_SUPPORT_ACTION	(0x5000+0x151)
#define SC79_KNOT_LOGIC	(0x5000+0x152)
#define GT_SC79_KNOT	(0x5000+0x153)
#define SC79_KNOT_ACTION	(0x5000+0x154)
#define SC79_ROPE_LOGIC	(0x5000+0x155)
#define GT_SC79_ROPE	(0x5000+0x156)
#define SC79_ROPE_ACTION	(0x5000+0x157)
#define GT_SC79_LADDER	(0x5000+0x158)
#define SC79_LADDER_ACTION	(0x5000+0x159)
#define SC80_LADDER_ACTION	(0x5000+0x15a)
#define SC80_ROPE_ACTION	(0x5000+0x15b)
#define SC80_ROPE_LOGIC	(0x5000+0x15c)
#define SC80_SPOUT_ACTION	(0x5000+0x15d)
#define SC80_ORIFICE_ACTION	(0x5000+0x15e)
#define SC80_SAMPLE_LOGIC	(0x5000+0x15f)
#define SC80_EXIT_LOGIC	(0x5000+0x160)
#define SC80_EXIT_ACTION	(0x5000+0x161)
#define SC80_GOO_LOGIC	(0x5000+0x162)
#define SC80_BUBBLE1_LOGIC	(0x5000+0x163)
#define SC80_BUBBLE2_LOGIC	(0x5000+0x164)
#define SC80_BUBBLE3_LOGIC	(0x5000+0x165)
#define SC80_BUBBLE4_LOGIC	(0x5000+0x166)
#define SC80_BUBBLE5_LOGIC	(0x5000+0x167)
#define SC80_BUBBLE6_LOGIC	(0x5000+0x168)
#define SC80_BUBBLE7_LOGIC	(0x5000+0x169)
#define SC80_BUBBLE8_LOGIC	(0x5000+0x16a)
#define SC80_BUBBLE9_LOGIC	(0x5000+0x16b)
#define SC80_BUBBLE10_LOGIC	(0x5000+0x16c)
#define SC80_BUBBLE11_LOGIC	(0x5000+0x16d)
#define SC80_BUBBLE12_LOGIC	(0x5000+0x16e)
#define SC81_PULSE_LOGIC	(0x5000+0x16f)
#define SC81_FATHER_CHAIR_LOGIC	(0x5000+0x170)
#define SC81_FATHER_FLOOR_LOGIC	(0x5000+0x171)
#define SC81_FATHER_FINISHED	(0x5000+0x172)
#define SC81_FATHER_SSS	(0x5000+0x173)
#define SC81_FATHER_FALL	(0x5000+0x174)
#define FOSTER_ENTER_BOARDROOM	(0x5000+0x175)
#define SC81_FATHER_ACTION	(0x5000+0x176)
#define LAST_WORDS_WITH_FATHER	(0x5000+0x177)
#define SC81_KEN_SSS	(0x5000+0x178)
#define SC81_KEN_ACTION	(0x5000+0x179)
#define SC81_DOOR_LOGIC	(0x5000+0x17a)
#define SC81_KEN_LOGIC	(0x5000+0x17b)
#define SC81_FOSTER_ABSORBED	(0x5000+0x17c)
#define SC81_FOSTER_GRABBED	(0x5000+0x17d)
#define SC81_CHAIR_ACTION	(0x5000+0x17e)
#define SC81_TENT1_LOGIC	(0x5000+0x17f)
#define SC81_TENT2_LOGIC	(0x5000+0x180)
#define SC81_TENT3_LOGIC	(0x5000+0x181)
#define SC81_TENT4_LOGIC	(0x5000+0x182)
#define SC81_TENT5_LOGIC	(0x5000+0x183)
#define SC81_TENT6_LOGIC	(0x5000+0x184)
#define SC81_BIG_TENT1_LOGIC	(0x5000+0x185)
#define SC81_BIG_TENT2_LOGIC	(0x5000+0x186)
#define SC81_BIG_TENT3_LOGIC	(0x5000+0x187)
#define SC82_JOBS_SSS	(0x0000+0x47)
#define SC82_JOBSWORTH_LOGIC	(0x0000+0x48)
#define PRINT_CREDITS	(0x0000+0x49)
#define END_SEQUENCE	(0x0000+0x4a)
#define FOSTER_ENTER_NEW_BOARDROOM	(0x0000+0x4b)
#define SC82_KEN_LOGIC	(0x0000+0x4c)
#define S19_LEFT_ON	(0x0000+0x4d)
#define S19_RIGHT_ON	(0x0000+0x4e)
#define GT_RIGHT_EXIT_19	(0x0000+0x4f)
#define ER19_ACTION	(0x0000+0x50)
#define CABLE2_LOGIC	(0x0000+0x51)
#define CABLE_FALL_LOGIC	(0x0000+0x52)
#define SMASHED_WINDOW_LOGIC	(0x0000+0x53)
#define BITS_LOGIC	(0x0000+0x54)
#define GT_CABLE_11	(0x0000+0x55)
#define CABLE_11_ACTION	(0x0000+0x56)
#define SPY11_LOGIC	(0x0000+0x57)
#define LOCKER_11_LOGIC	(0x0000+0x58)
#define GT_LOCKER_11	(0x0000+0x59)
#define LOCKER_11_ACTION	(0x0000+0x5a)
#define START90	(0x0000+0x5b)
#define EXIT_LINC	(0x0000+0x5c)
#define LINC_MENU_SCRIPT	(0x6000+0x1)
#define LINC_MENU_SELECT	(0x6000+0x2)
#define INFO_MENU_SELECT	(0x6000+0x3)
#define DIS_MENU_SELECT	(0x6000+0x4)
#define JOIN_MENU_SELECT	(0x6000+0x5)
#define DECOMP_MENU_SELECT	(0x6000+0x6)
#define DECRYPT_MENU_SELECT	(0x6000+0x7)
#define DOC_MENU_SELECT	(0x6000+0x8)
#define SET_UP_INFO_WINDOW	(0x6000+0x9)
#define INFO_WINDOW_LOGIC	(0x6000+0xa)
#define INFO_BUTTON_LOGIC	(0x6000+0xb)
#define CLOSE_WINDOW	(0x6000+0xc)
#define NORMAL_MOUSE	(0x6000+0xd)
#define BUTTON_MOUSE	(0x6000+0xe)
#define DISCONNECT_FOSTER	(0x6000+0xf)
#define DOOR_L90_LOGIC	(0x6000+0x10)
#define DOOR_L90F_LOGIC	(0x6000+0x11)
#define GET_TO_DOOR_L90	(0x6000+0x12)
#define DOOR_L90_ACTION	(0x6000+0x13)
#define DOOR_R90_LOGIC	(0x6000+0x14)
#define DOOR_R90F_LOGIC	(0x6000+0x15)
#define GET_TO_DOOR_R90	(0x6000+0x16)
#define DOOR_R90_ACTION	(0x6000+0x17)
#define GET_TO_JOIN_OBJECT	(0x6000+0x18)
#define JOIN_OBJECT_ACTION	(0x6000+0x19)
#define JOIN_OBJECT_LOGIC	(0x6000+0x1a)
#define GET_TO_OSCILLATOR	(0x6000+0x1b)
#define OSCILLATOR_ACTION	(0x6000+0x1c)
#define OSCILLATOR_LOGIC	(0x6000+0x1d)
#define GET_TO_EYEBALL_90	(0x6000+0x1e)
#define EYEBALL_90_ACTION	(0x6000+0x1f)
#define EYEBALL_90_LOGIC	(0x6000+0x20)
#define DOOR_L91_LOGIC	(0x6000+0x21)
#define DOOR_L91F_LOGIC	(0x6000+0x22)
#define GET_TO_DOOR_L91	(0x6000+0x23)
#define DOOR_L91_ACTION	(0x6000+0x24)
#define DOOR_R91_LOGIC	(0x6000+0x25)
#define DOOR_R91F_LOGIC	(0x6000+0x26)
#define GET_TO_DOOR_R91	(0x6000+0x27)
#define DOOR_R91_ACTION	(0x6000+0x28)
#define DOOR_T91_LOGIC	(0x6000+0x29)
#define DOOR_T91R_LOGIC	(0x6000+0x2a)
#define GET_TO_DOOR_T91	(0x6000+0x2b)
#define DOOR_T91_ACTION	(0x6000+0x2c)
#define GET_TO_BAG_91	(0x6000+0x2d)
#define BAG_91_ACTION	(0x6000+0x2e)
#define BAG_91_LOGIC	(0x6000+0x2f)
#define GET_TO_DECOMP_OBJ	(0x6000+0x30)
#define DECOMP_OBJ_ACTION	(0x6000+0x31)
#define DECOMP_OBJ_LOGIC	(0x6000+0x32)
#define GET_TO_DECRYPT_OBJ	(0x6000+0x33)
#define DECRYPT_OBJ_ACTION	(0x6000+0x34)
#define DECRYPT_OBJ_LOGIC	(0x6000+0x35)
#define GET_TO_REPORT_BOOK	(0x6000+0x36)
#define REPORT_BOOK_ACTION	(0x6000+0x37)
#define REPORT_BOOK_LOGIC	(0x6000+0x38)
#define GET_TO_EYEBALL_91	(0x6000+0x39)
#define EYEBALL_91_ACTION	(0x6000+0x3a)
#define EYEBALL_91_LOGIC	(0x6000+0x3b)
#define DOOR_L92_LOGIC	(0x6000+0x3c)
#define DOOR_L92F_LOGIC	(0x6000+0x3d)
#define GET_TO_DOOR_L92	(0x6000+0x3e)
#define DOOR_L92_ACTION	(0x6000+0x3f)
#define DOOR_R92_LOGIC	(0x6000+0x40)
#define DOOR_R92R_LOGIC	(0x6000+0x41)
#define GET_TO_DOOR_R92	(0x6000+0x42)
#define DOOR_R92_ACTION	(0x6000+0x43)
#define SLAB1_LOGIC	(0x6000+0x44)
#define SLAB2_LOGIC	(0x6000+0x45)
#define SLAB3_LOGIC	(0x6000+0x46)
#define SLAB4_LOGIC	(0x6000+0x47)
#define SLAB5_LOGIC	(0x6000+0x48)
#define SLAB6_LOGIC	(0x6000+0x49)
#define SLAB7_LOGIC	(0x6000+0x4a)
#define SLAB8_LOGIC	(0x6000+0x4b)
#define SLAB9_LOGIC	(0x6000+0x4c)
#define GET_TO_SLAB	(0x6000+0x4d)
#define SLAB_ACTION	(0x6000+0x4e)
#define SLAB_6_9_ACTION	(0x6000+0x4f)
#define BRIDGE_A_LOGIC	(0x6000+0x50)
#define BRIDGE_B_LOGIC	(0x6000+0x51)
#define BRIDGE_C_LOGIC	(0x6000+0x52)
#define BRIDGE_D_LOGIC	(0x6000+0x53)
#define BRIDGE_E_LOGIC	(0x6000+0x54)
#define BRIDGE_F_LOGIC	(0x6000+0x55)
#define BRIDGE_G_LOGIC	(0x6000+0x56)
#define BRIDGE_H_LOGIC	(0x6000+0x57)
#define GET_TO_CIRCLE	(0x6000+0x58)
#define GREEN_CIRCLE_LOGIC	(0x6000+0x59)
#define GREEN_CIRCLE_ACTION	(0x6000+0x5a)
#define RED_CIRCLE_LOGIC	(0x6000+0x5b)
#define RED_CIRCLE_ACTION	(0x6000+0x5c)
#define SLAB_ON	(0x6000+0x5d)
#define SLAB_OFF	(0x6000+0x5e)
#define LEFT_MOUSE	(0x6000+0x5f)
#define RIGHT_MOUSE	(0x6000+0x60)
#define UP_MOUSE	(0x6000+0x61)
#define DOWN_MOUSE	(0x6000+0x62)
#define DOOR_L93_LOGIC	(0x6000+0x63)
#define DOOR_L93F_LOGIC	(0x6000+0x64)
#define GET_TO_DOOR_L93	(0x6000+0x65)
#define DOOR_L93_ACTION	(0x6000+0x66)
#define GET_TO_PERSONA	(0x6000+0x67)
#define PERSONA_ACTION	(0x6000+0x68)
#define PERSONA_LOGIC	(0x6000+0x69)
#define GET_TO_ADJUST_BOOK	(0x6000+0x6a)
#define ADJUST_BOOK_ACTION	(0x6000+0x6b)
#define ADJUST_BOOK_LOGIC	(0x6000+0x6c)
#define DOOR_L94_LOGIC	(0x6000+0x6d)
#define DOOR_L94R_LOGIC	(0x6000+0x6e)
#define GET_TO_DOOR_L94	(0x6000+0x6f)
#define DOOR_L94_ACTION	(0x6000+0x70)
#define DOOR_R94_LOGIC	(0x6000+0x71)
#define DOOR_R94R_LOGIC	(0x6000+0x72)
#define GET_TO_DOOR_R94	(0x6000+0x73)
#define DOOR_R94_ACTION	(0x6000+0x74)
#define GET_TO_HOLOGRAM_PAD	(0x6000+0x75)
#define HOLOGRAM_PAD_ACTION	(0x6000+0x76)
#define HOLOGRAM_A_LOGIC	(0x6000+0x77)
#define HOLOGRAM_B_LOGIC	(0x6000+0x78)
#define DOOR_L95_LOGIC	(0x6000+0x79)
#define DOOR_L95F_LOGIC	(0x6000+0x7a)
#define GET_TO_DOOR_L95	(0x6000+0x7b)
#define DOOR_L95_ACTION	(0x6000+0x7c)
#define DOOR_R95_LOGIC	(0x6000+0x7d)
#define DOOR_R95F_LOGIC	(0x6000+0x7e)
#define GET_TO_DOOR_R95	(0x6000+0x7f)
#define DOOR_R95_ACTION	(0x6000+0x80)
#define DOOR_T95_LOGIC	(0x6000+0x81)
#define DOOR_T95R_LOGIC	(0x6000+0x82)
#define GET_TO_DOOR_T95	(0x6000+0x83)
#define DOOR_T95_ACTION	(0x6000+0x84)
#define GET_TO_GUARDIAN	(0x6000+0x85)
#define GUARDIAN_ACTION	(0x6000+0x86)
#define GUARDIAN_LOGIC	(0x6000+0x87)
#define WEIGHT_LOGIC	(0x6000+0x88)
#define DOOR_L96_LOGIC	(0x6000+0x89)
#define DOOR_L96F_LOGIC	(0x6000+0x8a)
#define GET_TO_DOOR_L96	(0x6000+0x8b)
#define DOOR_L96_ACTION	(0x6000+0x8c)
#define CRYSTAL_LOGIC	(0x6000+0x8d)
#define GET_TO_CRYSTAL	(0x6000+0x8e)
#define CRYSTAL_ACTION	(0x6000+0x8f)
#define VIRUS_LOGIC	(0x6000+0x90)
#define GET_TO_VIRUS	(0x6000+0x91)
#define VIRUS_ACTION	(0x6000+0x92)
#define ANITA_SPEECH	(0x2000+0x105)
#define LAMB_FACTORY	(0x2000+0x106)
#define LAMB_UNUSED	(0x2000+0x107)
#define LAMB_BELLEVUE	(0x0000+0x5d)
#define FORE_SPEECH	(0x2000+0x108)
#define GORDON_SPEECH	(0x2000+0x109)
#define GUARD_SPEECH	(0x2000+0x10a)
#define WANK	(0x2000+0x10b)
#define WRECK_SPEECH	(0x2000+0x10c)
#define LOB_DAD_SPEECH	(0x2000+0x10d)
#define LOB_SON_SPEECH	(0x2000+0x10e)
#define RADMAN_SPEECH	(0x2000+0x10f)
#define BURKE_SPEECH	(0x3000+0x139)
#define JASON_SPEECH	(0x3000+0x13a)
#define JOEY_RECYCLE	(0x1000+0xab)
#define JOEY_UNUSED	(0x1000+0xac)
#define JOEY_FACTORY	(0x2000+0x110)
#define JOEY_BELLEVUE	(0x3000+0x13b)
#define ANCHOR_SPEECH	(0x3000+0x13c)
#define TREVOR_SPEECH	(0x3000+0x13d)
#define HELGA_SPEECH	(0x3000+0x13e)
#define GALL_BELLEVUE	(0x3000+0x13f)
#define FULL_SCREEN_LOGIC	(0x0000+0x5e)
#define CANCEL_ACTION_101	(0x0000+0x5f)
#define BUTTON_ACTION_101	(0x0000+0x60)
#define FS_BUTTON_LOGIC	(0x0000+0x61)
#define FS_RETINA_SCAN_LOGIC	(0x0000+0x62)
#define START_0	(0x0000+0x63)
#define START_S4	(0x0000+0x64)
#define START_S2	(0x0000+0x65)
#define START_S3	(0x0000+0x66)
#define START_S6	(0x0000+0x67)
#define START_29	(0x0000+0x68)
#define START_TEN	(0x0000+0x69)
#define START_ONE	(0x0000+0x6a)
#define START_IN_FACTORY	(0x0000+0x6b)
#define START_14	(0x0000+0x6c)
#define START_SC31	(0x0000+0x6d)
#define START_SC37	(0x0000+0x6e)
#define START_SC42	(0x0000+0x6f)
#define START_SC48	(0x0000+0x70)
#define START_SC66	(0x0000+0x71)
#define START_SC73	(0x0000+0x72)
#define START_SC81	(0x0000+0x73)
#define START_SC82	(0x0000+0x74)
#define START_SC90	(0x0000+0x75)
#define MANTRACH_SPEECH	(0x0000+0x76)
#define ID_GRID81	21010
#define ID_SC81_DOOR	21011
#define ID_SC81_CHAIR	21012
#define ID_SC81_HELMET	21013
#define ID_SC81_FATHER	21014
#define ID_SC81_FATHER_SAT	21015
#define ID_SC81_FOSTER_SAT	21016
#define ID_SC81_KEN_SAT	21017
#define ID_SC81_TENT1	21025
#define ID_SC81_TENT2	21026
#define ID_SC81_TENT3	21027
#define ID_SC81_TENT4	21028
#define ID_SC81_TENT5	21029
#define ID_SC81_TENT6	21030
#define ID_SC81_BIG_TENT1	21037
#define ID_SC81_BIG_TENT2	21038
#define ID_SC81_BIG_TENT3	21039
#define ID_SC39_WALTERS	16809
#define ID_SC31_JOEY	16851
#define ID_SC82_JOBSWORTH	21069
#define DISQ_1	2048
#define DISQ_2	4096
#define DISQ_3	6144
#define DISQ_5	10240
#define DISQ_6	12288
#define DISQ_7	14336
#define DISQ_8	16384
#define DISQ_9	18432
#define DISQ_10	20480
#define DISQ_11	22528
#define DISQ_12	24576
#define DISQ_13	26624
#define DISQ_14	28672
#define DISQ_15	30720
//#define T0	0
//#define T1	4096
//#define T2	8192
//#define T3	12288
//#define T4	16384
//#define T5	20480
//#define T6	24576
//#define T7	28672
#define UP	0
#define DOWN	1
#define LEFT	2
#define RIGHT	3
#define TALK	4
#define ID_FOSTER	3
#define ID_JOEY	1
#define JOBS	4122
#define ID_JOBS	4122
#define MINI_SS	4100
#define FULL_SS	4101
#define ID_S2_FLOOR	115
#define ID_L_EXIT_S2	4315
#define FOSTER_BIG	4098
#define ID_R_EXIT_S2	4103
#define ID_S4_FLOOR	4104
#define ID_S4_L_EXIT	4105
#define ID_TV_SCREENS	4108
#define ID_KNOB	4109
#define ID_CHUCK	4110
#define ID_LAZER	4111
#define ID_CUPBOARD	4112
#define ID_SARNIE	4113
#define ID_SPANNER	4114
#define ID_BUTTONS	4115
#define ID_TOP_LIFT	4116
#define ID_MONITORS	4117
#define ID_HOLE	4119
#define ID_TOP_BARREL	4120
#define ID_LOADER	4121
#define ID_UPLOAD	4125
#define ID_LIGHT1	4126
#define ID_PANEL	4127
#define ID_ALARM	4128
#define ID_S3_FLOOR	4130
#define ID_ROBOT_SHELL	4131
#define ID_JOEY_PARK	2
#define ID_DEAD_LOADER	4133
#define IDO_CROW_BAR	63
#define IDO_SARNIE	64
#define IDO_SPANNER	65
#define IDO_JOEY_BOARD	66
#define IDO_CITYCARD	8
#define IDO_SHADES	9
#define IDO_PUTTY	10
#define IDO_LIGHTBULB	11
#define IDO_ANITA_CARD	71
#define IDO_ANCHOR	74
#define IDO_MAGAZINE	75
#define IDO_TAPE	76
#define IDO_GLASS	77
#define IDO_TICKET	79
#define IDO_SECATEURS	36
#define IDO_ROPE	37
#define IDO_PLASTER	38
#define IDO_NEW_CABLE	39
#define IDO_BRICK	42
#define IDO_TONGS	43
#define IDO_GALLCARD	6
#define ID_LOW_LIFT	4137
#define ID_STEVE_SPY	4138
#define ID_LOW_BARREL	4139
#define ID_CONVEY	4140
#define ID_JOEY_FLY	4141
#define ID_FURNACE	4142
#define ID_LIGHTS1	4143
#define ID_EYE_BALL	4144
#define ID_EYE_BOLT	4145
#define ID_FURNACE_DOOR	4146
#define ID_SLOT	4147
#define ID_SHADES	4148
#define ID_LAZER_GUN	4149
#define ID_SMOULDER	4150
#define ID_NOTICE	4151
#define ID_NOTICE2	4152
#define ID_SS_SIGN	4153
#define ID_POSTCARD	4154
#define ID_NOTICE4	4155
#define ID_SHRUG_SEQ	40
#define ID_SMALL_SHRUG	13
#define ID_SML_UP_GET_SEQ	14
#define ID_TEXT_MOUSE	5
#define ID_S_AND_R	19
#define ID_MENU_LOGIC	4
#define ID_STD_MENU_LOGIC	4
#define ID_ANIM	4186
#define ID_RESET	4282
#define ID_RESET_MEGA	7
#define ID_FAN1	4102
#define ID_FAN2	4303
#define ID_FAN3	4305
#define ID_FAN4	4307
#define ID_FAN5	4309
#define ID_FAN6	4311
#define ID_FAN7	4313
#define ID_S6_FLOOR	8200
#define ID_S6_STAIRS	8210
#define ID_S6_JOEY_FLY	8215
#define ID_LEFT_EXIT_S6	8221
#define ID_S5_FLOOR	8223
#define ID_RIGHT_EXIT_S5	8224
#define ID_RIGHT_EXIT_S6	8226
#define ID_S7_FLOOR	8231
#define ID_LEFT_EXIT_S7	8234
#define ID_LEFT_EXIT_S5	8238
#define ID_S18_FLOOR	8243
#define ID_RIGHT_EXIT_S18	8246
#define ID_SECURITY_EXIT	8248
#define ID_S9_FLOOR	8253
#define ID_LEFT_EXIT_S9	8256
#define ID_STEAM	8259
#define ID_POWER_DOOR	8264
#define ID_POWER_MOTOR	8266
#define ID_POWER_PANEL	8270
#define PANEL_FRAME	4160
#define SWITCH_FRAME	4032
#define ID_POWER_SWITCH	8271
#define ID_POWER_CHAIR	8272
#define ID_LEFT_SKULL	8273
#define ID_RIGHT_SKULL	8274
#define ID_POWER_BANG	8275
#define ID_MONITOR	136
#define ID_LEFT_LEVER	8290
#define ID_RIGHT_LEVER	8291
#define LEFT_LEVER_FRAME	5760
#define RIGHT_LEVER_FRAME	5824
#define ID_FANS	8292
#define ID_LOBBY_DOOR	8295
#define ID_SCANNER	8298
#define ID_LOBBY_SLOT	8299
#define NO_TEXT_MESSAGE	28707
#define ID_DAD	8301
#define ID_SON	8211
#define ID_LOW_GET_SEQ	12
#define ID_PRESS	4321
#define ID_LOW_FLOOR	67
#define ID_SMALL_DOOR	105
#define ID_LFAN1	4326
#define ID_LFAN2	4328
#define ID_SMOKE1	4330
#define ID_SMOKE2	4332
#define ID_SKORL_GUARD	8309
#define S5_SECURITY_EXIT	8310
#define ID_S8_FLOOR	8316
#define ID_S7_RIGHT_EXIT	8317
#define ID_DOWN_EXIT_S8	8320
#define ID_WRECK_GUARD	8324
#define ID_FACTORY_ENTRY	8331
#define ID_S12_FLOOR	8336
#define ID_FACTORY_EXIT	8341
#define ID_FACT1_EXIT	8344
#define ID_S13_FLOOR	8349
#define ID_FACT2_L_EXIT	8353
#define ID_FACT2_R_EXIT	8355
#define ID_S14_FLOOR	8360
#define ID_FACT3_L_EXIT	8364
#define ID_F2_STORE_EXIT	8366
#define ID_S15_FLOOR	8371
#define ID_NU_FLOOR	8441
#define ID_STORE_EXIT	8375
#define ID_ANITA	137
#define ID_TOP_BELT	8379
#define ID_BOT_BELT	8381
#define ID_PIPES	8383
#define ID_ANITA_SPY	8385
#define ID_WELDER	8388
#define ID_LAMB	16
#define ID_COGS	8393
#define ID_GEARS	8395
#define ID_BELT1	8397
#define ID_BELT2	8399
#define ID_PIPE1	8401
#define ID_PIPE2	8403
#define ID_PIPE3	8405
#define ID_PIPE4	8407
#define ID_STD_LEFT_TALK	23
#define ID_STD_RIGHT_TALK	24
#define ID_SENSOR	8410
#define ID_LITE1	8412
#define ID_LITE2	8414
#define ID_FOREMAN	8544
#define ID_FACT2_SPY	8418
#define ID_S7_CARD_SLOT	8420
#define ID_LIFT_NOTICE	8421
#define ID_LIFT_S7	8422
#define ID_LINC_S7	8425
#define ID_JUNCTION_BOX	8426
#define ID_FAKE_FLOOR	8427
#define ID_FACT_CONSOLE	8435
#define ID_FLAP	8438
#define ID_SKEY	8442
#define ID_WD40	8443
#define IDO_WD40	34
#define IDO_SKEY	35
#define ID_FLOOR_PUTTY	8446
#define ID_NEW_GRID	15
#define ST_BACKGROUND	1
#define ST_FOREGROUND	2
#define ST_SORT	4
#define ST_RECREATE	8
#define ST_MOUSE	16
#define ST_COLLISION	32
#define ST_LOGIC	64
#define ST_GRID_PLOT	128
#define ST_AR_PRIORITY	256
#define S62	3968
#define S91	5824
#define S94	6016
#define S95	6080
#define S96	6144
#define S106	6784
#define S108	6912
#define S137	8768
#define S152	9728
#define S182	11648
#define S191	12224
#define HEAD_TEXT	24681
#define PAL_90	24717
#define PAL_90A	24718
#define PAL_90B	24719
#define PAL_91	24720
#define PAL_92	24721
#define PAL_93	24722
#define PAL_94	24723
#define PAL_95	24724
#define PAL_96	24725
#define RST_L_ARR_LINC	142
#define RST_R_ARR_LINC	143
#define RST_BLANKS_LINC	144
#define RST_FOST_S90	24656
#define RST_FOST_90_91	24657
#define RST_FOST_90_94	24658
#define RST_FOST_91_90	24659
#define RST_FOST_91_92	24660
#define RST_FOST_91_95	24661
#define RST_FOST_92_91	24662
#define RST_FOST_92_93	24663
#define RST_FOST_93_92	24664
#define RST_FOST_94_90	24665
#define RST_FOST_94_95	24666
#define RST_FOST_95_91	24667
#define RST_FOST_95_94	24668
#define RST_FOST_95_96	24669
#define RST_FOST_96_95	24670
#define AMT_ENTER_TOP	24814
#define AMT_EXIT_TOP	24815
#define AMT_LOGON	24824
#define AMT_LOGOFF	24825
#define AMT_CROUCH_LEFT	24759
#define AMT_CROUCH_RIGHT	24760
#define AMT_CROUCH_RIGHT_A	24805
#define AMT_CROUCH_RIGHT_B	24806
#define AMT_CROUCH_DOWN	24704
#define AMT_SHRUG	24618
#define AMT_LIGHT1	24671
#define AMT_LIGHT2	24672
#define AMT_LIGHT3A	24673
#define AMT_LIGHT3B	24674
#define AMT_LIGHT3C	24675
#define AMT_LIGHT4	24676
#define AMT_LIGHT5	24677
#define AMT_LIGHT6	24678
#define AMT_LIGHT7	24679
#define AMT_LIGHT8	24680
#define AMT_LIGHT9A	24681
#define AMT_LIGHT9B	24682
#define AMT_LIGHT9C	24683
#define AMT_LIGHT10A	24684
#define AMT_LIGHT10B	24685
#define AMT_LIGHT10C	24686
#define AMT_LIGHT10D	24687
#define AMT_DOOR_L90	24688
#define AMT_DOOR_L90F	24689
#define AMT_DOOR_R90	24690
#define AMT_DOOR_R90F	24691
#define AMT_GET_JOIN	24692
#define AMT_GET_OSCILL	24693
#define AMT_BLIND_EYE	24694
#define AMT_SEE_EYE	24695
#define AMT_GET_EYE	24758
#define AMT_EYE90_ZAP	24802
#define AMT_FOST_DIE90	24793
#define AMT_DOOR_L91	24696
#define AMT_DOOR_L91F	24697
#define AMT_DOOR_R91	24796
#define AMT_DOOR_R91F	24797
#define AMT_DOOR_T91	24698
#define AMT_DOOR_T91R	24699
#define AMT_GET_DECOMP	24702
#define AMT_GET_DECRYPT	24703
#define AMT_GET_REPORT	24733
#define AMT_EYE91_ZAP	24800
#define AMT_FOST_DIE91	24728
#define AMT_DOOR_L92	24822
#define AMT_DOOR_L92F	24823
#define AMT_DOOR_R92	24808
#define AMT_DOOR_R92R	24809
#define AMT_DOOR_L93	24812
#define AMT_DOOR_L93F	24813
#define AMT_GET_PERSONA	24705
#define AMT_GET_ADJUST	24706
#define AMT_DOOR_L94	24707
#define AMT_DOOR_L94R	24708
#define AMT_DOOR_R94	24709
#define AMT_DOOR_R94R	24710
#define AMT_HOLO1_A	24726
#define AMT_HOLO1_B	24727
#define AMT_HOLO3	24768
#define AMT_DOOR_L95	24711
#define AMT_DOOR_L95F	24712
#define AMT_DOOR_R95	24771
#define AMT_DOOR_R95F	24772
#define AMT_DOOR_T95	24713
#define AMT_DOOR_T95R	24714
#define AMT_GUARDIAN_UP	24791
#define AMT_GUARDIAN_DOWN	24801
#define AMT_WEIGHT_ANIM	24826
#define AMT_DOOR_L96	24780
#define AMT_DOOR_L96F	24781
#define AMT_CRYSTAL_SPIN	24788
#define AMT_CRYSTAL_BREAK	24789
#define AMT_VIRUS_SPIN	24790
#define AMT_GET_VIRUS	24794
#define ID_LINC_MENU_LOGIC	24831
#define ID_LINC_MENU_MOUSE	24832
#define IT_BLUE_FOSTER	182
#define IT_LOGOFF	117
#define IT_LINK_ARROWS	190
#define IT_LINK_OBJECTS	191
#define IT_WINDOW	26
#define IT_INFO_BUTTON	137
#define IT_WINDOW_LOGIC	24765
#define IT_WINDOW_MOUSE	24766
#define IT_GET_EYE	18
#define IT_CROUCH_LEFT	16
#define IT_CROUCH_RIGHT	17
#define IT_CROUCH_DOWN	20
#define IT_ENTER_TOP	135
#define IT_EXIT_TOP	136
#define IT_LIGHT1	64
#define IT_LIGHT2	65
#define IT_LIGHT3A	66
#define IT_LIGHT3B	67
#define IT_LIGHT3C	68
#define IT_LIGHT4	69
#define IT_LIGHT5	70
#define IT_LIGHT6	71
#define IT_LIGHT7	72
#define IT_LIGHT8	73
#define IT_LIGHT9A	74
#define IT_LIGHT9B	75
#define IT_LIGHT9C	76
#define IT_LIGHT10A	85
#define IT_LIGHT10B	86
#define IT_LIGHT10C	87
#define IT_LIGHT10D	88
#define IT_SC90_LAYER_0	175
#define IT_SC90_LAYER_1	176
#define IT_SC90_GRID_1	177
#define IT_SC90_FAST	102
#define IT_SC90_CHIP	24735
#define IT_SC90_LOGIC	24736
#define IT_SC90_MOUSE	24737
#define IT_DOOR_L90	45
#define IT_DOOR_L90F	46
#define IT_DOOR_R90	258
#define IT_DOOR_R90F	259
#define IT_JOIN_OBJECT	22
#define IT_OSCILLATOR	132
#define IT_EYEBALL	91
#define IT_BLIND_EYE	89
#define IT_SEE_EYE	90
#define IT_EYE90_ZAP	113
#define IT_FOST_DIE90	115
#define IT_SC91_LAYER_0	183
#define IT_SC91_LAYER_1	184
#define IT_SC91_GRID_1	185
#define IT_SC91_FAST	24738
#define IT_SC91_CHIP	24739
#define IT_SC91_LOGIC	24740
#define IT_SC91_MOUSE	24741
#define IT_DOOR_L91	260
#define IT_DOOR_L91F	261
#define IT_DOOR_R91	111
#define IT_DOOR_R91F	112
#define IT_DOOR_T91	31
#define IT_DOOR_T91R	32
#define IT_BAG_91	47
#define IT_DECOMP_OBJ	48
#define IT_DECRYPT_OBJ	131
#define IT_REPORT_BOOK	95
#define IT_EYE91_ZAP	114
#define IT_FOST_DIE91	116
#define IT_SC92_LAYER_0	192
#define IT_SC92_LAYER_1	193
#define IT_SC92_GRID_1	194
#define IT_SC92_FAST	24742
#define IT_SC92_CHIP	24743
#define IT_SC92_LOGIC	24744
#define IT_SC92_MOUSE	24745
#define IT_BRIDGES	44
#define IT_CIRCLES	62
#define IT_DOOR_L92	54
#define IT_DOOR_L92F	55
#define IT_DOOR_R92	129
#define IT_DOOR_R92R	130
#define IT_SC93_LAYER_0	199
#define IT_SC93_LAYER_1	250
#define IT_SC93_GRID_1	251
#define IT_SC93_FAST	24746
#define IT_SC93_CHIP	24747
#define IT_SC93_LOGIC	24748
#define IT_SC93_MOUSE	24749
#define IT_DOOR_L93	133
#define IT_DOOR_L93F	134
#define IT_PERSONA	51
#define IT_ADJUST_BOOK	63
#define IT_SC94_LAYER_0	13
#define IT_SC94_FAST	24750
#define IT_SC94_CHIP	24751
#define IT_SC94_LOGIC	24752
#define IT_SC94_MOUSE	24753
#define IT_DOOR_L94	58
#define IT_DOOR_L94R	59
#define IT_DOOR_R94	60
#define IT_DOOR_R94R	61
#define IT_HOLO1_A	92
#define IT_HOLO1_B	93
#define IT_HOLO2_A	94
#define IT_HOLO2_B	96
#define IT_HOLO3	97
#define IT_SC95_LAYER_0	23
#define IT_SC95_LAYER_1	24
#define IT_SC95_GRID_1	25
#define IT_SC95_FAST	24754
#define IT_SC95_CHIP	24755
#define IT_SC95_LOGIC	24756
#define IT_SC95_MOUSE	24757
#define IT_DOOR_L95	56
#define IT_DOOR_L95F	57
#define IT_DOOR_R95	100
#define IT_DOOR_R95F	101
#define IT_DOOR_T95	52
#define IT_DOOR_T95R	53
#define IT_GUARDIAN	102
#define IT_WEIGHT	103
#define IT_SC96_LAYER_0	27
#define IT_SC96_LAYER_1	28
#define IT_SC96_GRID_1	29
#define IT_SC96_FAST	24773
#define IT_SC96_CHIP	24774
#define IT_SC96_LOGIC	24775
#define IT_SC96_MOUSE	24776
#define IT_DOOR_L96	98
#define IT_DOOR_L96F	99
#define IT_CRYSTAL_SPIN	106
#define IT_CRYSTAL_BREAK	107
#define IT_VIRUS_SPIN	108
#define IT_GET_VIRUS	110
#define ID_BLUE_FOSTER	3
#define ID_WINDOW_1	24761
#define ID_WINDOW_2	24762
#define ID_WINDOW_3	24763
#define ID_WINDOW_4	24764
#define ID_INFO_BUTTON	24810
#define ID_HEAD_MODULE	24816
#define ID_FILE_MODULE	24817
#define ID_SIZE_MODULE	24818
#define ID_AUTH_MODULE	24819
#define ID_NOTE_MODULE	24820
#define ID_SKY	24640
#define ID_LIGHTNING	24645
#define ID_LIGHTNING1	24646
#define ID_LIGHTNING2	24647
#define ID_LIGHTNING3	24648
#define ID_GRID90	24701
#define ID_GRID91	24715
#define ID_GRID92	24716
#define ID_GRID93	24782
#define ID_GRID94	24783
#define ID_GRID95	24784
#define ID_GRID96	24785
#define ID_INFO_MENU	24581
#define ID_READ_MENU	24582
#define ID_OPEN_MENU	24583
#define ID_ORDERS_MENU	24630
#define ID_ORDERS2_MENU	24828
#define ID_CHARON_MENU	24628
#define ID_JOIN_MENU	24584
#define ID_GREEN_MENU	24626
#define ID_RED_MENU	24627
#define ID_REPORT_MENU	24732
#define ID_REPORT2_MENU	24829
#define ID_DECOMP_MENU	24629
#define ID_DECRYPT_MENU	24631
#define ID_PERSONA_MENU	24632
#define ID_ADJUST_MENU	24643
#define ID_ADJUST2_MENU	24830
#define ID_PLAYBAK_MENU	24650
#define ID_BLIND_MENU	24625
#define ID_OSCILL_MENU	24649
#define ID_KILL_MENU	24827
#define ID_VIRUS_MENU	24651
#define ID_SC90_FLOOR	24577
#define ID_SC90_SMFLOOR	24591
#define ID_DOOR_L90	24635
#define ID_DOOR_L90F	24636
#define ID_DOOR_R90	24579
#define ID_DOOR_R90F	24600
#define ID_JOIN_OBJECT	24604
#define ID_OSCILLATOR	24641
#define ID_EYEBALL_90	24644
#define ID_EYE_90_TABLE	24652
#define ID_SC91_FLOOR	24578
#define ID_DOOR_L91	24580
#define ID_DOOR_L91F	24601
#define ID_DOOR_R91	24585
#define ID_DOOR_R91F	24795
#define ID_DOOR_T91	24606
#define ID_DOOR_T91R	24607
#define ID_BAG_91	24637
#define ID_DECOMP_OBJ	24638
#define ID_DECRYPT_OBJ	24639
#define ID_REPORT_BOOK	24731
#define ID_EYEBALL_91	24798
#define ID_EYE_91_TABLE	24799
#define ID_SLAB1	24586
#define ID_SLAB2	24592
#define ID_SLAB3	24593
#define ID_SLAB4	24594
#define ID_SLAB5	24595
#define ID_SLAB6	24596
#define ID_SLAB7	24597
#define ID_SLAB8	24598
#define ID_SLAB9	24599
#define ID_BRIDGE_A	24610
#define ID_BRIDGE_B	24611
#define ID_BRIDGE_C	24612
#define ID_BRIDGE_D	24613
#define ID_BRIDGE_E	24614
#define ID_BRIDGE_F	24615
#define ID_BRIDGE_G	24616
#define ID_BRIDGE_H	24617
#define ID_DOOR_L92	24587
#define ID_DOOR_L92F	24821
#define ID_DOOR_R92	24588
#define ID_DOOR_R92R	24807
#define ID_GREEN_CIRCLE	24633
#define ID_RED_CIRCLE	24634
#define ID_SC93_FLOOR	24589
#define ID_DOOR_L93	24590
#define ID_DOOR_L93F	24792
#define ID_PERSONA	24602
#define ID_ADJUST_BOOK	24642
#define ID_SC94_FLOOR	24603
#define ID_DOOR_L94	24623
#define ID_DOOR_L94R	24624
#define ID_DOOR_R94	24621
#define ID_DOOR_R94R	24622
#define ID_HOLOGRAM_A	24729
#define ID_HOLOGRAM_B	24767
#define ID_HOLOGRAM_PAD	24730
#define ID_SC95_FLOOR	24605
#define ID_DOOR_L95	24608
#define ID_DOOR_L95F	24609
#define ID_DOOR_R95	24769
#define ID_DOOR_R95F	24770
#define ID_DOOR_T95	24619
#define ID_DOOR_T95R	24620
#define ID_GUARDIAN	24804
#define ID_WEIGHT	24811
#define ID_SC96_FLOOR	24777
#define ID_DOOR_L96	24778
#define ID_DOOR_L96F	24779
#define ID_CRYSTAL	24786
#define ID_VIRUS	24787
#define BEFORE_SHRUG	5
#define OFF_LEFT	104
#define OFF_RIGHT	472
#define DOOR_SHUT	1
#define DOOR_OPEN	2
#define DOOR_MOVING	3
#define AR_OK	0
#define AR_FAIL	1
#define AR_ZERO	2
#define L_BUTTON	2
#define R_BUTTON	1
#define F_UP	9
#define W_UP	86
#define M_UP	104
#define G_UP	114
#define K_UP	134
#define ID_PIPE_TALK	144
#define ID_MEDI	20511
#define ID_WITNESS	20754
#define ID_GALLAGHER	20812
#define ID_KEN	20911
#define ID_WALTER_TALK_UP	20983
#define ID_WALTER_TALK_DWN	20984
#define ID_WALTER_TALK_LFT	20985
#define ID_WALTER_CONV	20986
#define ID_MEDI_TALK_UP	20987
#define ID_MEDI_TALK_DOWN	20988
#define ID_MEDI_TALK_LEFT	20989
#define ID_MEDI_TALK_RIGHT	20990
#define ID_FOST_CONV_LEFT	20991
#define ID_GALL_TALK_UP	20992
#define ID_GALL_TALK_LEFT	20993
#define ID_SC75_FREEZE_TLK	20994
#define ID_SC75_DEAD_TLK	20995
#define ID_KEN_TALK_UP	20996
#define ID_KEN_TALK_DOWN	20997
#define ID_KEN_TALK_LEFT	20998
#define ID_KEN_TALK_RIGHT	20999
#define ID_ANDROID_BABBLE	21000
#define ID_STUCK_TALK	21001
#define ID_FOST_PIPE_TALK	21002
#define ID_SC66_FAST_LIST	20481
#define ID_SC66_CHIP_LIST	20482
#define ID_SC66_LOGIC_LIST	20483
#define ID_SC66_MOUSE_LIST	20484
#define ID_SC66_PALETTE	20485
#define ID_RESET_66	20486
#define ID_SC66_DOOR	20977
#define ID_SC66_DOOR_CLOSE	20978
#define ID_SC66_HOLE	20487
#define ID_SC66_FOS_WALK_IN	20982
#define ID_SC66_FOS_CRUSHED	20981
#define ID_SC66_LO_BEAM	20969
#define ID_SC66_LO_BEAM_ANM	20970
#define ID_SC66_HI_BEAM	20966
#define ID_SC66_HI_BEAM_AN1	20967
#define ID_SC66_HI_BEAM_AN2	20968
#define ID_SC66_ROCK1	20971
#define ID_SC66_ROCK1_ANIM	20972
#define ID_SC66_ROCK2	20973
#define ID_SC66_ROCK2_ANIM	20974
#define ID_SC66_ROCK3	20975
#define ID_SC66_ROCK3_ANIM	20976
#define ID_SC66_STONES	20979
#define ID_SC66_STONES_ANIM	20980
#define ID_SC67_FAST_LIST	20488
#define ID_SC67_CHIP_LIST	20489
#define ID_SC67_LOGIC_LIST	20490
#define ID_SC67_MOUSE_LIST	20491
#define ID_SC67_PALETTE	20492
#define ID_GRID67	20502
#define ID_RESET_66_67	20523
#define ID_RESET_68_67	20529
#define ID_SC67_FLOOR	20501
#define ID_SC67_DOOR	20506
#define ID_SC67_DOOR_OPEN	20508
#define ID_SC67_DOOR_CLOSE	20509
#define ID_SC67_BRICKWORK	20503
#define ID_SC67_VEIN	20510
#define ID_SC67_CLOT	20507
#define ID_SC67_CRAWL	20521
#define ID_SC67_DUSTOFF	20522
#define ID_SC67_GETBRICK	20524
#define ID_SC67_PLASTER	20526
#define ID_SC67_PLAST_FALL	20525
#define ID_SC67_PICK_PLAST	20651
#define ID_SC67_BRICK	20527
#define ID_SC67_BRICK_FALL	20528
#define ID_SC67_PICK_BRICK	20650
#define ID_SC67_STICK_IN	20652
#define ID_SC67_PULL_OUT	20653
#define ID_SC67_BRICK_HIT	20654
#define ID_SC67_PLAST_HIT	20655
#define ID_SC67_LPOCKET	20661
#define ID_SC67_RPOCKET	20662
#define ID_SC67_RUB_HEAD	20663
#define ID_SC67_TRY_STICK	20677
#define ID_SC67_CROWBAR	20678
#define ID_SC67_BAR_FALL	20679
#define ID_SC67_PUSS_LEAK	20680
#define ID_SC67_MEDIFIX	20681
#define ID_SC67_MEND	20682
#define ID_SC67_MENDING	20683
#define ID_SC67_ROCK	20504
#define ID_SC67_ROCK_ANIM	20505
#define ID_SC67_PULSE1	20493
#define ID_SC67_PULSE1_ANIM	20497
#define ID_SC67_PULSE2	20494
#define ID_SC67_PULSE2_ANIM	20498
#define ID_SC67_PULSE3	20495
#define ID_SC67_PULSE3_ANIM	20499
#define ID_SC67_PULSE4	20496
#define ID_SC67_PULSE4_ANIM	20500
#define ID_SC68_FAST_LIST	20512
#define ID_SC68_CHIP_LIST	20513
#define ID_SC68_LOGIC_LIST	20514
#define ID_SC68_MOUSE_LIST	20515
#define ID_SC68_PALETTE	20516
#define ID_GRID68	20520
#define ID_SC68_JOEY_LIST	20784
#define ID_RESET_67_68	20517
#define ID_RESET_69_68	20561
#define ID_RESET_70_68	20599
#define ID_SC68_FLOOR	20519
#define ID_SC68_DOOR	20518
#define ID_SC68_DOOR_CLOSE	20533
#define ID_SC68_STAIRS	20532
#define ID_SC68_DESCEND	20684
#define ID_SC68_ASCEND	20685
#define ID_SC68_EXIT	20558
#define ID_SC68_SENSOR	20531
#define ID_SC68_SENSOR_ANIM	20656
#define ID_SC68_GRILL	20530
#define ID_SC68_PULSE1	20534
#define ID_SC68_PULSE1_ANIM	20540
#define ID_SC68_PULSE2	20535
#define ID_SC68_PULSE2_ANIM	20541
#define ID_SC68_PULSE3	20536
#define ID_SC68_PULSE3_ANIM	20542
#define ID_SC68_PULSE4	20537
#define ID_SC68_PULSE4_ANIM	20543
#define ID_SC68_PULSE5	20538
#define ID_SC68_PULSE5_ANIM	20544
#define ID_SC68_PULSE6	20539
#define ID_SC68_PULSE6_ANIM	20545
#define ID_SC69_FAST_LIST	20552
#define ID_SC69_CHIP_LIST	20553
#define ID_SC69_LOGIC_LIST	20554
#define ID_SC69_MOUSE_LIST	20555
#define ID_SC69_PALETTE	20556
#define ID_GRID69	20563
#define ID_SC69_JOEY_LIST	20813
#define ID_RESET_68_69	20559
#define ID_RESET_71_69	20574
#define ID_SC69_FLOOR	20557
#define ID_SC69_EXIT	20560
#define ID_SC69_GRILL	20562
#define ID_SC69_DOOR	20570
#define ID_SC69_PULSE1	20635
#define ID_SC69_PULSE1_ANIM	20641
#define ID_SC69_PULSE2	20636
#define ID_SC69_PULSE2_ANIM	20642
#define ID_SC69_PULSE3	20637
#define ID_SC69_PULSE3_ANIM	20643
#define ID_SC69_PULSE4	20638
#define ID_SC69_PULSE4_ANIM	20644
#define ID_SC69_PULSE5	20639
#define ID_SC69_PULSE5_ANIM	20645
#define ID_SC69_PULSE6	20640
#define ID_SC69_PULSE6_ANIM	20646
#define ID_SC70_FAST_LIST	20589
#define ID_SC70_CHIP_LIST	20590
#define ID_SC70_LOGIC_LIST	20591
#define ID_SC70_MOUSE_LIST	20592
#define ID_SC70_PALETTE	20593
#define ID_GRID70	20597
#define ID_RESET_68_70	20594
#define ID_SC70_FLOOR	20595
#define ID_SC70_DOOR	20598
#define ID_SC70_IRIS	20600
#define ID_SC70_BAR	20601
#define ID_SC70_CONTROL	20602
#define ID_SC70_GRILL	20603
#define ID_SC70_CONSOL_ANIM	20647
#define ID_SC70_PIT	20648
#define ID_SC70_PIT_ANIM	20649
#define ID_SC70_STEP_UP	20756
#define ID_SC70_STEP_DOWN	20757
#define ID_SC70_BAR_ANIM	20758
#define ID_SC70_PULL_BAR	20759
#define ID_SC70_ENTER_ANIM	20778
#define ID_SC70_EXIT_ANIM	20779
#define ID_SC710_FAST_LIST	20687
#define ID_SC71_FAST_LIST	20564
#define ID_SC71_CHIP_LIST	20565
#define ID_SC71_LOGIC_LIST	20566
#define ID_SC71_MOUSE_LIST	20567
#define ID_SC71_PALETTE	20568
#define ID_GRID71	20575
#define ID_SC71_JOEY_LIST	20814
#define ID_RESET_69_71	20571
#define ID_RESET_72_71	20582
#define ID_SC71_FAKE_FLOOR	20569
#define ID_SC71_FLOOR	20572
#define ID_SC71_DOOR69	20573
#define ID_SC71_DOOR72	20579
#define ID_SC71_LOCKED_DOOR	20674
#define ID_SC71_MONITOR	20576
#define ID_SC71_RECHARGER	20577
#define ID_SC71_PANEL_ANIM	20776
#define ID_SC71_PANEL2	20775
#define ID_SC71_PANEL2_ANIM	20777
#define ID_SC71_CONTROLS	20578
#define ID_SC71_LIGHT2_ANIM	20768
#define ID_SC71_LIGHT1	20766
#define ID_SC71_LIGHT1_ANIM	20767
#define ID_SC71_CHLITE	20769
#define ID_SC71_CHLITE_ANIM	20770
#define ID_SC71_MON_ANIM	20771
#define ID_SC71_MEDI_CHARGE	20772
#define ID_SC71_MEDI_GET_UP	20774
#define ID_SC71_MEDI_SLOT	20675
#define ID_SC71_USE_BOARD	20773
#define ID_SC720_FAST_LIST	20686
#define ID_SC72_FAST_LIST	20546
#define ID_SC72_CHIP_LIST	20547
#define ID_SC72_LOGIC_LIST	20548
#define ID_SC72_MOUSE_LIST	20549
#define ID_SC72_PALETTE	20550
#define ID_GRID72	20596
#define ID_SC72_JOEY_LIST	20815
#define ID_RESET_71_72	20581
#define ID_RESET_73_72	20614
#define ID_SC72_FAKE_FLOOR	20551
#define ID_SC72_FLOOR	20580
#define ID_SC72_DOOR	20583
#define ID_SC72_EXIT	20604
#define ID_SC72_TAP	20588
#define ID_SC72_TANK	20584
#define ID_SC72_TANK_ANIM	20785
#define ID_SC72_ROT_LIGHT	20792
#define ID_SC72_ROTATING	20793
#define ID_SC72_CHAMBER1	20585
#define ID_SC72_CHAM1_ANIM	20789
#define ID_SC72_CHAM1_LIGHT	20780
#define ID_SC72_CHAM1_FLASH	20781
#define ID_SC72_CHAMBER2	20586
#define ID_SC72_CHAM2_ANIM	20790
#define ID_SC72_CHAM2_LIGHT	20782
#define ID_SC72_CHAM2_FLASH	20783
#define ID_SC72_CHAMBER3	20761
#define ID_SC72_CHAM3_ANIM	20791
#define ID_SC72_COMPUTER	20765
#define ID_SC72_COMP_FLASH	20786
#define ID_SC72_COMPUTER2	20787
#define ID_SC72_COMP2_FLASH	20788
#define ID_SC72_LIGHT1	20762
#define ID_SC72_LIGHT2	20763
#define ID_SC72_LIGHT3	20764
#define ID_SC72_GRILL	20587
#define ID_SC72_WALTER_KILL	20794
#define ID_SC72_FOSTER_DIE	20795
#define ID_SC72_WALTER_DIE	20800
#define ID_SC72_JOEY_TAP	20796
#define ID_SC72_SPILL	20798
#define ID_SC72_SPILL_ANIM	20799
#define ID_SC72_DRIP_ANIM	20797
#define ID_SC73_FAST_LIST	20605
#define ID_SC73_CHIP_LIST	20606
#define ID_SC73_LOGIC_LIST	20607
#define ID_SC73_MOUSE_LIST	20608
#define ID_SC73_PALETTE	20609
#define ID_GRID73	20612
#define ID_SC73_JOEY_LIST	20816
#define ID_RESET_72_73	20610
#define ID_RESET_74_73	20629
#define ID_RESET_75_73	20673
#define ID_SC73_FLOOR	20611
#define ID_SC73_EXIT	20613
#define ID_SC73_BIG_DOOR	20617
#define ID_SC73_SENSOR	20618
#define ID_SC73_SENSOR_ANIM	20657
#define ID_SC73_DOOR	20619
#define ID_SC73_LOCKED_DOOR	20676
#define ID_SC73_CHAMBER3	20817
#define ID_SC73_CHAM3_ANIM	20818
#define ID_SC73_CHAMBER4	20615
#define ID_SC73_CHAM4_ANIM	20658
#define ID_SC73_CHAM4_LIGHT	20819
#define ID_SC73_CHAM4_FLASH	20820
#define ID_SC73_CHAMBER5	20616
#define ID_SC73_CHAM5_ANIM	20755
#define ID_SC73_CHAM5_LIGHT	20821
#define ID_SC73_CHAM5_FLASH	20822
#define ID_SC73_JOEY_LUNGE	20846
#define ID_SC73_JOEY_FIGHT1	20847
#define ID_SC73_GALL_FIGHT1	20848
#define ID_SC73_JOEY_FIGHT2	20849
#define ID_SC73_GALL_FIGHT2	20850
#define ID_SC73_GET_BOARD	20859
#define ID_SC73_SEARCH	20860
#define ID_SC73_BITS	20851
#define ID_SC73_BITS_ANIM	20852
#define ID_SC73_BITS2	20853
#define ID_SC73_BITS2_ANIM	20854
#define ID_SC73_SPRAY	20855
#define ID_SC73_SPRAY_ANIM	20856
#define ID_SC74_FAST_LIST	20620
#define ID_SC74_CHIP_LIST	20621
#define ID_SC74_LOGIC_LIST	20622
#define ID_SC74_MOUSE_LIST	20623
#define ID_SC74_PALETTE	20624
#define ID_GRID74	20627
#define ID_RESET_73_74	20625
#define ID_SC74_FLOOR	20626
#define ID_SC74_DOOR	20628
#define ID_SC74_INTERFACE	20633
#define ID_SC74_INT_SLOT	20659
#define ID_SC74_TERMINAL	20634
#define ID_SC74_POD	20823
#define ID_SC74_POD_DOWN	20824
#define ID_SC74_POD_UP	20825
#define ID_SC74_FOST_SIT	20826
#define ID_SC74_GET_UP	20827
#define ID_SC74_USECARD	20702
#define ID_SC74_USECARD2	20704
#define ID_SC74_RPOCKET	20862
#define ID_SC74_MONITOR1	20630
#define ID_SC74_MON1_ANIM	20801
#define ID_SC74_MONITOR2	20802
#define ID_SC74_MON2_ANIM	20803
#define ID_SC74_MONITOR3	20804
#define ID_SC74_MON3_ANIM	20805
#define ID_SC74_MONITOR4	20806
#define ID_SC74_MON4_ANIM	20807
#define ID_SC74_LEFT_TV	20631
#define ID_SC74_LTV_ANIM	20808
#define ID_SC74_RIGHT_TV	20632
#define ID_SC74_RTV_ANIM	20809
#define ID_SC74_LIGHTS	20810
#define ID_SC74_LIGHTS_ANIM	20811
#define ID_SC75_FAST_LIST	20664
#define ID_SC75_CHIP_LIST	20665
#define ID_SC75_LOGIC_LIST	20666
#define ID_SC75_MOUSE_LIST	20667
#define ID_SC75_PALETTE	20668
#define ID_GRID75	20671
#define ID_SC75_JOEY_LIST	20912
#define ID_RESET_73_75	20669
#define ID_RESET_76_75	20698
#define ID_RS_TONGS_EMPTY	20868
#define ID_RS_TONGS_LIVE	20869
#define ID_RS_TONGS_FROZEN	20870
#define ID_RS_TONGS_DEAD	20871
#define ID_SC75_FLOOR	20670
#define ID_SC75_BIG_DOOR	20672
#define ID_SC75_DOOR	20696
#define ID_SC75_TONGS	20660
#define ID_SC75_GET_TONGS	20857
#define ID_SC75_NITRO_TANK	20699
#define ID_SC75_NITRO_ANIM	20828
#define ID_SC75_LIVE_TANK	20700
#define ID_SC75_TANK_ANIM	20872
#define ID_SC75_CONSOLE	20703
#define ID_SC75_MON_ANIM	20829
#define ID_SC75_CRASH_ANIM	20701
#define ID_SC75_LIGHT1	20830
#define ID_SC75_LIGHT1_ANIM	20831
#define ID_SC75_LIGHT2	20832
#define ID_SC75_LIGHT2_ANIM	20833
#define ID_SC75_USECARD	20858
#define ID_SC75_RPOCKET	20861
#define ID_SC75_HAND_TANK	20875
#define ID_SC75_GET_TISS	20863
#define ID_SC75_FREEZE_IT	20864
#define ID_SC75_FREEZE_IT2	20865
#define ID_SC75_FREEZE_DED	20866
#define ID_SC75_FREEZE_DED2	20867
#define ID_SC75_FREEZE_TALK	126
#define ID_SC75_DEAD_TALK	128
#define ID_SC76_FAST_LIST	20688
#define ID_SC76_CHIP_LIST	20689
#define ID_SC76_LOGIC_LIST	20690
#define ID_SC76_MOUSE_LIST	20691
#define ID_SC76_PALETTE	20692
#define ID_GRID76	20695
#define ID_SC76_JOEY_LIST	20913
#define ID_RESET_75_76	20693
#define ID_RESET_77_76	20727
#define ID_SC76_FLOOR	20694
#define ID_SC76_DOOR75	20697
#define ID_SC76_DOOR77	20725
#define ID_SC76_ANDROID_1	20705
#define ID_SC76_HATCH_1	20909
#define ID_SC76_ANDROID_2	20706
#define ID_SC76_HATCH_2	20910
#define ID_SC76_ANDROID_3	20707
#define ID_SC76_HATCH_3	20908
#define ID_SC76_PUNCH	20916
#define ID_SC76_FOSTFALL	20917
#define ID_SC76_CONSOLE_1	20711
#define ID_SC76_CONSOLE_2	20712
#define ID_SC76_CONSOLE_3	20713
#define ID_SC76_CABINET_1	20714
#define ID_SC76_CAB1_OPEN	20890
#define ID_SC76_CAB1_CLOSE	20891
#define ID_SC76_CABINET_2	20715
#define ID_SC76_CAB2_OPEN	20892
#define ID_SC76_CAB2_CLOSE	20893
#define ID_SC76_CABINET_3	20716
#define ID_SC76_CAB3_OPEN	20894
#define ID_SC76_CAB3_CLOSE	20895
#define ID_SC76_BOARD_1	20896
#define ID_SC76_BOARD_2	20897
#define ID_SC76_BOARD_3	20898
#define ID_SC76_OPEN_CAB	20899
#define ID_SC76_SHUT_CAB	20900
#define ID_SC76_LOW_GET	20901
#define ID_SC76_LIGHT1	20834
#define ID_SC76_LIGHT1_ANIM	20835
#define ID_SC76_LIGHT2	20836
#define ID_SC76_LIGHT2_ANIM	20837
#define ID_SC76_LIGHT3	20838
#define ID_SC76_LIGHT3_ANIM	20839
#define ID_SC76_LIGHT4	20840
#define ID_SC76_LIGHT4_ANIM	20841
#define ID_SC76_LIGHT5	20842
#define ID_SC76_LIGHT5_ANIM	20843
#define ID_SC76_LIGHT6	20844
#define ID_SC76_LIGHT6_ANIM	20845
#define ID_SC76_LIGHT7	20902
#define ID_SC76_LIGHT7_ANIM	20903
#define ID_SC76_LIGHT8	20904
#define ID_SC76_LIGHT8_ANIM	20905
#define ID_SC76_LIGHT9	20906
#define ID_SC76_LIGHT9_ANIM	20907
#define ID_SC76_AND2_BABBLE	142
#define ID_SC77_FAST_LIST	20717
#define ID_SC77_CHIP_LIST	20718
#define ID_SC77_LOGIC_LIST	20719
#define ID_SC77_MOUSE_LIST	20720
#define ID_SC77_PALETTE	20721
#define ID_GRID77	20724
#define ID_SC77_JOEY_LIST	20914
#define ID_RESET_76_77	20722
#define ID_RESET_78_77	20742
#define ID_SC77_FLOOR	20723
#define ID_SC77_DOOR76	20726
#define ID_SC77_BIG_DOOR	20728
#define ID_SC77_TANK_1	20729
#define ID_SC77_TANK_2	20730
#define ID_SC77_HAND_1	20731
#define ID_SC77_HAND_2	20732
#define ID_SC77_DOOR_OPEN	20760
#define ID_SC77_FPUSHL_1	20918
#define ID_SC77_FPUSHL_2	20919
#define ID_SC77_FPUSHR_1	20920
#define ID_SC77_FPUSHR_2	20921
#define ID_SC77_KPUSHR_1	20922
#define ID_SC77_KPUSHR_2	20923
#define ID_SC77_STRETCH	20924
#define ID_SC78_FAST_LIST	20733
#define ID_SC78_CHIP_LIST	20734
#define ID_SC78_LOGIC_LIST	20735
#define ID_SC78_MOUSE_LIST	20736
#define ID_SC78_PALETTE	20737
#define ID_SC781_PALETTE	20964
#define ID_GRID78	20740
#define ID_RESET_77_78	20738
#define ID_RESET_79_78	20753
#define ID_SC78_LEDGE	20739
#define ID_SC78_PIPE	20915
#define ID_SC78_BIG_DOOR	20741
#define ID_SC78_EXIT	20743
#define ID_SC78_SUPPORT	20874
#define ID_SC78_JUMP_DOWN	20881
#define ID_SC78_CLIMB_UP	20883
#define ID_SC79_FAST_LIST	20744
#define ID_SC79_CHIP_LIST	20745
#define ID_SC79_LOGIC_LIST	20746
#define ID_SC79_MOUSE_LIST	20747
#define ID_SC79_PALETTE	20748
#define ID_SC791_PALETTE	20963
#define ID_GRID79	20751
#define ID_RESET_78_79	20749
#define ID_RESET_80_79	20889
#define ID_SC79_PIPE	20750
#define ID_SC79_EXIT	20752
#define ID_SC79_SUPPORT	20873
#define ID_SC79_LADDER	20940
#define ID_SC79_CROUCH_DOWN	20941
#define ID_SC79_CROUCH_UP	20942
#define ID_SC79_CLIMB_DOWN	20943
#define ID_SC79_CLIMB_UP	20944
#define ID_SC79_TIE_ROPE	20951
#define ID_SC79_TOSS_ROPE	20952
#define ID_SC79_KNOT	20955
#define ID_SC79_ROPE	20887
#define ID_SC79_ROPE_ANIM	20953
#define ID_SC80_FAST_LIST	20876
#define ID_SC80_CHIP_LIST	20877
#define ID_SC80_LOGIC_LIST	20878
#define ID_SC80_MOUSE_LIST	20879
#define ID_SC80_PALETTE	20880
#define ID_SC801_PALETTE	20959
#define ID_SC802_PALETTE	20960
#define ID_SC803_PALETTE	20961
#define ID_SC804_PALETTE	20962
#define ID_RESET_79_80	20882
#define ID_SC80_SPOUT	20884
#define ID_SC80_LADDER	20950
#define ID_SC80_ROPE	20888
#define ID_SC80_ORIFICE	20885
#define ID_SC80_EXIT	20886
#define ID_SC80_EXIT_OPEN	20954
#define ID_SC80_GOO	20925
#define ID_SC80_GOO_ANIM	20926
#define ID_SC80_BUBBLE1	20927
#define ID_SC80_BUB1_ANIM	20928
#define ID_SC80_BUBBLE2	20929
#define ID_SC80_BUBBLE3	20930
#define ID_SC80_BUBBLE4	20931
#define ID_SC80_BUBBLE5	20932
#define ID_SC80_BUBBLE6	20933
#define ID_SC80_BUBBLE7	20934
#define ID_SC80_BUBBLE8	20935
#define ID_SC80_BUBBLE9	20936
#define ID_SC80_BUBBLE10	20937
#define ID_SC80_BUBBLE11	20938
#define ID_SC80_BUBBLE12	20939
#define ID_SC80_CLIMB_DOWN	20945
#define ID_SC80_CLIMB_UP	20946
#define ID_SC80_PIPE_SHRUG	20965
#define ID_SC80_CLAMBER	20947
#define ID_SC80_GET_ROPE	20948
#define ID_SC80_SWING	20949
#define ID_SC80_DROP	20956
#define ID_SC80_SAMPLE	20957
#define ID_SC80_SAMPLE_FALL	20958
#define IT_MEDI	32
#define IT_MEDI_TALK	180
#define IT_WITNESS	159
#define IT_GALLAGHER	90
#define IT_GALL_TALK	91
#define IT_SC66_LAYER_0	20
#define IT_SC66_DOOR	105
#define IT_SC66_HI_BEAM_AN1	98
#define IT_SC66_HI_BEAM_AN2	99
#define IT_SC66_LO_BEAM_ANM	22
#define IT_SC66_ROCK1	100
#define IT_SC66_ROCK2	101
#define IT_SC66_ROCK3	102
#define IT_SC66_STONES	103
#define IT_SC66_FOS_CRUSHED	104
#define IT_SC66_FOS_WALK_IN	21
#define IT_SC67_LAYER_0	23
#define IT_SC67_LAYER_1	24
#define IT_SC67_GRID_1	25
#define IT_SC67_PULSE1	26
#define IT_SC67_PULSE2	27
#define IT_SC67_PULSE3	28
#define IT_SC67_PULSE4	29
#define IT_SC67_DOOR	30
#define IT_SC67_ROCK	31
#define IT_SC67_CRAWL	46
#define IT_SC67_DUSTOFF	47
#define IT_SC67_GETBRICK	48
#define IT_SC67_BRICK	55
#define IT_SC67_PLASTER	56
#define IT_SC67_PICK_BRICK	129
#define IT_SC67_PICK_PLAST	130
#define IT_SC67_STICK_IN	131
#define IT_SC67_PULL_OUT	132
#define IT_SC67_BRICK_HIT	133
#define IT_SC67_PLAST_HIT	134
#define IT_SC67_LPOCKET	141
#define IT_SC67_RPOCKET	142
#define IT_SC67_RUB_HEAD	143
#define IT_SC67_PUSS	149
#define IT_SC67_MEDIFIX	150
#define IT_SC67_MENDING	151
#define IT_SC67_CROWBAR	152
#define IT_SC68_LAYER_0	43
#define IT_SC68_LAYER_1	44
#define IT_SC68_GRID_1	45
#define IT_SC68_DOOR	57
#define IT_SC68_PULSE1	58
#define IT_SC68_PULSE2	59
#define IT_SC68_PULSE3	60
#define IT_SC68_PULSE4	61
#define IT_SC68_PULSE5	62
#define IT_SC68_PULSE6	63
#define IT_SC68_SENSOR	137
#define IT_SC68_DESCEND	153
#define IT_SC68_ASCEND	154
#define IT_SC69_LAYER_0	71
#define IT_SC69_LAYER_1	72
#define IT_SC69_LAYER_2	74
#define IT_SC69_GRID_1	75
#define IT_SC69_GRID_2	76
#define IT_SC69_PULSE1	109
#define IT_SC69_PULSE2	110
#define IT_SC69_PULSE3	111
#define IT_SC69_PULSE4	112
#define IT_SC69_PULSE5	113
#define IT_SC69_PULSE6	114
#define IT_SC70_LAYER_0	90
#define IT_SC70_LAYER_1	91
#define IT_SC70_LAYER_2	92
#define IT_SC70_GRID_1	93
#define IT_SC70_GRID_2	94
#define IT_SC70_IRIS	95
#define IT_SC70_BAR	96
#define IT_SC70_CONSOLE	115
#define IT_SC70_GRILL	116
#define IT_SC70_PIT	117
#define IT_SC70_STEP_UP	14
#define IT_SC70_STEP_DOWN	15
#define IT_SC70_PULL_BAR	18
#define IT_SC70_ENTER_ANIM	97
#define IT_SC71_LAYER_0	85
#define IT_SC71_LAYER_1	86
#define IT_SC71_LAYER_2	87
#define IT_SC71_GRID_1	88
#define IT_SC71_GRID_2	89
#define IT_SC710_LAYER_0	70
#define IT_SC710_LAYER_1	16
#define IT_SC710_LAYER_2	157
#define IT_SC710_GRID_1	17
#define IT_SC710_GRID_2	158
#define IT_SC71_LIGHT1	162
#define IT_SC71_LIGHT2	163
#define IT_SC71_SCREEN	164
#define IT_SC71_CHARGE_LIGHT	165
#define IT_SC71_MEDI_CHARGE	166
#define IT_SC71_USE_BOARD	148
#define IT_SC71_PANEL	167
#define IT_SC71_PANEL2	168
#define IT_SC72_LAYER_0	64
#define IT_SC72_LAYER_1	65
#define IT_SC72_LAYER_2	66
#define IT_SC72_GRID_1	68
#define IT_SC72_GRID_2	69
#define IT_SC720_LAYER_0	67
#define IT_SC720_LAYER_1	160
#define IT_SC720_LAYER_2	155
#define IT_SC720_GRID_1	161
#define IT_SC720_GRID_2	156
#define IT_WALTER_CONVERSATION	129
#define IT_WALTER_TALK_UP	130
#define IT_WALTER_TALK_DOWN	131
#define IT_WALTER_TALK_LEFT	132
#define IT_SC72_CHAM1_LIGHT	171
#define IT_SC72_CHAM2_LIGHT	172
#define IT_SC72_TANK	173
#define IT_SC72_ROT_LIGHT	177
#define IT_SC72_COMPUTER	169
#define IT_SC72_COMPUTER2	170
#define IT_SC72_CHAMBER1	174
#define IT_SC72_CHAMBER2	175
#define IT_SC72_CHAMBER3	176
#define IT_SC72_WALTER_KILL	178
#define IT_SC72_FOSTER_DIE	179
#define IT_SC72_WALTER_DIE	30
#define IT_SC72_GRILL	28
#define IT_SC72_JOEY_TAP	29
#define IT_SC72_SPILL	31
#define IT_SC73_LAYER_0	97
#define IT_SC73_LAYER_1	98
#define IT_SC73_LAYER_2	99
#define IT_SC73_GRID_1	101
#define IT_SC73_GRID_2	102
#define IT_SC73_BIG_DOOR	138
#define IT_SC73_SENSOR	139
#define IT_SC73_CHAMBER3	142
#define IT_SC73_CHAMBER4	140
#define IT_SC73_CHAMBER5	141
#define IT_SC73_CHAM4_LIGHT	95
#define IT_SC73_CHAM5_LIGHT	96
#define IT_SC73_JOEY_LUNGE	85
#define IT_SC73_JOEY_FIGHT1	86
#define IT_SC73_GALL_FIGHT1	87
#define IT_SC73_JOEY_FIGHT2	88
#define IT_SC73_GALL_FIGHT2	89
#define IT_SC73_GET_BOARD	43
#define IT_SC73_SEARCH	44
#define IT_SC73_DEAD_GALL	72
#define IT_SC73_BITS	74
#define IT_SC73_BITS2	75
#define IT_SC73_SPRAY	76
#define IT_SC74_LAYER_0	104
#define IT_SC74_LAYER_1	105
#define IT_SC74_LAYER_2	106
#define IT_SC74_GRID_1	107
#define IT_SC74_GRID_2	108
#define IT_SC74_POD_DOWN	109
#define IT_SC74_POD_UP	110
#define IT_SC74_FOST_SIT	92
#define IT_SC74_GET_UP	93
#define IT_SC74_USECARD	70
#define IT_SC74_USECARD2	71
#define IT_SC74_RPOCKET	62
#define IT_SC74_MONITOR1	55
#define IT_SC74_MONITOR2	56
#define IT_SC74_MONITOR3	57
#define IT_SC74_MONITOR4	58
#define IT_SC74_LEFT_TV	59
#define IT_SC74_RIGHT_TV	60
#define IT_SC74_LIGHTS	61
#define IT_SC75_LAYER_0	144
#define IT_SC75_LAYER_1	145
#define IT_SC75_LAYER_2	146
#define IT_SC75_GRID_1	147
#define IT_SC75_GRID_2	148
#define IT_SC75_MONITOR	149
#define IT_SC75_CRASH	164
#define IT_SC75_TANK	165
#define IT_SC75_STEAM	150
#define IT_SC75_LIGHT1	151
#define IT_SC75_LIGHT2	152
#define IT_SC75_TONGS	153
#define IT_SC75_GET_TONGS	154
#define IT_SC75_USECARD	155
#define IT_SC75_RPOCKET	156
#define IT_SC75_HAND_TANK	166
#define IT_SC75_GET_TISS	157
#define IT_SC75_FREEZE_IT	158
#define IT_SC75_FREEZE_TALK	159
#define IT_SC75_FREEZE_IT2	160
#define IT_SC75_FREEZE_DED	161
#define IT_SC75_DEAD_TALK	162
#define IT_SC75_FREEZE_DED2	163
#define IT_SC76_LAYER_0	14
#define IT_SC76_LAYER_1	15
#define IT_SC76_LAYER_2	16
#define IT_SC76_GRID_1	17
#define IT_SC76_GRID_2	18
#define IT_SC76_LIGHT1	29
#define IT_SC76_LIGHT2	30
#define IT_SC76_LIGHT3	31
#define IT_SC76_LIGHT4	32
#define IT_SC76_LIGHT5	43
#define IT_SC76_LIGHT6	44
#define IT_SC76_LIGHT7	45
#define IT_SC76_LIGHT8	46
#define IT_SC76_LIGHT9	47
#define IT_SC76_CABINET_1	55
#define IT_SC76_CABINET_2	56
#define IT_SC76_CABINET_3	57
#define IT_SC76_BOARD_1	58
#define IT_SC76_BOARD_2	59
#define IT_SC76_BOARD_3	60
#define IT_SC76_OPEN_CAB	62
#define IT_SC76_LOW_GET	63
#define IT_KEN	61
#define IT_SC76_HATCH_1	66
#define IT_SC76_ANDROID_2	67
#define IT_SC76_HATCH_2	68
#define IT_SC76_ANDROID_3	64
#define IT_SC76_HATCH_3	65
#define IT_SC76_PUNCH	69
#define IT_SC76_FOSTFALL	70
#define IT_SC76_KEN_TALK	71
#define IT_SC76_AND2_BABBLE	72
#define IT_SC77_LAYER_0	20
#define IT_SC77_LAYER_1	21
#define IT_SC77_GRID_1	22
#define IT_SC77_BIG_DOOR	28
#define IT_SC77_FPUSHL	74
#define IT_SC77_FPUSHR	75
#define IT_SC77_KPUSHR	76
#define IT_SC77_STRETCH	87
#define IT_SC78_LAYER_0	23
#define IT_SC78_LAYER_1	24
#define IT_SC78_GRID_1	25
#define IT_SC78_JUMP_DOWN	85
#define IT_SC78_CLIMB_UP	86
#define IT_SC79_LAYER_0	26
#define IT_SC79_SUPPORT	48
#define IT_SC79_CROUCH	91
#define IT_SC79_CLIMB	92
#define IT_SC79_TIE_ROPE	96
#define IT_SC79_TOSS_ROPE	97
#define IT_SC79_ROPE	98
#define IT_SC79_KNOT	101
#define IT_SC80_LAYER_0	27
#define IT_SC80_EXIT	100
#define IT_SC80_ROPE	99
#define IT_SC80_GOO	88
#define IT_SC80_BUBBLE	89
#define IT_SC80_CLIMB	90
#define IT_SC80_CLAMBER	93
#define IT_SC80_GET_ROPE	94
#define IT_SC80_SWING	95
#define IT_SC80_DROP	103
#define IT_SC80_SAMPLE	104
#define IT_SC80_PIPE_TALK	105
#define IT_SC80_PIPE_SHRUG	106
#define IDO_DOG_FOOD	49
#define ID_SC30_FAST_LIST	16385
#define ID_SC30_CHIP_LIST	16386
#define ID_SC30_LOGIC_LIST	16387
#define ID_SC30_MOUSE_LIST	16388
#define ID_SC30_PALETTE	16389
#define ID_SC30_WALK_GRID	16390
#define ID_SC30_JOEY_LIST	16547
#define ID_RESET_31_30	16413
#define ID_RESET_33_30	16414
#define ID_RESET_36_30	16539
#define ID_RESET_42_30	16811
#define ID_RESET_COURT_OPEN	16813
#define ID_SC30_FLOOR	16392
#define ID_SC30_EXIT_31	16393
#define ID_SC30_EXIT_33	16394
#define ID_SC30_EXIT_36	16492
#define ID_SC30_COURT_DOOR	16487
#define ID_SC30_COURT_CLOSE	16814
#define ID_SC30_NOTICE	16489
#define ID_SC30_STATUE_1	16490
#define ID_SC30_STATUE_2	16491
#define ID_SC30_HENRI	16516
#define ID_SC30_HENRI_TALK	16517
#define ID_SC30_HENRI_TIE	16518
#define ID_SC30_HEN_STEP_F	16519
#define ID_SC30_HEN_STEP_B	16520
#define ID_SC30_HEN_BLINK	16521
#define ID_SC30_PUSH_DOOR	16522
#define ID_SC31_FAST_LIST	16774
#define ID_SC31_CHIP_LIST	16396
#define ID_SC31_LOGIC_LIST	16397
#define ID_SC31_MOUSE_LIST	16398
#define ID_SC31_PALETTE	16399
#define ID_SC31_WALK_GRID	16400
#define ID_SC31_JOEY_LIST	16548
#define ID_RESET_START_31	16391
#define ID_RESET_30_31	16401
#define ID_RESET_32_31	16425
#define ID_RESET_39_31	16463
#define ID_RS_GUARD_CHAT	16699
#define ID_RS_GUARD_AVAIL	16700
#define ID_SC31_FLOOR	16402
#define ID_SC31_EXIT_30	16403
#define ID_SC31_EXIT_32	16415
#define ID_SC31_EXIT_39	16453
#define ID_SC31_LIFT_SLOT	16493
#define ID_SC31_LIFT	16513
#define ID_SC31_LIFT_OPEN	16514
#define ID_SC31_LIFT_CLOSE	16515
#define ID_SC31_USE_CARD	16523
#define ID_SC31_PULL_ROPE	16551
#define ID_SC31_LOWER_ROPE	16552
#define ID_SC31_DROP_ROPE	16553
#define ID_SC31_END_OF_ROPE	16554
#define ID_SC31_ROPE	16555
#define ID_SC31_ROPE_PULLED	16556
#define ID_SC31_ROPE_LOWER	16557
#define ID_SC31_ROPE_DROP	16558
#define ID_SC31_BRICKS	16559
#define ID_SC31_BRICKS_UP	16560
#define ID_SC31_BRICKS_DOWN	16561
#define ID_SC31_BRICKS_FALL	16562
#define ID_SC31_PLANK	16563
#define ID_SC31_PLANK_DROP	16564
#define ID_SC31_PLANK_RAISE	16565
#define ID_SC31_PLANK_FLICK	16566
#define ID_SC31_GUARD	16601
#define ID_SC31_GUARD_TALK	16607
#define ID_SC31_GUARD_BLINK	16693
#define ID_SC31_GUARD_MOVE	16694
#define ID_SC31_GUARD_REACH	16695
#define ID_SC31_GUARD_TALK2	16696
#define ID_SC31_GET_BRICKS	16683
#define ID_SC31_GET_PLANK	16687
#define ID_SC31_CLIMB_PLANK	16684
#define ID_SC31_DOG_FLY	16685
#define ID_SC31_DOG_RISE	16697
#define ID_SC31_DOG_SWIM	16698
#define ID_SC31_PUT_BISC	16688
#define ID_SC31_BISCUITS	16692
#define ID_SC31_BISC_PLACED	16689
#define ID_SC31_BISC_DROP	16690
#define ID_SC31_BISC_RAISE	16691
#define ID_SC32_FAST_LIST	16416
#define ID_SC32_CHIP_LIST	16417
#define ID_SC32_LOGIC_LIST	16418
#define ID_SC32_MOUSE_LIST	16419
#define ID_SC32_PALETTE	16420
#define ID_SC32_WALK_GRID	16421
#define ID_SC32_JOEY_LIST	16549
#define ID_RESET_31_32	16422
#define ID_RESET_33_32	16429
#define ID_RESET_38_32	16452
#define ID_SC32_FLOOR	16423
#define ID_SC32_EXIT_31	16424
#define ID_SC32_EXIT_33	16426
#define ID_SC32_LIFT	16442
#define ID_SC32_LIFT_OPEN	16540
#define ID_SC32_LIFT_CLOSE	16541
#define ID_SC32_TERMINAL	16494
#define ID_SC32_BUZZER	16495
#define ID_SC32_PLANT_1	16496
#define ID_SC32_PLANT_2	16497
#define ID_SC32_PLANT_3	16498
#define ID_SC32_USE_CARD	16524
#define ID_SC32_USE_COM	16525
#define ID_SC32_VINCENT	16599
#define ID_SC32_VINC_ANIM	16602
#define ID_SC32_GARDENER	16600
#define ID_SC32_GARDENING1	16622
#define ID_SC32_GARDENING2	16623
#define ID_SC32_GARDENER_UP	16624
#define ID_SC32_GARDENER_DN	16625
#define ID_SC32_GARD_TURN_D	16626
#define ID_SC32_GARD_TURN_U	16627
#define ID_SC32_GARDEN_TALK	16628
#define ID_SC33_FAST_LIST	16404
#define ID_SC33_CHIP_LIST	16405
#define ID_SC33_LOGIC_LIST	16406
#define ID_SC33_MOUSE_LIST	16407
#define ID_SC33_PALETTE	16408
#define ID_SC33_WALK_GRID	16409
#define ID_SC33_JOEY_LIST	16550
#define ID_RESET_30_33	16410
#define ID_RESET_32_33	16427
#define ID_RESET_34_33	16440
#define ID_SC33_FLOOR	16411
#define ID_SC33_EXIT_30	16412
#define ID_SC33_EXIT_32	16428
#define ID_SC33_SHED_DOOR	16430
#define ID_SC33_LOCK	16499
#define ID_SC33_USE_CARD	16526
#define ID_SC33_PUSH_DOOR1	16527
#define ID_SC33_PUSH_DOOR2	16528
#define ID_SC33_DOOR_OPEN	16529
#define ID_SC34_FAST_LIST	16431
#define ID_SC34_CHIP_LIST	16432
#define ID_SC34_LOGIC_LIST	16433
#define ID_SC34_MOUSE_LIST	16434
#define ID_SC34_PALETTE	16435
#define ID_SC34_WALK_GRID	16436
#define ID_RESET_33_34	16437
#define ID_SC34_FLOOR	16438
#define ID_SC34_DOOR	16439
#define ID_SC34_SECATEURS	16501
#define ID_SC34_TKT_MACHINE	16502
#define ID_SC34_MAP	16503
#define ID_SC34_BRICKS	16504
#define ID_SC34_GET_SECS	16544
#define ID_SC34_STAIRS1	16545
#define ID_SC34_STAIRS2	16546
#define ID_SC36_FAST_LIST	16530
#define ID_SC36_CHIP_LIST	16531
#define ID_SC36_LOGIC_LIST	16532
#define ID_SC36_MOUSE_LIST	16533
#define ID_SC36_PALETTE	16534
#define ID_SC36_WALK_GRID	16535
#define ID_RESET_30_36	16536
#define ID_RESET_37_36	16593
#define ID_RESET_COLSTON	16812
#define ID_SC36_FLOOR	16537
#define ID_SC36_LOW_FLOOR	16596
#define ID_SC36_EXIT_30	16538
#define ID_SC36_DOOR	16583
#define ID_SC36_DOOROPEN	16792
#define ID_SC36_DOORSHUT	16793
#define ID_SC36_FOS_DOWN1	16748
#define ID_SC36_FOS_DOWN2	16749
#define ID_SC36_FOS_UP1	16750
#define ID_SC36_FOS_UP2	16751
#define ID_SC36_PRESS_PLATE	16752
#define ID_SC36_USE_JUKEBOX	16753
#define ID_SC36_REACH_GLASS	16759
#define ID_SC36_GET_GLASS	16760
#define ID_SC36_JUKEBOX	16597
#define ID_SC36_JUKE_TALK	16756
#define ID_SC36_JUKE_STUCK	16770
#define ID_SC36_JUKE_BREAK	16771
#define ID_SC36_JUKE_LIGHT	16757
#define ID_SC36_JUKEBOX_ON	16754
#define ID_SC36_JUKEBOX_OFF	16755
#define ID_SC36_JUKE_KICKED	16758
#define ID_SC36_CARDS	16742
#define ID_SC36_GLASS	16747
#define ID_SC36_SENSOR	16594
#define ID_SC36_BAND	16598
#define ID_SC36_BAND_ANIM	16686
#define ID_SC36_BARMAN	16701
#define ID_BAR_BLINK	16702
#define ID_BAR_GET_DRINK	16703
#define ID_BAR_DRINK	16704
#define ID_BAR_GET_CLOTH	16705
#define ID_BAR_PUT_CLOTH	16706
#define ID_BAR_WIPE	16707
#define ID_BAR_WIPE2	16708
#define ID_BARMAN_TALK	16709
#define ID_SC36_BABS	16772
#define ID_SC36_BABS_TALK	16773
#define ID_SC36_COLSTON	16731
#define ID_SC36_COL_FEET	16732
#define ID_SC36_COL_TALK1	16743
#define ID_SC36_COL_TALK2	16744
#define ID_SC36_COL_DRINK	16746
#define ID_SC36_COL_DEAL	16733
#define ID_SC36_COL_THINK	16734
#define ID_SC36_COL_BLINK1	16735
#define ID_SC36_COL_BLINK2	16736
#define ID_SC36_COL_DOWN1	16761
#define ID_SC36_COL_DOWN2	16762
#define ID_SC36_COL_DOWN3	16763
#define ID_SC36_COL_DOWN4	16764
#define ID_SC36_COL_UP1	16765
#define ID_SC36_COL_UP2	16766
#define ID_SC36_COL_UP3	16767
#define ID_SC36_COL_UP4	16768
#define ID_SC36_COL_KICK	16769
#define ID_SC36_GALLAGHER	16737
#define ID_SC36_GAL_TALK	16745
#define ID_SC36_GAL_LEGS	16738
#define ID_SC36_GAL_DEAL	16739
#define ID_SC36_GAL_LOOK1	16740
#define ID_SC36_GAL_LOOK2	16741
#define ID_SC37_FAST_LIST	16584
#define ID_SC37_CHIP_LIST	16585
#define ID_SC37_LOGIC_LIST	16586
#define ID_SC37_MOUSE_LIST	16587
#define ID_SC37_PALETTE	16588
#define ID_SC37_WALK_GRID	16589
#define ID_RESET_36_37	16590
#define ID_SC37_FLOOR	16591
#define ID_SC37_HOLDING_LID	16794
#define ID_SC37_DOOR	16592
#define ID_SC37_DOOROPEN	16790
#define ID_SC37_DOORSHUT	16791
#define ID_SC37_SENSOR	16595
#define ID_SC37_BIG_BOX	16620
#define ID_SC37_FLIMSY_BOX	16619
#define ID_SC37_WINE_RACK	16799
#define ID_SC37_LID	16621
#define ID_SC37_LIDUP	16786
#define ID_SC37_LIDDOWN	16787
#define ID_SC37_LIDUSED	16788
#define ID_SC37_GRILL	16617
#define ID_SC37_GRILLOPEN	16789
#define ID_SC37_CRBARBOX	16775
#define ID_SC37_GETLID	16776
#define ID_SC37_PUTLID	16777
#define ID_SC37_USELID	16778
#define ID_SC37_STEPUP	16779
#define ID_SC37_FOOTDROP	16780
#define ID_SC37_STEPDOWN	16781
#define ID_SC37_USEBAR	16782
#define ID_SC37_USESEC	16783
#define ID_SC37_CLIMBOUT	16784
#define ID_SC37_THUMBSUP	16785
#define ID_SC38_FAST_LIST	16443
#define ID_SC38_CHIP_LIST	16444
#define ID_SC38_LOGIC_LIST	16445
#define ID_SC38_MOUSE_LIST	16446
#define ID_SC38_PALETTE	16447
#define ID_SC38_WALK_GRID	16448
#define ID_RESET_32_38	16449
#define ID_RESET_SPUNKY_38	16616
#define ID_RESET_DANI_SIT	16608
#define ID_RESET_DANI_STAND	16609
#define ID_RESET_DANI_32	16629
#define ID_RESET_SPUNKY_32	16630
#define ID_SC38_FLOOR	16450
#define ID_SC38_LIFT	16451
#define ID_SC38_LIFT_UP	16542
#define ID_SC38_LIFT_DOWN	16543
#define ID_SC38_STATUE	16505
#define ID_SC38_MONITOR	16506
#define ID_SC38_VIDEO	16507
#define ID_SC38_SOFA	16508
#define ID_SC38_DOG_TRAY	16615
#define ID_SC38_BISCUITS	16618
#define ID_SC38_HAND_SET	16610
#define ID_SC38_RINGER	16611
#define ID_SC38_RINGER_ANIM	16612
#define ID_DANIELLE	16441
#define ID_DANI_CONV	16603
#define ID_SC38_DANI_ANIM_1	16395
#define ID_SC38_DANI_ANIM_2	16488
#define ID_SC38_DANI_ANIM_3	16500
#define ID_SC38_DANI_GET_UP	16605
#define ID_SC38_DANI_SATTLK	16604
#define ID_SC38_GET_PHONE	16613
#define ID_SC38_PHONE_TALK	16614
#define ID_SPUNKY	16486
#define ID_SNIFF_LEFT	16509
#define ID_SNIFF_RIGHT	16510
#define ID_PISS_LEFT	16511
#define ID_PISS_RIGHT	16512
#define ID_BARK	16637
#define ID_SC38_USE_VIDEO	16631
#define ID_SC38_VIDEO_ANIM	16632
#define ID_SC38_SCREEN_1	16633
#define ID_SC38_SCREEN_2	16634
#define ID_SC38_SCREEN_3	16635
#define ID_SC38_SCREEN_4	16636
#define ID_SC38_REACH_FOOD	16638
#define ID_SC38_GET_FOOD	16639
#define ID_SC39_FAST_LIST	16454
#define ID_SC39_CHIP_LIST	16455
#define ID_SC39_LOGIC_LIST	16456
#define ID_SC39_MOUSE_LIST	16457
#define ID_SC39_PALETTE	16458
#define ID_SC39_WALK_GRID	16459
#define ID_RESET_31_39	16460
#define ID_RESET_40_39	16475
#define ID_RESET_41_39	16485
#define ID_SC39_FLOOR	16461
#define ID_SC39_EXIT_31	16462
#define ID_SC39_EXIT_40	16464
#define ID_SC39_EXIT_41	16465
#define ID_SC40_FAST_LIST	16466
#define ID_SC40_CHIP_LIST	16467
#define ID_SC40_LOGIC_LIST	16468
#define ID_SC40_MOUSE_LIST	16469
#define ID_SC40_PALETTE	16470
#define ID_SC40_WALK_GRID	16471
#define ID_RESET_39_40	16472
#define ID_SC40_FLOOR	16473
#define ID_SC40_EXIT_39	16474
#define ID_SC40_CABINET	16567
#define ID_SC40_TROLLEY	16568
#define ID_SC40_LOCKER_1	16569
#define ID_SC40_LOCKER_2	16570
#define ID_SC40_LOCKER_3	16571
#define ID_SC40_LOCKER_4	16572
#define ID_SC40_LOCKER_5	16573
#define ID_SC40_LOCKER_OPEN	16574
#define ID_SC40_LOCKER_SHUT	16575
#define ID_SC40_BODY_1	16576
#define ID_SC40_BODY_2	16577
#define ID_SC40_BODY_3	16578
#define ID_SC40_BODY_4	16579
#define ID_SC40_BODY_5	16580
#define ID_SC40_OPEN_DOOR	16581
#define ID_SC40_CLOSE_DOOR	16582
#define ID_SC41_FAST_LIST	16476
#define ID_SC41_CHIP_LIST	16477
#define ID_SC41_LOGIC_LIST	16478
#define ID_SC41_MOUSE_LIST	16479
#define ID_SC41_PALETTE	16480
#define ID_SC41_WALK_GRID	16481
#define ID_RESET_39_41	16482
#define ID_SC41_FLOOR	16483
#define ID_SC41_EXIT_39	16484
#define ID_SC42_FAST_LIST	16802
#define ID_SC42_CHIP_LIST	16803
#define ID_SC42_LOGIC_LIST	16804
#define ID_SC42_MOUSE_LIST	16805
#define ID_SC42_PALETTE	16806
#define ID_SC42_WALK_GRID	16807
#define ID_RESET_30_42	16808
#define ID_SC44_FAST_LIST	16640
#define ID_SC44_CHIP_LIST	16641
#define ID_SC44_LOGIC_LIST	16642
#define ID_SC44_MOUSE_LIST	16643
#define ID_SC44_PALETTE	16644
#define ID_SC44_WALK_GRID	16645
#define ID_RESET_37_44	16646
#define ID_RESET_45_44	16647
#define ID_SC44_FLOOR	16648
#define ID_SC44_EXIT_45	16649
#define ID_SC44_GRILL	16795
#define ID_SC44_RUBBLE	16800
#define ID_SC45_FAST_LIST	16650
#define ID_SC45_CHIP_LIST	16651
#define ID_SC45_LOGIC_LIST	16652
#define ID_SC45_MOUSE_LIST	16653
#define ID_SC45_PALETTE	16654
#define ID_SC45_WALK_GRID	16655
#define ID_RESET_44_45	16656
#define ID_RESET_46_45	16657
#define ID_RESET_47_45	16658
#define ID_SC45_FLOOR	16659
#define ID_SC45_EXIT_44	16660
#define ID_SC45_EXIT_46	16661
#define ID_SC45_EXIT_47	16662
#define ID_SC46_FAST_LIST	16663
#define ID_SC46_CHIP_LIST	16664
#define ID_SC46_LOGIC_LIST	16665
#define ID_SC46_MOUSE_LIST	16666
#define ID_SC46_PALETTE	16667
#define ID_SC46_WALK_GRID	16668
#define ID_RESET_45_46	16669
#define ID_SC46_FLOOR	16670
#define ID_SC46_EXIT_45	16671
#define ID_SC46_RUBBLE	16801
#define ID_SC47_FAST_LIST	16672
#define ID_SC47_CHIP_LIST	16673
#define ID_SC47_LOGIC_LIST	16674
#define ID_SC47_MOUSE_LIST	16675
#define ID_SC47_PALETTE	16676
#define ID_SC47_WALK_GRID	16677
#define ID_RESET_45_47	16678
#define ID_RESET_48_47	16679
#define ID_SC47_FLOOR	16680
#define ID_SC47_EXIT_45	16681
#define ID_SC47_EXIT_48	16682
#define ID_SC48_FAST_LIST	16710
#define ID_SC48_CHIP_LIST	16711
#define ID_SC48_LOGIC_LIST	16712
#define ID_SC48_MOUSE_LIST	16713
#define ID_SC48_PALETTE	16714
#define ID_SC48_WALK_GRID	16715
#define ID_RESET_47_48	16716
#define ID_RESET_65_48	16717
#define ID_SC48_FLOOR	16718
#define ID_SC48_EXIT_47	16719
#define ID_SC48_EXIT_65	16720
#define ID_SC65_FAST_LIST	16721
#define ID_SC65_CHIP_LIST	16722
#define ID_SC65_LOGIC_LIST	16723
#define ID_SC65_MOUSE_LIST	16724
#define ID_SC65_PALETTE	16725
#define ID_SC65_WALK_GRID	16726
#define ID_RESET_48_65	16727
#define ID_SC65_FLOOR	16728
#define ID_SC65_EXIT_48	16729
#define ID_SC65_EXIT_66	16730
#define ID_SC65_POSTER1	16796
#define ID_SC65_POSTER2	16797
#define ID_SC65_SIGN	16798
#define IT_SC30_LAYER_0	14
#define IT_SC30_LAYER_1	15
#define IT_SC30_LAYER_2	16
#define IT_SC30_GRID_1	17
#define IT_SC30_GRID_2	18
#define IT_SC30_HENRI_TALK	87
#define IT_SC30_HENRI_TIE	88
#define IT_SC30_HENRI_STEP	89
#define IT_SC30_HENRI_BLINK	90
#define IT_SC30_COURT_DOOR	134
#define IT_SC30_PUSH_DOOR	91
#define IT_SC31_LAYER_0	20
#define IT_SC31_LAYER_1	21
#define IT_SC31_GRID_1	22
#define IT_SC31_LIFT	86
#define IT_SC31_USE_CARD	92
#define IT_SC31_PULL_ROPE	31
#define IT_SC31_HOLD_ROPE	108
#define IT_SC31_LOWER_ROPE	32
#define IT_SC31_DROP_ROPE	43
#define IT_SC31_PLANK	44
#define IT_SC31_BRICK_UP	45
#define IT_SC31_BRICK_FALL	46
#define IT_SC31_END_OF_ROPE	61
#define IT_SC31_ROPE_PULLED	62
#define IT_SC31_ROPE_LOWER	63
#define IT_SC31_ROPE_DROP	64
#define IT_SC31_GUARD_TALK	101
#define IT_SC31_GUARD_BLINK	110
#define IT_SC31_GUARD_MOVE	129
#define IT_SC31_GUARD_REACH	130
#define IT_SC31_GUARD_TALK2	131
#define IT_SC31_GET_BRICKS	102
#define IT_SC31_GET_PLANK	106
#define IT_SC31_CLIMB_PLANK	103
#define IT_SC31_DOG_FLY	104
#define IT_SC31_DOG_RISE	132
#define IT_SC31_DOG_SWIM	133
#define IT_SC31_PUT_BISC	109
#define IT_SC31_HAND	107
#define IT_SC31_BISCUITS	105
#define IT_SC32_LAYER_0	23
#define IT_SC32_LAYER_1	24
#define IT_SC32_LAYER_2	98
#define IT_SC32_GRID_1	25
#define IT_SC32_GRID_2	99
#define IT_SC32_USE_CARD	93
#define IT_SC32_USE_COM	94
#define IT_SC32_LIFT	100
#define IT_SC32_VINCENT	56
#define IT_SC32_VINC_TALK	57
#define IT_SC32_GARDENER	58
#define IT_SC32_GARD_TURN	59
#define IT_SC32_GARDEN_TALK	60
#define IT_SC33_LAYER_0	26
#define IT_SC33_LAYER_1	27
#define IT_SC33_LAYER_2	28
#define IT_SC33_GRID_1	29
#define IT_SC33_GRID_2	30
#define IT_SC33_USE_CARD	95
#define IT_SC33_PUSH_DOOR	96
#define IT_SC33_SHED_DOOR	97
#define IT_SC34_LAYER_0	31
#define IT_SC34_LAYER_1	32
#define IT_SC34_GRID_1	43
#define IT_SC34_STAIRS1	102
#define IT_SC34_STAIRS2	103
#define IT_SC34_SECATEURS	104
#define IT_SC34_GET_SECS	105
#define IT_SC36_LAYER_0	20
#define IT_SC36_LAYER_1	21
#define IT_SC36_LAYER_2	22
#define IT_SC36_LAYER_3	56
#define IT_SC36_GRID_1	23
#define IT_SC36_GRID_2	24
#define IT_SC36_GRID_3	57
#define IT_SC36_BABS	106
#define IT_SC36_BABS_TALK	107
#define IT_SC36_FOS_DOWN1	92
#define IT_SC36_FOS_DOWN2	93
#define IT_SC36_FOS_UP1	94
#define IT_SC36_FOS_UP2	95
#define IT_SC36_PRESS_PLATE	70
#define IT_SC36_USE_JUKEBOX	67
#define IT_SC36_GET_GLASS	96
#define IT_SC36_JUKE_LIGHT	68
#define IT_SC36_JUKEBOX	86
#define IT_SC36_GLASS	66
#define IT_SC36_BAND	31
#define IT_SC36_BARMAN	32
#define IT_BARMAN_TALK	61
#define IT_SC36_COLSTON	47
#define IT_SC36_COL_FEET	48
#define IT_SC36_COL_TALK1	62
#define IT_SC36_COL_TALK2	63
#define IT_SC36_COL_DRINK	69
#define IT_SC36_COL_DOWN1	97
#define IT_SC36_COL_DOWN2	98
#define IT_SC36_COL_DOWN3	99
#define IT_SC36_COL_DOWN4	100
#define IT_SC36_COL_UP1	101
#define IT_SC36_COL_UP2	102
#define IT_SC36_COL_UP3	103
#define IT_SC36_COL_UP4	104
#define IT_SC36_COL_KICK	105
#define IT_SC36_GALLAGHER	58
#define IT_SC36_GAL_LEGS	59
#define IT_SC36_GAL_TALK	64
#define IT_SC36_CARDS	60
#define IT_SC36_DOOR	144
#define IT_SC37_LAYER_0	14
#define IT_SC37_LAYER_1	15
#define IT_SC37_LAYER_2	16
#define IT_SC37_GRID_1	17
#define IT_SC37_GRID_2	18
#define IT_SC37_CRBARBOX	108
#define IT_SC37_GETLID	109
#define IT_SC37_USELID	110
#define IT_SC37_STEPUP	129
#define IT_SC37_FOOTDROP	130
#define IT_SC37_STEPDOWN	131
#define IT_SC37_USEBAR	132
#define IT_SC37_USESEC	133
#define IT_SC37_CLIMBOUT	134
#define IT_SC37_THUMBSUP	136
#define IT_SC37_BOXLID	137
#define IT_SC37_LIDUP	138
#define IT_SC37_LIDUSED	139
#define IT_SC37_LOOSEBIT	140
#define IT_SC37_GRILL	141
#define IT_SC37_GRILLOPEN	142
#define IT_SC37_DOOR	143
#define IT_SC38_LAYER_0	44
#define IT_SC38_LAYER_1	45
#define IT_SC38_LAYER_2	46
#define IT_SC38_GRID_1	47
#define IT_SC38_GRID_2	48
#define IT_DANIELLE	55
#define IT_DANI_CONV	85
#define IT_SPUNKY	71
#define IT_SC38_SEXY_DANI	106
#define IT_SC38_DANI_ANIMS	107
#define IT_SC38_DANI_SATTLK	108
#define IT_SC38_DANI_GET_UP	109
#define IT_SNIFF_LEFT	72
#define IT_SNIFF_RIGHT	74
#define IT_PISS_LEFT	75
#define IT_PISS_RIGHT	76
#define IT_BARK	65
#define IT_SC38_FOSTER_LIFT	101
#define IT_SC38_HAND_SET	110
#define IT_SC38_RINGER	129
#define IT_SC38_GET_PHONE	130
#define IT_SC38_PHONE_TALK	131
#define IT_SC38_USE_VIDEO	132
#define IT_SC38_VIDEO_ANIM	133
#define IT_SC38_SCREEN_1	134
#define IT_SC38_SCREEN_2	136
#define IT_SC38_SCREEN_3	137
#define IT_SC38_SCREEN_4	138
#define IT_SC38_GET_FOOD	139
#define IT_SC39_LAYER_0	56
#define IT_SC39_LAYER_1	57
#define IT_SC39_LAYER_2	58
#define IT_SC39_GRID_1	59
#define IT_SC39_GRID_2	60
#define IT_SC40_LAYER_0	61
#define IT_SC40_LAYER_1	62
#define IT_SC40_LAYER_2	63
#define IT_SC40_GRID_1	64
#define IT_SC40_GRID_2	65
#define IT_SC40_LOCKER	14
#define IT_SC40_OPEN_DOOR	15
#define IT_SC40_CLOSE_DOOR	16
#define IT_SC41_LAYER_0	66
#define IT_SC41_LAYER_1	67
#define IT_SC41_LAYER_2	68
#define IT_SC41_GRID_1	69
#define IT_SC41_GRID_2	70
#define IT_SC42_LAYER_0	20
#define IT_SC42_LAYER_1	21
#define IT_SC42_GRID_1	23
#define IT_SC44_LAYER_0	25
#define IT_SC45_LAYER_0	26
#define IT_SC45_LAYER_1	27
#define IT_SC45_GRID_1	28
#define IT_SC46_LAYER_0	29
#define IT_SC47_LAYER_0	30
#define IT_SC48_LAYER_0	43
#define IT_SC65_LAYER_0	44
#define IT_SC65_LAYER_1	45
#define IT_SC65_GRID_1	46
#define ID_RADMAN	8205
#define ID_FACT3_R_EXIT	8459
#define ID_LOCKER3	8460
#define ID_LOCKER2	8463
#define ID_LOCKER1	8464
#define ID_MACHINE	8467
#define ID_STUMP	8468
#define ID_S16_FLOOR	8473
#define ID_ENTRANCE_EXIT	8478
#define ID_REACTOR_PC	8480
#define ID_REACTOR_DOOR	8481
#define ID_RAD_SCREEN	8482
#define ID_14_CONSOLE	8483
#define ID_COAT	8484
#define ID_SENSORS	8500
#define ID_REACTOR_LOWER	8502
#define ID_S17_FLOOR	8507
#define ID_CORE_EXIT	8511
#define ID_PULSE	8513
#define ID_PULSEB	8515
#define ID_ANITA_CARD	8517
#define ID_CONSOLE_12	8524
#define ID_JUNK1	4339
#define ID_JUNK2	4340
#define ID_LIFT7_LIGHT	8529
#define ID_S29_FLOOR	12292
#define ID_LIFT_29	12296
#define ID_S29_CARD_SLOT	12299
#define ID_LIFT29_LIGHT	12301
#define ID_RIGHT_EXIT_29	12304
#define ID_S23_FLOOR	12309
#define ID_LEFT_EXIT_23	12313
#define ID_ANCHOR_EXIT_23	12315
#define ID_S25_FLOOR	12320
#define ID_ANCHOR_EXIT_25	12324
#define ID_TRAVEL_EXIT_23	12327
#define ID_S24_FLOOR	12332
#define ID_LEFT_EXIT_24	12336
#define ID_LEFT_EXIT_29	12338
#define ID_S28_FLOOR	12343
#define ID_RIGHT_EXIT_28	12347
#define ID_LEFT_EXIT_28	12349
#define ID_S19_FLOOR	12354
#define ID_RIGHT_EXIT_19	12358
#define ID_LEFT_EXIT_19	12361
#define ID_S26_FLOOR	12366
#define ID_RIGHT_EXIT_26	12370
#define ID_DUSTBIN_28	12372
#define ID_POSTER1	12375
#define ID_POSTER2	12376
#define ID_POSTER3	12377
#define ID_POSTER4	12378
#define ID_26_PLANT	12379
#define ID_LEAFLET	12380
#define ID_HOLO	12381
#define ID_BIN_23	12382
#define ID_SCULPTURE	12383
#define ID_LINK_23	12384
#define ID_WRECK_23	12385
#define ID_LONDON_POSTER	12386
#define ID_NEW_YORK	12387
#define ID_MURAL	12388
#define ID_PIDGEONS	12405
#define ID_LEFT_EXIT_26	12390
#define ID_S27_FLOOR	12395
#define ID_RIGHT_EXIT_27	12399
#define ID_CHART1	12401
#define ID_CHART2	12402
#define ID_GAS	12403
#define ID_SCANNER_27	12404
#define ID_BURKE	12407
#define ID_MEDI_COMP	12425
#define ID_CHAIR_27	12417
#define ID_HELMET_COLE	12420
#define ID_BODY	12429
#define ID_ANCHOR	12430
#define ID_ANCHOR_PC	3
#define ID_HOOK	12434
#define ID_STATUE_25	12435
#define ID_LAZER_25	12437
#define ID_SPARK_25	12439
#define ID_TREVOR	12442
#define ID_UP_EXIT_28	12447
#define ID_S20_FLOOR	12452
#define ID_DOWN_EXIT_20	12456
#define ID_REICH_DOOR_20	12459
#define ID_REICH_SLOT	12462
#define ID_S22_FLOOR	12467
#define ID_RIGHT_EXIT_22	12471
#define ID_LAMB_DOOR_20	12474
#define ID_LAMB_SLOT	12477
#define ID_S21_FLOOR	12482
#define ID_LEFT_EXIT_21	12486
#define ID_SHRUB_1	12488
#define ID_SHRUB_2	12489
#define ID_SHRUB_3	12490
#define ID_LAMB_BED	12492
#define ID_LAMB_TV	12493
#define ID_FISH_TANK	12494
#define ID_FISH_POSTER	12495
#define ID_PILLOW	12496
#define ID_MAGAZINE	12501
#define ID_REICH_CHAIR	12505
#define ID_CABINET	12506
#define ID_CERT	12507
#define ID_REICH_PICTURE	12508
#define ID_FISH_FOOD	12509
#define ID_LAMBS_BOOKS	12510
#define ID_LAMBS_CHAIR	12511
#define ID_DISPENSOR	12512
#define ID_CATFOOD	12514
#define ID_VIDEO	12516
#define ID_CASSETTE	12517
#define ID_BIG_PICT1	12524
#define ID_VIDEO_SCREEN	12525
#define ID_BIG_PICT2	12526
#define ID_BIG_PICT3	12527
#define ID_CAT	12534
#define ID_BIO_DOOR	12541
#define ID_SALES_CHART	12545
#define ID_GALLAGER_BEL	12546
#define ID_FAKE_FLOOR_22	12554
#define ID_REICH_WINDOW	12555
#define ID_LAMB_WINDOW	12556
#define ID_FAKE_FLOOR_21	12557
#define ID_INNER_LAMB_DOOR	12558
#define ID_TICKET	12565
#define ID_GLOBE	12568
#define ID_INNER_R_DOOR	12571
#define ID_GLASS_SLOT	12574
#define ID_LIFT_WAIT	42
#define ID_CABLE_7	8204
#define ID_CABLE_29	12588
#define ID_S11_FLOOR	12594
#define ID_CABLE_FALL	12601
#define ID_CABLE_FALL2	12604
#define ID_SMASHED_WINDOW	12605
#define ID_BITS	12607
#define ID_BITS2	12609
#define ID_LOCKER_11	12613
#define ID_SPY_11	12612
#define ID_SLOT_11	12616
#define ID_SOCCER_1	12620
#define ID_SOCCER_2	12621
#define ID_SOCCER_3	12622
#define ID_SOCCER_4	12623
#define ID_SOCCER_5	12624
#define ID_SLAT_1	12626
#define ID_SLAT_2	12627
#define ID_SLAT_3	12628
#define ID_SLAT_4	12629
#define ID_SLAT_5	12630
#define ID_RIGHT_EXIT_11	12631
#define ID_S10_FLOOR	12636
#define ID_LEFT_EXIT_10	12641
#define ID_LIFT_10	12642
#define ID_LIFT_SLOT_10	12644
#define ID_SCANNER_10	12647
#define ID_POD	12648
#define ID_LINC_10	12651
#define ID_POD_LIGHT	12652
#define ID_MONITOR_10	12657
#define ID_LIYT_1	12659
#define ID_LIYT_2	12661
#define ID_LIYT_3	12663
#define ID_LIYT_4	12665
#define ID_LITEBANK	12667
#define ID_TERMINAL_10	12670
#define ID_FAKE_FLOOR_9	8536
#define ID_FAKE_FLOOR_10	12672
#define ID_LINC_S9	8543
#define ID_SMALL_23	12676
#define ID_SMALL_R_29	12677
#define ID_SMALL_L_29	12678
#define ID_SMALL_R_28	12679
#define ID_SMALL_L_28	12680
#define ID_SMALL_19	12681
#define ID_S29_SML_FLOOR	12682
#define ID_S28_SML_FLOOR	12686
#define ID_LIFT_28	12694
#define ID_SLOT_28	12697
#define ID_COPTER	8209
#define ID_SC48_SOCKET	16815
#define ID_SC48_HOLE	16816
#define ID_SC48_EYES	16817
#define ID_SC48_LIGHT_PAL	16820
#define ID_SC42_JUDGE	16821
#define ID_SC42_CLERK	16822
#define ID_SC42_PROSECUTION	16823
#define ID_SC42_JOBSWORTH	16824
#define ID_SC42_SIGN	16849
#define ID_DOG_BARK_THING	16855
#define ID_SC41_HEAT_1	16856
#define ID_SC41_HEAT_2	16857
#define ID_SC41_HEAT_3	16858
#define ID_FIRE1	4360
#define ID_FIRE2	4362
#define ID_CAR_UP	4364
#define ID_CAR_DOWN	4366
#define C_LOGIC	0
#define C_STATUS	2
#define C_SYNC	4
#define C_SCREEN	6
#define C_PLACE	8
#define C_GET_TO_TABLE	10
#define C_XCOOD	14
#define C_YCOOD	16
#define C_FRAME	18
#define C_CURSOR_TEXT	20
#define C_MOUSE_ON	22
#define C_MOUSE_OFF	24
#define C_MOUSE_CLICK	26
#define C_MOUSE_REL_X	28
#define C_MOUSE_REL_Y	30
#define C_MOUSE_SIZE_X	32
#define C_MOUSE_SIZE_Y	34
#define C_ACTION_SCRIPT	36
#define C_UP_FLAG	38
#define C_DOWN_FLAG	40
#define C_GET_TO_FLAG	42
#define C_FLAG	44
#define C_MOOD	46
#define C_GRAFIX_PROG	48
#define C_OFFSET	52
#define C_MODE	54
#define C_BASE_SUB	56
#define C_ACTION_SUB	60
#define C_GET_TO_SUB	64
#define C_EXTRA_SUB	68
#define C_DIR	72
#define C_STOP_SCRIPT	74
#define C_MINI_BUMP	76
#define C_LEAVING	78
#define C_AT_WATCH	80
#define C_AT_WAS	82
#define C_ALT	84
#define C_REQUEST	86

//system flags
#define SF_TIMER	(1 << 0)	// set if timer interrupt redirected
#define SF_GRAPHICS	(1 << 1)	// set if screen is in graphics mode
#define SF_MOUSE	(1 << 2)	// set if mouse handler installed
#define SF_KEYBOARD	(1 << 3)	// set if keyboard interrupt redirected
#define SF_MUSIC_BOARD	(1 << 4)	// set if a music board detected
#define SF_ROLAND	(1 << 5)	// set if roland board present
#define SF_ADLIB	(1 << 6)	// set if adlib board present
#define SF_SBLASTER	(1 << 7)	// set if sblaster present
#define SF_TANDY	(1 << 8)	// set if tandy present
#define SF_MUSIC_BIN	(1 << 9)	// set if music driver is loaded
#define SF_PLUS_FX	(1 << 10)	// set if extra fx module needed
#define SF_FX_OFF	(1 << 11)	// set if fx disabled
#define SF_MUS_OFF	(1 << 12)	// set if music disabled
#define SF_TIMER_TICK	(1 << 13)	// set every timer interupt

// Status flags
#define SF_CHOOSING	(1 << 14)	// set when choosing text
#define SF_NO_SCROLL	(1 << 15)	// when set don't scroll
#define SF_SPEED	(1 << 16)	// when set allow speed options
#define SF_GAME_RESTORED	(1 << 17)	// set when game restored or restarted
#define SF_REPLAY_RST	(1 << 18)	// set when loading restart data (used to stop rewriting of replay file)
#define SF_SPEECH_FILE	(1 << 19)	// set when loading speech file
#define SF_VOC_PLAYING	(1 << 20)	// set when a voc file is playing
#define SF_PLAY_VOCS	(1 << 21)	// set when we want speech instead of text
#define SF_CRIT_ERR	(1 << 22)	// set when critical error routine trapped
#define SF_ALLOW_SPEECH	(1 << 23)	// speech allowes on cd sblaster version
#define SF_ALLOW_TEXT	(1 << 24)	// text allowed on cd sblaster version
#define SF_ALLOW_QUICK	(1 << 25)	// when set allow speed playing
#define SF_TEST_DISK	(1 << 26)	// set when loading files
#define SF_MOUSE_LOCKED	(1 << 27)	// set if coordinates are locked

// Mouse flags
#define MF_NO_UPDATE	(1 << 0)	// set to disable mouse updating
#define MF_IN_INT	(1 << 1)	// set when in mouse interrupt
#define MF_SAVED	(1 << 2)	// set when saved data is valid
#define MF_GOT_INT	(1 << 3)	// set when mouse interrupt received

#define MOUSE_NORMAL	1	// normal mouse
#define MOUSE_DISK		2	// disk mouse
#define MOUSE_DOWN		3
#define MOUSE_RIGHT		4	// right pointer
#define MOUSE_LEFT		5	// left pointer
#define MOUSE_BLANK		6	// blank mouse
#define MOUSE_CROSS		7	// angry mouse
#define MOUSE_UP		8	// mouse up

#define TEXT_MOUSE_WIDTH 0x80

} // End of namespace Sky

#endif
