#!/usr/bin/env python
"""   
  @file: InfoFriend.py  
  File is a part of Scribo Project  
  Module implements friend window from UI
  @author: Zaiceva Diana <zaiceva@cs.karelia.ru>
  @date: 05.08.2010
"""

__author__ = "Diana Zaiceva <zaiceva@cs.karelia.ru>"
__version__ = "$Revision: 0.3 $"
__date__ = "$Date: 2010/08/05 $"
__copyright__ = ""
__license__ = "GPLv2"


import sys

from PyQt4 import QtCore
from PyQt4 import QtGui

from ldm.Profile import main_prof
from ldm.Account import *
from HomePage import *

class InfoFriend(HomePage):
    """
    home window for UI
    @version  1.0   
    @author  Zaiceva Diana <zaiceva@cs.karelia.ru>   
    """
    def __init__(self,friend,parent=None):
        """
        Initialization for HomeWindow   
        @param parent (widget) 
        @return 
        """
        self.friend = friend
        super(InfoFriend, self).__init__(friend, parent)
        #self.show()        
    
    def create_list_acc(self, def_acc = None):
        '''        
        create combobox with list of accounts
        @param def_acc - default account
        @return acc_combo
        '''
        return None        

    def create_push_button_group(self):
        """                                                                                                                                                 
        draw buttons from main window                                                                                                                       
        @param                                                                                                                                              
        @return                                                                                                                                             
        """
        my_post_button = QtGui.QPushButton(self.tr("Posts"), self.centr_widg)
        friends_list_btn = QtGui.QPushButton(self.tr("Friends"), self.centr_widg)

        my_post_button.setIcon(QtGui.QIcon("../data/en/my_posts.png"))
        friends_list_btn.setIcon(QtGui.QIcon("../data/en/friends.png"))
        friends_list_btn.setDisabled(True)

        hbox = QtGui.QHBoxLayout()
        hbox.addWidget(my_post_button)
        hbox.addWidget(friends_list_btn)


        self.connect(my_post_button, QtCore.SIGNAL("clicked()"),
                     self.list_my_posts)

        #self.connect(friends_list_btn, QtCore.SIGNAL("clicked()"),
        #             self.list_friends)
        return hbox

    def list_my_posts(self):
        """                                                                                                                                                 
        handler for clicked "my_posts"                                                                                                                      
        @param                                                                                                                                              
        @return                                                                                                                                             
        """
        from ListMyPosts import ListMyPosts
        widg = ListMyPosts(self, self.friend)
