#!/usr/bin/env python
"""   
 @file: MainWindow.py  
  File is a part of Scribo Project  
  Module implements main window from UI
  @author: Zaiceva Diana <zaiceva@cs.karelia.ru>
  @date: 23.06.2010
"""

__author__ = "Diana Zaiceva <zaiceva@cs.karelia.ru>"
__version__ = "$Revision: 0.2 $"
__date__ = "$Date: 2010/06/23 $"
__copyright__ = ""
__license__ = "GPLv2"


import sys
from PyQt4 import QtCore
from PyQt4 import QtGui
from ldm.Profile import main_prof
from ldm.Account import *
from services.LivejAccount import LivejAccount

OUR_JOURNAL = "scribo_journal"

class MainWindow(QtGui.QMainWindow):
    """
    main class for all windows
    @version  1.0   
    @author  Zaiceva Diana <zaiceva@cs.karelia.ru>   
    """
    def __init__(self, parent=None):
        """
        Initialization for MainWindow   
        @param parent (widget), start (string) 
        @return 
        """
        QtGui.QMainWindow.__init__(self, parent)
        from ConfigDriver import config
        font = QtGui.QFont()
        str_font = None
        try:
            str_font = config.get('UI', 'font')
        except:
            config.set('UI', 'font', None)
        if str_font:
            ok = font.fromString(str_font)
            if font and ok:
                self.setFont(font)
        self.setWindowTitle(QtCore.QCoreApplication.translate("MainWindow","Scribo"))
        self.setMinimumSize(160, 160)
        self.resize(480, 340)

        try:
            self.setAttribute(QtCore.Qt.WA_Maemo5StackedWindow)
        except AttributeError:
            print "no stacked attribute"
        
        self.parent = parent
        self.new_act = QtGui.QAction(QtCore.QCoreApplication.translate("MainWindow","&New Account"), self)
        self.manage_act = QtGui.QAction(QtCore.QCoreApplication.translate("MainWindow","&Edit Accounts"), self)
        self.create_actions_menu()
        self.create_menus()
        

    def new_profile(self):
        """
        change window on "add profile"
        @param 
        @return
        """
        from AddProfile import AddProfileWindow
        add_widg = AddProfileWindow(self)
        

    def manage_profile(self):
        """
        change window on "manage profile"
        @param 
        @return
        """
        from AddProfile import AddProfileWindow
        add_widg = AddProfileWindow(self, default=main_prof.def_account)

    def draft(self):
        """
        change window on "manage profile"
        @param 
        @return
        """
        self.dial = QtGui.QMessageBox()
        self.dial.setWindowTitle(QtCore.QCoreApplication.translate("MainWindow","Draft"))
        self.list_drafts = self.view_list_drafts()
        vbox = QtGui.QVBoxLayout()
        but_box = QtGui.QDialogButtonBox()
        but_box.setOrientation(QtCore.Qt.Horizontal)
        
        self.dial.setWindowTitle(QtCore.QCoreApplication.translate("MainWindow","Drafts"))
        self.dial.setOrientation(QtCore.Qt.Horizontal)

        self.send_button = but_box.addButton(QtCore.QCoreApplication.translate("MainWindow","Send"),
                                     QtGui.QDialogButtonBox.ActionRole)
        self.edit_button = but_box.addButton(QtCore.QCoreApplication.translate("MainWindow","Edit"),
                                       QtGui.QDialogButtonBox.ActionRole)
        self.remove_button = but_box.addButton(QtCore.QCoreApplication.translate("MainWindow","Delete"),
                                       QtGui.QDialogButtonBox.ActionRole)
       
        cancel_button = self.dial.addButton(QtGui.QMessageBox.Abort)
        cancel_button.hide()
        but_box.adjustSize()
        self.list_drafts.adjustSize()        
        vbox.addWidget(self.list_drafts)
        vbox.addWidget(but_box,3, QtCore.Qt.AlignCenter)
        self.dial.layout().addLayout(vbox, 0, 0, -1, -1, QtCore.Qt.AlignCenter)      
        #self.dial.layout().addWidget(but_box, 10, 0, 1, 3, QtCore.Qt.AlignCenter)
        self.dial.layout().setRowMinimumHeight(0,300)        

        self.connect(but_box, QtCore.SIGNAL("clicked(QAbstractButton *)"), self.draft_click)
        self.dial.exec_()
        if self.dial.clickedButton() == QtGui.QMessageBox.Abort:
            pass
        else:
            return

    def view_list_drafts(self):
        """
        QListWidget with list of drafts
        """
        from ldm.Draft import get_drafts
        self.drafts = get_drafts()
        list_widget = QtGui.QListWidget()
        list_widget.setResizeMode(QtGui.QListView.Adjust)
        list_widget.setSelectionMode(QtGui.QAbstractItemView.SingleSelection)
        index = 0    
        for mes in self.drafts:
            date = mes.date
            if date:
                import time
                datetime = time.strptime(date, "%Y-%m-%d %H:%M:%S")
                date = time.strftime("%a, %d %b %Y %H:%M", datetime)
            else:
               date = ""
            if not mes.title:
                title = unicode(QtCore.QCoreApplication.translate("MainWindow","no subject"))
            else:
                title = unicode(mes.title)
            text = date.decode('utf8') + "  " + title

            author = mes.poster
            icon = ""
            if author:
               text = text + "  (" + author.username + ")"
               icon = author.get_icon()
               if not icon:
                   icon = ""
            new_item = QtGui.QListWidgetItem(QtGui.QIcon(QtCore.QString(icon)),
                                             text,
                                             list_widget)
            new_item.setData(1, QtCore.QVariant(index))
            index = index + 1
            del text
            del title
            del date
        
        return list_widget


    def draft_click(self, button):
        """                                                                                                                                      
        dialog adding html in the text                                                                                                             
        """
        list = self.list_drafts.selectedItems()
        if list or not list == []:
            index = list[0].data(1).toString().toInt()[0]
            mes = self.drafts[index]
        else:
            self.dial.reject()
            if self.drafts == []:
                QtGui.QMessageBox.information(self, QtCore.QCoreApplication.translate("MainWindow","Scribo"),
                               QtCore.QCoreApplication.translate("MainWindow","List of drafts is empty!"),
                               QtGui.QMessageBox.Yes)
            else:
                QtGui.QMessageBox.information(self, QtCore.QCoreApplication.translate("MainWindow","Scribo"),
                               QtCore.QCoreApplication.translate("MainWindow","Please, choose messages!"),
                               QtGui.QMessageBox.Yes)
            return
        if button == self.send_button:
            from RepeatPost import RepeatPost
            send_window = RepeatPost(self,mes)
        elif button == self.edit_button:
            from AddPost import AddPostWindow
            add_window = AddPostWindow(self, mes)
        elif button == self.remove_button:
             mes.del_msg_tree()            
             self.list_drafts.removeItemWidget(list[0])
             list[0].setHidden(True)
             list[0].setSelected(False)

        else:
                return
        if not button == self.remove_button:
            self.dial.reject()

    

    def about(self):
        """  
        page with info about application
        @param 
        @return
        """
        from About import __version__ as ver
        self.dial_about = QtGui.QMessageBox(self)
        self.dial_about.setWindowTitle(QtCore.QCoreApplication.translate("MainWindow","About Scribo"))
        self.dial_about.setIcon(QtGui.QMessageBox.Information)
        
        label_about =  QtGui.QLabel(QtCore.QCoreApplication.translate("MainWindow","A mobile multiblog client."\
                                        " \n Version: " + ver+
                                        "\n More information you can get from README file.\n"))  
        #label_about.setBackgroundRole(QtGui.QPalette.AlternateBase)  
        #label_about.setForegroundRole(QtGui.QPalette.Text)
                                   
        label_friend = QtGui.QLabel(QtCore.QCoreApplication.translate("MainWindow","You can add us to your friends to leave your feedback"))
        self.push_fr = QtGui.QPushButton(QtCore.QCoreApplication.translate("MainWindow","Add friend"), self.dial_about)
        self.push_fr.setMinimumWidth(350)
        self.connect(self.push_fr, QtCore.SIGNAL("clicked()"), self.add_us_friend)
        self.dial_about.layout().addWidget(label_about, 0, 0, 1, 2, QtCore.Qt.AlignLeft) 
        self.dial_about.layout().addWidget(label_friend, 1, 0, 1, 2, QtCore.Qt.AlignLeft)  
        self.dial_about.layout().addWidget(self.push_fr, 2, 0, QtCore.Qt.AlignLeft)
        
                                        
        cancel_button = self.dial_about.addButton(QtGui.QMessageBox.Abort)
        cancel_button.hide()
         
        self.dial_about.exec_()
        if self.dial_about.clickedButton() == cancel_button:
            return

    def add_us_friend(self):
        flag_add_us_fr = False
        for acc in main_prof.accounts:
            if type(acc) == LivejAccount:
                friend_acc = Account.register(LivejAccount, OUR_JOURNAL)
                acc.add_friend(friend_acc)
                flag_add_us_fr = True
                break
        if flag_add_us_fr:
             QtGui.QMessageBox.information(self,
                              QtCore.QCoreApplication.translate("MainWindow","Scribo"),
                              QtCore.QCoreApplication.translate("MainWindow","Friend is added"),
                              QtGui.QMessageBox.Ok)
             self.push_fr.setDisabled(True)
        else:
             QtGui.QMessageBox.warning(self,
                              QtCore.QCoreApplication.translate("MainWindow","Scribo"),
                              QtCore.QCoreApplication.translate("MainWindow","We wasn't added to the friend. May be, we\
                              don't have LiveJournal account, then you can adds it."),
                              QtGui.QMessageBox.Ok)
             
 
    def show_warning(self, exc):
        """  
        error message
        @param exc - exception
        @return
        """
        print type(exc)
        QtGui.QMessageBox.warning(self,
                                  QtCore.QCoreApplication.translate("MainWindow","Scribo"),
                                  exc.to_html(),
                                  QtGui.QMessageBox.Ok)
    def settings_change(self):
        """  
        page with info about application
        @param 
        @return
        """
        self.dial_set = QtGui.QMessageBox()
        self.dial_set.setWindowTitle(QtCore.QCoreApplication.translate("MainWindow","Settings"))
        
        from ConfigDriver import config
        proxy = config.get('Main', 'proxy')
        
        self.check_proxy = QtGui.QCheckBox(QtCore.QCoreApplication.translate("MainWindow","Use proxy connections"), self.dial_set)
        self.check_proxy.adjustSize()
        self.check_proxy.setMinimumWidth(350)
        self.connect(self.check_proxy, QtCore.SIGNAL("stateChanged (int)"), self.change_set_proxy)
      
        label_proxy = QtGui.QLabel(QtCore.QCoreApplication.translate("MainWindow","Proxy: "))
        label_port = QtGui.QLabel(QtCore.QCoreApplication.translate("MainWindow","Port: "))
        label_font = QtGui.QLabel(QtCore.QCoreApplication.translate("MainWindow","Font: "))
        
        self.edit_font = QtGui.QLineEdit()
        self.edit_font.setMinimumWidth(500)
        self.font = config.get('UI', 'font')
        if self.font:
            font = QtGui.QFont()
            ok = font.fromString(self.font)
            if ok:
                self.edit_font.setText(self.parse_font(font))
        self.push_font = QtGui.QPushButton(QtCore.QCoreApplication.translate("MainWindow","Choose font"), self.dial_set)
               
        self.edit_proxy = QtGui.QLineEdit()
        self.edit_proxy.setMinimumWidth(350)
        
        self.edit_port = QtGui.QLineEdit()
        self.edit_port.setMinimumWidth(350)
        self.edit_port.setValidator(QtGui.QRegExpValidator(QtCore.QRegExp("^[1-9]{1,5}$"),self))
        self.edit_proxy.setDisabled(True)
        self.edit_port.setDisabled(True)
        self.edit_font.setDisabled(True)
        
        if proxy:
            self.check_proxy.setCheckState(QtCore.Qt.Checked)
            list_proxy = QtCore.QString(proxy).split(":")
            self.edit_proxy.setDisabled(False)
            self.edit_port.setDisabled(False)
            self.edit_proxy.setText(list_proxy[0])
            self.edit_port.setText(list_proxy[1])
            
            
        self.dial_set.layout().addWidget(self.check_proxy, 0, 0, 1, 2, QtCore.Qt.AlignLeft)  
        self.dial_set.layout().addWidget(label_proxy, 1 ,0, QtCore.Qt.AlignLeft)
        self.dial_set.layout().addWidget(self.edit_proxy, 1 ,1, 1, 2, QtCore.Qt.AlignLeft)
        self.dial_set.layout().addWidget(label_port, 2 ,0, QtCore.Qt.AlignLeft)
        self.dial_set.layout().addWidget(self.edit_port, 2 ,1 ,1 ,2, QtCore.Qt.AlignLeft)
        self.dial_set.layout().addWidget(label_font, 3 ,0 , QtCore.Qt.AlignLeft)
        self.dial_set.layout().addWidget(self.push_font, 3 ,1 , QtCore.Qt.AlignLeft)
        self.dial_set.layout().addWidget(self.edit_font, 4 ,0 ,1 ,2, QtCore.Qt.AlignLeft)
        
        self.connect(self.push_font, QtCore.SIGNAL("clicked()"),
                     self.choose_font)
       
        cancel_button = self.dial_set.addButton(QtGui.QMessageBox.Abort)
        ok_button = self.dial_set.addButton(QtGui.QMessageBox.Ok)
        cancel_button.hide()
         
        self.dial_set.exec_()
        if self.dial_set.clickedButton() == cancel_button:
            pass
        elif self.dial_set.clickedButton() == ok_button:
             self.save_settings() 
        else:
            return
            
    def save_settings(self):
        proxy = self.edit_proxy.text()
        port = self.edit_port.text()
        from ConfigDriver import config
        if self.check_proxy.checkState() == QtCore.Qt.Unchecked:
            try:
                config.set('Main', 'proxy', None)
            except WarningExc, e:
                self.show_warning(e)
        else:
            try:
                config.set('Main', 'proxy', str(proxy+":"+port))
            except WarningExc, e:
                self.show_warning(e)
        if self.font:
            try:
                config.set('UI', 'font', str(self.font))
            except WarningExc, e:
                self.show_warning(e)            
   
    def choose_font(self):
        font, ok = QtGui.QFontDialog.getFont(QtGui.QFont("Helvetica [Cronyx]", 10), self.dial_set)
        if ok:
            self.font = font.toString()
            self.edit_font.setText(self.parse_font(font))
            
    def parse_font(self, font):
        family = font.family()
        bold = font.bold()
        italic = font.italic()
        overline = font.overline()
        point_size = font.pointSize()
        pixel_size = font.pixelSize()
        style = font.style()
        disp_font = family
        if bold:
            disp_font+= ", bold"
        if italic:
            disp_font+= ", italic"
        if overline:
            disp_font+= ", overline"
        if point_size <> -1:
            disp_font+= ", " + str(point_size)
        elif pixel_size <> -1:
            disp_font+= ", "+ str(pixel_size)
        if style == QtGui.QFont.StyleNormal:
            disp_font+= ", style - normal"
        elif style == QtGui.QFont.StyleItalic:
            disp_font += ", style - italic"
        elif style == QtGui.QFont.StyleOblique:
            disp_font += ", style - oblique"
        return disp_font
            

        
    def change_set_proxy(self, state):
        if state == QtCore.Qt.Unchecked:
            self.edit_proxy.setDisabled(True)
            self.edit_port.setDisabled(True)
        else:
            self.edit_proxy.setDisabled(False)
            self.edit_port.setDisabled(False)
        


    def create_actions_menu(self):
        """
        create submenu
        @param
        @return
        """
        self.new_act.setShortcut(QtCore.QCoreApplication.translate("MainWindow","Ctrl+N"))
        self.connect(self.new_act, QtCore.SIGNAL("triggered()"),
                     self.new_profile)

        self.connect(self.manage_act, QtCore.SIGNAL("triggered()"),
                     self.manage_profile)

        self.exit_act = QtGui.QAction(QtCore.QCoreApplication.translate("MainWindow","E&xit"), self)
        self.exit_act.setShortcut(QtCore.QCoreApplication.translate("MainWindow","Ctrl+Q"))
        self.connect(self.exit_act, QtCore.SIGNAL("triggered()"), self.quit_app)

        bold_font = self.exit_act.font()
        bold_font.setBold(True)
        self.exit_act.setFont(bold_font)

        self.about_act = QtGui.QAction(QtCore.QCoreApplication.translate("MainWindow","About"), self)
        self.connect(self.about_act, QtCore.SIGNAL("triggered()"), self.about)
        
        self.settings_act = QtGui.QAction(QtCore.QCoreApplication.translate("MainWindow","Settings"), self)
        self.connect(self.settings_act, QtCore.SIGNAL("triggered()"), self.settings_change)

        self.draft_act = QtGui.QAction(QtCore.QCoreApplication.translate("MainWindow","Drafts"), self)
        self.connect(self.draft_act, QtCore.SIGNAL("triggered()"), self.draft)


    def create_menus(self):
        """
        create menu
        @param
        @return
        """
        self.main_menu = self.menuBar().addMenu(QtCore.QCoreApplication.translate("MainWindow","Menu"))
        self.main_menu.addAction(self.new_act)
        self.main_menu.addAction(self.manage_act)
        self.main_menu.addAction(self.draft_act)
        self.main_menu.addAction(self.settings_act)
        self.main_menu.addAction(self.about_act)
        self.main_menu.addSeparator()
        self.main_menu.addAction(self.exit_act)



    def closeEvent(self, event):
        """
        handler for clicked "back" 
        @param
        @return
        """
        event.accept()
        if self.parent:
            self.parent.show()
        else:
            ret = QtGui.QMessageBox.question(self, QtCore.QCoreApplication.translate("MainWindow","Scribo"),
                                             QtCore.QCoreApplication.translate("MainWindow","Do you really want to quit?"),
                                             QtGui.QMessageBox.Yes, QtGui.QMessageBox.No)
            if (ret == QtGui.QMessageBox.No):
                event.ignore()
                return
                
    def quit_app(self):
        """
        handler for clicked "back" 
        @param
        @return
        """
        ret = QtGui.QMessageBox.question(self, QtCore.QCoreApplication.translate("MainWindow","Scribo"),
                                         QtCore.QCoreApplication.translate("MainWindow","Do you really want to quit?"),
                                         QtGui.QMessageBox.Yes, QtGui.QMessageBox.No)
        if (ret == QtGui.QMessageBox.No):
             return
        else:
            QtGui.qApp.quit()

    def home_window(self):
        """
        handler for clicked "home"
        @param
        @return
        """
        parent = self.parent
        child = self
        del_window = []
        while parent<>None:
            del_window.append(child)
            child = parent
            parent = parent.parent
            
        for window in del_window:
            window.close()
	child.show()
	return child
	
    def reload_home_window(self):
        """
        reload home window (if profile is changed)
        @param
        @return
        """
        self = self.home_window()
        if not main_prof.accounts:
           from StartPage import StartPage
           self.parent = StartPage()
        else:
            from HomePage import HomePage
	    home_page = HomePage(main_prof.def_account)
            self.parent = home_page 
        self = self.home_window()
        
main_window = MainWindow()


