#!/usr/bin/env python
"""
 @file: ListFriends.py
  File is a part of Scribo Project
  Module implements viewing list of friends from UI
  @author: Zaiceva Diana <zaiceva@cs.karelia.ru>
  @date: 05.08.2010
"""


from PyQt4 import QtCore
from PyQt4 import QtGui
from ldm.Profile import main_prof
from ToolbarWindow import ToolbarWindow
from MainWindow import *
__author__ = "Diana Zaiceva <zaiceva@cs.karelia.ru>"
__version__ = "$Revision: 0.3 $"
__date__ = "$Date: 2010/05/08 $"
__copyright__ = ""
__license__ = "GPLv2"

class ListFriends(MainWindow):
    """
    class for draw list of friends window
    @version  1.0
    @author  Zaiceva Diana <zaiceva@cs.karelia.ru>
    """
    def __init__(self, parent):
        """ 
        initialization "friends" window
        @return
        """
        super(ListFriends,self).__init__(parent)
        self.centr_widg = QtGui.QWidget(self)
        self.create_actions()
        self.parent = parent
        toolbar = self.create_toolbar()
        self.hbox = QtGui.QHBoxLayout()
        self.friends_list = self.get_list_friends()
        self.hbox.addWidget(toolbar)
        self.hbox.addSpacing(10)
        self.hbox.addWidget(self.friends_list)
        self.centr_widg.setLayout(self.hbox)
        self.setCentralWidget(self.centr_widg)
        self.show()

    def get_list_friends(self):
        """
        fill list of friends
        @param
        @return
        """
        list_widget = QtGui.QListWidget(self.centr_widg)
        self.list = self.get_friends()
        index = 0

        if len(self.list) == 0:
            from ConfigDriver import config
            c = config.get_bool('UI', 'warning_press_refresh')
            if not c:
                msg = QtGui.QMessageBox()
                msg.setWindowTitle(self.tr("Refresh message"))
                show_button = QtGui.QCheckBox(self.tr("Don't show this message again"), msg)
                title_label = QtGui.QLabel(self.tr("Press \"Refresh\" to update list"), msg)
                msg.layout().addWidget(title_label, 0, 0)
                msg.layout().addWidget(show_button, 1, 0)
                cancel_button = msg.addButton(QtGui.QMessageBox.Close)
                msg.exec_()

                if msg.clickedButton() == cancel_button:
                    if show_button.isChecked():
                        config.set('UI', 'warning_press_refresh', True)

        for item in self.list:
            #print item
            #print self.whom_friend[index]
            login = item.username
            login_acc = self.whom_friend[index].username
            if item.nick:
                login = unicode(item.nick)+ " - " + login
            friend_str = QtCore.QString(" (friend of "+login_acc+")")
            icon = item.path_to_ava
            if not icon:
                icon = ""
            
            new_item = QtGui.QListWidgetItem(QtGui.QIcon(QtCore.QString(icon)),
                                             login + friend_str,
                                             list_widget)
            new_item.setData(QtCore.Qt.UserRole, QtCore.QVariant(index))
            index = index + 1
            del login
        self.connect(list_widget, QtCore.SIGNAL("itemDoubleClicked(QListWidgetItem*)"),
                     self.view_info_friend)
        list_widget.sortItems(QtCore.Qt.AscendingOrder)
        return list_widget

    def create_toolbar(self):
        """
        create toolbar for list of posts window
        @return
        """
        file_tool_bar = ToolbarWindow(parent=self.centr_widg)
        file_tool_bar.addWidget(self.refresh_act)
        file_tool_bar.addWidget(self.del_act)
        self.connect(file_tool_bar.home_act, QtCore.SIGNAL("clicked()"),
                             self.home_window)
        return file_tool_bar


    def create_actions(self):
        """
        create buttons for toolbar
        @return
        """
        self.refresh_act = QtGui.QToolButton(self.centr_widg)
        self.refresh_act.setIcon(QtGui.QIcon("../data/en/refresh.png"))
        self.refresh_act.setText(self.tr("Refresh"))
        self.refresh_act.setToolButtonStyle(QtCore.Qt.ToolButtonTextUnderIcon)
        self.refresh_act.setSizePolicy(QtGui.QSizePolicy.Expanding, QtGui.QSizePolicy.Minimum)

        self.connect(self.refresh_act, QtCore.SIGNAL("clicked()"),
                     self.reload_window)

        self.del_act = QtGui.QToolButton(self.centr_widg)
        self.del_act.setIcon(QtGui.QIcon("../data/en/post_delete.png"))
        self.del_act.setText(self.tr("Delete"))
        self.del_act.setToolButtonStyle(QtCore.Qt.ToolButtonTextUnderIcon)
        self.del_act.setSizePolicy(QtGui.QSizePolicy.Expanding, QtGui.QSizePolicy.Minimum)
        self.connect(self.del_act, QtCore.SIGNAL("clicked()"),
                     self.delete_friend)


    def view_info_friend(self, item):
        """        
        view choosing post
        @param
        @return       
        """
        index = item.data(QtCore.Qt.UserRole).toString().toInt()[0]
        friend = self.list[index]
        view_widg = InfoFriend(friend, self)
        

    def delete_friend(self):
        """        
        delete choosing post
        @param
        @return       
        """
        ret = QtGui.QMessageBox.information(self, self.tr("Scribo"),
                               self.tr("Do you really want to delete friend?"),
                               QtGui.QMessageBox.Yes,
                               QtGui.QMessageBox.No)
        if (ret == QtGui.QMessageBox.No):
            return
        list = self.friends_list.selectedItems()
        if list:
            for item in list:
                index = item.data(QtCore.Qt.UserRole).toString().toInt()[0]
                friend = self.list[index]
                acc_whom_friend = self.whom_friend[index]
                
                try:
                    acc_whom_friend.remove_friend(friend)
                except WarningExc, exc:
                    try:
                         self.refresh_list()
                    except WarningExc, ex:
                        super(ListMyPosts, self).show_warning(ex)
                        return
                    else:
                        main_window.show_warning(exc)
                else:
                    self.friends_list.removeItemWidget(item)
                    item.setHidden(True)
                    item.setSelected(False)

        else:
            QtGui.QMessageBox.information(self, self.tr("Scribo"),
                               self.tr("Please, choose friends to delete!"),
                               QtGui.QMessageBox.Yes)

    def reload_window(self):
        """
        refresh list of posts 
        @param          
        @return
        """
        self.progress = MyProgress(self)
        self.refresh_list()
        self.progress.close()

    def end_refresh(self):
        """
        update list messages from database
        """
        self.hbox.removeWidget(self.friends_list)
        self.friends_list.deleteLater()
        self.friends_list = self.get_list_friends()
        self.hbox.addWidget(self.friends_list)

    def callback(self):
        """
        update toolbar
        """
        self.progress.setValue(100 * (self.progress.value_progress / (self.progress.value_progress + 4.5)))
        self.progress.value_progress = self.progress.value_progress + 1.1
        QtCore.QCoreApplication.processEvents()
        

    def refresh_list(self):
        """
        update list of messages from network
        """
        list_acc = main_prof.accounts
        for acc in list_acc:
            try:
                acc.refresh_friends_list(self.callback)
            except WarningExc, exc:
                main_window.show_warning(exc)


    def get_friends(self):
        """
        getting all messages
        """
        getting_friends = []
        self.whom_friend = []
        list_acc = main_prof.accounts
        for acc in list_acc:
            try:
                list_fr_acc = acc.get_friends()
            except WarningExc, exc:
                main_window.show_warning(exc)
            else:
                getting_friends.extend(list_fr_acc)
                element = [acc]
                self.whom_friend.extend(element*len(list_fr_acc))
        return getting_friends

class MyProgress(QtGui.QProgressDialog):
    """
    class with common ProgressBar
    """
    def __init__(self, parent):
        """
        initialization ProgressBar
        """
        QtGui.QProgressDialog.__init__(self, parent)
        self.setLabelText(self.tr("Operation is in progress."))
        self.setCancelButtonText(self.tr("Cancel"))
        self.parent = parent
        self.setWindowTitle(self.tr("Receiving data..."))
        self.setWindowModality(QtCore.Qt.WindowModal)
        self.value_progress = 1.1
        self.setValue(self.value_progress)
        self.forceShow()
        
    def closeEvent(self, event):
        """
        closing progressbar
        """
        self.setValue(self.maximum())
        event.accept()
        self.parent.end_refresh()

#from HomePage import *
from InfoFriend import *
