#!/usr/bin/env python
# -*- coding: utf-8 -*-

"""
===============================================================
Class with test method for Account module
===============================================================
"""

import unittest
import sys
sys.path.append("..")

from ldm.Account import Account
from ldm.Profile import Profile
from FakeAccount import FakeAccount
from ldm.Message import Message
from ScriboExc import WarningExc


__author__ = "Mezhenin Artoym <mezhenin@cs.karelia.ru>"
__version__ = "$Revision: 1 $"
__date__ = "$Date: 2010/02/09 $"
__copyright__ = ""
__license__ = "GPLv2"



class AccountTest(unittest.TestCase):
    """
    Class with test method for Account module. Account is interface-class so we
    have to use FakeAccount to test methods in Account 
    """

    def setUp(self):
        """
        Init variables for test methods
        """

        self.acc = Account.register(FakeAccount, "test")
        self.str_list = [u'ololo',
                         None,
                         u'1"; DROP TABLE Messages;',
                         u"1'; DROP TABLE Messages;"
                         u'Hello World!',
                         u'русский текст',
                         u'외국인 텍스트',
                         u'النص الأجنبي',
                         u'étrangers texte',
                         u'90k_text ' * 10000,
                         u''
                        ]

        self.date_list = [
                          '0000-00-00 00:00:00',
                          None,
                          '1234:12:12 09:09:09',
                          '2010-02-07 16:44:30'
                         ]

        self.int_list = [0, 1, 7, 11111, 2732924]

    '''
    def test_service_id(self):
        """
        test for Account.service_id
        assigning strings
        """

        for i in self.str_list:
            try:
                acc.service_id = i
            except AttributeError:
                return
            self.fail()
                        

    def test_username(self):
        """
        test for Account.username
        assigning strings
        """

        for i in self.str_list:
            self.assertRaises(AttributeError, self.acc.set_username, i)
    '''

    def test_passwd(self):
        """
        test for Account.passwd
        assigning strings
        """

        for i in self.str_list:
            self.acc.passwd = i
            self.assertEqual(i, self.acc.passwd)


    def test_nick(self):
        """
        test for Account.nick
        assigning strings
        """

        for i in self.str_list:
            self.acc.nick = i
            self.assertEqual(i, self.acc.nick)


    def test_path_to_ava(self):
        """
        test for Account.path_to_ava
        assigning strings
        """

        for i in self.str_list:
            self.acc.path_to_ava = i
            self.assertEqual(i, self.acc.path_to_ava)


    def test_date_of_birth(self):
        """
        test for Account.date_of_birth
        assigning strings
        """

        for i in self.date_list:
            self.acc.date_of_birth = i
            self.assertEqual(i, self.acc.date_of_birth)


    def test_date(self):
        """
        test for Account.date
        assigning strings
        """

        for i in self.date_list:
            self.acc.date = i
            self.assertEqual(i, self.acc.date)


    def test_city(self):
        """
        test for Account.city
        assigning strings
        """

        for i in self.str_list:
            self.acc.city = i
            self.assertEqual(i, self.acc.city)

    def test_read(self):
        """
        test for Account.group
        try to assign diffrent values: correct and not corrent
        """

        self.acc.group = True
        self.assertTrue(self.acc.group)

        self.acc.group = False
        self.assertFalse(self.acc.group)

        self.assertRaises(WarningExc, self.acc.set_group, "string")
        self.assertRaises(WarningExc, self.acc.set_group, 1414)
        self.assertRaises(WarningExc, self.acc.set_group, Message)

        self.assertFalse(self.acc.group)


    def test_prof(self):
        """
        test for Account.prof
        try to assign diffrent values: correct and not corrent 
        """
        self.acc.prof = None
        self.assertEqual(self.acc.prof, None)

        new_prof = Profile()
        self.acc.prof = new_prof
        self.assertEqual(new_prof, self.acc.prof)

        self.assertRaises(WarningExc, self.acc.set_prof, "string")
        self.assertRaises(WarningExc, self.acc.set_prof, 1414)
        self.assertRaises(WarningExc, self.acc.set_prof, True)
        self.assertRaises(WarningExc, self.acc.set_prof, Message)
        self.assertRaises(WarningExc, self.acc.set_prof, FakeAccount)

        self.assertEqual(new_prof, self.acc.prof)


    def test_posts(self):
        """
        test for Account.add_post, Account.get_posts
        """
        self.assertEqual(self.acc.posts, [])
        for _ in xrange(5):
            new_post = Message()
            self.acc.add_post(new_post)

            for _ in xrange(6):
                new_comment = Message()
                new_post.add_comment(new_comment)

        nomsg_list = [
                      None,
                      "OP_string_",
                      555,
                      Account.register(FakeAccount,"ededqsd"),
                      Profile()
                     ]

        for i in nomsg_list:
            self.assertRaises(WarningExc, self.acc.add_post, i)

        self.assertEqual(len(self.acc.posts), 5)
        self.assertEqual(type(self.acc.posts), list)
        self.assertEqual(type(self.acc.posts[0]), Message)

    def test_inbox(self):
        """
        test for Account.add_inbox, Account.get_inbox
        """
        self.assertEqual(self.acc.inbox, [])

        sid = Account.register(FakeAccount,"sid")

        for _ in xrange(5):
            new_inbox = Message()
            new_inbox.poster = sid
            self.acc.add_inbox(new_inbox)

        nomsg_list = [
                      None,
                      "_string_",
                      555,
                      Account.register(FakeAccount,"nsdcsd"),
                      Profile()
                     ]

        for i in nomsg_list:
            self.assertRaises(WarningExc, self.acc.add_inbox, i)

        self.assertEqual(len(self.acc.inbox), 5)
        self.assertEqual(type(self.acc.inbox), list)
        self.assertEqual(type(self.acc.inbox[0]), Message)


    def test_outbox(self):
        """
        test for Account.add_outbox, Account.get_outbox
        """
        self.assertEqual(self.acc.outbox, [])

        nancy = Account.register(FakeAccount,"nancy")

        for _ in xrange(5):
            new_outbox = Message()
            new_outbox.journal = nancy
            self.acc.add_outbox(new_outbox)

        nomsg_list = [
                      None,
                      "_string_",
                      555,
                      Account.register(FakeAccount,"test111"),
                      Profile()
                     ]

        for i in nomsg_list:
            self.assertRaises(WarningExc, self.acc.add_outbox, i)

        self.assertEqual(len(self.acc.outbox), 5)
        self.assertEqual(type(self.acc.outbox), list)
        self.assertEqual(type(self.acc.outbox[0]), Message)


    def test_default(self):
        """
        test for Account.set_default, Account.is_default 
        add 2 accounts to profile and changing default account        
        """

        self.assertRaises(WarningExc, self.acc.set_default)

        new_prof = Profile()
        new_prof.add_account(self.acc)
        self.acc.prof = new_prof

        self.assertFalse(self.acc.is_default())
        self.acc.set_default()
        self.assertTrue(self.acc.is_default())

        acc2 = Account.register(FakeAccount, "swdwfwf")
        new_prof.add_account(acc2)
        self.assertFalse(acc2.is_default())
        acc2.set_default()
        self.assertTrue(acc2.is_default())
        self.assertFalse(self.acc.is_default())

    '''
    def test_del_posts(self):
        """
        test for Account.del_posts
        delete posts from DB and trying to load one Message, then delete posts
        from account witout posts
        """
        self.test_posts()
        id = self.acc.posts[0].id

        self.acc.del_posts()
        self.assertEqual(self.acc.posts, [])

        self.assertRaises(WarningExc, Message, id)

        self.acc.del_posts()
        self.assertEqual(self.acc.posts, [])
    '''

    '''
    def test_del_account(self):
        """
        test for Account.del_account
        delete account from DB and trying to load it, and one of posts
        """
        self.test_posts()

        acc_id = self.acc.id
        id = self.acc.posts[0].id

        self.acc.del_account()
        self.assertEqual(self.acc.posts, [])

        self.assertRaises(WarningExc, Message, id)
        self.assertRaises(WarningExc, Account, acc_id)
    '''

if __name__ == '__main__':
    unittest.main()
