#!/usr/bin/env python

"""
===============================================================
    This file contains functions to show posts of out friends
===============================================================
"""

__author__ = "Mezhenin Artoym <mezhenin@cs.karelia.ru>"
__version__ = "$Revision: 9 $"
__date__ = "$Date: 2010/04/04 $"
__copyright__ = ""
__license__ = "GPLv2"


from ListMyPosts import ListMyPosts
from ldm.Profile import main_prof
from ScriboExc import WarningExc
from PyQt4 import QtGui
from PyQt4 import QtCore

class ListFriendsPosts(ListMyPosts):
    def __init__(self, parent):
        """                                                                                                                                                 
        initialization "list of posts" window                                                                                                               
        @return                                                                                                                                             
        """
        self.parent = parent
        super(ListFriendsPosts, self).__init__(parent)
            
    def refresh_messages(self):
        """
        from parent class, call refreshing friend's posts
        """
        list_acc = main_prof.accounts
        #call refreshing for every user's accounts
        for acc in list_acc:
            try:
                acc.refresh_friends_page(self.callback)
            except WarningExc, exc:
                super(ListMyPosts, self).show_warning(exc)

    def get_messages(self, friend):
        """
        getting frinds posts
        @param friend - in future, for getting friends posts of friend
        @return list posts
        """
        if not self.flag_is_filter:
            return main_prof.get_friends_posts(100)
        else:
            return self.filter_list

    def create_toolbar(self):
        """
        create toolbar for list of posts window
        @return
        """
        file_tool_bar = super(ListFriendsPosts, self).create_toolbar()
        self.refresh_act.setText(self.tr("Refresh"))
        self.del_act.setDisabled(True)
        self.del_act.setText(self.tr("Delete"))
        return file_tool_bar

    def ui_filter_msg(self, field, first_value, second_value = None, filt_list = None, acc_id = None):
        """
        from parent class, call filter_msg without parameter poster
        """
        from ldm.Message import Message
        return Message.filter_msg(field, first_value, second_value, already_found = filt_list)

    def create_combo_filter(self):
        """
        create combo box with all friends
        """
        acc_combo = QtGui.QComboBox()
        list_acc = main_prof.accounts
        self.f_account = []

        for acc in list_acc:
            try:
                list_fr_acc = acc.get_friends()
            except WarningExc, exc:
                main_window.show_warning(exc)
            else:
                # get all friend and for every friend get username and userpick
                self.f_account.extend(list_fr_acc)
                for friend in list_fr_acc:
                    path_ava = friend.path_to_ava
                    if not path_ava:
                        acc_combo.addItem(friend.username)
                    else:
                        acc_combo.addItem(QtGui.QIcon(path_ava), friend.username)
        return acc_combo

    def sort_post_asc(self):
        """                                                                                                                                                 
        handler for clicked "asc" button,
        (virtual method, for calling sort wthout parameters poster)                                                                                       
        sorts list of current posts in asc order by choosing parameter                                                                                      
        """
        cur_index = self.combo_sort.currentIndex()
        if cur_index == SORT_DATE:
            value = "date"
        elif cur_index == SORT_TITLE:
            value = "title"
        elif cur_index == SORT_READ:
            value = "read"
        from ldm.Message import Message

        self.filter_list = Message.sort_msg(value, ASC, self.filter_list)
        #refresh sorted list                                                                                                                                
        self.flag_is_sort = True
        self.end_refresh()

    def sort_post_desc(self):
        """                                                                                                                                                 
        handler for clicked "asc" button,
        (virtual method, for calling sort wthout parameters poster)                      
        sorts list of current posts in asc order by choosing parameter                                                                                      
        """
        cur_index = self.combo_sort.currentIndex()
        if cur_index == SORT_DATE:
            value = "date"
        elif cur_index == SORT_TITLE:
            value = "title"
        elif cur_index == SORT_READ:
            value = "read"
        from ldm.Message import Message
        self.filter_list = Message.sort_msg(value, DESC, self.filter_list)
        #refresh sorted list                                                                                                                                
        self.flag_is_sort = True
        self.end_refresh()
