#!/usr/bin/env python
# -*- coding: utf-8 -*-

"""
===============================================================
    Module for testing of some classes from  LjCommentUtils module
===============================================================
"""


from time import *
import sys
from ScriboExc import WarningExc

import LjCommentUtils
import random

import unittest
__author__ = "Sannikov Alexander <sannikov@cs.karelia.ru>"
__version__ = "$Revision: 0.1 $"
__date__ = "$Date: 2010/01/27 $"
__copyright__ = ""
__license__ = "GPLv2"

class CommentProcessorTest(unittest.TestCase):
    """
    Class with test method for CommentProcessor class
    """
    def testfin(self):
	"""
	tests for correctyly setting of finish flag
	"""
	ind =[-1,0,1]
	igm = [True, False,]
	res =[ False, False, False, False, False, False, False, False, False, True,\
	  True, True, False, True, True,  False, False, True,]
	cp = CommentProcessor()
	for cp.isgetmeta in igm:
	    for cp.maxid in ind:
	        for cp.current in ind:
		    self.assertEqual(cp.isFinished(),res.pop(0))
	

    def testfeed(self):
	"""
	tests for correctyly frocessing of  xml data
	"""
	indata = ((''),("some plain text"),
	  ("""<?xml version="1.0" encoding='utf-8'?>
    <livejournal>
        <maxid>100</maxid>
    </livejournal>"""),("""<?xml version="1.0" encoding='utf-8'?>
    <livejournal>
        <maxid>100</maxid>
        <comments>
        </comments>
        <usermaps>
            <usermap id='6' user='exampleusername2' />
            <usermap id='3' user='exampleusername' />
            <usermap id='2' user='bob' />
        <usermaps>
    </livejournal>"""),("""<?xml version="1.0" encoding='utf-8'?>
    <livejournal>
        <maxid>100</maxid>
        <comments>
            <comment id='71' posterid='3' state='D' />
            <comment id='70' state='D' />
            <comment id='99' />
            <comment id='100' posterid='3' />
            <comment id='92' state='D' />
            <comment id='69' posterid='3' state='S' />
            <comment id='98' posterid='3' />
            <comment id='73' state='D' />
            <comment id='86' state='S' />
        </comments>
        <usermaps>
            <usermap id='6' user='exampleusername2' />
            <usermap id='3' user='exampleusername' />
            <usermap id='2' user='bob' />
        <usermaps>
    </livejournal>"""),("""<?xml version="1.0" encoding='utf-8'?>
    <livejournal>
        <maxid>100</maxid>
        <comments>
        </comments>
        <usermaps>
            <usermap id='6' user='exampleusername2' />
            <usermap id='3' user='exampleusername' />
            <usermap id='2' user='bob' />
        <usermaps>
    </livejournal>"""),("""<?xml version="1.0" encoding='utf-8'?>
    <livejournal>
        <maxid>100</maxid>
        <comments>
            <comment id='71' posterid='3' state='D' />
            <comment id='70' state='D' />
            <comment id='99' />
            <comment id='100' posterid='3' />
            <comment id='92' state='D' />
            <comment id='69' posterid='3' state='S' />
            <comment id='98' posterid='3' />
            <comment id='73' state='D' />
            <comment id='86' state='S' />
        </comments>
        <usermaps>
            <usermap id='6' user='exampleusername2' />
            <usermap id='3' user='exampleusername' />
            <usermap id='2' user='bob' />
        <usermaps>
    </livejournal>""","""<?xml version="1.0" encoding='utf-8'?>
    <livejournal>
        <comments>
            <comment id='86' posterid='3' state='S' jitemid='34'>
            <body>we should all comment all day</body>
            <date>2007-03-02T18:14:06Z</date>
        </comment>
        <comment id='69' posterid='3' state='S' jitemid='34'>
            <body>commenting is fun</body>
            <date>2007-03-02T18:16:08Z</date>
        </comment>
        <comment id='99' jitemid='43' parentid='98'>
            <body>anonynote!</body>
            <date>2007-03-16T19:06:31Z</date>
            <property name='poster_ip'>127.0.0.1</property>
        </comment>
        <comment id='100' posterid='3' jitemid='43' parentid='98'>
            <subject>subject!#@?</subject>
            <body>&lt;b&gt;BOLD!&lt;/b&gt;</body>
            <date>2007-03-16T19:19:16Z</date>
        </comment>
    </comments>
    </livejournal>
    """))
    
	resultsmeta = [(False, {0:"Anonymous"},{}), (False, {0:"Anonymous"},{}),
	    (False, {0:"Anonymous",2:'bob',3:'exampleusername',6:'exampleusername2'},{}),
	    (True, {0:"Anonymous",2:'bob',3:'exampleusername',6:'exampleusername2'},{
	      71:{'posterid':3, 'state':'D', 'parentid':0, 'jitemid':0},
	      70:{'posterid':0, 'state':'D', 'parentid':0, 'jitemid':0},
	      99:{'posterid':0, 'state':'A', 'parentid':0, 'jitemid':0},
	      100:{'posterid':3, 'state':'A', 'parentid':0, 'jitemid':0},
	      92:{'posterid':0, 'state':'D', 'parentid':0, 'jitemid':0},
	      69:{'posterid':3, 'state':'S', 'parentid':0, 'jitemid':0},
	      98:{'posterid':3, 'state':'A', 'parentid':0, 'jitemid':0},
	      73:{'posterid':0, 'state':'D', 'parentid':0, 'jitemid':0},
	      86:{'posterid':0, 'state':'S', 'parentid':0, 'jitemid':0},
	      }),(True, {0:"Anonymous",2:'bob',3:'exampleusername',6:'exampleusername2'},{
	      71:{'posterid':3, 'state':'D', 'parentid':0, 'jitemid':0, },
	      70:{'posterid':0, 'state':'D', 'parentid':0, 'jitemid':0},
	      99:{'posterid':0, 'state':'A', 'parentid':98, 'jitemid':43,
		      'body':'anonynote!','date':'2007-03-16T19:06:31Z','subject':None},
	      100:{'posterid':3, 'state':'A', 'parentid':98, 'jitemid':43,
		      'body':'&lt;b&gt;BOLD!&lt;/b&gt;','date':'2007-03-16T19:19:16Z','subject':'subject!#@?'},
	      92:{'posterid':0, 'state':'D', 'parentid':0, 'jitemid':0},
	      69:{'posterid':3, 'state':'S', 'parentid':0, 'jitemid':34,
		      'body':'commenting is fun','date':'2007-03-02T18:16:08Z','subject':None},
	      98:{'posterid':3, 'state':'A', 'parentid':0, 'jitemid':0},
	      73:{'posterid':0, 'state':'D', 'parentid':0, 'jitemid':0},
	      86:{'posterid':3, 'state':'S', 'parentid':0, 'jitemid':34,
		      'body':'we should all comment all day','date':'2007-03-02T18:14:06Z','subject':None},
	      }),]
	
	for i in indata:
	    cp = CommentProcessor()
	    for xmlp in i:
		res = cp.feed(xmlp)
	    resd = resultsmeta.pop(0)
	    self.assertEqual(res,resd[0])
	    self.assertDictEqual(cp.umap,resd[1])
	    self.assertDictEqual(cp.changeset,resd[2])
	    
	    
	    
if __name__ == '__main__':
    unittest.main()
