#!/usr/bin/env python
from ldm.SqlDriver import sql_driver
from ldm.Account import Account
from services.Dispatcher import dispatcher

__author__ = "Mezhenin Artoym <mezhenin@cs.karelia.ru>"
__version__ = "$Revision: 1 $"
__date__ = "$Date: 2010/02/09 $"
__copyright__ = ""
__license__ = "GPLv2"


class FakeAccount(Account):

    def __init__(self, id=None):
        super(FakeAccount, self).__init__(id)

        if not id:
            self.service_id = type(self).__name__

    @staticmethod
    def get_name():
        """
        Get name of this service. It will be used in UI in list of 
        avalible services.
        
        @return (string) name of this service
        """

        return 'Testing Account'


    @staticmethod
    def get_icon():
        """
        Get path to icon of this service. It will be used in UI in list of 
        avalible services.
        
        @return (string) path to icon of this service
        """

        return 'path to icon'

"""
add this fake service to list of avalible services
"""

dispatcher.add_service(FakeAccount)
