#!/usr/bin/env python

__author__ = "Mezhenin Artoym <mezhenin@cs.karelia.ru>"
__version__ = "$Revision: 2 $"
__date__ = "$Date: 2010/02/06 $"
__copyright__ = ""
__license__ = "GPLv2"

import unittest
import sys
sys.path.append("..")
sys.path.append("../ldm")

from Profile import Profile
from FakeAccount import FakeAccount
from Message import Message
from ScriboExc import WarningExc


class ProfileTest(unittest.TestCase):
    """
    Class with test method for Profile module
    """

    def setUp(self):
        """
        Init variables for test methods
        """
        self.prof = Profile()


    def test_add_account(self):
        """
        test for Profile.add_account()
        add one account
        """
        acc = FakeAccount()
        self.prof.add_account(acc)
        self.assertTrue(acc in self.prof.accounts)


    def test_get_accounts(self):
        """
        test for Profile.get_accounts
        add 5 accounts get them from DB
        """
        self.assertFalse(self.prof.get_accounts())

        for _ in xrange(5):
            self.test_add_account()

        list = self.prof.get_accounts()
        list2 = self.prof.accounts
        self.assertEqual(list, list2)
        self.assertEqual(type(list[0]), FakeAccount)
        self.assertEqual(len(list), 5)


    def test_def_account(self):
        """
        test for Profile.def_account (get_ and set_)
        """
        acc = FakeAccount()

        self.assertRaises(WarningExc, self.prof.set_def_account, acc)

        self.prof.add_account(acc)
        self.prof.def_account = acc
        self.assertEqual(acc, self.prof.def_account)


    def test_del_profile(self):
        """
        test for Profile.del_profile()
        delete profile from DB and try to load it after deleting
        """
        id = self.prof.id
        self.prof.del_profile()

        self.assertRaises(WarningExc, Profile, id)


    def test_get_posts(self):
        """
        test for Profile.get_posts()
        add 5 accouns with 5 posts in each and try to get them
        """
        self.test_get_accounts()

        for i in self.prof.accounts:
            for _ in xrange(5):
                msg = Message()
                i.add_post(msg)

        list = self.prof.get_posts()

        self.assertEqual(len(list), 25)
        self.assertEqual(type(list[0]), Message)


if __name__ == '__main__':
    unittest.main()
