#!/usr/bin/env python
"""
 @file: StartPage.py
  File is a part of Scribo Project
  Module implements start window from UI
  @author: Zaiceva Diana <zaiceva@cs.karelia.ru>
  @date: 23.06.2010
"""

import sys
from PyQt4 import QtCore
from PyQt4 import QtGui
from ldm.Profile import main_prof
from ldm.Account import Account
from services.Dispatcher import dispatcher
from ScriboExc import WarningExc
from MainWindow import *
__author__ = "Diana Zaiceva <zaiceva@cs.karelia.ru>"
__version__ = "$Revision: 0.2 $"
__date__ = "$Date: 2010/06/23 $"
__copyright__ = ""
__license__ = "GPLv2"


class StartPage(MainWindow):
    """
    class for draw start window
    @version  1.0
    @author  Zaiceva Diana <zaiceva@cs.karelia.ru>
    @todo  auth_check
    """

    def __init__(self, parent=None):
        """
        initialization start window
        @return
        """
        super(StartPage, self).__init__(parent)
        self.parent = parent
        self.centr_widg = QtGui.QWidget(self)
        login_label = QtGui.QLabel(self.tr("Login"), self.centr_widg)
        login_label.setAlignment(QtCore.Qt.AlignRight)
        pasw_label = QtGui.QLabel(self.tr("Password"), self.centr_widg)
        pasw_label.setAlignment(QtCore.Qt.AlignRight)
        service_label = QtGui.QLabel(self.tr("Blog service"), self.centr_widg)
        service_label.setAlignment(QtCore.Qt.AlignRight)

        self.new_act.setDisabled(True)
        self.manage_act.setDisabled(True)

        self.login_edit = QtGui.QLineEdit(self)
        self.pasw_edit = QtGui.QLineEdit(self)
        self.pasw_edit.setEchoMode(QtGui.QLineEdit.Password)
        self.login_edit.setFocus()
        self.serv_combo = self.fill_combo()

        start_button = QtGui.QPushButton(self.tr("Go"), self)
        self.connect(start_button, QtCore.SIGNAL("clicked()"), self.add_account)

        grid = QtGui.QGridLayout()
        grid.addWidget(login_label, 0, 0)
        grid.addWidget(self.login_edit, 0, 1, 1, 1, QtCore.Qt.AlignLeft)
        grid.addWidget(pasw_label, 1, 0)
        grid.addWidget(self.pasw_edit, 1, 1, 1, 1, QtCore.Qt.AlignLeft)
        grid.addWidget(service_label, 2, 0)
        grid.addWidget(self.serv_combo, 2, 1, 1, 1, QtCore.Qt.AlignLeft)
        grid.addWidget(start_button, 3, 0, 1, 1, QtCore.Qt.AlignLeft)
        grid.setColumnStretch(0, 1)
        grid.setColumnStretch(1, 2)
        self.centr_widg.setLayout(self.create_start(grid))
        self.setCentralWidget(self.centr_widg)
        self.show()

    def fill_combo(self):
        """
        fill combo_box 
        @param
        @return
        """

        serv_combo = QtGui.QComboBox(self.centr_widg)

        serv = dispatcher.get_services()
        for i in serv:
            icon = QtGui.QIcon(i.get_icon())
            name = i.get_name()
            serv_combo.addItem(icon, name)

        return serv_combo


    def add_account(self):
        """
        handler fo buttons Go(authentification)
        @return
        """
        if (self.login_edit.text() == "") or (self.pasw_edit.text() == ""):
            QtGui.QMessageBox.information(self, self.tr("Scribo"),
                               self.tr("Please, fill all fields!"),
                               QtGui.QMessageBox.Yes)
            return

        if self._add_new_account():
            self.new_act.setDisabled(False)
            self.manage_act.setDisabled(False)
            self.hide()
            from HomePage import HomePage
            home_page = HomePage()
            self.parent = home_page
            super(StartPage, self).home_window()
            
    
    def _add_new_account(self):
	"""
	inside method adding new account
	"""
        index = self.serv_combo.currentIndex()

        service = dispatcher.get_services()[index]
        username = unicode(self.login_edit.text())
        acc = Account.register(service, username)
        acc.passwd = unicode(self.pasw_edit.text())

        main_prof.add_account(acc)

        try:
            acc.check_login()
        except WarningExc, exc:
            main_prof.remove_account(acc)
            super(StartPage, self).show_warning(exc)
            return False

        try:
            acc.refresh_user_info()
        except WarningExc, exc:
            main_prof.remove_account(acc)
            super(StartPage, self).show_warning(exc)
            return False

        acc.set_default()

        return True


    def create_start(self, grid):
        """
        creating containers
        @param grid - grid with lines for login and password
        @return
        """
        hbox = QtGui.QHBoxLayout()
        vbox1 = QtGui.QVBoxLayout()
        vbox2 = QtGui.QVBoxLayout()
        image_label = QtGui.QLabel(self.centr_widg)
        image_label.setAlignment(QtCore.Qt.AlignCenter)
        start_label = QtGui.QLabel(self.tr("<i>Welcome to Scribo,<br/> mobile multiblog client!</i>"), self.centr_widg)
        start_label.setAlignment(QtCore.Qt.AlignCenter)
        upic = QtGui.QImage(self.tr("../data/Scribo.png"))
        image_label.setPixmap(QtGui.QPixmap.fromImage(upic))
        vbox1.addWidget(start_label, 0, QtCore.Qt.AlignTop)
        vbox1.addWidget(image_label, 1, QtCore.Qt.AlignCenter)
        vbox2.addLayout(grid, 1)

        hbox.addLayout(vbox1, 1)
        hbox.addLayout(vbox2, 1)
        hbox.insertSpacing(-1, 30)
        return hbox
start_page = StartPage()



