# -*- coding: utf-8 -*-
"""
 @file: BDTest.py
  File is a part of Scribo Project
  Module implements group and friends test scenariouses
  @author: Kirill Germanov <kgermano@cs.karelia.ru>
  @date: 9.03.2010
"""


from ldm.Message import Message
from ldm.Profile import main_prof
from ldm.Account import Account
from services.Dispatcher import dispatcher
from time import time, localtime
from ldm.SqlDriver import sql_driver






__author__ = "Kirill Germanov <kgermano@cs.karelia.ru>"
__version__ = "$Revision: 0.1 $"
__date__ = "$Date: 2010/02/14 $"
__copyright__ = ""
__license__ = "GPLv2"

class BDTest:
    """
    Class with test method for DB testing
    @version  1.0
    @author  Germanov Kirill <kgermano@cs.karelia.ru>
    @todo  global testing of all scenarios
    """
    def __init__(self):
        """
        initialization of test account
        @return
        """
        service = dispatcher.get_services()[0]
        acc = Account.register(service, "scribo_rpc")
        acc.passwd = "test123"
        accs = main_prof.get_accounts()
        for acc in accs:
            if(acc.username == "scribo_rpc"):
                if(acc.service_id == "LivejAccount"):
                    main_prof.set_def_account(acc)
        f11 = open('./data/DBTest_info.txt', 'w')
        f11.close()


    def getdb_def_acc(self):
        """
        test if account become default after init
        """
        f12 = open('./data/TestRes.txt', 'a+')
        f12.write('\nChecking Set defoult account scenario ')
        print '\nChecking Set defoult account scenario '

        f11 = open('./data/DBTest_info.txt', 'a')
        cmd = "SELECT def_account FROM Profiles;"
        args = sql_driver.select_mcmd(cmd)
        f11.write("default account = %s\n\n" % (args))
        f11.close()
        print "\ndef_acc = "
        print args
        if(args[0] == 0):
            f12.write('ERROR\n')
            print 'ERROR\n'
        else:
            f12.write('OK\n')
            print 'OK\n'
        f12.close()


    def getdb_acc(self):
        """
        get acc from db
        @return
        
        """

        service = dispatcher.get_services()[0]
        acc = Account.register(service, "proffko")
        try:
            main_prof.add_account(acc)
        except:
            print "already have"
            acc = Account.find(type(acc), acc.username)

        list_acc = main_prof.accounts
        for acc in list_acc:
            print acc.username + "\n"


        f12 = open('./data/TestRes.txt', 'a+')
        f12.write('\nChecking Delete account from DB: ')
        print '\nChecking Delete account from DB: '

        f11 = open('./data/DBTest_info.txt', 'a')
        cmd = "SELECT username FROM Accounts;"
        args = sql_driver.select_mcmd(cmd)
        f11.write("accounts = %s\n\n" % (args))
        args = main_prof.accounts
        print "\nacc-s number= "
        print args.__len__()
        #print acc.username + " - удаляем"
        """
        Function del_account is not exist any more, 
        so we will try remove_account function
        """
        main_prof.remove_account(acc)

        args1 = sql_driver.select_mcmd(cmd)
        f11.write("acc-s after delete = %s\n\n" % (args1))
        f11.close()

        args1 = main_prof.accounts
        print "\nacc-s after delete= "
        print args1.__len__()
        if(len(args) <= len(args1)):
            f12.write('ERROR\n')
            print "ERROR\n"
        else:
            f12.write('OK\n')
            print "OK\n"

        list_acc = main_prof.accounts
        for acc in list_acc:
            print acc.username + "\n"

        f12.close()



    def getdb_posts(self):
        """
        test if post added to db
        """

        f22 = open('./data/TestRes.txt', 'a+')
        f22.write('\nChecking Add post to DB: ')
        print '\nChecking Add post to DB: '
        f12 = open('./data/DBTest_info.txt', 'a')
        cmd = "SELECT date FROM Messages;"
        args = sql_driver.select_mcmd(cmd)
        f12.write("dates of all posts = %s\n\n" % (args))
        print "\ndates of all posts = "
        print args

        f11 = open('./data/bigPOST', 'r')

        all_lines = f11.readlines()

        tm_ = localtime(time())
        date = "%s-%s-%s %s:%s" % (tm_.tm_year,
            tm_.tm_mon, tm_.tm_mday, tm_.tm_hour, tm_.tm_min)


        header = all_lines[0]
        body = all_lines[1]
        f11.close()
        f11 = open('./data/bigPOST', 'r')

        mesa = Message()
        mesa.title = unicode(header, errors='replace')
        mesa.title += (unicode(" - ", errors='replace') +
                         unicode(body, errors='replace'))
        mesa.date = date

        all_lines = f11.read()
        mesa.text = unicode(all_lines, errors='replace')
        f11.close()
        main_prof.def_account.add_post(mesa)
        res = main_prof.def_account.send_post(mesa)
        print res

        args1 = sql_driver.select_mcmd(cmd)
        f12.write("dates of all posts after adding a post = %s\n\n" % (args))
        print "\ndates of all posts after adding a post = "
        f12.close()
        print args1
        if(len(args) >= len(args1)):
            f22.write('ERROR\n')
            print 'ERROR\n'
        else:
            f22.write('OK\n')
            print 'OK\n'
        f22.close()


    def getdb_accs(self):
        """
        addin' different acounts
        """
        f22 = open('./data/TestRes.txt', 'a+')
        f22.write('\nChecking Add Accounts to DB: ')
        print '\nChecking Add Accounts to DB: '
        fil = open('./data/DBTest_info.txt', 'a')
        service = dispatcher.get_services()[0]
        acc = Account.register(service, "scribo_rpc")
        acc.passwd = "test123"

        cmd = "SELECT username, passwd FROM Accounts;"
        args = sql_driver.select_mcmd(cmd)
        try:
            main_prof.add_account(acc)
        except:
            print "already have"

        service = dispatcher.get_services()[0]
        ac_ = Account.register(service, "maemoblogs")
        try:
            main_prof.add_account(ac_)
        except:
            print "already have"

        service = dispatcher.get_services()[0]
        acc1 = Account.register(service, "")
        acc1.passwd = "maemo100500"
        try:
            main_prof.add_account(acc1)
        except:
            print "already have"


        service = dispatcher.get_services()[0]
        acc2 = Account.register(service, "")
        acc2.friends = ["maemo100500"]
        try:
            main_prof.add_account(acc2)
        except:
            print "already have"

        service = dispatcher.get_services()[0]
        acc3 = Account.register(service, "")
        try:
            main_prof.add_account(acc3)
        except:
            print "already have"
        main_prof.set_def_account(acc3)

        cmd = "SELECT username, passwd FROM Accounts;"
        args1 = sql_driver.select_mcmd(cmd)
        fil.write("acc-s after adding new ones = %s\n\n" % (args1))
        fil.close()
        print "\nacc-s after adding new ones= "
        print args1

        if(len(args) >= len(args1)):
            f22.write('ERROR\n')
            print "error\n"
        else:
            f22.write('OK\n')
            print "OK\n"
        f22.close()


OMG = BDTest()
OMG.getdb_def_acc()
OMG.getdb_posts()
OMG.getdb_acc()
OMG.getdb_accs()
print "ReAdY!"



