#!/usr/bin/env python
"""
 @file: AddProfile.py
  File is a part of Scribo Project
  Module implements add profile window from UI
  @author: Zaiceva Diana <zaiceva@cs.karelia.ru>
  @date: 23.06.2010
"""
import sys

from PyQt4 import QtCore
from PyQt4 import QtGui

from ldm.Profile import *
from ldm.Account import *
from services.Dispatcher import dispatcher

from ToolbarWindow import ToolbarWindow
#from StartPage import StartPage
from MainWindow import *
__author__ = "Diana Zaiceva <zaiceva@cs.karelia.ru>"
__version__ = "$Revision: 0.2 $"
__date__ = "$Date: 2010/06/23 $"
__copyright__ = ""
__license__ = "GPLv2"


class AddProfileWindow(MainWindow):
    """
    class for draw profile window
    @version  1.0
    @author  Zaiceva Diana <zaiceva@cs.karelia.ru>
    """
    def __init__(self, parent=None, default=None):
        """
        initialization "add profile" window
        default = default account (for managing profile) or None (for adding profile) 
        @return
        """
        super(AddProfileWindow, self).__init__(parent)

        self.centr_widg = QtGui.QWidget(self)
        self.accounts2 = []
        self.default = default
        self.create_actions()
        self.parent = parent
        toolbar = self.create_toolbar()
        self.hbox_add = QtGui.QHBoxLayout()

        login_label = QtGui.QLabel(self.tr("Login"), self.centr_widg)
        login_label.setAlignment(QtCore.Qt.AlignRight)
        pasw_label = QtGui.QLabel(self.tr("Password"), self.centr_widg)
        pasw_label.setAlignment(QtCore.Qt.AlignRight)
        self.login_edit = QtGui.QLineEdit(self.centr_widg)
        self.pasw_edit = QtGui.QLineEdit(self.centr_widg)
        self.pasw_edit.setEchoMode(QtGui.QLineEdit.Password)
        self.login_edit.setFocus()
        self.serv_combo = self.create_list_acc(self.default)

        grid = QtGui.QGridLayout()
        grid.addWidget(login_label, 0, 0)
        grid.addWidget(self.login_edit, 0, 1, 1, 4, QtCore.Qt.AlignLeft)
        grid.addWidget(pasw_label, 1, 0)
        grid.addWidget(self.pasw_edit, 1, 1, 1, 4, QtCore.Qt.AlignLeft)
        service_label = QtGui.QLabel(self.tr("Blog Service"), self.centr_widg)
        service_label.setAlignment(QtCore.Qt.AlignRight)
        grid.addWidget(service_label, 2, 0)
        if default:
            self.login_edit.setText(self.default.username)
            self.pasw_edit.setText(self.default.passwd)
            self.login_edit.setDisabled(True)
            self.service_edit = QtGui.QLabel(default.get_name(), self.centr_widg)
            grid.addWidget(self.service_edit, 2, 1, 1, 4, QtCore.Qt.AlignLeft)
            grid.addWidget(self.serv_combo, 3, 1, 1, 4, QtCore.Qt.AlignLeft)
            grid.setRowStretch(3, 2)
        else:
            grid.addWidget(self.serv_combo, 2, 1, 1, 4, QtCore.Qt.AlignLeft)
            grid.setRowStretch(2, 2)
        grid.setColumnStretch(0, 1)
        grid.setColumnStretch(1, 3)
        self.setCentralWidget(self.centr_widg)


        self.hbox_add.addWidget(toolbar)
        self.hbox_add.addSpacing(10)
        self.hbox_add.addLayout(grid)
        self.centr_widg.setLayout(self.hbox_add)
        
        self.show()
    
    def create_toolbar(self):
        """
        create profile for "add profile" window
        @return
        """
        file_tool_bar = ToolbarWindow(parent=self.centr_widg)
        if self.default:
            file_tool_bar.addWidget(self.del_act)
        file_tool_bar.addWidget(self.add_acc)
        self.connect(file_tool_bar.home_act, QtCore.SIGNAL("clicked()"),
                             self.home_window)                             
        return file_tool_bar

    def create_actions(self):
        """ 
        create buttons for toolbar
        @return
        """
        self.add_acc = QtGui.QToolButton(self.centr_widg)
        self.connect(self.add_acc, QtCore.SIGNAL("clicked()"),
                     self.add_account)
        if self.default:
            self.del_act = QtGui.QToolButton(self.centr_widg)
            self.del_act.setIcon(QtGui.QIcon("../data/en/remove_profile.png"))
            self.del_act.setText(self.tr("Delete account"))
            self.del_act.setToolButtonStyle(QtCore.Qt.ToolButtonTextUnderIcon)
            self.del_act.setSizePolicy(QtGui.QSizePolicy.Expanding, QtGui.QSizePolicy.Minimum)
            self.connect(self.del_act, QtCore.SIGNAL("clicked()"),
                         self.del_account_ui)
            self.add_acc.setIcon(QtGui.QIcon(self.tr("../data/en/change_profile_ok.png")))
            self.add_acc.setText(self.tr("OK"))
        else:
            self.add_acc.setIcon(QtGui.QIcon(self.tr("../data/en/add_profile.png")))
            self.add_acc.setText(self.tr("Add account"))

        self.add_acc.setToolButtonStyle(QtCore.Qt.ToolButtonTextUnderIcon)
        self.add_acc.setSizePolicy(QtGui.QSizePolicy.Expanding, QtGui.QSizePolicy.Minimum)


    def create_list_acc(self, default):
        """
        create list with services or accounts
        @param default = None for adding account or default account for
         manage account
        @return acc_combo pop-up list with accounts or services
        """
        acc_combo = QtGui.QComboBox(self.centr_widg)
        self.accounts2 = []
        if default:
            self.accounts2.append(default)
            if default.path_to_ava:
                acc_combo.addItem(QtGui.QIcon(default.path_to_ava),
                                  default.username)
            else:
                acc_combo.addItem(default.username)

            for acc in main_prof.accounts:
                if not acc == default:
                    self.accounts2.append(acc)
                    if acc.path_to_ava:
                        acc_combo.addItem(QtGui.QIcon(acc.path_to_ava),
                                          acc.username)
                    else:
                        acc_combo.addItem(acc.username)

            self.connect(acc_combo,
                         QtCore.SIGNAL("currentIndexChanged(int)"),
                         self.reload_list)

        else:
            services = dispatcher.get_services()
            for i in services:
                icon = QtGui.QIcon(i.get_icon())
                name = i.get_name()
                acc_combo.addItem(icon, name)

        return acc_combo

    def reload_list(self, number):
        """
        reload page with acounts
        @param number = index of selected items
        @return 
        """
        self.login_edit.setText(self.accounts2[number].username)
        self.pasw_edit.setText(self.accounts2[number].passwd)
        self.service_edit.setText(self.accounts2[number].get_name())
        self.default = self.accounts2[number]


    def add_account(self):
        """
        handler for button OK
        @param 
        @return
        """
        if (self.login_edit.text() == "") or (self.pasw_edit.text() == ""):
            QtGui.QMessageBox.information(self, self.tr("Scribo"),
                               self.tr("Please, fill all fields!"),
                               QtGui.QMessageBox.Yes)
            return

        if self.default:
            ret = self._edit_account()
        else:
            ret = self._add_new_account()

        if ret:
            super(AddProfileWindow, self).reload_home_window()
    
    def _edit_account(self):


        old_pass = self.default.passwd

        self.default.passwd = str(self.pasw_edit.text())

        try:
            self.default.check_login()
        except WarningExc, exc:
            self.default.passwd = old_pass
            super(AddProfileWindow,self).show_warning(exc)
            return False

        try:
            self.default.refresh_user_info()
        except WarningExc, exc:
            super(AddProfileWindow,self).show_warning(exc)

        self.default.set_default()

        return True


    def _add_new_account(self):
        index = self.serv_combo.currentIndex()

        service = dispatcher.get_services()[index]
        username = unicode(self.login_edit.text())
        acc = Account.register(service, username)
        acc.passwd = unicode(self.pasw_edit.text())

        main_prof.add_account(acc)

        try:
            acc.check_login()
        except WarningExc, exc:
            main_prof.remove_account(acc)
            super(AddProfileWindow, self).show_warning(exc)
            return False

        try:
            acc.refresh_user_info()
        except WarningExc, exc:
            main_prof.remove_account(acc)
            super(AddProfileWindow, self).show_warning(exc)
            return False

        acc.set_default()

        return True

    def del_account_ui(self):
        """
        deleting account 
        @param
        @return 
        """
        ret = QtGui.QMessageBox.information(self, self.tr("Scribo"),
                               self.tr("Do you really want to delete account?"),
                               QtGui.QMessageBox.Yes,
                               QtGui.QMessageBox.No)
        if (ret == QtGui.QMessageBox.No):
            return
        index = self.serv_combo.currentIndex()
        del_acc = self.accounts2[index]
        #it is last account      
        if (len(self.accounts2) - 1):
            self.accounts2.remove(del_acc)
            if (self.default == del_acc):
                self.default = self.accounts2[0] #first account
                main_prof.def_account = self.default
            del_acc.del_account()
            ret = QtGui.QMessageBox.information(self, self.tr("Scribo"),
                                   self.tr("Account was deleted"),
                                   QtGui.QMessageBox.Yes)

        else:
            #all accounts are deleted
    	    main_prof.remove_account(del_acc)
        super(AddProfileWindow, self).reload_home_window()
