#!/usr/bin/env python

"""
================================================================
    This file contains base class for all modules with serrvises 
================================================================
"""

__author__ = "Mezhenin Artoym <mezhenin@cs.karelia.ru>"
__version__ = "$Revision: 1 $"
__date__ = "$Date: 2010/02/25 $"
__copyright__ = ""
__license__ = "GPLv2"

class Service(object):

    def get_proxy(self):
        """
        determines the policy of access to the network through a proxy for some 
        account. settings could be different for different accounts 
        
        @param account (child of Account) determine proxy settings for than account
        @return (string, None) proxy settings (for example '192.168.1.1:81')
        @note this function simly reads proxy from config file, but in future it 
              could change
        """

        from ConfigDriver import config
        proxy = config.get('Main', 'proxy')
        return proxy
