#!/usr/bin/env python

"""
===============================================================
Base class for windows in Scribo
===============================================================
"""

__author__ = "Mezhenin Artoym <mezhenin@cs.karelia.ru>"
__version__ = "$Revision: 20 $"
__date__ = "$Date: 2010/02/07 $"
__copyright__ = ""
__license__ = "GPLv2"

from PyQt4 import QtGui
from PyQt4 import QtCore

from MainWindow import main_window

class ToolbarWindow(QtGui.QToolBar):

    def __init__(self, parent=None, right=False):
        """
        create buttons for toolbar
        @return
        """
        QtGui.QToolBar.__init__(self)
        self.setToolButtonStyle(QtCore.Qt.ToolButtonTextUnderIcon)
        self.setOrientation(QtCore.Qt.Vertical)
        self.setMovable(True)
        self.setIconSize(QtCore.QSize(64, 64))

        if right:
            self.setAllowedAreas(QtCore.Qt.RightToolBarArea)
        else:
            self.setAllowedAreas(QtCore.Qt.LeftToolBarArea)
            self.create_actions()
            #self.addWidget(self.back_act)
            self.addWidget(self.home_act)


    def create_actions(self, parent=None):
        """
        create buttons for toolbar
        @return
        """
        """
        self.back_act = QtGui.QToolButton(self)
        self.back_act.setIcon(QtGui.QIcon(main_window.tr('../data/en/back.png')))
        self.back_act.setText(self.tr("Back"))
        self.back_act.setToolButtonStyle(QtCore.Qt.ToolButtonTextUnderIcon)
        self.back_act.setSizePolicy(QtGui.QSizePolicy.Expanding, QtGui.QSizePolicy.Minimum)
        self.connect(self.back_act, QtCore.SIGNAL("clicked()"),
                     main_window.back_window)
        """
        self.home_act = QtGui.QToolButton(self)
        self.home_act.setIcon(QtGui.QIcon(main_window.tr('../data/en/home.png')))
        self.home_act.setText(self.tr("Home"))
        self.home_act.setToolButtonStyle(QtCore.Qt.ToolButtonTextUnderIcon)
        self.home_act.setSizePolicy(QtGui.QSizePolicy.Expanding, QtGui.QSizePolicy.Minimum)
        #self.connect(self.home_act, QtCore.SIGNAL("clicked()"),
        #             main_window.home_window)


