#!/usr/bin/env python
"""   
 @file: MainWindow.py  
  File is a part of Scribo Project  
  Module implements main window from UI
  @author: Zaiceva Diana <zaiceva@cs.karelia.ru>
  @date: 23.06.2010
"""

__author__ = "Diana Zaiceva <zaiceva@cs.karelia.ru>"
__version__ = "$Revision: 0.2 $"
__date__ = "$Date: 2010/06/23 $"
__copyright__ = ""
__license__ = "GPLv2"


import sys
from PyQt4 import QtCore
from PyQt4 import QtGui

#sys.path.append("../ldm")
#sys.path.append("..")

from ldm.Profile import main_prof

class MainWindow(QtGui.QMainWindow):
    """
    main class for all windows
    @version  1.0   
    @author  Zaiceva Diana <zaiceva@cs.karelia.ru>   
    """
    def __init__(self, parent=None):
        """
        Initialization for MainWindow   
        @param parent (widget), start (string) 
        @return 
        """
        QtGui.QMainWindow.__init__(self, parent)
        self.setWindowTitle(self.tr("Scribo"))
        self.setMinimumSize(160, 160)
        self.resize(480, 340)

        try:
            self.setAttribute(QtCore.Qt.WA_Maemo5StackedWindow)
        except AttributeError:
            print "no stacked attribute"
        
        self.parent = parent
        self.new_act = QtGui.QAction(self.tr("&New Account"), self)
        self.manage_act = QtGui.QAction(self.tr("&Edit Accounts"), self)
        self.create_actions_menu()
        self.create_menus()
        #self.show()

    def new_profile(self):
        """
        change window on "add profile"
        @param 
        @return
        """
        from AddProfile import AddProfileWindow
        add_widg = AddProfileWindow(self)
        

    def manage_profile(self):
        """
        change window on "manage profile"
        @param 
        @return
        """
        from AddProfile import AddProfileWindow
        add_widg = AddProfileWindow(self, default=main_prof.def_account)
        

    def about(self):
        """  
        page with info about application
        @param 
        @return
        """
        from About import __version__ as ver
        QtGui.QMessageBox.about(self, self.tr("About Scribo"),
                                self.tr("A mobile multiblog client."\
                                        " \n Version: " + ver))
    def show_warning(self, exc):
        """  
        error message
        @param exc - exception
        @return
        """

        QtGui.QMessageBox.warning(self,
                                  self.tr("Scribo"),
                                  exc.to_html(),
                                  QtGui.QMessageBox.Ok)


    def create_actions_menu(self):
        """
        create submenu
        @param
        @return
        """
        self.new_act.setShortcut(self.tr("Ctrl+N"))
        self.connect(self.new_act, QtCore.SIGNAL("triggered()"),
                     self.new_profile)

        self.connect(self.manage_act, QtCore.SIGNAL("triggered()"),
                     self.manage_profile)

        self.exit_act = QtGui.QAction(self.tr("E&xit"), self)
        self.exit_act.setShortcut(self.tr("Ctrl+Q"))
        self.connect(self.exit_act, QtCore.SIGNAL("triggered()"),
                     self, QtCore.SLOT("close()"))

        bold_font = self.exit_act.font()
        bold_font.setBold(True)
        self.exit_act.setFont(bold_font)

        self.about_act = QtGui.QAction(self.tr("&About"), self)
        self.connect(self.about_act, QtCore.SIGNAL("triggered()"), self.about)


    def create_menus(self):
        """
        create menu
        @param
        @return
        """
        self.main_menu = self.menuBar().addMenu(self.tr("&Menu"))
        self.main_menu.addAction(self.new_act)
        self.main_menu.addAction(self.manage_act)
        self.main_menu.addAction(self.about_act)
        self.main_menu.addSeparator()
        self.main_menu.addAction(self.exit_act)



    def closeEvent(self, event):
        """
        handler for clicked "back" 
        @param
        @return
        """
        event.accept()
        if self.parent:
            self.parent.show()
        else:
            ret = QtGui.QMessageBox.question(self, self.tr("Scribo"), self.tr("Do you really want to quit?"), QtGui.QMessageBox.Yes, QtGui.QMessageBox.No)
            if (ret == QtGui.QMessageBox.No):
                return
    
    def home_window(self):
        """
        handler for clicked "home"
        @param
        @return
        """
        parent = self.parent
        child = self
        del_window = []
        while parent<>None:
            print parent
            print child
            del_window.append(child)
            child = parent
            parent = parent.parent
            
        for window in del_window:
            window.close()
        #child.show()


    def reload_window(self):
        """
        handler for clicked "reload"
        @param
        @return
        """
        pass

    def home_start(self):
        from HomePage import home_window
        self.parent = self
        self.close()

main_window = MainWindow()


