#!/usr/bin/env python

"""
===============================================================
    This file contains functions to show posts of out friends
===============================================================
"""

__author__ = "Mezhenin Artoym <mezhenin@cs.karelia.ru>"
__version__ = "$Revision: 9 $"
__date__ = "$Date: 2010/04/04 $"
__copyright__ = ""
__license__ = "GPLv2"


from ListMyPosts import ListMyPosts
from ldm.Profile import main_prof
from ScriboExc import WarningExc

class ListFriendsPosts(ListMyPosts):
    def __init__(self, parent):
        """                                                                                                                                                 
        initialization "list of posts" window                                                                                                               
        @return                                                                                                                                             
        """
        print "begin_init"
        self.parent = parent
        super(ListFriendsPosts, self).__init__(parent)
        print "end_init" 
    
    def refresh_messages(self):
        list_acc = main_prof.accounts
        for acc in list_acc:
            try:
                acc.refresh_friends_page(self.callback)
            except WarningExc, exc:
                super(ListMyPosts, self).show_warning(exc)

    def get_messages(self):
        return main_prof.get_friends_posts(20)

    def create_toolbar(self):
        """
        create toolbar for list of posts window
        @return
        """
        file_tool_bar = super(ListFriendsPosts, self).create_toolbar()
        self.refresh_act.setText(self.tr("Refresh"))
        self.del_act.setDisabled(True)
        #self.del_act.deleteLater()
        return file_tool_bar
