#!/usr/bin/env python
"""
 @file: AddPost.py
  File is a part of Scribo Project
  Module implements add post window from UI
  @author: Zaiceva Diana <zaiceva@cs.karelia.ru>
  @date: 11.12.2009
"""


from PyQt4 import QtCore
from PyQt4 import QtGui

#from HomePage import home_page
from ToolbarWindow import ToolbarWindow
from MainWindow import *
from ldm.Profile import *
from ldm.Account import *
from services.LivejAccount import *

__author__ = "Diana Zaiceva <zaiceva@cs.karelia.ru>"
__version__ = "$Revision: 0.1 $"
__date__ = "$Date: 2009/12/11 $"
__copyright__ = ""
__license__ = "GPLv2"

class AddPostWindow(MainWindow):
    """
    class for draw add post window
    @version  1.0
    @author  Zaiceva Diana <zaiceva@cs.karelia.ru>
    @todo  duplication
    """
    def __init__(self, parent=None, msg=None):
        """ 
        initialization "add post" window
        @return
        """

        self.tags = None
        self.msg = msg
        self.is_change = False
        self.start_text = ""
        self.plain_text = ""
        self.sending_post = False
        
        super(AddPostWindow, self).__init__(parent)
        self.parent = parent
        self.centr_widg = QtGui.QWidget(parent)
        
        self.vbox_add = QtGui.QVBoxLayout()
        self.hbox_all = QtGui.QHBoxLayout()
        self.hbox_title = QtGui.QHBoxLayout()        

        title_label = QtGui.QLabel(self.tr("Subject"), self)
        title_label.setAlignment(QtCore.Qt.AlignLeft)

        self.text_edit = QtGui.QTextEdit(self)
        self.text_edit.setReadOnly(False)
        self.text_edit.setAutoFormatting(QtGui.QTextEdit.AutoNone)
        self.text_edit.setTextInteractionFlags(QtCore.Qt.TextEditorInteraction)
        self.title_edit = QtGui.QLineEdit(self)
        self.title_edit.setMaxLength(100)

        self.combo_view = QtGui.QComboBox(self.centr_widg)
        self.combo_view.addItem(self.tr("Edit"))
        self.combo_view.addItem(self.tr("Preview"))
        self.connect(self.combo_view,QtCore.SIGNAL("currentIndexChanged(int)"),
                         self.reload_edit)
        if msg:
            self.text_edit.insertPlainText(msg.text)
            self.start_text = msg.text
            title = msg.title
            if not msg.title:
                title = ""
            self.title_edit.setText(title)
        self.title_edit.setFocus()

        self.connect(self.text_edit, QtCore.SIGNAL("undoAvailable(bool)"),self.undo_available)
        self.connect(self.text_edit, QtCore.SIGNAL("redoAvailable(bool)"),self.redo_available)
        self.create_actions()
        first_toolbar = self.create_toolbar()
        second_toolbar = self.create_toolbar_second()
        self.undo_act.setDisabled(True)
        self.redo_act.setDisabled(True)

        self.hbox_title.addWidget(title_label)
        self.hbox_title.addWidget(self.combo_view)
        self.hbox_all.addWidget(first_toolbar)
        self.hbox_all.addSpacing(5)
        self.vbox_add.addLayout(self.hbox_title)
        self.vbox_add.addWidget(self.title_edit)
        self.vbox_add.addWidget(self.text_edit)

        self.hbox_all.addLayout(self.vbox_add)
        self.hbox_all.addSpacing(5)
        self.hbox_all.addWidget(second_toolbar)

        self.centr_widg.setLayout(self.hbox_all)
        self.setCentralWidget(self.centr_widg)
        self.show()

    def create_toolbar(self):
        """
        create profile for "add profile" window
        @return
        """
        file_tool_bar = ToolbarWindow(parent=self.centr_widg)
        file_tool_bar.addWidget(self.send_act)
        file_tool_bar.addWidget(self.undo_act)
        file_tool_bar.addWidget(self.redo_act)
        self.connect(file_tool_bar.home_act, QtCore.SIGNAL("clicked()"),
                     self.home_window)
        return file_tool_bar

    def create_toolbar_second(self):
        """
        create profile for "add profile" window
        @return
        """
        second_tool_bar = ToolbarWindow(parent=self.centr_widg, right=True)
        second_tool_bar.addWidget(self.pict_act)
        second_tool_bar.addWidget(self.link_act)
        second_tool_bar.addWidget(self.other_act)
        second_tool_bar.addWidget(self.option_act)
        return second_tool_bar

    def create_actions(self):
        """
        create buttons for toolbar
        @return
        """

        self.pict_act = QtGui.QToolButton(self.centr_widg)
        self.pict_act.setIcon(QtGui.QIcon(self.tr("../data/en/image.png")))
        self.pict_act.setText(self.tr("Add image"))
        self.pict_act.setToolButtonStyle(QtCore.Qt.ToolButtonTextUnderIcon)
        self.pict_act.setSizePolicy(QtGui.QSizePolicy.Expanding, QtGui.QSizePolicy.Minimum)
        self.connect(self.pict_act, QtCore.SIGNAL("clicked()"),
                     self.pict_post)

        self.link_act = QtGui.QToolButton(self.centr_widg)
        self.link_act.setIcon(QtGui.QIcon(self.tr("../data/en/add_link.png")))
        self.link_act.setText(self.tr("Add link"))
        self.link_act.setToolButtonStyle(QtCore.Qt.ToolButtonTextUnderIcon)
        self.link_act.setSizePolicy(QtGui.QSizePolicy.Expanding, QtGui.QSizePolicy.Minimum)
        self.connect(self.link_act, QtCore.SIGNAL("clicked()"),
                     self.link_post)

        self.other_act = QtGui.QToolButton(self.centr_widg)
        self.other_act.setIcon(QtGui.QIcon(self.tr("../data/en/add_html.png")))
        self.other_act.setText(self.tr("HTML"))
        self.other_act.setToolButtonStyle(QtCore.Qt.ToolButtonTextUnderIcon)
        self.other_act.setSizePolicy(QtGui.QSizePolicy.Expanding, QtGui.QSizePolicy.Minimum)
        self.connect(self.other_act, QtCore.SIGNAL("clicked()"),
                     self.other_post)

        self.option_act = QtGui.QToolButton(self.centr_widg)
        self.option_act.setIcon(QtGui.QIcon(self.tr("../data/en/options.png")))
        self.option_act.setText(self.tr("Options"))
        self.option_act.setToolButtonStyle(QtCore.Qt.ToolButtonTextUnderIcon)
        self.option_act.setSizePolicy(QtGui.QSizePolicy.Expanding, QtGui.QSizePolicy.Minimum)
        self.connect(self.option_act, QtCore.SIGNAL("clicked()"),
                     self.option_post)

        self.undo_act = QtGui.QToolButton(self.centr_widg)
        self.undo_act.setIcon(QtGui.QIcon(self.tr("../data/en/undo.png")))
        self.undo_act.setText(self.tr("Undo"))
        self.undo_act.setToolButtonStyle(QtCore.Qt.ToolButtonTextUnderIcon)
        self.undo_act.setSizePolicy(QtGui.QSizePolicy.Expanding, QtGui.QSizePolicy.Minimum)
        self.connect(self.undo_act, QtCore.SIGNAL("clicked()"),
                     self.text_edit.undo)

        self.redo_act = QtGui.QToolButton(self.centr_widg)
        self.redo_act.setIcon(QtGui.QIcon(self.tr("../data/en/redo.png")))
        self.redo_act.setText(self.tr("Redo"))
        self.redo_act.setToolButtonStyle(QtCore.Qt.ToolButtonTextUnderIcon)
        self.redo_act.setSizePolicy(QtGui.QSizePolicy.Expanding, QtGui.QSizePolicy.Minimum)
        self.connect(self.redo_act, QtCore.SIGNAL("clicked()"),
                     self.text_edit.redo)
        


        self.send_act = QtGui.QToolButton(self)


        if not self.msg:
            self.send_act.setIcon(QtGui.QIcon(self.tr("../data/en/post_send_to.png")))
            self.send_act.setText(self.tr("Send to.."))
            self.connect(self.send_act, QtCore.SIGNAL("clicked()"),
                         self.send_post)
        else:
            self.send_act.setIcon(QtGui.QIcon(self.tr("../data/en/send_post.png")))
            self.send_act.setText(self.tr("Send"))
            self.connect(self.send_act, QtCore.SIGNAL("clicked()"),
                         self.edit_post)
        self.send_act.setToolButtonStyle(QtCore.Qt.ToolButtonTextUnderIcon)
        self.send_act.setSizePolicy(QtGui.QSizePolicy.Expanding, QtGui.QSizePolicy.Minimum)


    def send_post(self):
        """ 
        handler for button OK
        @return
        """
        if self.combo_view.currentIndex() == 1:
            text_post =self.plain_text
            #QtCore.QString(unicode(self.text_edit.toHtml())).trimmed()
        else:
            text_post = QtCore.QString(unicode(self.text_edit.toPlainText())).trimmed()

        if (text_post == ""):
            ret = QtGui.QMessageBox.critical(self, self.tr("Scribo"),
                               self.tr("The post is empty!"),
                               QtGui.QMessageBox.Ok)
            return

        if (self.title_edit.text() == ""):
            ret = QtGui.QMessageBox.question(self, self.tr("Scribo"),
                               self.tr("Do you want to send post"\
                                       " with empty subject?"),
                               QtGui.QMessageBox.Yes,
                               QtGui.QMessageBox.No)
            if (ret == QtGui.QMessageBox.No):
                return

        mes = Message()
        mes.title = unicode(self.title_edit.text())
        mes.text = unicode(text_post)
        if self.tags:
            mes.tags = unicode(self.tags)

        from ui.RepeatPost import RepeatPost
        rep_post = RepeatPost(self, mes)
        


    def edit_post(self):
        """ 
        handler for button OK
        @return
        """
        if self.combo_view.currentIndex() == 1:
            text_post = self.plain_text
            #QtCore.QString(unicode(self.text_edit.toHtml())).trimmed()
        else:
            text_post = QtCore.QString(unicode(self.text_edit.toPlainText())).trimmed()

        if text_post == "":
            ret = QtGui.QMessageBox.critical(self, self.tr("Scribo"),
                               self.tr("The post is empty!"),
                               QtGui.QMessageBox.Ok)
            return

        if (self.title_edit.text() == ""):
            ret = QtGui.QMessageBox.question(self, self.tr("Scribo"),
                               self.tr("Do you want to send post"\
                                       " with empty subject?"),
                               QtGui.QMessageBox.Yes,
                               QtGui.QMessageBox.No)
            if (ret == QtGui.QMessageBox.No):
                return

        mes = self.msg.copy()
        mes.title = unicode(self.title_edit.text())
        mes.text = unicode(text_post)
        if self.tags:
            mes.tags = unicode(self.tags)
        #else:
        #    mes.tags = self.msg.tags
        author = self.msg.poster
        try:
            res = author.edit_post(mes)
        except WarningExc, exc:
            super(AddPost, self).show_warning(exc)
        else:
            ret = QtGui.QMessageBox.information(self, self.tr("Scribo"),
                                                self.tr("Post is edit"),
                                                QtGui.QMessageBox.Yes)
        mes.del_msg_tree()
        super(AddPost, self).home_window()


    def pict_post(self):
        """
        insert picture in the post
        @param 
        @return
        """
        msg = QtGui.QMessageBox()
        uri_edit = QtGui.QLineEdit(msg)
        msg.setWindowTitle(self.tr("Add picture"))
        title_label = QtGui.QLabel(self.tr("Link to the image (URL)"), msg)
        msg.layout().addWidget(title_label, 0, 0)
        msg.layout().addWidget(uri_edit, 1, 0)
        link_button = msg.addButton(self.tr("Add"),
                                    QtGui.QMessageBox.AcceptRole)
        cancel_button = msg.addButton(QtGui.QMessageBox.Abort)
        cancel_button.hide()
        msg.exec_()
        if msg.clickedButton() == cancel_button:
            return

        if msg.clickedButton() == link_button:
            link = uri_edit.text()
            text = self.text_edit.textCursor().selectedText()

            if QtCore.QString(link).contains("http://", QtCore.Qt.CaseInsensitive):
                self.text_edit.insertPlainText("<img src=\"" + link + "\" title = \""+ text+"\"/>")
            else:
                self.text_edit.insertPlainText("<img src=\"http://" + link + "\" title = \""+ text+ "\"/>")


    def link_post(self):
        """
        insert link in the post
        @param
        @return 
        """
        msg = QtGui.QMessageBox()
        msg.setWindowTitle(self.tr("Add link"))
        uri_edit = QtGui.QLineEdit(msg)
        uri_edit.setFocus()

        title_label = QtGui.QLabel(self.tr("Link"), msg)
        msg.layout().addWidget(title_label, 0, 0)
        msg.layout().addWidget(uri_edit, 1, 0)

        link_button = msg.addButton(self.tr("Add"),
                                     QtGui.QMessageBox.AcceptRole)
        cancel_button = msg.addButton(QtGui.QMessageBox.Abort)
        cancel_button.hide()
        msg.exec_()

        if msg.clickedButton() == cancel_button:
            return
        if msg.clickedButton() == link_button:
            link = uri_edit.text()
            text_link = self.text_edit.textCursor().selectedText() 
            if QtCore.QString(link).contains("http://", QtCore.Qt.CaseInsensitive):
                self.text_edit.insertPlainText("<a href=\"" + link + "\">" + text_link + "</a>")
            else:
                self.text_edit.insertPlainText("<a href=\"http://" + link + "\">" + text_link + "</a>")

    def other_post(self):
        '''
        marked text insert between tags
        '''
        #start = self.text_edit.selectionStart()
        #if start <> -1:
            #text = self.text_edit.selectedText()
        self.dial = QtGui.QMessageBox()
        
        but_box = QtGui.QDialogButtonBox()
        but_box2 = QtGui.QDialogButtonBox()

        but_box.setOrientation(QtCore.Qt.Horizontal)
        but_box2.setOrientation(QtCore.Qt.Horizontal)

        self.dial.setWindowTitle(self.tr("Add html tags"))
        self.dial.setOrientation(QtCore.Qt.Horizontal)

        self.bold_button = but_box.addButton(self.tr("Bold"),
                                     QtGui.QDialogButtonBox.ActionRole)
        self.italic_button = but_box.addButton(self.tr("Italic"),
                                       QtGui.QDialogButtonBox.ActionRole)
        self.center_button = but_box2.addButton(self.tr("Center"),
                                       QtGui.QDialogButtonBox.ActionRole)
        self.right_button = but_box2.addButton(self.tr("Right"),
                                      QtGui.QDialogButtonBox.ActionRole)
        self.left_button = but_box2.addButton(self.tr("Left"),
                                    QtGui.QDialogButtonBox.ActionRole)
        self.just_button = but_box.addButton(self.tr("Justify"),
                                     QtGui.QDialogButtonBox.ActionRole)
        self.color_button = but_box.addButton(self.tr("Color"),
                                      QtGui.QDialogButtonBox.ActionRole)
        cancel_button = self.dial.addButton(QtGui.QMessageBox.Abort)
        cancel_button.hide()
        but_box.adjustSize()
        but_box2.adjustSize()

        self.dial.layout().addWidget(but_box, 0, 0, 1, 3, QtCore.Qt.AlignCenter)
        self.dial.layout().addWidget(but_box2, 1, 0, 1, 3, QtCore.Qt.AlignCenter)

        self.connect(but_box, QtCore.SIGNAL("clicked(QAbstractButton *)"), self.html_click)
        self.connect(but_box2, QtCore.SIGNAL("clicked(QAbstractButton *)"), self.html_click)

        self.dial.exec_()
        if self.dial.clickedButton() == QtGui.QMessageBox.Abort:
            pass
        else:
            return

    def html_click(self, button):
        text = self.text_edit.textCursor().selectedText()

        if button == self.bold_button:
            self.text_edit.insertPlainText("<span style=\"font-weight:bold\">" + text + "</span>")
        elif button == self.italic_button:
            self.text_edit.insertPlainText("<span style=\"font-style:italic\">" + text + "</span>")
        elif button == self.center_button:
            self.text_edit.insertPlainText("<div style=\"text-align:center\">"
                                      + text + "</div>")
        elif button == self.right_button:
            self.text_edit.insertPlainText("<div style=\"text-align:right\">"
                                      + text + "</div>")
        elif button == self.left_button:
            self.text_edit.insertPlainText("<div style=\"text-align:left\">"
                                      + text + "</div>")
        elif button == self.just_button:
            self.text_edit.insertPlainText("<div style=\"text-align:justify\">"
                                      + text + "</div>")
        elif button == self.color_button:
            link = self.text_edit.textCursor().selectedText()

            col = QtGui.QColorDialog.getColor()
            if col.isValid():
                red = QtCore.QString().number(col.red(), 16).toUpper()
                green = QtCore.QString().number(col.green(), 16).toUpper()
                blue = QtCore.QString().number(col.blue(), 16).toUpper()
                color = red + green + blue
                self.text_edit.insertPlainText("<span style=\"color:#"
                                           + color + "\">"
                                           + link + "</span>")
        else:
    	    return
        self.dial.reject()


    def option_post(self):
        """
        add tags in the post
        @param 
        @return
        """

        msg = QtGui.QMessageBox()
        msg.setWindowTitle(self.tr("Add option"))
        tag_edit = QtGui.QTextEdit(msg)
        tags = None
        if self.msg:
            tags = self.msg.tags
        elif self.tags:
            tags = self.tags
        if not tags:
            tags = ""
        tag_edit.setText(tags)
        title_label = QtGui.QLabel(self.tr("Tags (comma separated)"))
        msg.layout().addWidget(title_label, 0, 0)
        msg.layout().addWidget(tag_edit, 1, 0)
        link_button = msg.addButton(self.tr("Add"),
                                    QtGui.QMessageBox.AcceptRole)
        cancel_button = msg.addButton(QtGui.QMessageBox.Abort)
        cancel_button.hide()
        msg.exec_()
        if msg.clickedButton() == cancel_button:
            return
        if msg.clickedButton() == link_button:
	        self.tags = tag_edit.toPlainText()
            #self.text_edit.deselect()

    def text_changed(self):
        """
        catch changes text edit and title
        """
        text_post = QtCore.QString(unicode(self.text_edit.toPlainText())).trimmed()
        res = QtGui.QMessageBox.No
        if self.title_edit.isModified() or self.start_text != text_post:
            res = QtGui.QMessageBox.question(self, self.tr("Scribo"),
                               self.tr("Post will be lost! "\
                                   "Continue? "),
                               QtGui.QMessageBox.Yes,
                               QtGui.QMessageBox.No)
        else:
            res = QtGui.QMessageBox.Yes
        return res

    def undo_available(self, undo):
        if undo:
            self.undo_act.setDisabled(False)
        else:
            self.undo_act.setDisabled(True)

    def redo_available(self, redo):
        if redo:
            self.redo_act.setDisabled(False)
        else:
            self.redo_act.setDisabled(True)

    def reload_edit(self, number):
        """                                                                                                                                                 
        reload text edit                                                                                                                            
        @param number = index of selected items                                                                                                             
        @return                                                                                                                                             
        """
        if number == 1:
            self.text_edit.setReadOnly(True)
            self.plain_text = self.text_edit.toPlainText()
            self.text_edit.setHtml(self.plain_text)
        else:
            self.text_edit.setReadOnly(False)
            self.text_edit.setPlainText(self.plain_text)
                
    
    def closeEvent(self, event):
        """
        check post on changing event
        """
        if not self.sending_post:
            ret = self.text_changed()
            if (ret == QtGui.QMessageBox.No):
                return
        event.accept()
    
    def home_window(self):
        """
        check post on changing event
        """
        ret = self.text_changed()
        if (ret == QtGui.QMessageBox.No):
                return
        super(AddPostWindow, self).home_window()
