#!/usr/bin/env python
"""   
 @file: HomePage.py  
  File is a part of Scribo Project  
  Module implements home window from UI
  @author: Zaiceva Diana <zaiceva@cs.karelia.ru>
  @date: 23.02.2010
"""

__author__ = "Diana Zaiceva <zaiceva@cs.karelia.ru>"
__version__ = "$Revision: 0.1 $"
__date__ = "$Date: 2010/02/23 $"
__copyright__ = ""
__license__ = "GPLv2"


import sys

from PyQt4 import QtCore
from PyQt4 import QtGui

#from MainWindow import main_window

#sys.path.append("../ldm")
#sys.path.append("..")

from ldm.Profile import main_prof
from ldm.Account import *


class HomePage(QtGui.QWidget):
    """
    home window for UI
    @version  1.0   
    @author  Zaiceva Diana <zaiceva@cs.karelia.ru>   
    """
    def __init__(self, parent=None):
        """
        Initialization for HomeWindow   
        @param parent (widget) 
        @return 
        """
        QtGui.QWidget.__init__(self, parent.centralWidget())
        self.mainwindow = parent
        self.account = []
        self.vboxmain = QtGui.QVBoxLayout()
        self.vboxmain.addLayout(self.create_info_group())
        self.vboxmain.addSpacing(20)
        self.vboxmain.addLayout(self.create_push_button_group(), 2)
        self.vboxmain.addSpacing(20)
        self.setLayout(self.vboxmain)


    def create_list_acc(self, def_acc):
        '''        
        create combobox with list of accounts
        @param def_acc - default account
        @return acc_combo
        '''
        self.account = []
        acc_combo = QtGui.QComboBox(self)
        path_ava = def_acc.path_to_ava
        # if user haven't userpic on service, it isn't added. 
        if not path_ava:
            acc_combo.addItem(def_acc.username)
        else:
            acc_combo.addItem(QtGui.QIcon(path_ava), def_acc.username)

        self.account.append(def_acc)
        for acc in main_prof.accounts:
            if not acc == def_acc:
                self.account.append(acc)
                path_ava = acc.path_to_ava
                if not path_ava:
                    acc_combo.addItem(acc.username)
                else:
                    acc_combo.addItem(QtGui.QIcon(path_ava), acc.username)


        self.connect(acc_combo, QtCore.SIGNAL("currentIndexChanged(int)"),
                     self.reload_list)
        return acc_combo

    def fill_user_info(self, def_acc):
        """
        get anf fill information about user
        @param def_acc = account for getting infornation
        @return info = string with information
        """

        def_acc = main_prof.def_account

        info = self.tr("<h2>Personal info:</h2><br>")
        if def_acc.nick:
            info = info + self.tr("<div>Nick: <b>")\
            + QtCore.QString(unicode(def_acc.nick)) + self.tr("</b></div><br>")
        if def_acc.date_of_birth:
            info = info + self.tr("<div>Birthday: <b>")\
            + QtCore.QString(unicode(def_acc.date_of_birth)) + self.tr("</b></div><br>")
        if def_acc.city:
            info = info + self.tr("<div>City: <b>")\
            + QtCore.QString(unicode(def_acc.city)) + self.tr("</b></div>")
        if def_acc.get_name():
            info = info + self.tr("<div>Blog service: <b>")\
            + QtCore.QString(unicode(def_acc.get_name())) + self.tr("<b><br></div><br>")
            return info

    def reload_list(self, number):
        '''        
        change default account and default user info
        @param
        @return
        '''

        main_prof.def_account = self.account[number]
        self.info_label.setText(self.fill_user_info(self.account[number]))
        path_ava = self.account[number].path_to_ava
        # if user haven't userpic on service, it isn't added. 
        if path_ava:
            self.upic = QtGui.QImage(path_ava)
            self.image_label.setPixmap(QtGui.QPixmap.fromImage(self.upic))
        else:
             self.image_label.setPixmap(QtGui.QPixmap.fromImage(QtGui.QImage("../data/en/no_photo_128.png")))



    def create_info_group(self):
        """
        draw information about user
        @param
        @return
        """
        hbox = QtGui.QHBoxLayout()
        vbox1 = QtGui.QVBoxLayout()
        def_acc = main_prof.def_account
        #label with personal information

        self.info_label = QtGui.QLabel(self.fill_user_info(def_acc), self)
        self.info_label.setAlignment(QtCore.Qt.AlignLeft)

        self.image_label = QtGui.QLabel(self.tr("Photo"), self)
        self.image_label.setAlignment(QtCore.Qt.AlignCenter)

        self.acc_combo_box = self.create_list_acc(def_acc)
        path_ava = def_acc.path_to_ava
        # if user haven't userpic on service, it isn't added. 

        if path_ava:
            self.upic = QtGui.QImage(path_ava)
            self.image_label.setPixmap(QtGui.QPixmap.fromImage(self.upic))
        else:
            self.image_label.setPixmap(QtGui.QPixmap.fromImage(QtGui.QImage("../data/en/no_photo_128.png")))

        vbox1.addWidget(self.image_label)
        vbox1.addWidget(self.acc_combo_box)

        hbox.addLayout(vbox1)
        #hbox.addLayout(self.vbox2)
        hbox.addWidget(self.info_label)
	#hbox.addStretch(1)
        return hbox

    def create_push_button_group(self):
        """
        draw buttons from main window
        @param
        @return
        """

        add_post_button = QtGui.QPushButton(self.tr("&Add post"), self)
        my_post_button = QtGui.QPushButton(self.tr("&My posts"), self)
        friends_posts_btn = QtGui.QPushButton(self.tr("&Friends' posts"), self)

        add_post_button.setIcon(QtGui.QIcon(self.tr("../data/en/add_post.png")))
        my_post_button.setIcon(QtGui.QIcon(self.tr("../data/en/my_posts.png")))
        friends_posts_btn.setIcon(QtGui.QIcon(self.tr("../data/en/friends_posts.png")))

        hbox = QtGui.QHBoxLayout()
        hbox.addWidget(add_post_button, -1, QtCore.Qt.AlignCenter)
        hbox.addWidget(my_post_button, -1, QtCore.Qt.AlignCenter)
        hbox.addWidget(friends_posts_btn, -1, QtCore.Qt.AlignCenter)

        self.connect(add_post_button, QtCore.SIGNAL("clicked()"),
                     self.mainwindow.add_post)
        self.connect(my_post_button, QtCore.SIGNAL("clicked()"),
                     self.mainwindow.list_my_posts)
        self.connect(friends_posts_btn, QtCore.SIGNAL("clicked()"),
                     self.mainwindow.list_friends_posts)
        return hbox


