#!/usr/bin/env python
"""   
 @file: MainWindow.py  
  File is a part of Scribo Project  
  Module implements main window from UI
  @author: Zaiceva Diana <zaiceva@cs.karelia.ru>
  @date: 11.12.2009
"""

__author__ = "Diana Zaiceva <zaiceva@cs.karelia.ru>"
__version__ = "$Revision: 0.1 $"
__date__ = "$Date: 2009/12/11 $"
__copyright__ = ""
__license__ = "GPLv2"


import sys
from PyQt4 import QtCore
from PyQt4 import QtGui

#sys.path.append("../ldm")
#sys.path.append("..")

from ldm.Profile import main_prof


class MainWindow(QtGui.QMainWindow):
    """
    main class for UI
    @version  1.0   
    @author  Zaiceva Diana <zaiceva@cs.karelia.ru>   
    @todo  back and reload function 
    """
    def __init__(self, parent=None, start=None):
        """
        Initialization for MainWindow   
        @param parent (widget), start (string) 
        @return 
        """
        QtGui.QMainWindow.__init__(self, parent)
        self.setWindowTitle(self.tr("Scribo"))
        self.setMinimumSize(160, 160)
        self.resize(480, 320)
        self.stack_widg = QtGui.QStackedLayout()
        self.account = []
        centr_widg = QtGui.QWidget(self)
        centr_widg.setLayout(self.stack_widg)

        self.new_act = QtGui.QAction(self.tr("&New Account"), self)
        self.manage_act = QtGui.QAction(self.tr("&Edit Accounts"), self)

        if start:
            QtGui.QMessageBox.critical(self, self.tr("Scribo"), str(start))
            self.close()
            sys.exit()
        else:
            widg = self.widget_init()
            self.setCentralWidget(centr_widg)
            self.create_actions()
            self.create_menus()

    def new_profile(self):
        """
        change window on "add profile"
        @param 
        @return
        """
        from AddProfile import AddProfileWindow
        add_widg = AddProfileWindow(self)
        self.push_window(add_widg)


    def manage_profile(self):
        """
        change window on "manage profile"
        @param 
        @return
        """
        from AddProfile import AddProfileWindow
        add_widg = AddProfileWindow(self, default=main_prof.def_account)
        self.push_window(add_widg)


    def about(self):
        """  
        page with info about application
        @param 
        @return
        """
        #from ConfigDriver import config
        from About import __version__ as ver
        #ver = 
        QtGui.QMessageBox.about(self, self.tr("About Scribo"),
                                self.tr("A mobile multiblog client."\
                                        " \n Version: " + ver))
    def show_warning(self, exc):
        """  
        error message
        @param exc - exception
        @return
        """

        QtGui.QMessageBox.warning(self,
                                  self.tr("Scribo"),
                                  exc.to_html(),
                                  QtGui.QMessageBox.Ok)


    def create_actions(self):
        """
        create submenu
        @param
        @return
        """
        #self.new_act = QtGui.QAction(self.tr("&New Profile"), self)
        self.new_act.setShortcut(self.tr("Ctrl+N"))
        #self.new_act.setStatusTip(self.tr("Create a new profile"))
        self.connect(self.new_act, QtCore.SIGNAL("triggered()"),
                     self.new_profile)

        #self.manage_act = QtGui.QAction(self.tr("&Manage profile"), self)
        #self.manage_act.setStatusTip(self.tr("Manage existing profile"))
        self.connect(self.manage_act, QtCore.SIGNAL("triggered()"),
                     self.manage_profile)

        self.exit_act = QtGui.QAction(self.tr("E&xit"), self)
        self.exit_act.setShortcut(self.tr("Ctrl+Q"))
        #self.exit_act.setStatusTip(self.tr("Exit the application"))
        self.connect(self.exit_act, QtCore.SIGNAL("triggered()"),
                     self, QtCore.SLOT("close()"))

        bold_font = self.exit_act.font()
        bold_font.setBold(True)
        self.exit_act.setFont(bold_font)

        self.about_act = QtGui.QAction(self.tr("&About"), self)
        #self.about_act.setStatusTip(self.tr("About Scribo"))
        self.connect(self.about_act, QtCore.SIGNAL("triggered()"), self.about)


    def create_menus(self):
        """
        create menu
        @param
        @return
        """
        self.main_menu = self.menuBar().addMenu(self.tr("&Menu"))
        self.main_menu.addAction(self.new_act)
        self.main_menu.addAction(self.manage_act)
        self.main_menu.addAction(self.about_act)
        self.main_menu.addSeparator()
        self.main_menu.addAction(self.exit_act)



    def widget_init(self):
        """
        draw main widget
        @param 
        @return
        """

        if not main_prof.accounts:
            from StartPage import StartPage
            widg = StartPage(parent=self)
            self.push_window(widg)
            return widg
        else:
            from HomePage import HomePage
            widg = HomePage(self)
            self.push_window(widg)
            return widg


    def back_window(self):
        """
        handler for clicked "back" 
        @param
        @return
        """
        print "back"
        widg = self.stack_widg.currentWidget()
        self.stack_widg.removeWidget(widg)
        widg.deleteLater()


    def home_window(self):
        """
        handler for clicked "home"
        @param
        @return
        """
        print "go home"
        count = self.stack_widg.count()

        for _ in xrange(count):
            widg = self.stack_widg.currentWidget()
            self.stack_widg.removeWidget(widg)
            widg.deleteLater()

        self.widget_init()


    def reload_window(self):
        """
        handler for clicked "reload"
        @param
        @return
        """
        pass

    def add_post(self):
        """
        handler for clicked "add_post"
        @param
        @return
        """

        from AddPost import AddPostWindow
        add_widg = AddPostWindow(self)
        self.push_window(add_widg)


    def list_my_posts(self):
        """
        handler for clicked "my_posts"
        @param
        @return
        """
        from ListMyPosts import ListMyPosts
        widg = ListMyPosts(self)
        self.push_window(widg)


    def list_friends_posts(self):
        """
        handler for clicked "friends posts"
        @param
        @return
        """
        from ListFriendsPosts import ListFriendsPosts
        widg = ListFriendsPosts(self)
        self.push_window(widg)


    def push_window(self, widg):
        """
        push widget into stack 
        @version:  1   
        @author:  Mezhenin Artoym <mezhenin@cs.karelia.ru>
        """
        try:
            self.stack_widg.addStackedWidget(widg)
        except AttributeError:
            self.stack_widg.addWidget(widg)

        self.stack_widg.setCurrentWidget(widg)


main_window = MainWindow()


