#!/usr/bin/env python

"""
===============================================================
Manage list of avalible services
===============================================================
"""

__author__ = "Mezhenin Artoym <mezhenin@cs.karelia.ru>"
__version__ = "$Revision: 1 $"
__date__ = "$Date: 2010/02/26 $"
__copyright__ = ""
__license__ = "GPLv2"


class Dispatcher(object):

    """
    Class contain information abount all services avalible in application
    """
    def __init__(self):
        self._services = []
        self._class_names = {}


    def reset_defaults(self):
        """
        create list with default services
        """
        self._services = []
        self._class_names = {}

        # build list with available sevices

        from LivejAccount import LivejAccount
        self.add_service(LivejAccount)
        from BlurtyAccount import BlurtyAccount
        self.add_service(BlurtyAccount)
        from InsanejAccount import InsanejAccount
        self.add_service(InsanejAccount)
        from DreamwAccount import DreamwAccount
        self.add_service(DreamwAccount)
        # ... other imports and appendings


    def add_service(self, type):
        """
        Add new module with service to dictionary with services. For more 
        infrormation see function init_defaults. 
                
        @param type (type of class) type of new service
        @return None 
        """

        if not type in self._services:
            self._services.append(type)
            self._class_names[type.__name__] = type



    def get_services(self):
        """
        Get list with avalible services. 
        
        @return (list) list with avalible services
        """

        return self._services



    def get_type(self, name):
        """
        Return type of service by name
        
        @param name (string) name of service
        @return (type) class for this service
        """

        return self._class_names[name]


dispatcher = Dispatcher()
dispatcher.reset_defaults()
