#!/usr/bin/env python

"""
File is a part of Scribo Project.
Module for providing Exceptioin class for project.
"""

__author__ = "Mezhenin Artoym <mezhenin@cs.karelia.ru>"
__version__ = "$Revision: 5 $"
__date__ = "$Date: 2010/03/19 $"
__copyright__ = ""
__license__ = "GPLv2"


class WarningExc(Exception):
    """
    not critical error (application can work)
    """

    def __init__(self, module, descr, adv=None):
        """
        init new exception
        @param (string) module : place where exception happence
        @param (string) descr : short description of exception
        @param (string) adv : advanced info about error. (default - None)
        """
        super(WarningExc, self).__init__()
        self.module = module.decode('utf-8')
        self.descr = descr.decode('utf-8')
        if adv:
            self.adv = adv.decode('utf-8')
        else:
            self.adv = None



    def __str__(self):
        """
        generate string representation of error
        @return : string with error description
        """
        return str(self.descr) + " in " + str(self.module) + ":\t " + \
               str(self.adv)

    def to_html(self):
        """
        generate HTML contened error description.
        @return : string with error's representation in HTML
        """
        html = "<b>%s</b><br>%s" % (self.module, self.descr)
        if self.adv:
            html += '<br><pre>' + self.adv + '</pre>'
        return html


class XmlrpcExc(WarningExc):
    def __init__(self, acc, exc):

        self.faultCode = exc.faultCode
        self.faultString = exc.faultString
        account_str = 'Protocol error in ' + acc.username + '@' + acc.get_name()
        super(XmlrpcExc, self).__init__(account_str, self.faultString)


class SocketExc(WarningExc):
    def __init__(self, acc, exc):
        account_str = 'Networking error in ' + acc.username + '@' + \
                      acc.get_name()

        super(SocketExc, self).__init__(account_str, str(exc))
