#!/usr/bin/env python
"""
 @file: SysTest.py
  File is a part of Scribo Project
  Module implements add post from file
  @author: Kirill Germanov <kgermano@cs.karelia.ru>
  @date: 14.02.2010
"""

import sys
sys.path.append("..")
sys.path.append("../ldm")
sys.path.append("../ui")
sys.path.append("../services")

from Message import Message
from Profile import *
from Account import *
from LivejAccount import *
from BlurtyAccount import *
from time import *
import random




__author__ = "Kirill Germanov <kgermano@cs.karelia.ru>"
__version__ = "$Revision: 0.1 $"
__date__ = "$Date: 2010/02/14 $"
__copyright__ = ""
__license__ = "GPLv2"

class SysBugs:
    """
    Class with test method for SendPost module
    @version  1.0
    @author  Germanov Kirill <kgermano@cs.karelia.ru>
    @todo  global testing of all scenarios
    """
    def __init__(self):
        """
        initialization of test account
        @return
        """
        acc = LivejAccount()
        acc.set_option('proxy', '172.20.3.1:81')

        acc.username = "scribo_rpc"
        acc.passwd = "test123"

        try:
            main_prof.add_account(acc)
        except:
            acc = Account.find(type(acc), acc.username)
        main_prof.set_def_account(acc)

    def bug107(self):
        """
        duble of added acounts 
        """

        acc = LivejAccount()
        acc.username = "maemoblogs"
        acc.passwd = "maemo100500"

        try:
            main_prof.add_account(acc)
        except:
            print "already added"

        print "\nbug 107: "

        try:
            main_prof.add_account(acc)
        except:
            print "fixed"
        else:
            print "ERROR!"

    def bug92(self):
        """
        adding post with non-unicode coding
        """
        mes = Message()
        mes.title = unicode("header")
        mes.text = unicode("Hello, moony")
        mes.tags = "magic tag"

        print "\nbug 92: "
        try:
            main_prof.def_account.add_post(mes)
            res = main_prof.def_account.send_post(mes)
        except:
            print "ERROR!!!1"
        else:
            print "fixed"

    def bug87(self):
        """
        test of getting posts without title
        """
        mes = Message()
        mes.title = ""
        mes.text = unicode("Hello, moonSpIRiT")
        main_prof.def_account.add_post(mes)
        res = main_prof.def_account.send_post(mes)


        print "\nbug 87: "
        try:
            main_prof.def_account.refresh_posts(self.callback)
            list = main_prof.get_posts()
        except:
            print 'ERROR'
        else:
            print 'fixed'


    def bug78(self):
        """
        BD fail after second posts refresh
        """
        print "\nbug 78: "
        try:
            main_prof.def_account.refresh_posts(self.callback)
            list = main_prof.get_posts()
            main_prof.def_account.refresh_posts(self.callback)
            list = main_prof.get_posts()
        except:
            print 'ERROR'
        else:
            print 'fixed'


    def bug117(self):
        """
        test of getting posts without title
        added check from UI
        """
        mes = Message()
        mes.title = "trolollo"
        mes.text = ""

        print "\nbug 117: "
        try:
            main_prof.def_account.add_post(mes)
            res = main_prof.def_account.send_post(mes)
        except:
            if (mes.text == ""):
                print 'fixed'
            else:
                print 'ERROR'
        else:
            print 'fixed'



    def callback(self):
        """
        just a callback
        """
        print "call me!"


a = SysBugs()
a.bug107()
a.bug92()
a.bug87()
a.bug117()

print "Loppu!"






