#!/usr/bin/env python
""" 
 @file: RepeatPost.py
  File is a part of Scribo Project
  Module implements repeating send posts from UI
  @author: Zaiceva Diana <zaiceva@cs.karelia.ru>
  @date: 25.03.2010
"""
import sys
#sys.path.append("./src/services")
sys.path.append("./src/ldm")

from PyQt4 import QtCore
from PyQt4 import QtGui

from MainWindow import main_window
from ToolbarWindow import ToolbarWindow

__author__ = "Diana Zaiceva <zaiceva@cs.karelia.ru>"
__version__ = "$Revision: 0.1 $"
__date__ = "$Date: 2010/03/25 $"
__copyright__ = ""
__license__ = "GPLv2"

class RepeatPost(ToolbarWindow):
    """
    class for window with a tree accounts
    @version  1.0
    @author  Zaiceva Diana <zaiceva@cs.karelia.ru>
    """
    def __init__(self, parent, msg):
        """ 
        initialization "tree of messages" window
        @return
        """
        QtGui.QWidget.__init__(self, parent.centralWidget())
        self.mes = msg
        self.tree_view = self.tree_view_acc()
        super(RepeatPost, self).create_actions()
        title = QtGui.QLabel("Please, choose accounts and groups for sending this post", self)
        title.setAlignment(QtCore.Qt.AlignLeft)
        send_button = QtGui.QPushButton(self.tr("Send"), self)
        self.connect(send_button, QtCore.SIGNAL("clicked()"), self.send_selected)
        toolbar = self.create_toolbar()
        self.vbox = QtGui.QVBoxLayout()
        self.vbox.addWidget(toolbar)
        self.vbox.addWidget(title)
        self.vbox.addWidget(self.tree_view)
        self.vbox.addWidget(send_button)
        self.setLayout(self.vbox)


    def create_toolbar(self):
        """
        create toolbar for window
        @return
        """
        file_tool_bar = QtGui.QToolBar("", self)
        file_tool_bar.setIconSize(QtCore.QSize(64, 64))
        file_tool_bar.addAction(self.back_act)
        file_tool_bar.addAction(self.home_act)
        return file_tool_bar

    def tree_view_acc(self):
        tree_widget = QtGui.QTreeWidget()
        tree_widget.setColumnCount(2)
        tree_widget.setSelectionMode(QtGui.QAbstractItemView.MultiSelection)
        accounts = []
        self.all_acc = []
        list_acc = main_prof.accounts
        index = 0
        for acc in list_acc:
            self.all_acc.append(acc)
            path_icon = acc.get_icon()

            login = QtGui.QTreeWidgetItem(tree_widget)
            # if user haven't userpic on service, it isn't added. 
            if path_icon:
                login.setIcon(0, QtGui.QIcon(QtCore.QString(path_icon)))
            else:
                login.setIcon(0, QtGui.QIcon())
            login.setText(1, acc.username)

            child_login = QtGui.QTreeWidgetItem(login)
            child_login.setText(1, acc.username)
            child_login.setData(1, QtCore.Qt.UserRole, QtCore.QVariant(index))
            index = index + 1

            #if login has group...
            groups = acc.get_journals()
            if groups:
                len_groups = len(groups)
            else:
                len_groups = 0
            for l in xrange(len_groups):
                group_login = QtGui.QTreeWidgetItem(login)
                group_login.setText(1, groups[l].username)
                group_login.setData(1, QtCore.Qt.UserRole, QtCore.QVariant(index))
                self.all_acc.append(groups[l])
                index = index + 1

            accounts.append(login)
        tree_widget.insertTopLevelItems(0, accounts)
        return tree_widget



    def send_selected(self):
        login_items = self.tree_view.selectedItems()
        flag_send = True
        if login_items:
            for item in login_items:
                msg_copy = self.mes.copy()
                acc = item.parent()

                #select root item
                if not acc:
                    if len(login_items) == 1:
                        QtGui.QMessageBox.information(self, self.tr("Scribo"),
                                                self.tr("Please, choose subitem for sending "),
                                                QtGui.QMessageBox.Yes)
                        return
                    continue
                first_child = acc.child(0)

                index = item.data(1, QtCore.Qt.UserRole).toString().toInt()[0]
                send_journal = self.all_acc[index]
                msg_copy.journal = send_journal

                num_acc = first_child.data(1, QtCore.Qt.UserRole).toString().toInt()[0]
                send_acc = self.all_acc[num_acc]
                try:
                    res = send_acc.send_post(msg_copy)
                except WarningExc, exc:
                    main_window.show_warning(exc)
                    flag_send = False

                msg_copy.del_msg_tree()
        else:
            QtGui.QMessageBox.information(self, self.tr("Scribo"),
                                          self.tr("Please, choose account or group for sending "),
                                          QtGui.QMessageBox.Yes)


        if flag_send:
            ret = QtGui.QMessageBox.information(self, self.tr("Scribo"),
                                                self.tr("Post is sent"),
                                                QtGui.QMessageBox.Yes)
        main_window.home_window()



from AddPost import *
