
#include <gtk/gtk.h>
#include <hildon/hildon.h>
#include "scout-window.h"
#include <libosso.h>
#include <libosso-abook/osso-abook.h>
#include <locale.h>

#define OSSO_SERVICE "com.nokia."PACKAGE

#include <config.h>
#include <glib/gi18n.h>

typedef struct _AppData AppData;

struct _AppData
{
  HildonProgram *program;
  ScoutWindow* window;
};


static void on_main_window_hide (GtkWidget *widget, gpointer user_data)
{
  gtk_main_quit ();
}
static void
account_manager_ready_cb(OssoABookAccountManager *waitable,
			 const GError *error,
			 gpointer data)
{
  ScoutWindow* window = SCOUT_WINDOW(data);
  scout_window_set_account_manager(window, OSSO_ABOOK_ACCOUNT_MANAGER(waitable));
  hildon_gtk_window_set_progress_indicator(GTK_WINDOW(window), 0);
}

static void
aggregator_ready_cb(OssoABookWaitable *waitable,
		    const GError *error,
		    gpointer data)
{
  ScoutWindow* window = SCOUT_WINDOW(data);
  scout_window_set_abook(window, OSSO_ABOOK_AGGREGATOR(waitable));
  osso_abook_account_manager_call_when_ready(NULL, account_manager_ready_cb, data, NULL);
}

int main(int argc, char** argv)
{
  osso_context_t* osso = NULL;
  AppData* data = g_new0(AppData, 1);
  
  setlocale(LC_ALL, "");
  bindtextdomain(GETTEXT_PACKAGE, LOCALEDIR);
  bind_textdomain_codeset(GETTEXT_PACKAGE, "UTF-8");
  textdomain(GETTEXT_PACKAGE);
  
  hildon_gtk_init(&argc, &argv);
  
  if(!g_thread_supported())
  {
    g_thread_init(NULL);
  }

  data->program = HILDON_PROGRAM(hildon_program_get_instance());
  g_set_application_name(_("Scout"));
  
  osso = osso_initialize(OSSO_SERVICE, VERSION, TRUE, NULL);
  g_assert(osso);

  osso_abook_init(&argc, &argv, osso);

  data->window = scout_window_new(osso);

  hildon_program_add_window(data->program, HILDON_WINDOW(data->window));
  
  gtk_widget_show(GTK_WIDGET(data->window));
  hildon_gtk_window_set_progress_indicator(GTK_WINDOW(data->window), 1);

  OssoABookAggregator *aggregator;
  aggregator = OSSO_ABOOK_AGGREGATOR(osso_abook_aggregator_get_default (NULL));
  if(!aggregator)
  {
    g_warning("no aggregator foudn \n");
    return 1;
  }
  osso_abook_waitable_call_when_ready(OSSO_ABOOK_WAITABLE(aggregator),
				      aggregator_ready_cb, data->window, NULL);

  g_signal_connect(data->window, "hide", G_CALLBACK(&on_main_window_hide), NULL);
  g_signal_connect(data->window, "delete-event", G_CALLBACK(&gtk_widget_hide_on_delete), NULL);
  gtk_main();

  gtk_widget_destroy(GTK_WIDGET(data->window));
  g_free(data);
  return 0;
}

