/*
    This file is part of Scoresheet, a simple scorekeeping application.
    Copyright (C) 2010 Heikki Holstila

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef _SCORESHEET_H_
#define _SCORESHEET_H_

#include <QtGui>

const QString VERSION = "0.9";

class CScoresheet : public QObject
{
	Q_OBJECT

	public:
	CScoresheet(QWidget *win_);
	~CScoresheet();

	public slots:
	void orientationChanged();
	void updateHeaders();
	void cellClicked(int row_, int col_);
	void softkeyClicked();
	void showAbout() { dlg_about->exec(); }
	void showSetup();
	void saveSetup();
	void clear();
	void playersNumChanged(int num);
	void save();
	void load();

	private:
	
	void createSetup();
	void resizeTable();
	
	int sizeX;
	int sizeY;
	int defaultSizeX;
	int defaultSizeY;
	int minSizeX;
	int maxSizeX;
	int minSizeY;
	int maxSizeY;
	int defaultRowHeight;
	int minSectSize;
	bool hideKeys;
	QString defaultName;
	
	int lastcellCol;
	int lastcellRow;
	bool typing;
	bool portrait;
	bool loadingFile;
	
	QWidget *win;
	QWidget *keys;
	QWidget *barH;
	QWidget *barV;
	QTableWidget *table;
	QProgressBar *progress;
	
	QDialog *win_setup;
	QDialog *dlg_about;
	QDialog *dlg_confirmation;
	QFileDialog *dlg_file;
	
	QSpinBox *stp_players;
	QSpinBox *stp_rows;
	QListWidget *stp_list;
	
	QStringList names;
	QList<int> totalScores;

};

#endif
