/*
    This file is part of Scoresheet, a simple scorekeeping application.
    Copyright (C) 2010 Heikki Holstila

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include <QtGui>

#include "scoresheet.h"

int main(int argc, char *argv[])
{
	QApplication app(argc, argv);
	QWidget *win = new QWidget();
	
	win->setAttribute(Qt::WA_Maemo5PortraitOrientation, true);
	//win->setAttribute(Qt::WA_Maemo5AutoOrientation, true);
	win->setWindowFlags(win->windowFlags() | Qt::Window);
	win->setWindowTitle("Scoresheet");

	CScoresheet sc(win);
	
	QMenuBar *menu = new QMenuBar(win);
	menu->addAction("Save...",&sc,SLOT(save()));
	menu->addAction("Load...",&sc,SLOT(load()));
	menu->addAction("Setup",&sc,SLOT(showSetup()));
	menu->addAction("Clear",&sc,SLOT(clear()));
	menu->addAction("About",&sc,SLOT(showAbout()));


	QObject::connect(QApplication::desktop(), SIGNAL(resized(int)), &sc, SLOT(orientationChanged()));
	
	win->show();

	return app.exec();
}
