/*
 * Copyright (C) 2009 Sakari Poussa
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 2.
 */

#include <QStringList>
#include <QAbstractListModel>

#include "data.h"

class ScoreListModel : public QAbstractListModel
{
    Q_OBJECT

public:

    ScoreListModel(QList<Score *> &sList, QList<Club *> &cList, QObject *parent = 0) 
        : QAbstractListModel(parent), scoreList(sList), clubList(cList) {}
        
    QVariant data(const QModelIndex & index, int role) const;
    int rowCount(const QModelIndex & parent) const;

    void update(QList<Score *> &list);

 private:
    QList<Score *> scoreList;
    QList<Club *> clubList;
};

class CourseListModel : public QAbstractListModel
{
    Q_OBJECT

public:

    CourseListModel(QList<Club *> &list, QObject *parent = 0);

    int rowCount(const QModelIndex & parent) const;
    QVariant data(const QModelIndex & index, int role) const;
    void update(QList<Club *> &list);
    void updateList();

private:
    QList<Club *> clubList;
    QList<QString *> clubAndCourseList;
};
