/*
 * Copyright (C) 2009 Sakari Poussa
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 2.
 */

#ifndef COURSE_DIALOG_H
#define COURSE_DIALOG_H

#include <QtGui>
#include <QDialog>
#include <QLabel>
#include <QGroupBox>
#include <QDialogButtonBox>
#include <QLineEdit>
#include <QDebug>

#include "data.h"
#include "table-model.h"

QT_BEGIN_NAMESPACE
class QTableWidget;
class QTableWidgetItem;
QT_END_NAMESPACE

class CourseWindow: public QMainWindow
{
    Q_OBJECT;

public:
    CourseWindow(QWidget *parent = 0);

    void setup(Course *course);

private:
    CourseTableModel *model;
};

class CourseSelectDialog: public QDialog
{
  Q_OBJECT

 public:
  CourseSelectDialog(QWidget *parent = 0);

  void results(QString &club, QString &course);

private slots:
  void next(void);

 private:

  void createLayout(QWidget *parent);
  void showNote(QString msg);
  bool validate(void);

  QLineEdit    *lineEditClub;
  QLineEdit    *lineEditCourse;
  QLabel       *labelClub;
  QLabel       *labelCourse;
  QPushButton  *pushButtonNext;

  // Layouts
  QVBoxLayout *leftLayout;
  QVBoxLayout *rightLayout;
};

class CourseDialog: public QDialog
{
  Q_OBJECT

 public:
  CourseDialog(QWidget *w);
  void results(QVector<QString> &, QVector<QString> &, QVector<QString> &);
  bool validate();
  void init(Course *course = 0);

 private slots:
  void up(void);
  void down(void);
  void next(void);
  void finish(void);

 private:
  enum { ROW_HOLE = 0, ROW_PAR = 1, ROW_HCP = 2, ROW_LEN = 3, 
	 ROW_HOLE_2 = 4, ROW_PAR_2 = 5, ROW_HCP_2 = 6, ROW_LEN_2 = 7};
  enum { ROWS = 8, COLS = 9, separator_row = 3 };

  void createTable(QWidget *parent = 0);
  void createButton(QWidget *parent = 0);
  void createLayout(QWidget *parent = 0);
  void moveToNextCell(QTableWidgetItem *item);

  // Widgets
  QTableWidget *table;

  QPushButton *pushButtonUp;
  QPushButton *pushButtonDown;
  QPushButton *pushButtonNext;
  QPushButton *pushButtonFinish;

  // Layouts
  QVBoxLayout *rightLayout;
  QVBoxLayout *leftLayout;
};

#endif
