/*
 * Copyright (C) 2009 Sakari Poussa
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 2.
 */
#ifndef SETTINGS_DIALOG_H
#define SETTINGS_DIALOG_H

#include <QDialog>
#include <QList>
#include <QStandardItemModel>
#ifdef Q_WS_MAEMO_5
#include <QMaemo5ValueButton>
#endif

#include "data.h"
#include "score-common.h"

class SettingsDialog: public QDialog
{
    Q_OBJECT

public:
    SettingsDialog(QWidget *parent = 0);
    void init(AppSettings &conf, QList<Club *> &list);
    void results(AppSettings &conf);

private slots:
    void okClicked();

private:
    void createLayout(QWidget *parent);
    QStandardItemModel *hcpModel;
    QStandardItemModel *homeClubModel;
    QStandardItemModel *sortModel;
    QStandardItemModel *defaultCoursesModel;

    QList<Club *> clubList;
#ifdef Q_WS_MAEMO_5
    QMaemo5ValueButton * hcpButton;
    QMaemo5ValueButton * homeClubButton;
    QMaemo5ValueButton * sortButton;
    QMaemo5ValueButton * defaultCoursesButton;
#endif
};

#endif
