/*
 * Copyright (C) 2009 Sakari Poussa
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 2.
 */
#ifndef SCORE_COMMON_H
#define SCORE_COMMON_H

#include <QColor>

static QString settingsGroup("Settings");
static QString settingsHcp("hcp");
static QString settingsHomeClub("home-club");
static QString settingsSortOrder("sort-order");
static QString settingsDefaultCourses("default-courses");

#ifndef WANT_DEBUG
#define TRACE
#else
#include <QDebug>
#define TRACE qDebug()<<QString("[%1] %2(): %3").arg(__FILE__).arg(__func__).arg(__LINE__);
#endif

static int fontSize = 20;

class AppSettings {
public:
    QVariant hcp;
    QVariant homeClub;
    QVariant sortOrder;
    QVariant defaultCourses;
};

class ScoreColor
{
 public:
    static QColor holeBg()      { return Qt::white;                }
    static QColor holeFg()      { return Qt::yellow;               }
    static QColor birdie()      { return Qt::yellow;               }
    static QColor par()         { return Qt::green;                }
    static QColor bogey()       { return Qt::cyan;                 }
    static QColor doubleBogey() { return Qt::red;                  }
    static QColor bad()         { return Qt::red;                  }
    static QColor subTotal()    { return Qt::white;                }
    static QColor total()       { return Qt::white;                }
}; 

static QString statStyleSheet("QTableView {color : white;}");
static QString defaultStyleSheet("QTableView {"
                                 "background-color: white;"
                                 "color : gray;"
                                 "border: solid green;"
                                 "}"
                                 "QHeaderView::section {"
                                 "color : white;"
                                 "border: solid green;"
                                 "}");
#if 0
"QAbstractItemView::item[role=\"header\"]{"
"background : orange;"
"color : yellow;"
"border: solid green;"
"font-size : 16px;"
"}"
"QAbstractItemView::item"
"background : orange;"
"color : white;"
"border: solid green;"
"font-size : 16px;"
"}"
"QTableView {"
"alternate-background-color: yellow;"
"background-color: red;"
"color : blue;"
"border: solid green;"
"gridline-color: green;"
"}"
#endif
#endif
