/*
 * Copyright (C) 2009 Sakari Poussa
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 2.
 */

#include "cell-delegate.h"
#include <QtGui>
#include <QDebug>

CellDelegate::CellDelegate(QObject *parent) : QItemDelegate(parent) 
{
  m_parent = parent;
}

QWidget *CellDelegate::createEditor(QWidget *parent,
				    const QStyleOptionViewItem &,
				    const QModelIndex &index) const
{
  CellFilter *filter = new CellFilter(m_parent); // HACK

  //CellFilter filter(parent);

  QLineEdit *le = new QLineEdit(parent);

  le->installEventFilter(filter);

  qDebug() << "parent=" << parent << " m_parent=" << m_parent;
  // HACK: Connect CellFilter signal to CourseDialog nextCell slot
  connect(filter, SIGNAL(nextCell(QObject *)), m_parent, SLOT(nextCell(QObject *)));

  return le;
}

void CellDelegate::commitAndCloseEditor()
{
    QLineEdit *editor = qobject_cast<QLineEdit *>(sender());

    // TODO: del editor
    emit commitData(editor);
    emit closeEditor(editor);
}

void CellDelegate::setEditorData(QWidget *editor,
				 const QModelIndex &index) const
{
  QString value = index.model()->data(index, Qt::EditRole).toString();

  QLineEdit *le = static_cast<QLineEdit *>(editor);

  le->setText(value);
}

void CellDelegate::setModelData(QWidget *editor,
    QAbstractItemModel *model, const QModelIndex &index) const
{
    QLineEdit *le = static_cast<QLineEdit*>(editor);

    QString value = le->text();

    model->setData(index, value, Qt::EditRole);

}

