/*
 * Copyright (C) 2009 Sakari Poussa
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 2.
 */

#ifndef XML_DOM_PARSER_H
#define XML_DOM_PARSER_H

#include <QDomDocument>
#include "data.h"

class ScoreXmlHandler
{
public:
    ScoreXmlHandler(QList<Score *> &list);
    int parse(QString &fileName);
    int save(QString &fileName);

private:
    QDomDocument doc;
    QDomElement root;
    QList<Score *> &list;
};

class ClubXmlHandler
{
public:
    ClubXmlHandler(QList<Club *> &list);
    int parse(QString &fileName, bool readOnly = false);
    int save(QString &fileName);

private:
    QDomDocument doc;
    QDomElement root;
    QList<Club *> &list;
};

#endif
