/*
 * Copyright (C) 2009 Sakari Poussa
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 2.
 */
#ifndef TABLE_MODEL_H
#define TABLE_MODEL_H

#include <QStringList>
#include <QAbstractTableModel>

#include "data.h"

#define ROW_COUNT  3
#define COL_COUNT  9

class ScoreTableModel : public QAbstractTableModel
{
    Q_OBJECT

public:
    ScoreTableModel(QObject *parent = 0);

    void set(Score *, Course *);
    int rowCount(const QModelIndex & parent) const;
    int columnCount(const QModelIndex & parent) const;
    QVariant data(const QModelIndex & index, int role) const;
    QVariant headerData(int section, Qt::Orientation orientation, int role) const;

private:
    enum { 
        ROWS = 8, 
        COLS = 9 
    };
    enum { 
        ROW_HOLE = 0, 
        ROW_PAR = 1, 
        ROW_HCP = 2, 
        ROW_SCORE = 3, 
        ROW_HOLE_2 = 4, 
        ROW_PAR_2 = 5, 
        ROW_HCP_2 = 6, 
        ROW_SCORE_2 = 7
    };
    // Current data pointers
    Score *score;
    Club *club;
    Course *course;
};

class CourseTableModel : public QAbstractTableModel
{
    Q_OBJECT

public:
    CourseTableModel(QObject *parent = 0);

    void set(Course *);
    int rowCount(const QModelIndex & parent) const;
    int columnCount(const QModelIndex & parent) const;
    QVariant data(const QModelIndex & index, int role) const;
    QVariant headerData(int section, Qt::Orientation orientation, int role) const;

private:
    enum { 
        ROWS = 8, 
        COLS = 9 
    };
    enum { 
        ROW_HOLE = 0, 
        ROW_PAR = 1, 
        ROW_HCP = 2, 
        ROW_LEN = 3, 
        ROW_HOLE_2 = 4, 
        ROW_PAR_2 = 5, 
        ROW_HCP_2 = 6, 
        ROW_LEN_2 = 7
    };
    // Current data pointers
    Club *club;
    Course *course;
};
#endif
