#include <QPushButton>
#include <QDialogButtonBox>
#include <QLabel>
#include <QVBoxLayout>
#include <QHBoxLayout>
#include <QStandardItemModel>
#ifdef Q_WS_MAEMO_5
#include <QMaemo5InformationBox>
#include <QMaemo5ValueButton>
#include <QMaemo5ListPickSelector>
#endif

#include "settings-dialog.h"

SettingsDialog::SettingsDialog(QWidget *parent) : QDialog(parent)
{
    QWidget *centralWidget = new QWidget(this);
    createLayout(centralWidget);
    setWindowTitle(tr("Settings"));
}

void SettingsDialog::createLayout(QWidget *parent)
{
    QPushButton * ok = new QPushButton(tr("OK"));

    connect(ok, SIGNAL(clicked()), this, SLOT(okClicked()));

    QDialogButtonBox * buttonBox = new QDialogButtonBox(Qt::Vertical);
    buttonBox->addButton(ok, QDialogButtonBox::ActionRole);

    QVBoxLayout * leftLayout = new QVBoxLayout;

#ifdef Q_WS_MAEMO_5
    QStandardItem * item;

    // HCP
    hcpButton = new QMaemo5ValueButton();
    hcpButton->setValueLayout(QMaemo5ValueButton::ValueBesideText);
    QMaemo5ListPickSelector * listPickSelector1 = new QMaemo5ListPickSelector;
    hcpModel = new QStandardItemModel(54, 0);
    for (int i = 0; i < 54; i++) {
        item = new QStandardItem(QString("%0").arg(i));
        item->setTextAlignment(Qt::AlignCenter);
        hcpModel->setItem(i, item);
    }
    listPickSelector1->setModel(hcpModel);
    hcpButton->setPickSelector(listPickSelector1);
    hcpButton->setText(QString::fromUtf8("HCP"));

    // Home Club
    homeClubButton = new QMaemo5ValueButton();
    homeClubButton->setValueLayout(QMaemo5ValueButton::ValueBesideText);
    QMaemo5ListPickSelector * listPickSelector2 = new QMaemo5ListPickSelector;
    homeClubModel = new QStandardItemModel;
    listPickSelector2->setModel(homeClubModel);
    homeClubButton->setPickSelector(listPickSelector2);
    homeClubButton->setText(QString::fromUtf8("Home Club"));

    // Use Default Courses
    defaultCoursesButton = new QMaemo5ValueButton();
    defaultCoursesButton->setValueLayout(QMaemo5ValueButton::ValueBesideText);
    QMaemo5ListPickSelector * listPickSelector3 = new QMaemo5ListPickSelector;
    defaultCoursesModel = new QStandardItemModel(2, 0);
    item = new QStandardItem(QString("Yes"));
    item->setTextAlignment(Qt::AlignCenter);
    defaultCoursesModel->setItem(0, item);
    item = new QStandardItem(QString("No"));
    item->setTextAlignment(Qt::AlignCenter);
    defaultCoursesModel->setItem(1, item);

    listPickSelector3->setModel(defaultCoursesModel);
    defaultCoursesButton->setPickSelector(listPickSelector3);
    defaultCoursesButton->setText(QString::fromUtf8("Use Default Courses"));

    leftLayout->addWidget(hcpButton);
    leftLayout->addWidget(homeClubButton);
    leftLayout->addWidget(defaultCoursesButton);
#endif

    QVBoxLayout * rightLayout = new QVBoxLayout;
    rightLayout->addStretch();
    rightLayout->addWidget(buttonBox);

    QHBoxLayout *mainLayout = new QHBoxLayout(parent);
    mainLayout->addLayout(leftLayout);
    mainLayout->addLayout(rightLayout);

    setLayout(mainLayout);
}

void SettingsDialog::init(AppSettings &conf, QList<Club *> &list)
{
#ifdef Q_WS_MAEMO_5
    int index = 0;
    QMaemo5ListPickSelector * sel;
    clubList = list;

    if (conf.hcp.isValid()) {
        sel = (QMaemo5ListPickSelector *)hcpButton->pickSelector();
        sel->setCurrentIndex(conf.hcp.toInt());
    }

    QListIterator<Club *> i(clubList);

    while (i.hasNext()) {
        Club *club = i.next();
        QStandardItem *item = new QStandardItem(QString("%0").arg(club->getName()));
        item->setTextAlignment(Qt::AlignCenter);
        homeClubModel->appendRow(item);
        if (item->data(Qt::DisplayRole) == conf.homeClub) {
            sel = (QMaemo5ListPickSelector *)homeClubButton->pickSelector();
            sel->setCurrentIndex(index);
        }
        index++;
    }

    if (conf.defaultCourses.isValid()) {
        int index = conf.defaultCourses.toString() == "Yes" ? 0 : 1;
        sel = (QMaemo5ListPickSelector *)defaultCoursesButton->pickSelector();
        sel->setCurrentIndex(index);
    }
#endif
}

void SettingsDialog::results(AppSettings &conf)
{
#ifdef Q_WS_MAEMO_5
    QMaemo5ListPickSelector * sel;
    QStandardItem *item;
    QVariant value;

    sel = (QMaemo5ListPickSelector *)hcpButton->pickSelector();
    if (sel->currentIndex() != -1) {
        item = hcpModel->item(sel->currentIndex());
        conf.hcp = item->data(Qt::DisplayRole);
    }
    sel = (QMaemo5ListPickSelector *)homeClubButton->pickSelector();
    if (sel->currentIndex() != -1) {
        item = homeClubModel->item(sel->currentIndex());
        conf.homeClub = item->data(Qt::DisplayRole);
    }
    sel = (QMaemo5ListPickSelector *)defaultCoursesButton->pickSelector();
    if (sel->currentIndex() != -1) {
        item = defaultCoursesModel->item(sel->currentIndex());
        conf.defaultCourses = item->data(Qt::DisplayRole);
    }
#endif
}

void SettingsDialog::okClicked()
{
    done(1);
}
