/*
 * Copyright (C) 2009 Sakari Poussa
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 2.
 */

#ifndef SCORE_DIALOG_H
#define SCORE_DIALOG_H

#include <QDialog>
#include <QMainWindow>
#include <QTableWidget>
#include <QListWidget>
#include <QComboBox>
#include <QLabel>
#include <QPushButton>
#include <QDateEdit>
#include <QLayout>
#ifdef Q_WS_MAEMO_5
#include <QtMaemo5/QMaemo5ValueButton>
#include <QtMaemo5/QMaemo5DatePickSelector>
#endif

#include "data.h"
#include "table-model.h"

class ScoreWindow: public QMainWindow
{
    Q_OBJECT;

public:
    ScoreWindow(QWidget *parent = 0);
    ~ScoreWindow();

    void setup(Score * score, Course * course);

private:
    ScoreTableModel *model;
};


class SelectDialog: public QDialog
{
    Q_OBJECT;

public:
    SelectDialog(QWidget *parent = 0);
    
    void results(QString &club, QString &course, QString &date);
    void init(QList<Club *> &list);

private slots:
    void next(void);

private:

    bool validate(void);
    void reject(void);

    void comboBoxCourseUpdate(void);
    void createLayout(QWidget *parent = 0);

    // Widgets
    QListWidget  *listClub;
#ifdef Q_WS_MAEMO_5
    QMaemo5ValueButton *dateButton;
#else
    QLineEdit    *lineEditDate;
    QDateEdit    *date;
#endif
    QLabel       *labelClub;
    QLabel       *labelCourse;
    QPushButton  *pushButtonNext;

  // Layouts
    QVBoxLayout *leftLayout;
    QVBoxLayout *rightLayout;

    QList<Club *> clubList;
};

class ScoreDialog: public QDialog
{
  Q_OBJECT

public:
  ScoreDialog(QWidget *parent = 0);
  ~ScoreDialog();
  void init(Course *course, Score *score = 0);
  void results(QVector<QString> &scores);
  bool validate(void);

private slots:
  void up(void);
  void down(void);
  void next(void);
  void finish(void);

private:

  void createTable(QWidget *parent = 0);
  void createButton(QWidget *parent = 0);
  void createLayout(QWidget *parent = 0);
  void setDefaultScore(QTableWidget *table);
  void moveToNextCell(QTableWidgetItem *item);
  void showNote(QString msg);
  
  enum { ROWS = 8, COLS = 9 };
  enum { ROW_HOLE = 0, ROW_PAR = 1, ROW_HCP = 2, ROW_SCORE = 3, 
	 ROW_HOLE_2 = 4, ROW_PAR_2 = 5, ROW_HCP_2 = 6, ROW_SCORE_2 = 7};

  void reject(void);

  // Widgets
  QTableWidget *table;

  QPushButton  *pushButtonFinish;
  QPushButton  *pushButtonUp;
  QPushButton  *pushButtonDown;
  QPushButton  *pushButtonNext;

  // Layouts
  QVBoxLayout *leftLayout;
  QVBoxLayout *rightLayout;
};
#endif
