/*
 * Copyright (C) 2009 Sakari Poussa
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 2.
 */
#ifndef SCORE_COMMON_H
#define SCORE_COMMON_H

#if 0
#define SC_BLUE_THEME

QColor colorHoleBg(64, 64, 64);
QColor colorHoleFg(Qt::yellow);
QColor colorBirdie(00, 0x99, 00);
QColor colorPar(Qt::black);
#ifdef SC_ORANGE_THEME
QColor colorBogey(0xfc, 0xaf, 0x3e);
QColor colorDoubleBogey(0xf5, 0x79, 0x00);
QColor colorBad(0xce, 0x5c, 0x00);
#endif
#ifdef SC_BLUE_THEME
QColor colorBogey(0x20, 0x4a, 0x87);
QColor colorDoubleBogey(0x34, 0x65, 0xa4);
QColor colorBad(0x72, 0x9f, 0xcf);
#endif
QColor colorSubTotal(Qt::black);
QColor colorTotal(Qt::black);
#endif

#include <QColor>

class AppSettings {
public:
    QVariant hcp;
    QVariant homeClub;
    QVariant defaultCourses;
};

class ScoreColor
{
 public:
    static QColor holeBg()      { return Qt::white;                }
    static QColor holeFg()      { return Qt::yellow;               }
    static QColor birdie()      { return Qt::yellow;               }
    static QColor par()         { return Qt::green;                }
    static QColor bogey()       { return Qt::cyan;                 }
    static QColor doubleBogey() { return Qt::red;                  }
    static QColor bad()         { return Qt::red;                  }
    static QColor subTotal()    { return Qt::white;                }
    static QColor total()       { return Qt::white;                }
}; 

class ScoreStyle {
public:
    static QString style()
    {
        return QString("QTableView {"
                         "background-color: white;"
                         "color : gray;"
                         "border: solid green;"
                         "font-size : 20px;"
                         "font-style : italic;"
                       "}"
                       "QHeaderView::section {"
                         "color : white;"
                         "border: solid green;"
                         "font: bold italic large;"
                       "}");

#if 0
                       "QAbstractItemView::item[role=\"header\"]{"
                         "background : orange;"
                         "color : yellow;"
                         "border: solid green;"
                         "font-size : 16px;"
                       "}"
                       "QAbstractItemView::item"
                         "background : orange;"
                         "color : white;"
                         "border: solid green;"
                         "font-size : 16px;"
                       "}"
                       "QTableView {"
                         "alternate-background-color: yellow;"
                         "background-color: red;"
                         "color : blue;"
                         "border: solid green;"
                         "gridline-color: green;"
                       "}"

#endif
    }
    static QString headerView()
    {
        return QString("QHeaderView::section { background-color : #404040 }");
        //return QString("QHeaderView { background-color : #404040 }");
        return QString("QTableView { background-color : red }");
    }
};

#endif
