/*
 * Copyright (C) 2009 Sakari Poussa
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 2.
 */

#include <QFile>
#include "xml-dom-parser.h"

ScoreXmlHandler::ScoreXmlHandler(QList<Score *> &list) : list(list)
{
}

int ScoreXmlHandler::parse(QString &fileName)
{
  QFile file(fileName);

  if (!file.open(QFile::ReadOnly)) {
    qWarning() << "Unable to open :" << fileName;
    return false;
  }
  else if (!doc.setContent(&file)) {
    file.close();
    qWarning() << "Unable set content :" << fileName;
    return false;
  } 
  else {
    file.close();
    qDebug() << "File ready for XML : " << fileName;
  }

  root = doc.documentElement(); // this is for reading
  
  QDomElement scoreElement = root.firstChildElement("score");
  while (!scoreElement.isNull()) {
    Score *score = new Score(scoreElement);
    QDomElement holeElement = scoreElement.firstChildElement("hole");

    while (!holeElement.isNull()) {
      Hole *hole = new Hole(holeElement);
      score->addHole(hole);
      holeElement = holeElement.nextSiblingElement("hole");
    }
    list << score;
    scoreElement = scoreElement.nextSiblingElement("score");
  }
  return true;
}

int ScoreXmlHandler::save(QString &fileName)
{
  QFile file(fileName);

  root = doc.createElement("data");
  doc.appendChild(root);

  for (int i = 0; i < list.size(); i++) {
    Score *score = list.at(i);
    root.appendChild(score->toElement(doc));
  }

  if (!file.open(QFile::WriteOnly))
    return false;

  QTextStream ts(&file);
  ts << doc.toString();
  file.close();

  return true;
}

// ==========================================================
// 
// ==========================================================

ClubXmlHandler::ClubXmlHandler(QList<Club *> &list) : list(list)
{
}

int ClubXmlHandler::parse(QString &fileName)
{
  QFile file(fileName);

  if (!file.open(QFile::ReadOnly)) {
    qWarning() << "Unable to open :" << fileName;
    return false;
  }
  else if (!doc.setContent(&file)) {
    file.close();
    qWarning() << "Unable set content :" << fileName;
    return false;
  } 
  else {
    file.close();
    qDebug() << "File ready for XML :" << fileName;
  }

  root = doc.documentElement(); // this is for reading
  
  QDomElement clubElement = root.firstChildElement("club");
  while (!clubElement.isNull()) {

    Club *club = new Club(clubElement);

    QDomElement courseElement = clubElement.firstChildElement("course");
    while (!courseElement.isNull()) {

        Course *course = new Course(courseElement, club);
        club->addCourse(course);

        QDomElement holeElement = courseElement.firstChildElement("hole");
        while (!holeElement.isNull()) {
            Hole *hole = new Hole(holeElement);
            course->addHole(hole);

            holeElement = holeElement.nextSiblingElement("hole");
        }
        courseElement = courseElement.nextSiblingElement("course");
    }
    list << club;
    clubElement = clubElement.nextSiblingElement("club");
  }
  return true;
}

int ClubXmlHandler::save(QString &fileName)
{
  QFile file(fileName);

  root = doc.createElement("data");
  doc.appendChild(root);

  for (int i = 0; i < list.size(); i++) {
    Club *club = list.at(i);
    root.appendChild(club->toElement(doc));
  }

  if (!file.open(QFile::WriteOnly))
    return false;

  QTextStream ts(&file);
  ts << doc.toString();
  file.close();

  return true;
}
