/*
 * Copyright (C) 2009 Sakari Poussa
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 2.
 */

#include <QAbstractTableModel>

#include "data.h"

class StatItem
{
 public:
  StatItem() {}

  void setYear(QString &year) { m_year = year.toInt(); }
  int year() { return m_year; }

  void setRounds(int n) { m_rounds = n; }
  int rounds() { return m_rounds; }

  void setAverage(int n) { m_average = n; }
  int average() { return m_average; }

  void setMin(int n) { m_min = n; }
  int min() { return m_min; }

  void setMax(int n) { m_max = n; }
  int max() { return m_max; }

  void setBirdies(int n) { m_birdies = n; }
  int birdies() { return m_birdies; }

  void setPars(int n) { m_pars = n; }
  int pars() { return m_pars; }

  void setBogeys(int n) { m_bogeys = n; }
  int bogeys() { return m_bogeys; }

  void setMore(int n) { m_more = n; }
  int more() { return m_more; }

 private:

  int m_year;
  int m_rounds;
  int m_average;
  int m_min;
  int m_max;
  int m_birdies;
  int m_pars;
  int m_bogeys;
  int m_more;
};

class StatModel : public QAbstractTableModel
{
  Q_OBJECT

public:
  StatModel(QList<Club *> &clubList, QList<Score *> &scoreList);

  int rowCount(const QModelIndex & parent) const;
  int columnCount(const QModelIndex & parent) const;
  QVariant data(const QModelIndex & index, int role) const;
  QVariant headerData(int section, Qt::Orientation orientation, int role) const;


 private:

  Course *findCourse(const QString &clubName, 
		     const QString &courseName);
  
  enum { ROWS = 8, COLS = 4 };
  enum { ROW_ROUNDS = 0, 
	 ROW_AVERAGE, 
	 ROW_MIN, 
	 ROW_MAX, 
	 ROW_BIRDIE, 
	 ROW_PAR, 
	 ROW_BOGEY, 
	 ROW_MORE
  };
  enum { COL_TOTAL = 0, 
	 COL_1ST_YEAR, // Latest year
	 COL_2ND_YEAR, // One before latest
	 COL_3RD_YEAR  // Two before latest
  };


  QList<Club *> &clubList;
  QList<Score *> &scoreList;

  QList<StatItem *> stat;

  void update();
};
