/*
 * Copyright (C) 2009 Sakari Poussa
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 2.
 */

#include <QMainWindow>
#include <QTableView>
#include <QListView>
#include <QPushButton>
#include <QTextEdit>
#include <QVBoxLayout>
#include <QItemSelectionModel>
#include <QList>
#include <QLabel>
#include <QActionGroup>
#include <QXmlDefaultHandler>

#include "data.h"
#include "table-model.h"
#include "list-model.h"

class MainWindow : public QMainWindow
{
  Q_OBJECT

public:
  MainWindow(QMainWindow *parent = 0);
  void createLayoutTable(QWidget *parent = 0);
  void createLayoutList(QWidget *parent = 0);
  void createListView(QList<Score *> &, QList <Club *> &);
  void updateTitleBar(QString & msg);
  void loadScoreFile(QString &fileName, QList<Score *> &scoreList);
  void loadClubFile(QString &fileName, QList<Club *> &clubList);
  void saveScoreFile(QString &fileName, QList<Score *> &scoreList);
  void saveClubFile(QString &fileName, QList<Club *> &clubList);

signals:
  void dataChanged();

private slots:
  void clickedList(const QModelIndex &index);

  void newScore();
  void deleteScore();
  void editScore();
  void newCourse();
  void deleteCourse();
  void editCourse();
  void viewStatistics();
  void listScores();
  void listCourses();

private:

  void loadSettings(void);
  Club * findClub(QString &name);
  Course * findCourse(const QString &clubName, const QString &courseName);
  Course * findCourse();
  Score * findScore(QString & clubName, QString & courseName);
                               
  void showNote(QString msg);
  void getStat(QTextEdit *);

  void viewScore(Score * score, Course * course);
  void viewCourse(Course * course);

  QList<Score *> scoreList;
  QList<Club *> clubList;

  ScoreTableModel *scoreTableModel;
  ScoreListModel *scoreListModel;
  CourseListModel *courseListModel;

  QAbstractItemModel *tableModel;
  QItemSelectionModel *selectionModel;

  QTableView *table;
  QListView *list;

  // Layouts
  QWidget *centralWidget;

  // Menus
  QMenu *menu;

  // Actions
  QAction *newScoreAction;
  QAction *newCourseAction;
  QAction *statAction;

  QActionGroup *filterGroup;
  QAction *listScoreAction;
  QAction *listCourseAction;

  void createMenus();
  void createActions();

  // Windows
  QMainWindow *scoreWin;
  QMainWindow *courseWin;
};
