/*
 * Copyright (C) 2009 Sakari Poussa
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 2.
 */

#include <QColor>
#include <QBrush>
#include <QFont>
#include "list-model.h"
#include "score-common.h"

void ScoreListModel::update(QList<Score *> &list)
{
    scoreList = list;
    reset();
}

int ScoreListModel::rowCount(const QModelIndex &) const
{
    return scoreList.count();
}

QVariant ScoreListModel::data(const QModelIndex &index, int role) const
{
  if (!index.isValid())
    return QVariant();

  int row = index.row();

  Score * score = scoreList.at(row);
  //Course * course = findCourse(score->getClubName(), score->getCourseName());

  //
  // ALIGNMENT
  //
#if 0
  if (role == Qt::TextAlignmentRole ) {
    return Qt::AlignCenter;
  }
#endif
  if (index.column() > 10)
    return QVariant();

  //
  // Data
  //
  if (role == Qt::DisplayRole) {
      int n = score->getTotal(Total).toInt();
      QString s = QString("%1, %2").arg(score->getClubName()).arg(score->getCourseName());
      QString tabs;

      int len = s.length();
      if (len >= 40)
          tabs = "\t";
      else if (len >= 32)
          tabs = "\t\t";
      else if (len >= 24)
          tabs = "\t\t\t";
      else if (len >= 16)
          tabs = "\t\t\t\t";
      else
          tabs = "\t\t\t\t\t";

      QString str = QString("%1 %2 %3\n%4").arg(s, -40).arg(tabs).arg(n).arg(score->getDate());
      return str;
  }
  return QVariant();
}

CourseListModel::CourseListModel(QList<Club *> &list, QObject *parent) : QAbstractListModel(parent), clubList(list)
{
    updateList();
}

int CourseListModel::rowCount(const QModelIndex &) const
{
    return clubAndCourseList.count();
}

QVariant CourseListModel::data(const QModelIndex &index, int role) const
{
    if (!index.isValid())
        return QVariant();

    int row = index.row();

    if (role == Qt::DisplayRole) {
        QString *s = clubAndCourseList.at(row);
        return *s;
    }
    return QVariant();
}


void CourseListModel::updateList()
{
    QListIterator<Club *> i(clubList);
    
    while (!clubAndCourseList.isEmpty())
        delete clubAndCourseList.takeFirst();

    while (i.hasNext()) {
        Club *club = i.next();
        QList<Course *> courseList = club->getCourseList();

        QListIterator<Course *> j(courseList);
        while (j.hasNext()) {
            Course *course = j.next();
            QString *str = new QString(club->getName() + "," + course->getName());
            clubAndCourseList << str;
        }
    }
}

void CourseListModel::update(QList<Club *> &list)
{
    clubList = list;
    updateList();
    reset();
}
