/*
 * Copyright (C) 2009 Sakari Poussa
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 2.
 */

#include <QStringList>
#include <QAbstractTableModel>

#include "data.h"

#define ROW_COUNT  3
#define COL_COUNT  9

// TODO: change name to ScoreTableModel
class ScoreTableModel : public QAbstractTableModel
{

  Q_OBJECT

public:
  enum { ViewMode = 0, EditMode = 1 };

  ScoreTableModel(QObject *parent = 0) : QAbstractTableModel(parent) 
  {
    currentScore = 0;
    score = 0;
    club = 0;
    course = 0;
    currentMode = ViewMode;
  }
  Qt::ItemFlags flags ( const QModelIndex & index );
  void setMode(int m);
  int mode(void);
  void setScore(QList<Score *> &sList, Score *score = 0);
  void setClub(QList<Club *> &cList);
  Score *getScore(void);
  Club *getClub(void);
  Course *getCourse(void);

  Course *findCourse(const QString &clubName, const QString &courseName);
  QString& clubName(void);
  QString& courseName(void);
  int rowCount(const QModelIndex & parent) const;
  int columnCount(const QModelIndex & parent) const;
  QModelIndex index(int row, int column, const QModelIndex &parent = QModelIndex()) const;
  QVariant data(const QModelIndex & index, int role) const;
  QVariant headerData(int section, Qt::Orientation orientation, int role) const;

  int setItem(int row, int col, int data);

  QString getInfoText();
  QString getCountText();

  void next();
  void prev();
  void first();
  void last();

 private:
  int currentMode;
  enum { 
    ROWS = 8, 
    COLS = 9 
  };
  enum { 
    ROW_HOLE = 0, 
    ROW_PAR = 1, 
    ROW_HCP = 2, 
    ROW_SCORE = 3, 
    ROW_HOLE_2 = 4, 
    ROW_PAR_2 = 5, 
    ROW_HCP_2 = 6, 
    ROW_SCORE_2 = 7
  };

  QList<Score *> scoreList;
  QList<Club *> clubList;

  int currentScore;

  // Current data pointers
  Score *score;
  Club *club;
  Course *course;
};
