/*
 * Copyright (C) 2009 Sakari Poussa
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 2.
 */
#ifndef SCORE_COMMON_H
#define SCORE_COMMON_H

#if 0
#define SC_BLUE_THEME

QColor colorHoleBg(64, 64, 64);
QColor colorHoleFg(Qt::yellow);
QColor colorBirdie(00, 0x99, 00);
QColor colorPar(Qt::black);
#ifdef SC_ORANGE_THEME
QColor colorBogey(0xfc, 0xaf, 0x3e);
QColor colorDoubleBogey(0xf5, 0x79, 0x00);
QColor colorBad(0xce, 0x5c, 0x00);
#endif
#ifdef SC_BLUE_THEME
QColor colorBogey(0x20, 0x4a, 0x87);
QColor colorDoubleBogey(0x34, 0x65, 0xa4);
QColor colorBad(0x72, 0x9f, 0xcf);
#endif
QColor colorSubTotal(Qt::black);
QColor colorTotal(Qt::black);
#endif

#include <QColor>

class ScoreColor
{
 public:
  static QColor holeBg()      { return QColor(64, 64, 64);       }
  static QColor holeFg()      { return Qt::yellow;                }
  static QColor birdie()      { return QColor(00, 0x99, 00);     }
  static QColor par()         { return Qt::black;                }
  static QColor bogey()       { return QColor(0x20, 0x4a, 0x87); }
  static QColor doubleBogey() { return QColor(0x34, 0x65, 0xa4); }
  static QColor bad()         { return QColor(0x72, 0x9f, 0xcf); }
  static QColor subTotal()    { return Qt::black; }
  static QColor total()       { return Qt::black; }

  static QString styleSheet() 
  {
    return QString("QHeaderView::section { background-color : #404040 }");
  }
}; 

#endif
