/*
 * Copyright (C) 2009 Sakari Poussa
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 2.
 */

#ifndef CELLDELEGATE_H
#define CELLDELEGATE_H

#include <QItemDelegate>
#include <QEvent>
#include <QKeyEvent>
#include <QDebug>
//#include "cell.h"

class CellFilter : public QObject
{
  Q_OBJECT

public:
 CellFilter(QObject *parent=0) : QObject(parent) 
  {
    m_parent = parent;
  }

 signals:
  void nextCell(QObject *);

protected:
  bool eventFilter(QObject *dist, QEvent *event)
  {
    if (event->type() == QEvent::KeyPress) {
      QKeyEvent *keyEvent = static_cast<QKeyEvent*>(event);
      static QString digits = QString("123456789");
      if (digits.indexOf(keyEvent->text()) != -1) {
	qDebug() << "Key press number";
	int rc = QObject::eventFilter(dist, event);
	emit nextCell(m_parent);
	//return rc;
	return false;
      }
      else {
	qDebug() << "Key press invalid";
	return true;
      }
    }

  }
 private:
  QObject *m_parent;
};

class CellDelegate : public QItemDelegate
{
    Q_OBJECT

public:
    CellDelegate(QObject *parent = 0);
    QWidget *createEditor(QWidget *parent, const QStyleOptionViewItem &,
                          const QModelIndex &index) const;
    void setEditorData(QWidget *editor, const QModelIndex &index) const;
    void setModelData(QWidget *editor, QAbstractItemModel *model,
                      const QModelIndex &index) const;
    CellFilter *filter;

 signals:
  void nextCell(QObject *);

private slots:
    void commitAndCloseEditor();

 private:
    QObject *m_parent;
};

#endif // CELLDELEGATE_H
