TARGET = scorecard
DESTDIR = bin
MOC_DIR = moc
OBJECTS_DIR = obj
UI_DIR = obj

QMAKE_CXXFLAGS += -Wno-return-type

CONFIG  += qt debug
TEMPLATE = app
QT      += xml

RESOURCES = scorecard.qrc

HEADERS  = \
src/main-window.h \
src/score-dialog.h \
src/course-dialog.h \
src/table-model.h \
src/stat-model.h \
src/xml-dom-parser.h \
src/data.h

SOURCES  = \
src/main.cpp \
src/main-window.cpp \
src/score-dialog.cpp \
src/course-dialog.cpp \
src/table-model.cpp \
src/stat-model.cpp \
src/xml-dom-parser.cpp \
src/data.cpp

unix {
    #VARIABLES
    PREFIX = /opt/scorecard
    BINDIR = $$PREFIX/bin
    DATADIR = $$PREFIX/data
    IMGDIR = /usr/share/icons/hicolor
    MAEMODIR = /usr/share/applications/hildon

    DEFINES += DATADIR=\\\"$$DATADIR\\\" PKGDATADIR=\\\"$$PKGDATADIR\\\"

    #MAKE INSTALL    
    INSTALLS += target data desktop iconxpm icon26 icon40 icon64

    target.path =$$BINDIR

    data.path = $$DATADIR
    data.files += data/club.xml

    desktop.path = $$MAEMODIR
    desktop.files += maemo/scorecard.desktop

    iconxpm.path = /usr/share/pixmap
    iconxpm.files += images/scorecard.xpm 

    icon26.path = $$IMGDIR/26x26/apps
    icon26.files += images/scorecard_icon_26x26.png 

    icon40.path = $$IMGADIR/40x40/apps
    icon40.files += images/scorecard_icon_40x40.png 

    icon64.path = $$IMGDIR/64x64/apps
    icon64.files += images/scorecard_icon_64x64.png 
    
}
