/*
 * Copyright (C) 2009 Sakari Poussa
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 2.
 */

#ifndef XMLPARSER_H
#define XMLPARSER_H

#include <QList>
#include <QXmlDefaultHandler>

#include "data.h"

class ScoreHandler : public QXmlDefaultHandler
{
 public:
  ScoreHandler(QList<Score *> &scoreList);

  bool startDocument();
  bool endDocument();
  bool startElement(const QString &namespaceURI, const QString &localName,
		    const QString &qName, const QXmlAttributes &attributes);
  bool endElement(const QString &namespaceURI, const QString &localName,
		  const QString &qName);
  bool fatalError(const QXmlParseException &exception);
  QString errorString() const;
  
 private:
  QList<Score *> &scoreList;
  Score *score;
  Hole *hole;
  QString errorStr;
  bool inScore;
};

class ClubHandler : public QXmlDefaultHandler
{
 public:
  ClubHandler(QList<Club *> &clubList);

  bool startDocument();
  bool endDocument();
  bool startElement(const QString &namespaceURI, const QString &localName,
		    const QString &qName, const QXmlAttributes &attributes);
  bool endElement(const QString &namespaceURI, const QString &localName,
		  const QString &qName);
  bool fatalError(const QXmlParseException &exception);
  QString errorString() const;
  
 private:
  QList<Club *> &clubList;
  Club *club;
  Course *course;
  Hole *hole;
  QString errorStr;
  bool inClub;
  bool inCourse;
};

#endif
