/*
 * Copyright (C) 2009 Sakari Poussa
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, version 2.
 */

#ifndef __SCORE_DATA_H
#define __SCORE_DATA_H

#include <QDebug>
#include <QVector>
#include <QXmlAttributes>
#include <QDomElement>
#include <QDomDocument>

enum { TotalOut, TotalIn, Total };


class Hole {
 public:
  Hole(const QXmlAttributes &attrs);
  Hole(const QDomElement node);
  Hole(int num, QString &shots);
  Hole(int num, QString &par, QString &hcp);
  QDomElement toElement(QDomDocument doc);
  QString getShots();
  void setShots(QString& shots);
  QString getHcp();
  void setHcp(QString& shots);
  QString getPar();
  void setPar(QString& shots);
  void dump();

 private:
  QString num, shots, putts, hcp, length, par;
};

class Score {
 public:

  Score(const QXmlAttributes &attrs);
  Score(QString &iClub, QString &iCourse, QString &iDate);
  Score(const QDomElement node);
  Score(QVector<QString> scores, QString &club, QString &course, QString &date);

  bool operator< (const Score& val) const 
  { 
    return date < val.getDate();
  }

  QDomElement toElement(QDomDocument doc);
  int update(QVector<QString> &scores);
  void addHole(Hole *iHole);
  QString getScore(int i) const;
  QString getTotal(int what) const;
  const QString& getClubName() const;
  const QString& getCourseName() const;
  const QString& getDate() const;
  void dump();

 private:
  QList <Hole *> holeList;
  QString club, course, date;
};

class Course {
 public:
  Course(const QXmlAttributes &attrs);
  Course(const QDomElement node);
  Course(QString &name, QVector<QString> &, QVector<QString> &);
  QDomElement toElement(QDomDocument doc);
  int update(QVector<QString> &, QVector<QString> &, QVector<QString> &);
  void addHole(Hole *iHole);
  QString getPar(int i);
  QString getHcp(int i);
  QString& getName();
  QString getTotal(int what);
  void dump();

 private:
  QList <Hole *> holeList;
  QString name;
};

class Club {
 public:

  Club(const QXmlAttributes &attrs);
  Club(const QDomElement node);
  Club(QString &name);

  QDomElement toElement(QDomDocument doc);
  void addCourse(Course *iCourse);
  void dump();
  QString& getName();
  Course *getCourse(int pos);
  Course *getCourse(const QString &courseName);

  QList <Course *> getCourseList() { return courseList; } // HACK: fixme

 private:
  QList <Course *> courseList;
  QString name;

};
#endif
