#include <QtGui>

#include <QDebug>

#include "xml-parser.h"
#include "data.h"

//
// Score
//
ScoreHandler::ScoreHandler(QList<Score *> &scoreList) : scoreList(scoreList)
{
  score = 0;
  hole = 0;
}

bool ScoreHandler::startDocument()
{
  inScore = false;
  return true;
}

bool ScoreHandler::endDocument()
{
  return true;
}

bool ScoreHandler::startElement(const QString & /* namespaceURI */,
                                const QString & /* localName */,
                                const QString &name,
                                const QXmlAttributes &attrs)
{
  if (inScore && name == "hole") {
    hole = new Hole(attrs);
  }
  else if (name == "score") {
    score = new Score(attrs);
    inScore = true;
  }
  return true;
}

bool ScoreHandler::endElement(const QString & /* namespaceURI */,
			      const QString & /* localName */,
			      const QString &name)
{
  if (name == "score") {
    inScore = false;
    scoreList << score;
  } else if (name == "hole")
    score->addHole(hole);

  return true;
}

bool ScoreHandler::fatalError(const QXmlParseException &exception)
{
  qWarning() << "Fatal error on line" << exception.lineNumber()
	     << ", column" << exception.columnNumber() << ":"
	     << exception.message();

  return false;
}

QString ScoreHandler::errorString() const
{
  return errorStr;
}

//
// Club
//
ClubHandler::ClubHandler(QList<Club *> &clubList) : clubList(clubList)
{
  club = 0;
  hole = 0;
}

bool ClubHandler::startDocument()
{
  inClub = false;
  inCourse = false;
  return true;
}

bool ClubHandler::endDocument()
{
  return true;
}

bool ClubHandler::startElement(const QString & /* namespaceURI */,
			       const QString & /* localName */,
			       const QString &name,
			       const QXmlAttributes &attrs)
{
  if (inCourse && name == "hole") {
    hole = new Hole(attrs);
  }
  else if (name == "course") {
    course = new Course(attrs);
    inCourse = true;
  }  
  else if (name == "club") {
    club = new Club(attrs);
    inClub = true;
  }
  return true;
}

bool ClubHandler::endElement(const QString & /* namespaceURI */,
			     const QString & /* localName */,
			     const QString &name)
{
  if (name == "club") {
    inClub = false;
    clubList << club;
  } 
  else if (name == "course") {
    inCourse = false;
    club->addCourse(course);
  }
  else if (name == "hole")
    course->addHole(hole);

  return true;
}

bool ClubHandler::fatalError(const QXmlParseException &exception)
{
  qWarning() << "Fatal error on line" << exception.lineNumber()
	     << ", column" << exception.columnNumber() << ":"
	     << exception.message();

  return false;
}

QString ClubHandler::errorString() const
{
  return errorStr;
}
