#include <QStringList>
#include <QAbstractItemModel>

#include "tree-item.h"

class ScoreTreeModel : public QAbstractItemModel
{

  Q_OBJECT

public:

  enum Roles {Type=Qt::UserRole, Rounds, Total, TotalIn, TotalOut, ScoreBest, ScoreAvg };

  ScoreTreeModel(QList <Score *> &scoreList, QObject *parent = 0);
  int rowCount(const QModelIndex & parent) const;
  int columnCount(const QModelIndex & parent) const;
  QModelIndex index(int row, int column, const QModelIndex &parent = QModelIndex()) const;
  QModelIndex parent(const QModelIndex &index) const;
  QVariant data(const QModelIndex & index, int role) const;
  QVariant headerData(int section, Qt::Orientation orientation, int role) const;

  void setupModelData(QList<Score *> &scoreList, TreeItem *parent);

 private:
  TreeItem *itemFromIndex(const QModelIndex &index) const;
  TreeItem *rootItem;
};
