#include "tree-item.h"

TreeItem::TreeItem()
{
  this->type = TypeRoot;
  this->score = 0;
  parent = 0;
}

TreeItem::TreeItem(const QString &str)
{
  this->type = TypeDate;
  this->score = 0;
  this->str = str;
  parent = 0;
}

TreeItem::TreeItem(Score *s)
{
  this->type = TypeScore;
  this->score = s;
  this->str = s->getDate();
  parent = 0;
}

TreeItem::~TreeItem()
{
  qDeleteAll(children);
}

#if 1
int TreeItem::childCount() const
{
    return children.count();
}

int TreeItem::columnCount() const
{
  return 1;
}

void TreeItem::appendChild(TreeItem *item)
{
  item->parent = this;
  children.append(item);
}

TreeItem *TreeItem::child(int row)
{
  return children.value(row);
}

QVariant TreeItem::data(int column) const
{
  return str;
}

int TreeItem::row() const
{
  if (parent)
    return parent->children.indexOf(const_cast<TreeItem*>(this));
  
  return 0;
}
#endif
